/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_C_Order;
import org.adempiere.core.domains.models.X_M_InOut;
import org.adempiere.core.domains.models.X_M_RMA;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MDocTypeCounter;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MOrg;
import org.compiere.model.MRMALine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MRMA
extends X_M_RMA
implements DocAction {
    private static final long serialVersionUID = -3310525910645254261L;
    private MRMALine[] m_lines = null;
    private MInOut m_inout = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MRMA(Properties ctx, int M_RMA_ID, String trxName) {
        super(ctx, M_RMA_ID, trxName);
        if (M_RMA_ID == 0) {
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setIsApproved(false);
            this.setProcessed(false);
        }
    }

    public MRMA(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRMALine[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            MRMA.set_TrxName(this.m_lines, this.get_TrxName());
            return this.m_lines;
        }
        List<MRMALine> list = new Query(this.getCtx(), "M_RMALine", "M_RMA_ID=?", this.get_TrxName()).setParameters(this.getM_RMA_ID()).setOrderBy("Line").list();
        this.m_lines = new MRMALine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public List<MRMALine> getLinesAsList() {
        List<MRMALine> list = new Query(this.getCtx(), "M_RMALine", "M_RMA_ID=?", this.get_TrxName()).setParameters(this.getM_RMA_ID()).setOrderBy("Line").list();
        return list;
    }

    public MInOut getShipment() {
        if (this.m_inout == null && this.getInOut_ID() != 0) {
            this.m_inout = new MInOut(this.getCtx(), this.getInOut_ID(), this.get_TrxName());
        }
        return this.m_inout;
    }

    public List<MInOut> getReturns() {
        return new Query(this.getCtx(), "M_InOut", "M_RMA_ID=?", this.get_TrxName()).setParameters(this.getM_RMA_ID()).list();
    }

    public MOrder getOriginalOrder() {
        MInOut shipment = this.getShipment();
        if (shipment == null || shipment.getC_Order_ID() == 0) {
            return null;
        }
        return new MOrder(this.getCtx(), shipment.getC_Order_ID(), this.get_TrxName());
    }

    public MInvoice getOriginalInvoice() {
        MInOut shipment = this.getShipment();
        if (shipment == null) {
            return null;
        }
        int invId = 0;
        if (shipment.getC_Invoice_ID() != 0) {
            invId = shipment.getC_Invoice_ID();
        } else {
            String sqlStmt = "SELECT C_Invoice_ID FROM C_Invoice WHERE C_Order_ID=?";
            invId = DB.getSQLValueEx(null, sqlStmt, shipment.getC_Order_ID());
        }
        if (invId <= 0) {
            return null;
        }
        return new MInvoice(this.getCtx(), invId, this.get_TrxName());
    }

    public void setM_InOut_ID(int M_InOut_ID) {
        this.setInOut_ID(M_InOut_ID);
        this.setC_Currency_ID(0);
        this.setAmt(Env.ZERO);
        this.setC_BPartner_ID(0);
        this.m_inout = null;
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.isProcessed()) {
            return false;
        }
        if ("IN".equals(this.getDocStatus()) || "DR".equals(this.getDocStatus()) || "??".equals(this.getDocStatus())) {
            for (MRMALine rmaLine : this.getLinesAsList()) {
                rmaLine.deleteEx(false);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord) {
            this.setC_Order_ID(0);
        }
        this.getShipment();
        if (this.getC_BPartner_ID() == 0 && this.m_inout != null) {
            this.setC_BPartner_ID(this.m_inout.getC_BPartner_ID());
        }
        if (this.getC_Currency_ID() == 0 && this.m_inout != null) {
            if (this.m_inout.getC_Order_ID() != 0) {
                MOrder order = new MOrder(this.getCtx(), this.m_inout.getC_Order_ID(), this.get_TrxName());
                this.setC_Currency_ID(order.getC_Currency_ID());
            } else if (this.m_inout.getC_Invoice_ID() != 0) {
                MInvoice invoice = new MInvoice(this.getCtx(), this.m_inout.getC_Invoice_ID(), this.get_TrxName());
                this.setC_Currency_ID(invoice.getC_Currency_ID());
            }
        }
        if (this.m_inout != null && this.m_inout.isSOTrx() != this.isSOTrx()) {
            this.log.saveError("RMA.IsSOTrx <> InOut.IsSOTrx", "");
            return false;
        }
        return true;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MRMALine[] lines = this.getLines(false);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        for (MRMALine line : lines) {
            if (line.checkQty()) continue;
            this.m_processMsg = "@AmtReturned>Shipped@";
            return "IN";
        }
        this.setAmt(this.getTotalAmount());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String valid;
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info("completeIt - " + this.toString());
        MRMA counter = this.createCounterDoc();
        if (counter != null) {
            this.m_processMsg = "@CounterDoc@: RMA=" + counter.getDocumentNo();
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate(this, 9)) != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        String value;
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (dt.isOverwriteSeqOnComplete() && (value = DB.getDocumentNo(this.getC_DocType_ID(), this.get_TrxName(), true, (PO)this)) != null) {
            this.setDocumentNo(value);
        }
    }

    private MRMA createCounterDoc() {
        if (this.getRef_RMA_ID() > 0) {
            return null;
        }
        MOrg org = MOrg.get(this.getCtx(), this.getAD_Org_ID());
        int counterC_BPartner_ID = org.getLinkedC_BPartner_ID(this.get_TrxName());
        if (counterC_BPartner_ID == 0) {
            return null;
        }
        MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        int counterAD_Org_ID = bp.getAD_OrgBP_ID_Int();
        if (counterAD_Org_ID == 0) {
            return null;
        }
        int C_DocTypeTarget_ID = 0;
        MDocTypeCounter counterDT = MDocTypeCounter.getCounterDocType(this.getCtx(), this.getC_DocType_ID());
        if (counterDT != null) {
            this.log.fine(counterDT.toString());
            if (!counterDT.isCreateCounter() || !counterDT.isValid()) {
                return null;
            }
            C_DocTypeTarget_ID = counterDT.getCounter_C_DocType_ID();
        } else {
            C_DocTypeTarget_ID = MDocTypeCounter.getCounterDocType_ID(this.getCtx(), this.getC_DocType_ID());
            this.log.fine("Indirect C_DocTypeTarget_ID=" + C_DocTypeTarget_ID);
            if (C_DocTypeTarget_ID <= 0) {
                return null;
            }
        }
        MRMA counter = MRMA.copyFrom(this, C_DocTypeTarget_ID, !this.isSOTrx(), true, this.get_TrxName());
        counter.setAD_Org_ID(counterAD_Org_ID);
        counter.setC_BPartner_ID(counterC_BPartner_ID);
        counter.saveEx(this.get_TrxName());
        MRMALine[] counterLines = counter.getLines(true);
        for (int i2 = 0; i2 < counterLines.length; ++i2) {
            MRMALine counterLine = counterLines[i2];
            counterLine.setClientOrg(counter);
            counterLine.saveEx(this.get_TrxName());
        }
        this.log.fine(counter.toString());
        if (counterDT != null && counterDT.getDocAction() != null) {
            counter.setDocAction(counterDT.getDocAction());
            counter.processIt(counterDT.getDocAction());
            counter.saveEx(this.get_TrxName());
        }
        return counter;
    }

    public static MRMA copyFrom(MRMA from, int C_DocType_ID, boolean isSOTrx, boolean counter, String trxName) {
        PO peer;
        MRMA to = new MRMA(from.getCtx(), 0, null);
        to.set_TrxName(trxName);
        MRMA.copyValues(from, to, from.getAD_Client_ID(), from.getAD_Org_ID());
        to.set_ValueNoCheck("M_RMA_ID", I_ZERO);
        to.set_ValueNoCheck("DocumentNo", null);
        to.setDocStatus("DR");
        to.setDocAction("CO");
        to.setC_DocType_ID(C_DocType_ID);
        to.setIsSOTrx(isSOTrx);
        to.setIsApproved(false);
        to.setProcessed(false);
        to.setProcessing(false);
        to.setName(from.getName());
        to.setDescription(from.getDescription());
        to.setSalesRep_ID(from.getSalesRep_ID());
        to.setHelp(from.getHelp());
        to.setM_RMAType_ID(from.getM_RMAType_ID());
        to.setAmt(from.getAmt());
        to.setC_Order_ID(0);
        if (from.getC_Order_ID() != 0 && ((X_C_Order)(peer = new MOrder(from.getCtx(), from.getC_Order_ID(), from.get_TrxName()))).getRef_Order_ID() != 0) {
            to.setC_Order_ID(((X_C_Order)peer).getRef_Order_ID());
        }
        if (from.getInOut_ID() != 0 && ((X_M_InOut)(peer = new MInOut(from.getCtx(), from.getInOut_ID(), from.get_TrxName()))).getRef_InOut_ID() != 0) {
            to.setInOut_ID(((X_M_InOut)peer).getRef_InOut_ID());
        }
        to.setRef_RMA_ID(from.getM_RMA_ID());
        to.saveEx(trxName);
        if (counter) {
            from.setRef_RMA_ID(to.getM_RMA_ID());
        }
        if (to.copyLinesFrom(from, counter) == 0) {
            throw new IllegalStateException("Could not create RMA Lines");
        }
        return to;
    }

    public int copyLinesFrom(MRMA otherRMA, boolean counter) {
        if (this.isProcessed() || otherRMA == null) {
            return 0;
        }
        MRMALine[] fromLines = otherRMA.getLines(false);
        int count = 0;
        for (int i2 = 0; i2 < fromLines.length; ++i2) {
            MRMALine line = new MRMALine(this.getCtx(), 0, null);
            MRMALine fromLine = fromLines[i2];
            line.set_TrxName(this.get_TrxName());
            if (counter) {
                PO.copyValues(fromLine, line, this.getAD_Client_ID(), this.getAD_Org_ID());
            } else {
                PO.copyValues(fromLine, line, fromLine.getAD_Client_ID(), fromLine.getAD_Org_ID());
            }
            line.setM_RMA_ID(this.getM_RMA_ID());
            line.set_ValueNoCheck("M_RMALine_ID", I_ZERO);
            if (counter) {
                MInOutLine peer;
                line.setRef_RMALine_ID(fromLine.getM_RMALine_ID());
                if (fromLine.getM_InOutLine_ID() != 0 && (peer = new MInOutLine(this.getCtx(), fromLine.getM_InOutLine_ID(), this.get_TrxName())).getRef_InOutLine_ID() != 0) {
                    line.setM_InOutLine_ID(peer.getRef_InOutLine_ID());
                }
            }
            line.setProcessed(false);
            if (line.save(this.get_TrxName())) {
                ++count;
            }
            if (!counter) continue;
            fromLine.setRef_RMALine_ID(line.getM_RMALine_ID());
            fromLine.saveEx(this.get_TrxName());
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "Line difference - From=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    @Override
    public boolean voidIt() {
        MRMALine[] lines;
        this.log.info("voidIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        for (MRMALine rmaLine : lines = this.getLines(true)) {
            rmaLine.addDescription(Msg.getMsg(this.getCtx(), "Voided") + " (" + rmaLine.getQty() + ")");
            rmaLine.setQty(Env.ZERO);
            rmaLine.setAmt(Env.ZERO);
            rmaLine.saveEx();
        }
        this.addDescription(Msg.getMsg(this.getCtx(), "Voided"));
        this.setAmt(Env.ZERO);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() <= 0) {
            return;
        }
        int noLine = DB.executeUpdateEx("UPDATE M_RMALine SET Processed=? WHERE M_RMA_ID=?", new Object[]{processed, this.get_ID()}, this.get_TrxName());
        this.m_lines = null;
        this.log.fine("setProcessed - " + processed + " - Lines=" + noLine);
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public BigDecimal getTotalAmount() {
        MRMALine[] lines = this.getLines(true);
        BigDecimal amt = Env.ZERO;
        for (MRMALine line : lines) {
            amt = amt.add(line.getLineNetAmt());
        }
        return amt;
    }

    public void updateAmount() {
        this.setAmt(this.getTotalAmount());
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "Amt")).append("=").append(this.getAmt()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public MRMALine[] getChargeLines() {
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("IsActive='Y' AND M_RMA_ID=");
        whereClause.append(this.get_ID());
        whereClause.append(" AND C_Charge_ID IS NOT null");
        int[] rmaLineIds = MRMALine.getAllIDs("M_RMALine", whereClause.toString(), this.get_TrxName());
        ArrayList<MRMALine> chargeLineList = new ArrayList<MRMALine>();
        for (int i2 = 0; i2 < rmaLineIds.length; ++i2) {
            MRMALine rmaLine = new MRMALine(this.getCtx(), rmaLineIds[i2], this.get_TrxName());
            chargeLineList.add(rmaLine);
        }
        MRMALine[] lines = new MRMALine[chargeLineList.size()];
        chargeLineList.toArray(lines);
        return lines;
    }

    public boolean isTaxIncluded() {
        MOrder order = this.getOriginalOrder();
        if (order != null && order.get_ID() != 0) {
            return order.isTaxIncluded();
        }
        return true;
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return this.getAmt();
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }
}

