/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_AD_Ref_List;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.ValueNamePair;

public class MRefList
extends X_AD_Ref_List {
    private static final long serialVersionUID = -6948532574960232289L;
    static CCache<String, MRefList> referenceListCache = new CCache("MRefList", 50);
    private static CLogger s_log = CLogger.getCLogger(MRefList.class);
    private static CCache<String, String> s_cache = new CCache("AD_Ref_List", 20);

    public static MRefList get(Properties ctx, int referenceId, String value, String trxName) {
        String key = referenceId + "-" + value;
        MRefList referenceList = referenceListCache.get(key);
        if (referenceList != null) {
            return referenceList;
        }
        referenceList = (MRefList)new Query(ctx, "AD_Ref_List", "AD_Reference_ID=? AND Value=?", trxName).setParameters(referenceId, value).firstOnly();
        if (referenceList != null) {
            referenceList.set_TrxName(null);
            referenceListCache.put(key, referenceList);
        }
        return referenceList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getListName(Properties ctx, int AD_Reference_ID, String Value) {
        String AD_Language = Env.getAD_Language(ctx);
        String key = AD_Language + "_" + AD_Reference_ID + "_" + Value;
        String retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        boolean isBaseLanguage = Env.isBaseLanguage(AD_Language, "AD_Ref_List");
        String sql = isBaseLanguage ? "SELECT Name FROM AD_Ref_List WHERE AD_Reference_ID=? AND Value=?" : "SELECT t.Name FROM AD_Ref_List_Trl t INNER JOIN AD_Ref_List r ON (r.AD_Ref_List_ID=t.AD_Ref_List_ID) WHERE r.AD_Reference_ID=? AND r.Value=? AND t.AD_Language=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Reference_ID);
            pstmt.setString(2, Value);
            if (!isBaseLanguage) {
                pstmt.setString(3, AD_Language);
            }
            if ((rs = pstmt.executeQuery()).next()) {
                retValue = rs.getString(1);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException ex) {
            s_log.log(Level.SEVERE, sql + " -- " + key, ex);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue == null) {
            retValue = "";
            s_log.warning("Not found " + key);
        }
        s_cache.put(key, retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getListDescription(Properties ctx, String ListName, String Value) {
        String AD_Language = Env.getAD_Language(ctx);
        String key = AD_Language + "_" + ListName + "_" + Value;
        String retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        boolean isBaseLanguage = Env.isBaseLanguage(AD_Language, "AD_Ref_List");
        String sql = isBaseLanguage ? "SELECT a.Description FROM AD_Ref_List a, AD_Reference b WHERE b.Name=? AND a.Value=? AND a.AD_Reference_ID = b.AD_Reference_ID" : "SELECT t.Description FROM AD_Reference r INNER JOIN AD_Ref_List rl ON (r.AD_Reference_ID=rl.AD_Reference_ID) INNER JOIN AD_Ref_List_Trl t ON (t.AD_Ref_List_ID=rl.AD_Ref_List_ID) WHERE r.Name=? AND rl.Value=? AND t.AD_Language=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, ListName);
            pstmt.setString(2, Value);
            if (!isBaseLanguage) {
                pstmt.setString(3, AD_Language);
            }
            if ((rs = pstmt.executeQuery()).next()) {
                retValue = rs.getString(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException ex) {
            s_log.log(Level.SEVERE, sql + " -- " + key, ex);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue == null) {
            retValue = "";
            s_log.info("getListDescription - Not found " + key);
        }
        s_cache.put(key, retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValueNamePair[] getList(Properties ctx, int AD_Reference_ID, boolean optional) {
        String ad_language = Env.getAD_Language(ctx);
        boolean isBaseLanguage = Env.isBaseLanguage(ad_language, "AD_Ref_List");
        String sql = isBaseLanguage ? "SELECT Value, Name FROM AD_Ref_List WHERE AD_Reference_ID=? AND IsActive='Y' ORDER BY Name" : "SELECT r.Value, t.Name FROM AD_Ref_List_Trl t INNER JOIN AD_Ref_List r ON (r.AD_Ref_List_ID=t.AD_Ref_List_ID) WHERE r.AD_Reference_ID=? AND t.AD_Language=? AND r.IsActive='Y' ORDER BY t.Name";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<ValueNamePair> list = new ArrayList<ValueNamePair>();
        if (optional) {
            list.add(new ValueNamePair("", ""));
        }
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Reference_ID);
            if (!isBaseLanguage) {
                pstmt.setString(2, ad_language);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new ValueNamePair(rs.getString(1), rs.getString(2)));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        ValueNamePair[] retValue = new ValueNamePair[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MRefList(Properties ctx, int AD_Ref_List_ID, String trxName) {
        super(ctx, AD_Ref_List_ID, trxName);
        if (AD_Ref_List_ID == 0) {
            this.setEntityType("U");
        }
    }

    public MRefList(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

