/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import io.vavr.CheckedFunction1;
import io.vavr.Tuple;
import io.vavr.control.Try;
import java.awt.Color;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.sql.RowSet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.adempiere.core.domains.models.X_AD_Menu;
import org.adempiere.core.domains.models.X_AD_Org;
import org.adempiere.core.domains.models.X_AD_Tree;
import org.adempiere.core.domains.models.X_CM_CStage;
import org.adempiere.core.domains.models.X_CM_Container;
import org.adempiere.core.domains.models.X_CM_Media;
import org.adempiere.core.domains.models.X_CM_Template;
import org.adempiere.core.domains.models.X_C_Activity;
import org.adempiere.core.domains.models.X_C_BPartner;
import org.adempiere.core.domains.models.X_C_Campaign;
import org.adempiere.core.domains.models.X_C_ElementValue;
import org.adempiere.core.domains.models.X_C_Project;
import org.adempiere.core.domains.models.X_C_SalesRegion;
import org.adempiere.core.domains.models.X_M_BOM;
import org.adempiere.core.domains.models.X_M_Product;
import org.adempiere.core.domains.models.X_M_Product_Category;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.MTreeNode;
import org.compiere.print.MPrintColor;
import org.compiere.util.CCache;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.ResultSetIterable;
import org.compiere.util.Util;

public class MTree
extends X_AD_Tree {
    private static final long serialVersionUID = -6412057411585787707L;
    private boolean isTreeEditable = false;
    private ArrayList<MTreeNode> treeNodes = new ArrayList();
    private RowSet nodeRowSet;
    private MTreeNode rootNode = null;
    private HashMap<Integer, ArrayList<Integer>> nodeIdMap;
    private static CLogger logger = CLogger.getCLogger(MTree.class);
    private static CCache<Integer, MTree> s_cache = new CCache("AD_Tree", 10);
    private static CCache<String, Integer> treeIdFromStringKey = new CCache("AD_Tree_Table_ID", 10);
    private static ArrayList<String> s_TableNames = null;
    private static List<Integer> s_TableIDs = null;
    private static List<Integer> s_TableIDs_U1 = null;
    private static List<Integer> s_TableIDs_U2 = null;
    private static List<Integer> s_TableIDs_U3 = null;
    private static List<Integer> s_TableIDs_U4 = null;
    private static final String[] TREETYPES = new String[]{"AY", "BB", "BP", "CC", "CM", "CS", "CT", "EV", "MC", "MM", "OO", "PC", "PJ", "PR", "SR", "U1", "U2", "U3", "U4", "CU"};
    private static final int[] TABLEIDS = new int[]{X_C_Activity.Table_ID, X_M_BOM.Table_ID, X_C_BPartner.Table_ID, X_CM_Container.Table_ID, X_CM_Media.Table_ID, X_CM_CStage.Table_ID, X_CM_Template.Table_ID, X_C_ElementValue.Table_ID, X_C_Campaign.Table_ID, X_AD_Menu.Table_ID, X_AD_Org.Table_ID, X_M_Product_Category.Table_ID, X_C_Project.Table_ID, X_M_Product.Table_ID, X_C_SalesRegion.Table_ID, 0, 0, 0, 0, 0};

    public MTree(Properties ctx, int AD_Tree_ID, String trxName) {
        super(ctx, AD_Tree_ID, trxName);
        if (AD_Tree_ID == 0) {
            this.setIsAllNodes(true);
            this.setIsDefault(false);
        }
    }

    public MTree(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MTree(MClient client, String name, String treeType) {
        this(client.getCtx(), 0, client.get_TrxName());
        this.setClientOrg(client);
        this.setName(name);
        this.setTreeType(treeType);
    }

    public MTree(Properties ctx, String Name2, String TreeType, String trxName) {
        super(ctx, 0, trxName);
        this.setName(Name2);
        this.setTreeType(TreeType);
        this.setIsAllNodes(true);
        this.setIsDefault(false);
    }

    public MTree(Properties ctx, int treeId, boolean editable, String trxName) {
        this(ctx, treeId, editable, false, trxName);
    }

    public MTree(Properties ctx, int treeId, boolean editable, boolean allNodes, String trxName) {
        this(ctx, treeId, editable, allNodes, null, trxName);
    }

    public MTree(Properties ctx, int treeId, boolean editable, boolean allNodes, String whereClause, String trxName) {
        this(ctx, treeId, trxName);
        this.isTreeEditable = editable;
        int userId = allNodes ? -1 : Env.getContextAsInt(ctx, "AD_User_ID");
        this.log.info("AD_Tree_ID=" + treeId + ", AD_User_ID=" + userId + ", Editable=" + editable);
        this.loadNodes(userId, whereClause);
    }

    @Override
    public void setTreeType(String TreeType) {
        super.setTreeType(TreeType);
        this.setTable_ID(TreeType);
    }

    public static int getTableIdFromTreeType(String treeType) {
        int tableId = 0;
        if ("AY".equals(treeType)) {
            tableId = X_C_Activity.Table_ID;
        } else if ("BP".equals(treeType)) {
            tableId = X_C_BPartner.Table_ID;
        } else if ("MC".equals(treeType)) {
            tableId = X_C_Campaign.Table_ID;
        } else if ("CC".equals(treeType)) {
            tableId = X_CM_Container.Table_ID;
        } else if ("CS".equals(treeType)) {
            tableId = X_CM_CStage.Table_ID;
        } else if ("CM".equals(treeType)) {
            tableId = X_CM_Media.Table_ID;
        } else if ("CT".equals(treeType)) {
            tableId = X_CM_Template.Table_ID;
        } else if ("EV".equals(treeType) || "U1".equals(treeType) || "U2".equals(treeType) || "U3".equals(treeType) || "U4".equals(treeType)) {
            tableId = X_C_ElementValue.Table_ID;
        } else if ("OO".equals(treeType)) {
            tableId = X_AD_Org.Table_ID;
        } else if ("PR".equals(treeType)) {
            tableId = X_M_Product.Table_ID;
        } else if ("PC".equals(treeType)) {
            tableId = X_M_Product_Category.Table_ID;
        } else if ("BB".equals(treeType)) {
            tableId = X_M_BOM.Table_ID;
        } else if ("PJ".equals(treeType)) {
            tableId = X_C_Project.Table_ID;
        } else if ("SR".equals(treeType)) {
            tableId = X_C_SalesRegion.Table_ID;
        }
        if ("MM".equals(treeType)) {
            tableId = X_AD_Menu.Table_ID;
        }
        return tableId;
    }

    public static String getSourceTableName(String treeType) {
        if (treeType == null) {
            return null;
        }
        String sourceTable = null;
        if (treeType.equals("MM")) {
            sourceTable = "AD_Menu";
        } else if (treeType.equals("OO")) {
            sourceTable = "AD_Org";
        } else if (treeType.equals("PR")) {
            sourceTable = "M_Product";
        } else if (treeType.equals("PC")) {
            sourceTable = "M_Product_Category";
        } else if (treeType.equals("BB")) {
            sourceTable = "M_BOM";
        } else if (treeType.equals("BP")) {
            sourceTable = "C_BPartner";
        } else if (treeType.equals("MC")) {
            sourceTable = "C_Campaign";
        } else if (treeType.equals("PJ")) {
            sourceTable = "C_Project";
        } else if (treeType.equals("AY")) {
            sourceTable = "C_Activity";
        } else if (treeType.equals("SR")) {
            sourceTable = "C_SalesRegion";
        } else if (treeType.equals("CC")) {
            sourceTable = "CM_Container";
        } else if (treeType.equals("CS")) {
            sourceTable = "CM_CStage";
        } else if (treeType.equals("CM")) {
            sourceTable = "CM_Media";
        } else if (treeType.equals("CT")) {
            sourceTable = "CM_Template";
        } else if (treeType.equals("EV") || treeType.equals("U1") || treeType.equals("U2") || treeType.equals("U3") || treeType.equals("U4")) {
            sourceTable = "C_ElementValue";
        }
        return sourceTable;
    }

    public String getSourceTableName() {
        if (this.getTreeType().equals("CU")) {
            if (this.getAD_Table_ID() == 0) {
                throw new AdempiereException("@AD_Table_ID@ @NotFound@");
            }
            MTable table2 = MTable.get(this.getCtx(), this.getAD_Table_ID());
            if (table2 == null) {
                throw new AdempiereException("@AD_Table_ID@ @NotFound@");
            }
            return table2.getTableName();
        }
        return MTree.getSourceTableName(this.getTreeType());
    }

    public static String getNodeTableName(int tableId) {
        Object nodeTableName;
        Object object = nodeTableName = tableId == 0 ? null : "AD_TreeNode";
        if (X_AD_Menu.Table_ID == tableId) {
            nodeTableName = (String)nodeTableName + "MM";
        } else if (X_C_BPartner.Table_ID == tableId) {
            nodeTableName = (String)nodeTableName + "BP";
        } else if (X_M_Product.Table_ID == tableId) {
            nodeTableName = (String)nodeTableName + "PR";
        } else if (X_CM_Container.Table_ID == tableId) {
            nodeTableName = (String)nodeTableName + "CMC";
        } else if (X_CM_CStage.Table_ID == tableId) {
            nodeTableName = (String)nodeTableName + "CMS";
        } else if (X_CM_Media.Table_ID == tableId) {
            nodeTableName = (String)nodeTableName + "CMM";
        } else if (X_CM_Template.Table_ID == tableId) {
            nodeTableName = (String)nodeTableName + "CMT";
        } else {
            Integer ii;
            if (s_TableIDs == null) {
                MTree.fillUserTables(null);
            }
            if (s_TableIDs.contains(ii = Integer.valueOf(tableId))) {
                if (s_TableIDs_U1.contains(ii)) {
                    nodeTableName = (String)nodeTableName + "U1";
                } else if (s_TableIDs_U2.contains(ii)) {
                    nodeTableName = (String)nodeTableName + "U2";
                } else if (s_TableIDs_U3.contains(ii)) {
                    nodeTableName = (String)nodeTableName + "U3";
                } else if (s_TableIDs_U4.contains(ii)) {
                    nodeTableName = (String)nodeTableName + "U4";
                }
            }
        }
        return nodeTableName;
    }

    public static String getNodeTableName(String treeType) {
        Object nodeTableName = "AD_TreeNode";
        if ("MM".equals(treeType)) {
            nodeTableName = (String)nodeTableName + "MM";
        } else if ("BP".equals(treeType)) {
            nodeTableName = (String)nodeTableName + "BP";
        } else if ("PR".equals(treeType)) {
            nodeTableName = (String)nodeTableName + "PR";
        } else if ("CC".equals(treeType)) {
            nodeTableName = (String)nodeTableName + "CMC";
        } else if ("CS".equals(treeType)) {
            nodeTableName = (String)nodeTableName + "CMS";
        } else if ("CM".equals(treeType)) {
            nodeTableName = (String)nodeTableName + "CMM";
        } else if ("CT".equals(treeType)) {
            nodeTableName = (String)nodeTableName + "CMT";
        } else if ("U1".equals(treeType)) {
            nodeTableName = (String)nodeTableName + "U1";
        } else if ("U2".equals(treeType)) {
            nodeTableName = (String)nodeTableName + "U2";
        } else if ("U3".equals(treeType)) {
            nodeTableName = (String)nodeTableName + "U3";
        } else if ("U4".equals(treeType)) {
            nodeTableName = (String)nodeTableName + "U4";
        }
        return nodeTableName;
    }

    private void setTable_ID(String treeType) {
        if (this.getAD_Table_ID() > 0) {
            return;
        }
        this.setAD_Table_ID(MTree.getTableIdFromTreeType(treeType));
    }

    static synchronized void fillUserTables(String trxName) {
        KeyNamePair[] treeArray;
        boolean withTable;
        s_TableNames = new ArrayList();
        s_TableIDs = new ArrayList<Integer>();
        s_TableIDs_U1 = new ArrayList<Integer>();
        s_TableIDs_U2 = new ArrayList<Integer>();
        s_TableIDs_U3 = new ArrayList<Integer>();
        s_TableIDs_U4 = new ArrayList<Integer>();
        boolean bl = withTable = MColumn.getColumn_ID("AD_Tree", "AD_Table_ID") > 0;
        if (!withTable) {
            return;
        }
        boolean error = false;
        for (KeyNamePair pair : treeArray = DB.getKeyNamePairs("SELECT DISTINCT AD_Table_ID, TreeType FROM AD_Tree", false)) {
            int tableId = pair.getKey();
            String treeType = pair.getName();
            if (tableId <= 0) continue;
            s_TableIDs.add(tableId);
            if (treeType.equals("U1")) {
                s_TableIDs_U1.add(tableId);
                continue;
            }
            if (treeType.equals("U2")) {
                s_TableIDs_U2.add(tableId);
                continue;
            }
            if (treeType.equals("U3")) {
                s_TableIDs_U3.add(tableId);
                continue;
            }
            if (!treeType.equals("U4")) continue;
            s_TableIDs_U4.add(tableId);
        }
        if (!error && s_TableIDs.size() < 3) {
            MTree xx = MTree.get(Env.getCtx(), 10, trxName);
            xx.updateTrees();
            MTree.fillUserTables(null);
        }
    }

    public void updateTrees() {
        this.setAD_Table_ID();
        for (int i2 = 0; i2 < TREETYPES.length && this.updateTrees(TREETYPES[i2], TABLEIDS[i2]); ++i2) {
        }
    }

    private boolean updateTrees(String treeType, int tableId) {
        if (tableId == 0) {
            return true;
        }
        StringBuilder sb = new StringBuilder("UPDATE AD_Tree SET AD_Table_ID=?").append(" WHERE TreeType=?").append(" AND AD_Table_ID IS NULL");
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(tableId);
        parameters.add(treeType);
        int no = DB.executeUpdateEx(sb.toString(), parameters.toArray(), this.get_TrxName());
        this.log.fine(treeType + " #" + no);
        return no >= 0;
    }

    private int setAD_Table_ID() {
        int tableId = 0;
        String type = this.getTreeType();
        if (type == null || type.startsWith("U") || type.equals("CU")) {
            return 0;
        }
        for (int i2 = 0; i2 < TREETYPES.length; ++i2) {
            if (!type.equals(TREETYPES[i2])) continue;
            tableId = TABLEIDS[i2];
            break;
        }
        if (tableId != 0) {
            this.setAD_Table_ID(tableId);
        }
        if (tableId == 0) {
            this.log.warning("Did not find Table for TreeType=" + type);
        }
        return tableId;
    }

    public static boolean hasTree(int testTableId) {
        for (int tableId : TABLEIDS) {
            if (tableId != testTableId) continue;
            return true;
        }
        if (s_TableIDs == null) {
            MTree.fillUserTables(null);
        }
        Integer ii = testTableId;
        return s_TableIDs.contains(ii);
    }

    public static boolean hasTree(String tableName) {
        if (s_TableNames == null) {
            MTree.fillUserTables(null);
        }
        return s_TableNames.contains(tableName);
    }

    public static int getDefaultTreeIdFromTableId(int clientId, int tableId) {
        return MTree.getDefaultTreeIdFromTableId(clientId, tableId, 0);
    }

    public static int getDefaultTreeIdFromTableId(int clientId, int tableId, int elementId) {
        String sql;
        if (tableId <= 0) {
            return -1;
        }
        logger.finer("TableId=" + tableId);
        String key = "TableId|" + clientId + "|" + tableId;
        Integer treeId = treeIdFromStringKey.get(key);
        Object whereClause = new String();
        if (elementId != 0) {
            whereClause = " AND EXISTS (SELECT 1 FROM C_Element ae WHERE ae.C_Element_ID=" + elementId + " AND tr.AD_Tree_ID=ae.AD_Tree_ID) ";
        }
        if ((treeId == null || treeId == 0) && (treeId = Integer.valueOf(DB.getSQLValue(null, sql = "SELECT tr.AD_Tree_ID FROM AD_Tree tr WHERE tr.AD_Client_ID = ? AND tr.AD_Table_ID = ? AND tr.IsActive='Y' AND tr.IsAllNodes='Y' " + (String)whereClause + "ORDER BY tr.IsDefault DESC", clientId, tableId))) > 0) {
            treeIdFromStringKey.put(key, treeId);
        }
        return treeId;
    }

    public static int getDefaultTreeIdFromTableName(int clientId, String tableName) {
        return MTree.getDefaultTreeIdFromTableName(clientId, tableName, 0);
    }

    public static int getDefaultTreeIdFromTableName(int clientId, String tableName, int elementId) {
        String sql;
        if (Util.isEmpty(tableName)) {
            return -1;
        }
        logger.finer("TableName=" + tableName);
        String key = "TableName|" + tableName;
        Integer treeId = treeIdFromStringKey.get(key);
        Object whereClause = new String();
        if (elementId != 0) {
            whereClause = " AND EXISTS (SELECT 1 FROM C_Element ae WHERE ae.C_Element_ID=" + elementId + " AND tr.AD_Tree_ID=ae.AD_Tree_ID) ";
        }
        if ((treeId == null || treeId == 0) && (treeId = Integer.valueOf(DB.getSQLValue(null, sql = "SELECT tr.AD_Tree_ID FROM AD_Tree tr INNER JOIN AD_Table tb ON (tr.AD_Table_ID=tb.AD_Table_ID) WHERE tr.AD_Client_ID IN(0, ?) AND tb.TableName=? AND tr.IsActive='Y' AND tr.IsAllNodes='Y' " + (String)whereClause + "ORDER BY tr.IsDefault DESC, tr.AD_Tree_ID", clientId, tableName))) > 0) {
            treeIdFromStringKey.put(key, treeId);
        }
        return treeId;
    }

    private void loadNodes(int userId, String whereClause) {
        MTreeNode node;
        int i2;
        ArrayList<Constable> parameters = new ArrayList<Constable>();
        String fromClause = this.getSourceTableName();
        StringBuilder sql = new StringBuilder("SELECT tn.Node_ID,tn.Parent_ID,tn.SeqNo,tb.IsActive FROM ").append(this.getNodeTableName()).append(" tn ").append("LEFT JOIN ").append(fromClause).append(" ON(").append(fromClause).append(".").append(fromClause).append("_ID").append(" = tn.Node_ID) ").append(" LEFT OUTER JOIN AD_TreeBar tb ON (tn.AD_Tree_ID=tb.AD_Tree_ID AND tn.Node_ID=tb.Node_ID ").append(userId != -1 ? " AND tb.AD_User_ID=? " : "").append(") ").append("WHERE tn.AD_Tree_ID=?");
        if (userId != -1) {
            parameters.add(Integer.valueOf(userId));
        }
        parameters.add(Integer.valueOf(this.getAD_Tree_ID()));
        if (!this.isTreeEditable) {
            sql.append(" AND tn.IsActive=?");
            parameters.add(Boolean.valueOf(true));
        }
        if (whereClause != null && whereClause.length() > 0) {
            sql.append(" AND ").append(whereClause);
        }
        sql.append(" GROUP BY tn.Node_ID,tn.Parent_ID,tn.SeqNo,tb.IsActive ");
        sql.append(" ORDER BY COALESCE(tn.Parent_ID, -1), tn.SeqNo");
        this.log.finest(sql.toString());
        this.getNodeDetails();
        this.rootNode = new MTreeNode(0, 0, this.getName(), this.getDescription(), 0, true, null, false, null);
        Try addToTree = ((Try)DB.runResultSetFunction.apply((Object)this.get_TrxName(), (Object)sql.toString(), (Object)io.vavr.collection.List.ofAll(parameters), resultSet -> {
            ResultSetIterable records = new ResultSetIterable((ResultSet)resultSet, (CheckedFunction1 & Serializable)row -> Tuple.of((Object)row.getInt(1), (Object)row.getInt(2), (Object)row.getInt(3), (Object)row.getString(4)));
            records.stream().filter(node -> (Integer)node._1 != 0 || (Integer)node._2 != 0).forEach(node -> this.addToTree((Integer)node._1, (Integer)node._2, (Integer)node._3, node._4 != null));
        })).andFinally(() -> {
            this.nodeRowSet = null;
            this.nodeIdMap = null;
        }).onFailure(throwable -> this.log.log(Level.SEVERE, sql.toString(), (Throwable)throwable));
        if (addToTree.isFailure()) {
            return;
        }
        if (this.treeNodes.size() != 0) {
            this.log.finest("clearing buffer - Adding to: " + this.rootNode);
            for (i2 = 0; i2 < this.treeNodes.size(); ++i2) {
                node = this.treeNodes.get(i2);
                MTreeNode parent = this.rootNode.findNode(node.getParent_ID());
                if (parent == null || !parent.getAllowsChildren()) continue;
                parent.add(node);
                int sizeBeforeCheckBuffer = this.treeNodes.size();
                this.checkBuffer(node);
                if (sizeBeforeCheckBuffer == this.treeNodes.size()) {
                    this.treeNodes.remove(i2);
                }
                i2 = -1;
            }
        }
        if (this.treeNodes.size() != 0) {
            this.log.severe("Nodes w/o parent - adding to root - " + this.treeNodes);
            for (i2 = 0; i2 < this.treeNodes.size(); ++i2) {
                node = this.treeNodes.get(i2);
                this.rootNode.add(node);
                int sizeBeforeCheckBuffer = this.treeNodes.size();
                this.checkBuffer(node);
                if (sizeBeforeCheckBuffer == this.treeNodes.size()) {
                    this.treeNodes.remove(i2);
                }
                i2 = -1;
            }
            if (this.treeNodes.size() != 0) {
                this.log.severe("Still nodes in Buffer - " + this.treeNodes);
            }
        }
        if (!this.isTreeEditable && this.rootNode.getChildCount() > 0) {
            this.trimTree();
        }
        if (CLogMgt.isLevelFinest() || this.rootNode.getChildCount() == 0) {
            this.log.fine("ChildCount=" + this.rootNode.getChildCount());
        }
    }

    private void addToTree(int nodeId, int parentId, int seqNo, boolean onBar) {
        MTreeNode child = this.getNodeDetail(nodeId, parentId, seqNo, onBar);
        if (child == null) {
            return;
        }
        DefaultMutableTreeNode parent = null;
        if (this.rootNode != null) {
            parent = this.rootNode.findNode(parentId);
        }
        if (parent != null && parent.getAllowsChildren()) {
            parent.add(child);
            if (this.treeNodes.size() > 0) {
                this.checkBuffer(child);
            }
        } else {
            this.treeNodes.add(child);
        }
    }

    private void checkBuffer(MTreeNode newNode) {
        if (!newNode.isSummary() || !newNode.getAllowsChildren()) {
            return;
        }
        for (int i2 = 0; i2 < this.treeNodes.size(); ++i2) {
            MTreeNode node = this.treeNodes.get(i2);
            if (node.getParent_ID() != newNode.getNode_ID()) continue;
            try {
                newNode.add(node);
            }
            catch (Exception e) {
                this.log.severe("Adding " + node.getName() + " to " + newNode.getName() + ": " + e.getMessage());
            }
            this.treeNodes.remove(i2);
            --i2;
        }
    }

    public static MTree get(Properties ctx, int AD_Tree_ID, String trxName) {
        Integer key = AD_Tree_ID;
        MTree retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MTree(ctx, AD_Tree_ID, trxName);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public String getNodeTableName() {
        String tableName = MTree.getNodeTableName(this.getTreeType());
        if (tableName == null) {
            tableName = MTree.getNodeTableName(this.getAD_Table_ID());
        }
        return tableName;
    }

    public String getActionColorName() {
        String tableName = this.getSourceTableName();
        if ("AD_Menu".equals(tableName)) {
            return "t.Action";
        }
        return "NULL";
    }

    private void getNodeDetails() {
        boolean base;
        StringBuilder sqlNode = new StringBuilder();
        String sourceTable = "t";
        String fromClause = this.getSourceTableName();
        String color = this.getActionColorName();
        if (this.getTreeType().equals("MM")) {
            boolean hasWhere;
            base = Env.isBaseLanguage(this.p_ctx, "AD_Menu");
            sourceTable = "m";
            if (base) {
                sqlNode.append("SELECT m.AD_Menu_ID, m.Name,m.Description,m.IsSummary,m.Action, m.AD_Window_ID, m.AD_Process_ID, m.AD_Form_ID, m.AD_Workflow_ID, m.AD_Task_ID, m.AD_Workbench_ID , m.AD_Browse_ID FROM AD_Menu m");
            } else {
                sqlNode.append("SELECT m.AD_Menu_ID,  t.Name,t.Description,m.IsSummary,m.Action, m.AD_Window_ID, m.AD_Process_ID, m.AD_Form_ID, m.AD_Workflow_ID, m.AD_Task_ID, m.AD_Workbench_ID , m.AD_Browse_ID FROM AD_Menu m LEFT JOIN AD_Menu_Trl t ON(t.AD_Menu_ID = m.AD_Menu_ID AND t.AD_Language='").append(Env.getAD_Language(this.p_ctx)).append("') ");
            }
            if (!this.isTreeEditable) {
                hasWhere = sqlNode.indexOf(" WHERE ") != -1;
                sqlNode.append(hasWhere ? " AND " : " WHERE ").append("m.IsActive='Y' ");
            }
            if (!MClient.get(this.getCtx()).isUseBetaFunctions()) {
                hasWhere = sqlNode.indexOf(" WHERE ") != -1;
                sqlNode.append(hasWhere ? " AND " : " WHERE ");
                sqlNode.append("(m.AD_Window_ID IS NULL OR EXISTS (SELECT 1 FROM AD_Window w WHERE m.AD_Window_ID=w.AD_Window_ID AND w.IsBetaFunctionality='N'))").append(" AND (m.AD_Process_ID IS NULL OR EXISTS (SELECT 1 FROM AD_Process p WHERE m.AD_Process_ID=p.AD_Process_ID AND p.IsBetaFunctionality='N'))").append(" AND (m.AD_Workflow_ID IS NULL OR EXISTS (SELECT 1 FROM AD_Workflow wf WHERE m.AD_Workflow_ID=wf.AD_Workflow_ID AND wf.IsBetaFunctionality='N'))").append(" AND (m.AD_Form_ID IS NULL OR EXISTS (SELECT 1 FROM AD_Form f WHERE m.AD_Form_ID=f.AD_Form_ID AND f.IsBetaFunctionality='N'))").append(" AND (m.AD_Browse_ID IS NULL OR EXISTS (SELECT 1 FROM AD_Browse b WHERE m.AD_Browse_ID=b.AD_Browse_ID AND b.IsBetaFunctionality='N'))");
            }
            if (!this.isTreeEditable) {
                hasWhere = sqlNode.indexOf(" WHERE ") != -1;
                sqlNode.append(hasWhere ? " AND " : " WHERE ");
                sqlNode.append("(m.AD_Form_ID IS NULL OR EXISTS (SELECT 1 FROM AD_Form f WHERE m.AD_Form_ID=f.AD_Form_ID AND (f.Classname IS NOT NULL OR f.JSPURL IS NOT NULL)))");
            }
        } else if (this.getTreeType().equals("CU")) {
            base = Env.isBaseLanguage(this.p_ctx, fromClause);
            boolean translation = !base && MTable.hasTranslation(fromClause);
            sourceTable = "t";
            String recordClause = "";
            if (!translation) {
                sqlNode.append("SELECT t." + fromClause + "_ID, ").append("COALESCE(t.Name, '') AS Name, COALESCE(t.Description, '') AS Description, t.IsSummary, " + color + " AS Action ").append((String)(recordClause.length() > 0 ? ", " + recordClause : "")).append(" FROM ").append(fromClause).append(" AS t ");
            } else {
                sqlNode.append("SELECT t." + fromClause + "_ID, ").append("COALESCE(tt.Name, t.Name, '') AS Name, COALESCE(tt.Description, t.Description, '') AS Description, t.IsSummary,  ").append(color + " AS Action ").append((String)(recordClause.length() > 0 ? ", " + recordClause : "")).append(" FROM ").append(fromClause).append(" AS t ").append(" LEFT JOIN " + fromClause + "_Trl tt ON (t. " + fromClause + "_ID = t." + fromClause + "_ID AND tt.AD_Language='").append(Env.getAD_Language(this.p_ctx)).append("'").append(")");
            }
            if (!this.isTreeEditable) {
                boolean hasWhere = sqlNode.indexOf(" WHERE ") != -1;
                sqlNode.append(hasWhere ? " AND " : " WHERE ").append("t.IsActive='Y' ");
            }
        } else {
            if (fromClause == null) {
                throw new IllegalArgumentException("Unknown TreeType=" + this.getTreeType());
            }
            sqlNode.append("SELECT t.").append(fromClause).append("_ID,t.Name,t.Description,t.IsSummary,").append(color);
            if (this.containsValueColumn(fromClause)) {
                sqlNode.append(", t.Value");
            }
            sqlNode.append(" FROM ").append(fromClause).append(" t ");
            if (!this.isTreeEditable) {
                sqlNode.append(" WHERE t.IsActive='Y'");
            }
        }
        String sql = sqlNode.toString();
        if (!this.isTreeEditable) {
            sql = MRole.getDefault(this.getCtx(), false).addAccessSQL(sql, sourceTable, true, this.isTreeEditable);
        }
        this.log.fine(sql);
        this.nodeRowSet = DB.getRowSet(sql);
        this.nodeIdMap = new HashMap(50);
        try {
            this.nodeRowSet.beforeFirst();
            int i2 = 0;
            while (this.nodeRowSet.next()) {
                ++i2;
                int node = this.nodeRowSet.getInt(1);
                Integer nodeId = node;
                ArrayList<Integer> list = this.nodeIdMap.get(nodeId);
                if (list == null) {
                    list = new ArrayList(5);
                    this.nodeIdMap.put(nodeId, list);
                }
                list.add(i2);
            }
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "", e);
        }
    }

    public boolean containsValueColumn(String sourceTableName) {
        boolean result = false;
        MTable treeTable = MTable.get(this.getCtx(), sourceTableName);
        MColumn valueColumn = treeTable.getColumn("Value");
        if (valueColumn != null && valueColumn.getAD_Column_ID() > 0) {
            result = true;
        }
        return result;
    }

    private MTreeNode getNodeDetail(int node_ID, int parent_ID, int seqNo, boolean onBar) {
        MTreeNode retValue = null;
        try {
            ArrayList<Integer> nodeList = this.nodeIdMap.get(node_ID);
            int size = nodeList != null ? nodeList.size() : 0;
            int i2 = 0;
            while (i2 < size) {
                MPrintColor printColor;
                Integer nodeId = nodeList.get(i2);
                ++i2;
                this.nodeRowSet.absolute(nodeId);
                int node = this.nodeRowSet.getInt(1);
                if (node_ID != node) continue;
                int index = 2;
                Object name = this.nodeRowSet.getString(index++);
                String description = this.nodeRowSet.getString(index++);
                boolean isSummary = "Y".equals(this.nodeRowSet.getString(index++));
                String actionColor = this.nodeRowSet.getString(index++);
                if (this.getTreeType().equals("MM") && !isSummary) {
                    int AD_Window_ID = this.nodeRowSet.getInt(index++);
                    int AD_Process_ID = this.nodeRowSet.getInt(index++);
                    int AD_Form_ID = this.nodeRowSet.getInt(index++);
                    int AD_Workflow_ID = this.nodeRowSet.getInt(index++);
                    int AD_Task_ID = this.nodeRowSet.getInt(index++);
                    int AD_Workbench_ID = this.nodeRowSet.getInt(index++);
                    int AD_Browse_ID = this.nodeRowSet.getInt(index++);
                    MRole role = MRole.getDefault(this.getCtx(), false);
                    Boolean access = null;
                    if ("W".equals(actionColor)) {
                        access = role.getWindowAccess(AD_Window_ID);
                    } else if ("P".equals(actionColor) || "R".equals(actionColor)) {
                        access = role.getProcessAccess(AD_Process_ID);
                    } else if ("X".equals(actionColor)) {
                        access = role.getFormAccess(AD_Form_ID);
                    } else if ("S".equals(actionColor)) {
                        access = role.getBrowseAccess(AD_Browse_ID);
                    } else if ("F".equals(actionColor)) {
                        access = role.getWorkflowAccess(AD_Workflow_ID);
                    } else if ("T".equals(actionColor)) {
                        access = role.getTaskAccess(AD_Task_ID);
                    }
                    if (access == null && !this.isTreeEditable) continue;
                    retValue = new MTreeNode(node_ID, seqNo, (String)name, description, parent_ID, isSummary, actionColor, onBar, null);
                    continue;
                }
                if (this.getTreeType().equals("CU")) {
                    retValue = new MTreeNode(node_ID, seqNo, (String)name, description, parent_ID, isSummary, actionColor, onBar, null);
                    continue;
                }
                Color color = null;
                if (actionColor != null && !this.getTreeType().equals("MM") && (printColor = MPrintColor.get(this.getCtx(), actionColor)) != null) {
                    color = printColor.getColor();
                }
                if (this.getTreeType().equals("EV")) {
                    String value = this.nodeRowSet.getString(index++);
                    name = value + " - " + (String)name;
                }
                retValue = new MTreeNode(node_ID, seqNo, (String)name, description, parent_ID, isSummary, null, onBar, color);
            }
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "", e);
        }
        return retValue;
    }

    public void trimTree() {
        boolean needsTrim;
        boolean bl = needsTrim = this.rootNode != null;
        while (needsTrim) {
            needsTrim = false;
            Enumeration<TreeNode> en = this.rootNode.preorderEnumeration();
            while (this.rootNode.getChildCount() > 0 && en.hasMoreElements()) {
                MTreeNode nd = (MTreeNode)en.nextElement();
                if (!nd.isSummary() || nd.getChildCount() != 0) continue;
                nd.removeFromParent();
                needsTrim = true;
            }
        }
    }

    private void dumpTree() {
        Enumeration<TreeNode> en = this.rootNode.preorderEnumeration();
        int count = 0;
        while (en.hasMoreElements()) {
            StringBuilder sb = new StringBuilder();
            MTreeNode nd = (MTreeNode)en.nextElement();
            for (int i2 = 0; i2 < nd.getLevel(); ++i2) {
                sb.append(" ");
            }
            sb.append("ID=").append(nd.getNode_ID()).append(", SeqNo=").append(nd.getSeqNo()).append(" ").append(nd.getName());
            System.out.println(sb.toString());
            ++count;
        }
    }

    public MTreeNode getRoot() {
        return this.rootNode;
    }

    public boolean isMenu() {
        return "MM".equals(this.getTreeType());
    }

    public boolean isProduct() {
        return "PR".equals(this.getTreeType());
    }

    public boolean isBPartner() {
        return "BP".equals(this.getTreeType());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MTree[");
        sb.append("AD_Tree_ID=").append(this.getAD_Tree_ID()).append(", Name=").append(this.getName());
        sb.append("]");
        return sb.toString();
    }
}

