/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.tree.DefaultMutableTreeNode;
import org.adempiere.core.domains.models.X_AD_Tree_Favorite;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MMenu;
import org.compiere.model.MTreeNode;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MTreeFavorite
extends X_AD_Tree_Favorite {
    private static final long serialVersionUID = 4367834596370363558L;
    private ArrayList<MTreeNode> m_buffer = new ArrayList();
    private MTreeNode mroot = null;

    public MTreeFavorite(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MTreeFavorite(Properties ctx, int AD_Tree_Favorite_ID, String trxName) {
        super(ctx, AD_Tree_Favorite_ID, trxName);
        if (AD_Tree_Favorite_ID != 0) {
            this.loadNode(AD_Tree_Favorite_ID);
        }
    }

    public int getTreeID(int roleid, int userid, int clientid) {
        int AD_Tree_ID = -1;
        String Query2 = "SELECT ad_tree_favorite_id FROM ad_tree_favorite  WHERE ad_role_id = ? AND ad_user_id = ? AND ad_client_id = ?";
        Object[] params = new Object[]{roleid, userid, clientid};
        AD_Tree_ID = DB.getSQLValue(null, Query2, params);
        return AD_Tree_ID;
    }

    public MTreeNode getRoot() {
        return this.mroot;
    }

    public void loadNode(int AD_Tree_Favorite_ID) {
        String displayQuery = "SELECT fn.ad_tree_favorite_node_id, fn.parent_id, fn.seqno, fn.nodename,  fn.issummary, fn.ad_menu_id, iscollapsible, coalesce(t.name, m.name) as menuTrl  FROM ad_tree_favorite_node fn   LEFT JOIN AD_Menu m on (m.AD_Menu_ID = fn.ad_menu_ID) LEFT JOIN AD_Menu_Trl t ON(t.AD_Menu_ID = fn.AD_Menu_ID AND t.AD_Language='" + Env.getAD_Language(this.p_ctx) + "') WHERE ad_tree_favorite_id = ?  ORDER BY COALESCE(parent_id,-1), seqno, nodename";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(displayQuery, this.get_TrxName());
            pstmt.setInt(1, AD_Tree_Favorite_ID);
            rs = pstmt.executeQuery();
            this.mroot = new MTreeNode(0, 0, "User Favourite Root", "User Favourite Root", 0, true, 0, null, false);
            while (rs.next()) {
                int NodeID = rs.getInt(1);
                int parentID = rs.getInt(2);
                int seqno = rs.getInt(3);
                String name = rs.getString(4);
                boolean isSummary = rs.getString(5).equals("Y");
                boolean isCollapsible = rs.getString("iscollapsible").equals("Y");
                String img2 = null;
                int menuID = 0;
                if (!isSummary) {
                    menuID = rs.getInt(6);
                    MMenu mMenu = new MMenu(Env.getCtx(), menuID, null);
                    name = Env.getLanguage(Env.getCtx()).isBaseLanguage() ? mMenu.getName() : rs.getString(8);
                    img2 = mMenu.getAction();
                }
                if (AD_Tree_Favorite_ID == 0 && (parentID == 0 || NodeID == 0)) continue;
                this.addToTree(NodeID, parentID, seqno, name, isSummary, menuID, img2, isCollapsible);
            }
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, displayQuery.toString(), e);
                throw new AdempiereException(e);
            }
            catch (Throwable throwable) {
                DB.close(rs);
                DB.close(pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs);
        DB.close(pstmt);
        rs = null;
        pstmt = null;
    }

    private void addToTree(int favNodeID, int parentID, int seqno, String name, boolean isSummary, int menuID, String img2, boolean isCollapsible) {
        MTreeNode child = new MTreeNode(favNodeID, seqno, name, name, parentID, isSummary, menuID, img2, isCollapsible);
        DefaultMutableTreeNode parent = null;
        if (this.mroot != null) {
            parent = this.mroot.findNode(parentID);
        }
        if (parent != null && parent.getAllowsChildren()) {
            parent.add(child);
            if (this.m_buffer.size() > 0) {
                this.checkBuffer(child);
            }
        } else {
            this.m_buffer.add(child);
        }
    }

    private void checkBuffer(MTreeNode child) {
        if (!child.isSummary() || !child.getAllowsChildren()) {
            return;
        }
        for (int i2 = 0; i2 < this.m_buffer.size(); ++i2) {
            MTreeNode node = this.m_buffer.get(i2);
            if (node.getParent_ID() == child.getParent_ID()) {
                try {
                    child.add(node);
                }
                catch (Exception e) {
                    this.log.severe("Adding " + node.getName() + " to " + child.getName() + ": " + e.getMessage());
                }
                this.m_buffer.remove(i2);
                --i2;
                continue;
            }
            if (node.getParent_ID() != child.getNode_ID()) continue;
            try {
                child.add(node);
            }
            catch (Exception e) {
                this.log.severe("Adding " + node.getName() + " to " + child.getName() + ": " + e.getMessage());
            }
            this.m_buffer.remove(i2);
            --i2;
        }
    }

    public boolean isMenuAvailable(int mID, int parent_ID, int treeFavoriteID) {
        String Query2 = "SELECT ad_menu_id FROM ad_tree_favorite_node  WHERE ad_tree_favorite_id = ? AND parent_id = ? AND ad_menu_id IS NOT NULL";
        boolean flag = false;
        CPreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DB.prepareStatement(Query2, null);
            stmt.setInt(1, treeFavoriteID);
            stmt.setInt(2, parent_ID);
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (rs.getInt(1) != mID) continue;
                flag = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new AdempiereException(e);
            }
            catch (Throwable throwable) {
                DB.close(rs);
                DB.close(stmt);
                rs = null;
                stmt = null;
                throw throwable;
            }
        }
        DB.close(rs);
        DB.close(stmt);
        rs = null;
        stmt = null;
        return flag;
    }
}

