/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_AD_User_OrgAccess;
import org.compiere.model.MOrg;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MUserOrgAccess
extends X_AD_User_OrgAccess {
    private static final long serialVersionUID = 11601583764711895L;
    private static CLogger s_log = CLogger.getCLogger(MUserOrgAccess.class);
    private String m_clientName;
    private String m_orgName;

    public static MUserOrgAccess[] getOfUser(Properties ctx, int AD_User_ID) {
        return MUserOrgAccess.get(ctx, "SELECT * FROM AD_User_OrgAccess WHERE AD_User_ID=?", AD_User_ID);
    }

    private static MUserOrgAccess[] get(Properties ctx, String sql, int id) {
        ArrayList<MUserOrgAccess> list = new ArrayList<MUserOrgAccess>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, id);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MUserOrgAccess(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MUserOrgAccess[] retValue = new MUserOrgAccess[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MUserOrgAccess(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MUserOrgAccess(Properties ctx, int ignored, String trxName) {
        super(ctx, 0, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
        this.setIsReadOnly(false);
    }

    public MUserOrgAccess(MOrg org, int AD_User_ID) {
        this(org.getCtx(), 0, org.get_TrxName());
        this.setClientOrg(org);
        this.setAD_User_ID(AD_User_ID);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MUserOrgAccess[");
        sb.append("AD_User_ID=").append(this.getAD_User_ID()).append(",AD_Client_ID=").append(this.getAD_Client_ID()).append(",AD_Org_ID=").append(this.getAD_Org_ID()).append(",RO=").append(this.isReadOnly());
        sb.append("]");
        return sb.toString();
    }

    public String toStringX(Properties ctx) {
        StringBuffer sb = new StringBuffer();
        sb.append(Msg.translate(ctx, "AD_Client_ID")).append("=").append(this.getClientName()).append(" - ").append(Msg.translate(ctx, "AD_Org_ID")).append("=").append(this.getOrgName());
        return sb.toString();
    }

    public String getClientName() {
        if (this.m_clientName == null) {
            String sql = "SELECT c.Name, o.Name FROM AD_Client c INNER JOIN AD_Org o ON (c.AD_Client_ID=o.AD_Client_ID) WHERE o.AD_Org_ID=?";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, this.getAD_Org_ID());
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.m_clientName = rs.getString(1);
                    this.m_orgName = rs.getString(2);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                Object var2_2 = null;
            }
        }
        return this.m_clientName;
    }

    public String getOrgName() {
        if (this.m_orgName == null) {
            this.getClientName();
        }
        return this.m_orgName;
    }
}

