/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.adempiere.core.domains.models.X_AD_UserQuery;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.GridField;
import org.compiere.model.MQuery;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public class MUserQuery
extends X_AD_UserQuery {
    private static final long serialVersionUID = 6279689761765405320L;
    public static final String FIELD_SEPARATOR = "<^>";
    public static final String SEGMENT_SEPARATOR = "<~>";
    private static CLogger s_log = CLogger.getCLogger(MUserQuery.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MUserQuery[] get(Properties ctx, int AD_Tab_ID) {
        int AD_User_ID = Env.getAD_User_ID(ctx);
        String sql = "SELECT * FROM AD_UserQuery WHERE AD_Client_ID=? AND AD_Tab_ID=? AND IsActive='Y' AND AD_User_ID in (0, " + AD_User_ID + ") ORDER BY Name";
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        ArrayList<MUserQuery> list = new ArrayList<MUserQuery>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Client_ID);
            pstmt.setInt(2, AD_Tab_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MUserQuery(ctx, rs, null));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MUserQuery[] retValue = new MUserQuery[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MUserQuery get(Properties ctx, int AD_Tab_ID, String name) {
        int AD_User_ID = Env.getAD_User_ID(ctx);
        String sql = "SELECT * FROM AD_UserQuery WHERE AD_Client_ID=? AND AD_Tab_ID=? AND UPPER(Name) LIKE ? AND IsActive='Y' AND AD_User_ID in (0, " + AD_User_ID + ") ORDER BY Name";
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        if (name == null) {
            name = "%";
        }
        MUserQuery retValue = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Client_ID);
            pstmt.setInt(2, AD_Tab_ID);
            pstmt.setString(3, name.toUpperCase());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MUserQuery(ctx, rs, null);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    public MUserQuery(Properties ctx, int AD_UserQuery_ID, String trxName) {
        super(ctx, AD_UserQuery_ID, trxName);
    }

    public MUserQuery(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MQuery getQuery(int AD_Table_ID, int targetWindowNo, GridField[] gridFields) {
        int openBrackets = 0;
        MQuery m_query = new MQuery(AD_Table_ID);
        m_query.addRestriction(Env.parseContext(Env.getCtx(), targetWindowNo, "", false));
        String code = this.getCode();
        this.log.fine("Parse user query: " + code);
        String[] segments = code.split(Pattern.quote(SEGMENT_SEPARATOR), -1);
        for (int i2 = 0; i2 < segments.length; ++i2) {
            String op;
            String rBrackets;
            String columnName = null;
            String operator = null;
            Object value = null;
            Object value2 = null;
            String andor = null;
            String left_bracket = null;
            String right_bracket = null;
            String[] fields = segments[i2].split(Pattern.quote(FIELD_SEPARATOR));
            block1: for (int j = 0; j < fields.length; ++j) {
                GridField field;
                if (j == 0) {
                    columnName = fields[j];
                    continue;
                }
                if (j == 1) {
                    for (ValueNamePair vnp : MQuery.OPERATORS) {
                        if (!vnp.getValue().equals(fields[j])) continue;
                        operator = vnp.getValue();
                        continue block1;
                    }
                    continue;
                }
                if (j == 2 && fields[j].length() > 0) {
                    field = this.getTargetMField(gridFields, columnName);
                    value = this.parseString(field, fields[j]);
                    continue;
                }
                if (j == 3 && fields[j].length() > 0) {
                    field = this.getTargetMField(gridFields, columnName);
                    value2 = this.parseString(field, fields[j]);
                    continue;
                }
                if (j == 4 && fields[j].length() > 0) {
                    if (i2 == 0) continue;
                    andor = fields[j];
                    continue;
                }
                if (j == 5 && fields[j].length() > 0) {
                    left_bracket = fields[j];
                    continue;
                }
                if (j != 6 || fields[j].length() <= 0) continue;
                right_bracket = fields[j];
            }
            GridField field = this.getTargetMField(gridFields, columnName);
            if (field == null) continue;
            String ColumnSQL = field.getColumnSQL(false);
            String lBrackets = left_bracket;
            if (lBrackets != null) {
                openBrackets += lBrackets.length();
            }
            if ((rBrackets = right_bracket) != null) {
                openBrackets -= rBrackets.length();
            }
            boolean and = true;
            if (i2 > 0) {
                boolean bl = and = !"OR".equals(andor);
            }
            if ((op = operator) == null) continue;
            if (value == null) {
                if (!MQuery.OPERATORS[0].equals(op) && !MQuery.OPERATORS[1].equals(op)) continue;
                m_query.addRestriction(ColumnSQL, operator, null, columnName, null, and, openBrackets);
                continue;
            }
            Object parsedValue = this.parseValue(field, value);
            if (parsedValue == null) continue;
            String infoDisplay = value.toString();
            if (field.isLookup()) {
                infoDisplay = field.getLookup().getDisplay(value);
            } else if (field.getDisplayType() == 20) {
                infoDisplay = Msg.getMsg(Env.getCtx(), infoDisplay);
            }
            if (MQuery.OPERATORS[8].equals(op)) {
                if (value2 == null) continue;
                Object parsedValue2 = this.parseValue(field, value2);
                String infoDisplay_to = value2.toString();
                if (parsedValue2 == null) continue;
                m_query.addRangeRestriction(ColumnSQL, parsedValue, parsedValue2, columnName, infoDisplay, infoDisplay_to, and, openBrackets);
                continue;
            }
            m_query.addRestriction(ColumnSQL, operator, parsedValue, columnName, infoDisplay, and, openBrackets);
        }
        return m_query;
    }

    public GridField getTargetMField(GridField[] fields, String columnName) {
        if (columnName == null) {
            return null;
        }
        for (int c = 0; c < fields.length; ++c) {
            GridField field = fields[c];
            if (!columnName.equals(field.getColumnName())) continue;
            return field;
        }
        return null;
    }

    private Object parseString(GridField field, String in) {
        this.log.log(Level.FINE, "Parse: " + field + ":" + in);
        if (in == null) {
            return null;
        }
        int dt = field.getDisplayType();
        try {
            if (dt == 11 || DisplayType.isID(dt) && field.getColumnName().endsWith("_ID")) {
                int i2 = Integer.parseInt(in);
                return i2;
            }
            if (DisplayType.isNumeric(dt)) {
                return DisplayType.getNumberFormat(dt).parse(in);
            }
            if (DisplayType.isDate(dt)) {
                long time = 0L;
                try {
                    time = DisplayType.getDateFormat_JDBC().parse(in).getTime();
                    return new Timestamp(time);
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, in + "(" + in.getClass() + ")" + e);
                    time = DisplayType.getDateFormat(dt).parse(in).getTime();
                    return new Timestamp(time);
                }
            }
            if (dt == 20) {
                return in.equals("Y");
            }
            return in;
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, "Object=" + in, ex);
            return null;
        }
    }

    private Object parseValue(GridField field, Object in) {
        if (in == null) {
            return null;
        }
        int dt = field.getDisplayType();
        try {
            if (dt == 11 || DisplayType.isID(dt) && field.getColumnName().endsWith("_ID")) {
                if (in instanceof Integer) {
                    return in;
                }
                int i2 = Integer.parseInt(in.toString());
                return i2;
            }
            if (DisplayType.isNumeric(dt)) {
                if (in instanceof BigDecimal) {
                    return in;
                }
                return DisplayType.getNumberFormat(dt).parse(in.toString());
            }
            if (DisplayType.isDate(dt)) {
                if (in instanceof Timestamp) {
                    return in;
                }
                long time = 0L;
                try {
                    time = DisplayType.getDateFormat_JDBC().parse(in.toString()).getTime();
                    return new Timestamp(time);
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, in + "(" + in.getClass() + ")" + e);
                    time = DisplayType.getDateFormat(dt).parse(in.toString()).getTime();
                    return new Timestamp(time);
                }
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? "Y" : "N";
            }
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, "Object=" + in, ex);
            String error = ex.getLocalizedMessage();
            if (error == null || error.length() == 0) {
                error = ex.toString();
            }
            StringBuffer errMsg = new StringBuffer();
            errMsg.append(field.getColumnName()).append(" = ").append(in).append(" - ").append(error);
            throw new AdempiereException(errMsg.toString());
        }
        return in;
    }
}

