/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.X_M_Warehouse;
import org.compiere.model.MLocator;
import org.compiere.model.MOrg;
import org.compiere.model.Query;
import org.compiere.util.CCache;

public class MWarehouse
extends X_M_Warehouse {
    private static final long serialVersionUID = -848214135445693460L;
    private static CCache<Integer, MWarehouse> s_cache = new CCache("M_Warehouse", 50);
    private MLocator[] m_locators = null;

    public static MWarehouse get(Properties ctx, int M_Warehouse_ID) {
        return MWarehouse.get(ctx, M_Warehouse_ID, null);
    }

    public static MWarehouse get(Properties ctx, int M_Warehouse_ID, String trxName) {
        Integer key = M_Warehouse_ID;
        MWarehouse retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MWarehouse(ctx, M_Warehouse_ID, trxName);
        s_cache.put(key, retValue);
        return retValue;
    }

    public static MWarehouse[] getForOrg(Properties ctx, int AD_Org_ID) {
        String whereClause = "AD_Org_ID=?";
        List<MWarehouse> list = new Query(ctx, "M_Warehouse", "AD_Org_ID=?", null).setParameters(AD_Org_ID).setOnlyActiveRecords(true).setOrderBy("M_Warehouse_ID").list();
        return list.toArray(new MWarehouse[list.size()]);
    }

    public static MWarehouse[] getInTransitForOrg(Properties ctx, int AD_Org_ID) {
        String whereClause = "IsInTransit=? AND AD_Org_ID=?";
        List<MWarehouse> list = new Query(ctx, "M_Warehouse", "IsInTransit=? AND AD_Org_ID=?", null).setParameters("Y", AD_Org_ID).setOnlyActiveRecords(true).setOrderBy("M_Warehouse_ID").list();
        return list.toArray(new MWarehouse[list.size()]);
    }

    public MWarehouse(Properties ctx, int M_Warehouse_ID, String trxName) {
        super(ctx, M_Warehouse_ID, trxName);
        if (M_Warehouse_ID == 0) {
            this.setSeparator("*");
        }
    }

    public MWarehouse(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MWarehouse(MOrg org) {
        this(org.getCtx(), 0, org.get_TrxName());
        this.setClientOrg(org);
        this.setValue(org.getValue());
        this.setName(org.getName());
        if (org.getInfo() != null) {
            this.setC_Location_ID(org.getInfo().getC_Location_ID());
        }
    }

    public MLocator[] getLocators(boolean reload) {
        if (!reload && this.m_locators != null) {
            return this.m_locators;
        }
        String whereClause = "M_Warehouse_ID=?";
        List<MLocator> list = new Query(this.getCtx(), "M_Locator", "M_Warehouse_ID=?", null).setParameters(this.getM_Warehouse_ID()).setOnlyActiveRecords(true).setOrderBy("X,Y,Z").list();
        this.m_locators = list.toArray(new MLocator[list.size()]);
        return this.m_locators;
    }

    public MLocator getDefaultLocator() {
        MLocator[] locators = this.getLocators(false);
        for (int i2 = 0; i2 < locators.length; ++i2) {
            if (!locators[i2].isDefault() || !locators[i2].isActive()) continue;
            return locators[i2];
        }
        if (locators.length > 0) {
            this.log.warning("No default locator for " + this.getName());
            return locators[0];
        }
        MLocator loc = new MLocator(this, "Standard");
        loc.setIsDefault(true);
        loc.saveEx();
        this.log.info("Created default locator for " + this.getName());
        return loc;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord && success) {
            this.insert_Accounting("M_Warehouse_Acct", "C_AcctSchema_Default", null);
        }
        return success;
    }

    @Override
    protected boolean beforeDelete() {
        return this.delete_Accounting("M_Warehouse_Acct");
    }
}

