/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.X_AD_Element;
import org.compiere.model.MColumn;
import org.compiere.model.MField;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.print.MPrintFormatItem;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class M_Element
extends X_AD_Element {
    private static final long serialVersionUID = -6644398794862560030L;

    public static String getColumnName(String columnName) {
        return M_Element.getColumnName(columnName, null);
    }

    public static String getColumnName(String columnName, String trxName) {
        if (columnName == null || columnName.length() == 0) {
            return columnName;
        }
        M_Element element = M_Element.get(Env.getCtx(), columnName, trxName);
        if (element == null) {
            return columnName;
        }
        return element.getColumnName();
    }

    public static M_Element get(Properties ctx, String columnName) {
        return M_Element.get(ctx, columnName, null);
    }

    public static M_Element get(Properties ctx, String columnName, String trxName) {
        if (columnName == null || columnName.length() == 0) {
            return null;
        }
        String whereClause = "UPPER(ColumnName)=?";
        M_Element retValue = (M_Element)new Query(ctx, "AD_Element", "UPPER(ColumnName)=?", trxName).setParameters(columnName.toUpperCase()).firstOnly();
        return retValue;
    }

    public static M_Element getOfColumn(Properties ctx, int columnId, String trxName) {
        if (columnId == 0) {
            return null;
        }
        String whereClause = "EXISTS (SELECT 1 FROM AD_Column c WHERE c.AD_Element_ID=AD_Element.AD_Element_ID AND c.AD_Column_ID=?)";
        M_Element retValue = (M_Element)new Query(ctx, "AD_Element", "EXISTS (SELECT 1 FROM AD_Column c WHERE c.AD_Element_ID=AD_Element.AD_Element_ID AND c.AD_Column_ID=?)", trxName).setParameters(columnId).firstOnly();
        return retValue;
    }

    public static M_Element getOfColumn(Properties ctx, int columnId) {
        return M_Element.getOfColumn(ctx, columnId, null);
    }

    public M_Element(Properties ctx, int AD_Element_ID, String trxName) {
        super(ctx, AD_Element_ID, trxName);
    }

    public M_Element(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public M_Element(Properties ctx, String columnName, String EntityType, String trxName) {
        super(ctx, 0, trxName);
        this.setColumnName(columnName);
        this.setName(columnName);
        this.setPrintName(columnName);
        this.setEntityType(EntityType);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord || this.is_ValueChanged("ColumnName")) {
            int no;
            String columnName = this.getColumnName().trim();
            if (this.getColumnName().length() != columnName.length()) {
                this.setColumnName(columnName);
            }
            Object sql = "select count(*) from AD_Element where UPPER(ColumnName)=?";
            if (!newRecord) {
                sql = (String)sql + " AND AD_Element_ID<>" + this.get_ID();
            }
            if ((no = DB.getSQLValue(null, (String)sql, columnName.toUpperCase())) > 0) {
                this.log.saveError("@SaveErrorNotUnique@", Msg.getElement(this.getCtx(), "ColumnName"));
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!newRecord) {
            StringBuffer whereClause = new StringBuffer();
            int no = 0;
            if (this.is_ValueChanged("Name") || this.is_ValueChanged("Description") || this.is_ValueChanged("Help") || this.is_ValueChanged("ColumnName")) {
                List processParas;
                whereClause = new StringBuffer(" AD_Element_ID=?");
                List columns = new Query(this.getCtx(), "AD_Column", whereClause.toString(), this.get_TrxName()).setParameters(this.get_ID()).list();
                for (MColumn column : columns) {
                    column.set_ValueNoCheck("ColumnName", this.getColumnName());
                    column.set_ValueNoCheck("Name", this.getName());
                    column.set_ValueNoCheck("Description", this.getDescription());
                    column.set_ValueNoCheck("Help", this.getHelp());
                    column.saveEx();
                    ++no;
                }
                this.log.fine("afterSave - Columns updated #" + no);
                String oldColumnName = (String)this.get_ValueOld("ColumnName");
                if (oldColumnName != null) {
                    whereClause = new StringBuffer("UPPER(ColumnName)=?").append(" AND IsCentrallyMaintained=? AND AD_Element_ID IS NULL");
                    processParas = new Query(this.getCtx(), "AD_Process_Para", whereClause.toString(), this.get_TrxName()).setParameters(DB.TO_STRING(oldColumnName.toUpperCase()), true).list();
                    no = 0;
                    for (MProcessPara para : processParas) {
                        para.setColumnName(this.getColumnName());
                        para.setName(this.getName());
                        para.setDescription(this.getDescription());
                        para.setHelp(this.getHelp());
                        para.setAD_Element_ID(this.get_ID());
                        para.saveEx();
                        ++no;
                    }
                }
                whereClause = new StringBuffer("AD_Element_ID=?").append(" AND IsCentrallyMaintained=?");
                processParas = new Query(this.getCtx(), "AD_Process_Para", whereClause.toString(), this.get_TrxName()).setParameters(this.get_ID(), true).list();
                for (MProcessPara para : processParas) {
                    para.setColumnName(this.getColumnName());
                    para.setName(this.getName());
                    para.setDescription(this.getDescription());
                    para.setHelp(this.getHelp());
                    para.saveEx();
                    ++no;
                }
                this.log.fine("Parameters updated #" + no);
            }
            if (this.is_ValueChanged("Name") || this.is_ValueChanged("Description") || this.is_ValueChanged("Help")) {
                whereClause = new StringBuffer("AD_Column_ID IN (SELECT AD_Column_ID FROM AD_Column WHERE AD_Element_ID=?").append(") AND IsCentrallyMaintained=?");
                List fields = new Query(this.getCtx(), "AD_Field", whereClause.toString(), this.get_TrxName()).setParameters(this.get_ID(), true).list();
                no = 0;
                for (MField field : fields) {
                    field.setName(this.getName());
                    field.setDescription(this.getDescription());
                    field.setHelp(this.getHelp());
                    field.saveEx();
                    ++no;
                }
                this.log.fine("Fields updated #" + no);
            }
            if (this.is_ValueChanged("PrintName") || this.is_ValueChanged("Name")) {
                whereClause = new StringBuffer("AD_Column_ID IN (SELECT AD_Column_ID FROM AD_Column WHERE AD_Element_ID=?").append(") AND IsCentrallyMaintained=?");
                List items = new Query(this.getCtx(), "AD_PrintFormatItem", whereClause.toString(), this.get_TrxName()).setParameters(this.get_ID(), true).list();
                no = 0;
                for (MPrintFormatItem item : items) {
                    item.setPrintName(this.getPrintName());
                    item.setName(this.getName());
                    item.saveEx();
                    ++no;
                }
                this.log.fine("PrintFormatItem updated #" + no);
            }
        }
        return success;
    }

    public static boolean isReservedColumnName(String columnName) {
        if (columnName == null) {
            return false;
        }
        return columnName.equals("AD_Client_ID") || columnName.startsWith("Created") || columnName.startsWith("Updated") || columnName.equals("EntityType") || columnName.equals("DocumentNo") || columnName.equals("Processed") || columnName.equals("IsSelfService") || columnName.equals("DocAction") || columnName.equals("DocStatus") || columnName.equals("Posted") || columnName.equals("IsReconciled") || columnName.equals("IsApproved") || columnName.equals("IsGenerated") || columnName.startsWith("Ref_") || columnName.equals("GrandTotal") || columnName.equals("TotalLines") || columnName.equals("C_CashLine_ID") || columnName.equals("C_Payment_ID") || columnName.equals("IsPaid") || columnName.equals("IsAllocated") || columnName.equals("C_DocType_ID") || columnName.equals("Line") || columnName.equals("UUID") || columnName.equals("Reversal_ID") || columnName.equals("ReversalLine_ID") || columnName.equals("ProcessedOn") || columnName.equals("Processing") || columnName.equals("Related_ID") || columnName.equals("SeqNo") || columnName.equals("IsActive") || columnName.equals("RelatedPayment_ID") || columnName.equals("RelatedProduct_ID") || columnName.equals("Ref_BPartner_ID") || columnName.equals("Ref_DefinitionPeriod_ID") || columnName.equals("Ref_InOut_ID") || columnName.equals("Ref_InOutLine_ID") || columnName.equals("Ref_Invoice_ID") || columnName.equals("Ref_InvoiceLine_ID") || columnName.equals("Ref_Order_ID") || columnName.equals("Ref_OrderLine_ID") || columnName.equals("Ref_Payment_ID") || columnName.equals("Ref_RMA_ID") || columnName.equals("Ref_RMALine_ID") || columnName.equals("IsReversal") || columnName.equals("DatePrinted") || columnName.equals("IsPrinted") || columnName.equals("IsOverUnderPayment") || columnName.startsWith("Ref_") && columnName.endsWith("_ID");
    }

    public static boolean isLookupColumnName(String columnName, int referenceKeyId) {
        if (columnName == null || columnName.trim().length() == 0) {
            return false;
        }
        if (!columnName.endsWith("_ID") && referenceKeyId <= 0) {
            return false;
        }
        String tableName = columnName.substring(0, columnName.length() - 3);
        MTable table2 = MTable.get(Env.getCtx(), tableName);
        if (table2 == null) {
            return false;
        }
        return DisplayType.isLookup(referenceKeyId);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("M_Element[");
        sb.append(this.get_ID()).append("-").append(this.getColumnName()).append("]");
        return sb.toString();
    }
}

