/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.util.Iterator;
import java.util.List;
import org.adempiere.model.POWrapper;
import org.compiere.model.MTable;
import org.compiere.model.PO;

public class POIterator<T>
implements Iterator<T> {
    private MTable table;
    private Class<T> clazz;
    private List<Object[]> idList;
    private int iteratorIndex = -1;
    private String trxName;
    private String keyWhereClause = null;

    public POIterator(MTable table2, Class<T> clazz, List<Object[]> idList, String trxName) {
        this.table = table2;
        this.clazz = clazz;
        this.idList = idList;
        this.trxName = trxName;
    }

    public POIterator(MTable table2, List<Object[]> idList, String trxName) {
        this(table2, null, idList, trxName);
    }

    @Override
    public boolean hasNext() {
        return this.iteratorIndex < this.idList.size() - 1;
    }

    @Override
    public T next() {
        if (this.iteratorIndex < this.idList.size() - 1) {
            ++this.iteratorIndex;
            return this.get(this.iteratorIndex);
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove operation not supported.");
    }

    public int size() {
        return this.idList.size();
    }

    public T get(int index) {
        if (index <= this.idList.size() - 1) {
            Object[] ids = this.idList.get(index);
            if (ids.length == 1 && ids[0] instanceof Number) {
                PO o = this.table.getPO(((Number)ids[0]).intValue(), this.trxName);
                if (this.clazz != null && !o.getClass().isAssignableFrom(this.clazz)) {
                    return POWrapper.create(o, this.clazz);
                }
                return (T)o;
            }
            if (this.keyWhereClause == null) {
                String[] keys = this.table.getKeyColumns();
                StringBuffer sqlBuffer = new StringBuffer();
                for (int i = 0; i < keys.length; ++i) {
                    if (i > 0) {
                        sqlBuffer.append(" AND ");
                    }
                    sqlBuffer.append(keys[i]).append(" = ? ");
                }
                this.keyWhereClause = sqlBuffer.toString();
            }
            PO o = this.table.getPO(this.keyWhereClause, ids, this.trxName);
            if (this.clazz != null && !o.getClass().isAssignableFrom(this.clazz)) {
                return POWrapper.create(o, this.clazz);
            }
            return (T)o;
        }
        return null;
    }
}

