/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_AD_Archive;
import org.adempiere.core.domains.models.X_AD_Attachment;
import org.adempiere.core.domains.models.X_AD_Note;
import org.adempiere.core.domains.models.X_AD_RecentItem;
import org.adempiere.core.domains.models.X_CM_Chat;
import org.adempiere.core.domains.models.X_CM_Container;
import org.adempiere.core.domains.models.X_CM_Container_Element;
import org.adempiere.core.domains.models.X_C_Order;
import org.adempiere.core.domains.models.X_C_OrderLine;
import org.adempiere.core.domains.models.X_K_Index;
import org.adempiere.core.domains.models.X_R_Request;
import org.compiere.model.MTable;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class PO_Record {
    private static int[] s_parents = new int[]{X_C_Order.Table_ID, X_CM_Container.Table_ID};
    private static String[] s_parentNames = new String[]{"C_Order", "CM_Container"};
    private static int[] s_parentChilds = new int[]{X_C_OrderLine.Table_ID, X_CM_Container_Element.Table_ID};
    private static String[] s_parentChildNames = new String[]{"C_OrderLine", "CM_Container_Element"};
    private static int[] s_cascades = new int[]{X_AD_Attachment.Table_ID, X_AD_Archive.Table_ID, X_K_Index.Table_ID, X_AD_Note.Table_ID, X_AD_RecentItem.Table_ID};
    private static String[] s_cascadeNames = new String[]{"AD_Attachment", "AD_Archive", "K_Index", "AD_Note", "AD_RecentItem"};
    private static int[] s_restricts = new int[]{X_R_Request.Table_ID, X_CM_Chat.Table_ID};
    private static String[] s_restrictNames = new String[]{"R_Request", "CM_Chat"};
    private static CLogger log = CLogger.getCLogger(PO_Record.class);

    static boolean deleteCascade(int AD_Table_ID, int Record_ID, String trxName) {
        for (int i = 0; i < s_cascades.length; ++i) {
            if (s_cascades[i] == AD_Table_ID) continue;
            Object[] params = new Object[]{AD_Table_ID, Record_ID};
            StringBuffer sql = new StringBuffer("DELETE FROM ").append(s_cascadeNames[i]).append(" WHERE AD_Table_ID=? AND Record_ID=?");
            int no = DB.executeUpdate(sql.toString(), params, false, trxName);
            if (no > 0) {
                log.config(s_cascadeNames[i] + " (" + AD_Table_ID + "/" + Record_ID + ") #" + no);
                continue;
            }
            if (no >= 0) continue;
            log.severe(s_cascadeNames[i] + " (" + AD_Table_ID + "/" + Record_ID + ") #" + no);
            return false;
        }
        for (int j = 0; j < s_parents.length; ++j) {
            if (s_parents[j] != AD_Table_ID) continue;
            int AD_Table_IDchild = s_parentChilds[j];
            Object[] params = new Object[]{AD_Table_IDchild, Record_ID};
            for (int i = 0; i < s_cascades.length; ++i) {
                StringBuffer sql = new StringBuffer("DELETE FROM ").append(s_cascadeNames[i]).append(" WHERE AD_Table_ID=? AND Record_ID IN (SELECT ").append(s_parentChildNames[j]).append("_ID FROM ").append(s_parentChildNames[j]).append(" WHERE ").append(s_parentNames[j]).append("_ID=?)");
                int no = DB.executeUpdate(sql.toString(), params, false, trxName);
                if (no > 0) {
                    log.config(s_cascadeNames[i] + " " + s_parentNames[j] + " (" + AD_Table_ID + "/" + Record_ID + ") #" + no);
                    continue;
                }
                if (no >= 0) continue;
                log.severe(s_cascadeNames[i] + " " + s_parentNames[j] + " (" + AD_Table_ID + "/" + Record_ID + ") #" + no);
                return false;
            }
        }
        return true;
    }

    static String exists(int AD_Table_ID, int Record_ID, String trxName) {
        for (int i = 0; i < s_restricts.length; ++i) {
            StringBuffer sql = new StringBuffer("SELECT COUNT(*) FROM ").append(s_restrictNames[i]).append(" WHERE AD_Table_ID=? AND Record_ID=?");
            int no = DB.getSQLValue(trxName, sql.toString(), AD_Table_ID, Record_ID);
            if (no <= 0) continue;
            return s_restrictNames[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void validate() {
        String sql = "SELECT AD_Table_ID, TableName FROM AD_Table WHERE IsView='N' ORDER BY TableName";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                PO_Record.validate(rs.getInt(1), rs.getString(2));
            }
        }
        catch (Exception e) {
            try {
                log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    static void validate(int AD_Table_ID) {
        MTable table2 = new MTable(Env.getCtx(), AD_Table_ID, null);
        if (table2.isView()) {
            log.warning("Ignored - View " + table2.getTableName());
        } else {
            PO_Record.validate(table2.getAD_Table_ID(), table2.getTableName());
        }
    }

    private static void validate(int AD_Table_ID, String TableName) {
        for (int i = 0; i < s_cascades.length; ++i) {
            StringBuffer sql = new StringBuffer("DELETE FROM ").append(s_cascadeNames[i]).append(" WHERE AD_Table_ID=").append(AD_Table_ID).append(" AND Record_ID NOT IN (SELECT ").append(TableName).append("_ID FROM ").append(TableName).append(")");
            int no = DB.executeUpdate(sql.toString(), null);
            if (no <= 0) continue;
            log.config(s_cascadeNames[i] + " (" + AD_Table_ID + "/" + TableName + ") Invalid #" + no);
        }
    }
}

