/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import io.vavr.CheckedFunction1;
import io.vavr.Tuple;
import io.vavr.collection.List;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.adempiere.exceptions.TaxCriteriaNotFoundException;
import org.adempiere.exceptions.TaxForChangeNotFoundException;
import org.adempiere.exceptions.TaxNoExemptFoundException;
import org.adempiere.exceptions.TaxNotFoundException;
import org.compiere.model.MLocation;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTax;
import org.compiere.model.MTaxPostal;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.ResultSetIterable;

public class Tax {
    private static CLogger log = CLogger.getCLogger(Tax.class);

    @Deprecated
    public static int get(Properties ctx, int M_Product_ID, int C_Charge_ID, Timestamp billDate, Timestamp shipDate, int AD_Org_ID, int M_Warehouse_ID, int billC_BPartner_Location_ID, int shipC_BPartner_Location_ID, boolean IsSOTrx) {
        return Tax.get(ctx, M_Product_ID, C_Charge_ID, billDate, shipDate, AD_Org_ID, M_Warehouse_ID, billC_BPartner_Location_ID, shipC_BPartner_Location_ID, IsSOTrx, null);
    }

    public static int get(Properties ctx, int M_Product_ID, int C_Charge_ID, Timestamp billDate, Timestamp shipDate, int AD_Org_ID, int M_Warehouse_ID, int billC_BPartner_Location_ID, int shipC_BPartner_Location_ID, boolean IsSOTrx, String trxName) {
        if (M_Product_ID != 0) {
            return Tax.getProduct(ctx, M_Product_ID, billDate, shipDate, AD_Org_ID, M_Warehouse_ID, billC_BPartner_Location_ID, shipC_BPartner_Location_ID, IsSOTrx, trxName);
        }
        if (C_Charge_ID != 0) {
            return Tax.getCharge(ctx, C_Charge_ID, billDate, shipDate, AD_Org_ID, M_Warehouse_ID, billC_BPartner_Location_ID, shipC_BPartner_Location_ID, IsSOTrx, trxName);
        }
        return Tax.getExemptTax(ctx, AD_Org_ID);
    }

    @Deprecated
    public static int getCharge(Properties ctx, int chargeId, Timestamp billDate, Timestamp shipDate, int orgId, int warehouseId, int billPartnerLocationId, int shipPartnerLocationId, boolean isSOTrx) {
        return Tax.getCharge(ctx, chargeId, billDate, shipDate, orgId, warehouseId, billPartnerLocationId, shipPartnerLocationId, isSOTrx, null);
    }

    public static int getCharge(Properties ctx, int chargeId, Timestamp billDate, Timestamp shipDate, int orgId, int warehouseId, int billPartnerLocationId, int shipPartnerLocationId, boolean isSOTrx, String trxName) {
        Boolean useTaxExemptOrg;
        String sql = "SELECT c.C_TaxCategory_ID, o.C_Location_ID AS BillFromLocation_ID, il.C_Location_ID AS BillToLocation_ID, b.IsTaxExempt, b.IsPOTaxExempt, w.C_Location_ID AS ShipFromLocation_ID, sl.C_Location_ID AS ShipToLocation_ID, linkBP.C_BPartner_ID, CASE WHEN linkBP.C_BPartner_ID IS NOT NULL THEN linkBP.IsTaxExempt ELSE NULL END AS linkBP_TaxExempt, CASE WHEN linkBP.C_BPartner_ID IS NOT NULL THEN linkBP.IsPOTaxExempt ELSE NULL END AS linkBP_POTaxEXempt FROM C_Charge c, AD_OrgInfo o, C_BPartner_Location il INNER JOIN C_BPartner b ON (il.C_BPartner_ID=b.C_BPartner_ID) LEFT OUTER JOIN M_Warehouse w ON (w.M_Warehouse_ID=?), C_BPartner_Location sl LEFT JOIN C_BPartner linkBP ON (linkBP.AD_OrgBP_ID=?) WHERE c.C_Charge_ID=? AND o.AD_Org_ID=? AND il.C_BPartner_Location_ID=? AND sl.C_BPartner_Location_ID=?";
        AtomicBoolean found = new AtomicBoolean(false);
        TaxDefinition taxDefinition = new TaxDefinition();
        DB.runResultSetFunction.apply((Object)trxName, (Object)sql, (Object)List.of((Object[])new Object[]{warehouseId, orgId, chargeId, orgId, billPartnerLocationId, shipPartnerLocationId}), resultSet -> {
            TaxDefinition td2 = new TaxDefinition();
            List taxes = new ResultSetIterable((ResultSet)resultSet, (CheckedFunction1 & Serializable)row -> {
                td2.taxCategoryId = resultSet.getInt("C_TaxCategory_ID");
                td2.billFromLocationId = resultSet.getInt("BillFromLocation_ID");
                td2.billToLocationId = resultSet.getInt("BillToLocation_ID");
                td2.isSOTaxExempt = resultSet.getString("IsTaxExempt");
                td2.isPOTaxExempt = resultSet.getString("IsPOTaxExempt");
                td2.isTaxExempt = isSOTrx ? td2.isSOTaxExempt : td2.isPOTaxExempt;
                td2.shipFromLocationId = resultSet.getInt("ShipFromLocation_ID");
                td2.shipToLocationId = resultSet.getInt("ShipToLocation_ID");
                td2.linkBPartnerId = resultSet.getInt("C_BPartner_ID");
                td2.linkBPartnerTaxExempt = resultSet.getString("linkBP_TaxExempt");
                td2.linkBPartnerPOTaxExempt = resultSet.getString("linkBP_POTaxExempt");
                return td2;
            }).toList();
            taxes.forEach(row -> {
                taxDefinition.taxCategoryId = row.taxCategoryId;
                taxDefinition.billFromLocationId = row.billFromLocationId;
                taxDefinition.billToLocationId = row.billToLocationId;
                taxDefinition.isSOTaxExempt = row.isSOTaxExempt;
                taxDefinition.isPOTaxExempt = row.isPOTaxExempt;
                taxDefinition.isTaxExempt = isSOTrx ? taxDefinition.isSOTaxExempt : taxDefinition.isPOTaxExempt;
                taxDefinition.shipFromLocationId = row.shipFromLocationId;
                taxDefinition.shipToLocationId = row.shipToLocationId;
                taxDefinition.linkBPartnerId = row.linkBPartnerId;
                taxDefinition.linkBPartnerTaxExempt = row.linkBPartnerTaxExempt;
                taxDefinition.linkBPartnerPOTaxExempt = row.linkBPartnerPOTaxExempt;
                found.set(true);
            });
            if (!found.get()) {
                throw new TaxForChangeNotFoundException(chargeId, orgId, warehouseId, billPartnerLocationId, shipPartnerLocationId, null);
            }
        });
        if ("Y".equals(taxDefinition.isTaxExempt)) {
            return Tax.getExemptTax(ctx, orgId);
        }
        if ("N".equals(taxDefinition.isTaxExempt) && (useTaxExemptOrg = Boolean.valueOf(MSysConfig.getBooleanValue("VALIDATE_EXEMPT_TAXES_BASED_ON_ORGANIZATION", false, Env.getAD_Client_ID(ctx)))).booleanValue() && taxDefinition.linkBPartnerId > 0 && (isSOTrx && taxDefinition.linkBPartnerTaxExempt.equalsIgnoreCase("Y") || !isSOTrx && taxDefinition.linkBPartnerTaxExempt.equalsIgnoreCase("Y"))) {
            log.fine("getProduct - Business Partner is Tax exempt");
            return Tax.getExemptTax(ctx, orgId);
        }
        if (!isSOTrx) {
            int temp = taxDefinition.billFromLocationId;
            taxDefinition.billFromLocationId = taxDefinition.billToLocationId;
            taxDefinition.billToLocationId = temp;
            temp = taxDefinition.shipFromLocationId;
            taxDefinition.shipFromLocationId = taxDefinition.shipToLocationId;
            taxDefinition.shipToLocationId = temp;
        }
        log.fine("getCharge - C_TaxCategory_ID=" + taxDefinition.taxCategoryId + ", billFromC_Location_ID=" + taxDefinition.billFromLocationId + ", billToC_Location_ID=" + taxDefinition.billToLocationId + ", shipFromC_Location_ID=" + taxDefinition.shipFromLocationId + ", shipToC_Location_ID=" + taxDefinition.shipToLocationId);
        return Tax.get(ctx, taxDefinition.taxCategoryId, isSOTrx, shipDate, taxDefinition.shipFromLocationId, taxDefinition.shipToLocationId, billDate, taxDefinition.billFromLocationId, taxDefinition.billToLocationId, trxName);
    }

    @Deprecated
    public static int getProduct(Properties ctx, int M_Product_ID, Timestamp billDate, Timestamp shipDate, int AD_Org_ID, int M_Warehouse_ID, int billC_BPartner_Location_ID, int shipC_BPartner_Location_ID, boolean IsSOTrx) {
        return Tax.getProduct(ctx, M_Product_ID, billDate, shipDate, AD_Org_ID, M_Warehouse_ID, billC_BPartner_Location_ID, shipC_BPartner_Location_ID, IsSOTrx, null);
    }

    public static int getProduct(Properties ctx, int productId, Timestamp billDate, Timestamp shipDate, int organizationId, int warehouseId, int billBPartnerLocationId, int shipBPartnerLocationId, boolean isSOTrx, String trxName) {
        int temp;
        String variable = "";
        String sql = "SELECT p.C_TaxCategory_ID, o.C_Location_ID AS BillFromLocation_ID, il.C_Location_ID AS BillToLocation_ID, b.IsTaxExempt, b.IsPOTaxExempt, w.C_Location_ID AS ShipFromLocation_ID, sl.C_Location_ID AS ShipToLocation_ID, linkBP.C_BPartner_ID, CASE WHEN linkBP.C_BPartner_ID IS NOT NULL THEN linkBP.IsTaxExempt ELSE NULL END AS linkBP_TaxExempt, CASE WHEN linkBP.C_BPartner_ID IS NOT NULL THEN linkBP.IsPOTaxExempt ELSE NULL END AS linkBP_POTaxEXempt FROM M_Product p, AD_OrgInfo o, C_BPartner_Location il INNER JOIN C_BPartner b ON (il.C_BPartner_ID=b.C_BPartner_ID) LEFT OUTER JOIN M_Warehouse w ON (w.M_Warehouse_ID=?), C_BPartner_Location sl LEFT JOIN C_BPartner linkBP ON (linkBP.AD_OrgBP_ID=?) WHERE p.M_Product_ID=? AND o.AD_Org_ID=? AND il.C_BPartner_Location_ID=? AND sl.C_BPartner_Location_ID=?";
        AtomicBoolean found = new AtomicBoolean(false);
        TaxDefinition taxDefinition = new TaxDefinition();
        DB.runResultSetFunction.apply((Object)trxName, (Object)sql, (Object)List.of((Object[])new Object[]{warehouseId, organizationId, productId, organizationId, billBPartnerLocationId, shipBPartnerLocationId}), resultSet -> {
            List taxes = new ResultSetIterable((ResultSet)resultSet, (CheckedFunction1 & Serializable)row -> {
                TaxDefinition td2 = new TaxDefinition();
                td2.taxCategoryId = resultSet.getInt("C_TaxCategory_ID");
                td2.billFromLocationId = resultSet.getInt("BillFromLocation_ID");
                td2.billToLocationId = resultSet.getInt("BillToLocation_ID");
                td2.isSOTaxExempt = resultSet.getString("IsTaxExempt");
                td2.isPOTaxExempt = resultSet.getString("IsPOTaxExempt");
                td2.isTaxExempt = isSOTrx ? td2.isSOTaxExempt : td2.isPOTaxExempt;
                td2.shipFromLocationId = resultSet.getInt("ShipFromLocation_ID");
                td2.shipToLocationId = resultSet.getInt("ShipToLocation_ID");
                td2.linkBPartnerId = resultSet.getInt("C_BPartner_ID");
                td2.linkBPartnerTaxExempt = resultSet.getString("linkBP_TaxExempt");
                td2.linkBPartnerPOTaxExempt = resultSet.getString("linkBP_POTaxExempt");
                return td2;
            }).toList();
            taxes.forEach(row -> {
                taxDefinition.taxCategoryId = row.taxCategoryId;
                taxDefinition.billFromLocationId = row.billFromLocationId;
                taxDefinition.billToLocationId = row.billToLocationId;
                taxDefinition.isSOTaxExempt = row.isSOTaxExempt;
                taxDefinition.isPOTaxExempt = row.isPOTaxExempt;
                taxDefinition.isTaxExempt = isSOTrx ? taxDefinition.isSOTaxExempt : taxDefinition.isPOTaxExempt;
                taxDefinition.shipFromLocationId = row.shipFromLocationId;
                taxDefinition.shipToLocationId = row.shipToLocationId;
                taxDefinition.linkBPartnerId = row.linkBPartnerId;
                taxDefinition.linkBPartnerTaxExempt = row.linkBPartnerTaxExempt;
                taxDefinition.linkBPartnerPOTaxExempt = row.linkBPartnerPOTaxExempt;
                found.set(true);
            });
        });
        if (found.get() && "Y".equals(taxDefinition.isTaxExempt)) {
            log.fine("getProduct - Business Partner is Tax exempt");
            return Tax.getExemptTax(ctx, organizationId);
        }
        if (found.get() && "N".equals(taxDefinition.isTaxExempt)) {
            Boolean useTaxExemptOrg = MSysConfig.getBooleanValue("VALIDATE_EXEMPT_TAXES_BASED_ON_ORGANIZATION", false, Env.getAD_Client_ID(ctx));
            if (useTaxExemptOrg.booleanValue() && taxDefinition.linkBPartnerId > 0 && (isSOTrx && taxDefinition.linkBPartnerTaxExempt.equalsIgnoreCase("Y") || !isSOTrx && taxDefinition.linkBPartnerPOTaxExempt.equalsIgnoreCase("Y"))) {
                log.fine("getProduct - Business Partner is Tax exempt");
                return Tax.getExemptTax(ctx, organizationId);
            }
            if (!isSOTrx) {
                int temp2 = taxDefinition.billFromLocationId;
                taxDefinition.billFromLocationId = taxDefinition.billToLocationId;
                taxDefinition.billToLocationId = temp2;
                temp2 = taxDefinition.shipFromLocationId;
                taxDefinition.shipFromLocationId = taxDefinition.shipToLocationId;
                taxDefinition.shipToLocationId = temp2;
            }
            log.fine("getProduct - C_TaxCategory_ID=" + taxDefinition.taxCategoryId + ", billFromC_Location_ID=" + taxDefinition.billFromLocationId + ", billToC_Location_ID=" + taxDefinition.billToLocationId + ", shipFromC_Location_ID=" + taxDefinition.shipFromLocationId + ", shipToC_Location_ID=" + taxDefinition.shipToLocationId);
            return Tax.get(ctx, taxDefinition.taxCategoryId, isSOTrx, shipDate, taxDefinition.shipFromLocationId, taxDefinition.shipToLocationId, billDate, taxDefinition.billFromLocationId, taxDefinition.billToLocationId, trxName);
        }
        variable = "M_Product_ID";
        sql = "SELECT C_TaxCategory_ID FROM M_Product WHERE M_Product_ID=?";
        taxDefinition.taxCategoryId = DB.getSQLValueEx(null, sql, productId);
        found.set(taxDefinition.taxCategoryId != -1);
        if (taxDefinition.taxCategoryId <= 0) {
            throw new TaxCriteriaNotFoundException(variable, productId);
        }
        log.fine("getProduct - C_TaxCategory_ID=" + taxDefinition.taxCategoryId);
        variable = "AD_Org_ID";
        sql = "SELECT C_Location_ID FROM AD_OrgInfo WHERE AD_Org_ID=?";
        taxDefinition.billFromLocationId = DB.getSQLValueEx(null, sql, organizationId);
        found.set(taxDefinition.billFromLocationId != -1);
        if (taxDefinition.billFromLocationId <= 0) {
            throw new TaxCriteriaNotFoundException(variable, organizationId);
        }
        variable = "BillTo_ID";
        sql = "SELECT l.C_Location_ID, b.IsTaxExempt, b.IsPOTaxExempt  FROM C_BPartner_Location l INNER JOIN C_BPartner b ON (l.C_BPartner_ID=b.C_BPartner_ID)  WHERE C_BPartner_Location_ID=?";
        found.set(false);
        DB.runResultSetFunction.apply((Object)trxName, (Object)sql, (Object)List.of((Object)billBPartnerLocationId), resultSet -> {
            List rows = new ResultSetIterable((ResultSet)resultSet, (CheckedFunction1 & Serializable)row -> Tuple.of((Object)row.getInt(1), (Object)row.getString(2), (Object)row.getString(3))).toList();
            rows.forEach(row -> {
                taxDefinition.billToLocationId = (Integer)row._1;
                taxDefinition.isSOTaxExempt = (String)row._2;
                taxDefinition.isPOTaxExempt = (String)row._3;
                taxDefinition.isTaxExempt = isSOTrx ? taxDefinition.isSOTaxExempt : taxDefinition.isPOTaxExempt;
            });
        });
        if (taxDefinition.billToLocationId <= 0) {
            throw new TaxCriteriaNotFoundException(variable, billBPartnerLocationId);
        }
        if ("Y".equals(taxDefinition.isTaxExempt)) {
            return Tax.getExemptTax(ctx, organizationId);
        }
        if (!isSOTrx) {
            temp = taxDefinition.billFromLocationId;
            taxDefinition.billFromLocationId = taxDefinition.billToLocationId;
            taxDefinition.billToLocationId = temp;
        }
        log.fine("getProduct - billFromC_Location_ID = " + taxDefinition.billFromLocationId);
        log.fine("getProduct - billToC_Location_ID = " + taxDefinition.billToLocationId);
        variable = "M_Warehouse_ID";
        sql = "SELECT C_Location_ID FROM M_Warehouse WHERE M_Warehouse_ID=?";
        taxDefinition.shipFromLocationId = DB.getSQLValueEx(null, sql, warehouseId);
        found.set(taxDefinition.shipFromLocationId != -1);
        if (taxDefinition.shipFromLocationId <= 0) {
            throw new TaxCriteriaNotFoundException(variable, warehouseId);
        }
        variable = "C_BPartner_Location_ID";
        sql = "SELECT C_Location_ID FROM C_BPartner_Location WHERE C_BPartner_Location_ID=?";
        taxDefinition.shipToLocationId = DB.getSQLValueEx(trxName, sql, shipBPartnerLocationId);
        found.set(taxDefinition.shipToLocationId != -1);
        if (taxDefinition.shipToLocationId <= 0) {
            throw new TaxCriteriaNotFoundException(variable, shipBPartnerLocationId);
        }
        if (!isSOTrx) {
            temp = taxDefinition.shipFromLocationId;
            taxDefinition.shipFromLocationId = taxDefinition.shipToLocationId;
            taxDefinition.shipToLocationId = temp;
        }
        log.fine("getProduct - shipFromC_Location_ID = " + taxDefinition.shipFromLocationId);
        log.fine("getProduct - shipToC_Location_ID = " + taxDefinition.shipToLocationId);
        return Tax.get(ctx, taxDefinition.taxCategoryId, isSOTrx, shipDate, taxDefinition.shipFromLocationId, taxDefinition.shipToLocationId, billDate, taxDefinition.billFromLocationId, taxDefinition.billToLocationId, trxName);
    }

    private static int getExemptTax(Properties ctx, int AD_Org_ID) {
        String sql = "SELECT t.C_Tax_ID FROM C_Tax t INNER JOIN AD_Org o ON (t.AD_Client_ID=o.AD_Client_ID) WHERE t.IsTaxExempt='Y' AND o.AD_Org_ID=? ORDER BY t.Rate DESC";
        int C_Tax_ID = DB.getSQLValueEx(null, "SELECT t.C_Tax_ID FROM C_Tax t INNER JOIN AD_Org o ON (t.AD_Client_ID=o.AD_Client_ID) WHERE t.IsTaxExempt='Y' AND o.AD_Org_ID=? ORDER BY t.Rate DESC", AD_Org_ID);
        log.fine("getExemptTax - TaxExempt=Y - C_Tax_ID=" + C_Tax_ID);
        if (C_Tax_ID <= 0) {
            throw new TaxNoExemptFoundException(AD_Org_ID);
        }
        return C_Tax_ID;
    }

    @Deprecated
    protected static int get(Properties ctx, int C_TaxCategory_ID, boolean IsSOTrx, Timestamp shipDate, int shipFromC_Location_ID, int shipToC_Location_ID, Timestamp billDate, int billFromC_Location_ID, int billToC_Location_ID) {
        return Tax.get(ctx, C_TaxCategory_ID, IsSOTrx, shipDate, shipFromC_Location_ID, shipToC_Location_ID, billDate, billFromC_Location_ID, billToC_Location_ID, null);
    }

    protected static int get(Properties ctx, int C_TaxCategory_ID, boolean IsSOTrx, Timestamp shipDate, int shipFromC_Location_ID, int shipToC_Location_ID, Timestamp billDate, int billFromC_Location_ID, int billToC_Location_ID, String trxName) {
        MTax tax;
        int i2;
        if (CLogMgt.isLevelFine()) {
            log.info("get(Detail) - Category=" + C_TaxCategory_ID + ", SOTrx=" + IsSOTrx);
            log.config("get(Detail) - BillFrom=" + billFromC_Location_ID + ", BillTo=" + billToC_Location_ID + ", BillDate=" + billDate);
        }
        MTax[] taxes = MTax.getAll(ctx);
        MLocation lFrom = new MLocation(ctx, billFromC_Location_ID, trxName);
        MLocation lTo = new MLocation(ctx, billToC_Location_ID, trxName);
        log.finer("From=" + lFrom);
        log.finer("To=" + lTo);
        for (i2 = 0; i2 < taxes.length; ++i2) {
            tax = taxes[i2];
            log.finest(tax.toString());
            if (tax.getC_TaxCategory_ID() != C_TaxCategory_ID || !tax.isActive() || tax.getParent_Tax_ID() != 0 || IsSOTrx && "P".equals(tax.getSOPOType()) || !IsSOTrx && "S".equals(tax.getSOPOType())) continue;
            log.finest("From Country - " + (tax.getC_Country_ID() == lFrom.getC_Country_ID() || tax.getC_Country_ID() == 0));
            log.finest("From Region - " + (tax.getC_Region_ID() == lFrom.getC_Region_ID() || tax.getC_Region_ID() == 0));
            log.finest("To Country - " + (tax.getTo_Country_ID() == lTo.getC_Country_ID() || tax.getTo_Country_ID() == 0));
            log.finest("To Region - " + (tax.getTo_Region_ID() == lTo.getC_Region_ID() || tax.getTo_Region_ID() == 0));
            log.finest("Date valid - " + !tax.getValidFrom().after(billDate));
            if (tax.getC_Country_ID() != lFrom.getC_Country_ID() && tax.getC_Country_ID() != 0 || tax.getC_Region_ID() != lFrom.getC_Region_ID() && tax.getC_Region_ID() != 0 || tax.getTo_Country_ID() != lTo.getC_Country_ID() && tax.getTo_Country_ID() != 0 || tax.getTo_Region_ID() != lTo.getC_Region_ID() && tax.getTo_Region_ID() != 0 || tax.getValidFrom().after(billDate)) continue;
            if (!tax.isPostal()) {
                return tax.getC_Tax_ID();
            }
            MTaxPostal[] postals = tax.getPostals(false);
            for (int j = 0; j < postals.length; ++j) {
                MTaxPostal postal = postals[j];
                if (!postal.isActive() || !postal.getPostal().startsWith(lFrom.getPostal()) || postal.getPostal_To() != null && !postal.getPostal_To().startsWith(lTo.getPostal())) continue;
                return tax.getC_Tax_ID();
            }
        }
        for (i2 = 0; i2 < taxes.length; ++i2) {
            tax = taxes[i2];
            if (!tax.isDefault() || !tax.isActive() || tax.getParent_Tax_ID() != 0 || IsSOTrx && "P".equals(tax.getSOPOType()) || !IsSOTrx && "S".equals(tax.getSOPOType())) continue;
            log.fine("get (default) - " + tax);
            return tax.getC_Tax_ID();
        }
        throw new TaxNotFoundException(C_TaxCategory_ID, IsSOTrx, shipDate, shipFromC_Location_ID, shipToC_Location_ID, billDate, billFromC_Location_ID, billToC_Location_ID);
    }

    private static class TaxDefinition {
        private int taxCategoryId = 0;
        private int billFromLocationId = 0;
        private int billToLocationId = 0;
        private String isSOTaxExempt = null;
        private String isPOTaxExempt = null;
        private String isTaxExempt = null;
        private int shipFromLocationId = 0;
        private int shipToLocationId = 0;
        private int linkBPartnerId = 0;
        private String linkBPartnerTaxExempt = null;
        private String linkBPartnerPOTaxExempt = null;

        private TaxDefinition() {
        }
    }
}

