/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.layout;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Properties;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.layout.PrintElement;

public class QRCodeElement
extends PrintElement {
    private boolean isValid = true;
    private BufferedImage qrImage = null;
    private String qrCode = null;
    private boolean allowOverflow = true;
    private float scaleFactor = 1.0f;

    public QRCodeElement(String code, MPrintFormatItem item) {
        this.qrCode = code;
        if (this.qrCode == null || this.qrCode.length() == 0 || item == null || item.getBarcodeType() == null || item.getBarcodeType().length() == 0) {
            this.isValid = false;
        }
        this.createQR(code, item);
        if (this.qrImage == null) {
            this.isValid = false;
        }
        this.allowOverflow = item.isHeightOneLine();
    }

    private void createQR(String code, MPrintFormatItem item) {
        block8: {
            String type = item.getBarcodeType();
            try {
                if (type.equals("QRC")) {
                    if (item.getMaxWidth() <= 0 && item.getMaxHeight() <= 0) {
                        this.qrImage = null;
                        this.isValid = false;
                    }
                    try {
                        QRCodeWriter qr = new QRCodeWriter();
                        BitMatrix byteMatrix = qr.encode(code, BarcodeFormat.QR_CODE, item.getMaxWidth(), item.getMaxHeight());
                        this.qrImage = new BufferedImage(item.getMaxWidth(), item.getMaxHeight(), 1);
                        int white = 0xFFFFFF;
                        int black = 0;
                        for (int i2 = 0; i2 < item.getMaxWidth(); ++i2) {
                            for (int j = 0; j < item.getMaxHeight(); ++j) {
                                this.qrImage.setRGB(i2, j, byteMatrix.get(i2, j) ? black : white);
                            }
                        }
                        break block8;
                    }
                    catch (WriterException e) {
                        this.log.warning("Invalid Type" + type);
                        break block8;
                    }
                }
                this.log.warning("Invalid Type" + type);
            }
            catch (Exception e) {
                this.log.warning(code + " - " + e.toString());
                this.isValid = false;
            }
        }
    }

    public Image getQR() {
        return this.qrImage;
    }

    public boolean isValid() {
        return this.isValid;
    }

    @Override
    protected boolean calculateSize() {
        this.p_width = 0.0f;
        this.p_height = 0.0f;
        if (this.qrImage == null) {
            return true;
        }
        this.p_width = this.qrImage.getWidth();
        this.p_height = this.qrImage.getHeight();
        if (this.p_width * this.p_height == 0.0f) {
            return true;
        }
        this.scaleFactor = 1.0f;
        if (this.p_maxWidth != 0.0f && this.p_width > this.p_maxWidth) {
            this.scaleFactor = this.p_maxWidth / this.p_width;
        }
        if (this.p_maxHeight != 0.0f && this.p_height > this.p_maxHeight && this.p_maxHeight / this.p_height < this.scaleFactor) {
            this.scaleFactor = this.p_maxHeight / this.p_height;
        }
        this.p_width = this.scaleFactor * this.p_width;
        this.p_height = this.scaleFactor * this.p_height;
        return true;
    }

    public float getScaleFactor() {
        if (!this.p_sizeCalculated) {
            this.p_sizeCalculated = this.calculateSize();
        }
        return this.scaleFactor;
    }

    public boolean isAllowOverflow() {
        return this.allowOverflow;
    }

    @Override
    public void paint(Graphics2D g2D, int pageNo, Point2D pageStart, Properties ctx, boolean isView) {
        if (this.qrImage == null) {
            return;
        }
        Point2D.Double location = this.getAbsoluteLocation(pageStart);
        int x = (int)location.x;
        if ("T".equals(this.p_FieldAlignmentType)) {
            x = (int)((float)x + (this.p_maxWidth - this.p_width));
        } else if ("C".equals(this.p_FieldAlignmentType)) {
            x = (int)((float)x + (this.p_maxWidth - this.p_width) / 2.0f);
        }
        int y = (int)location.y;
        AffineTransform transform = new AffineTransform();
        transform.translate(x, y);
        transform.scale(this.scaleFactor, this.scaleFactor);
        g2D.drawImage(this.qrImage, transform, this);
    }

    @Override
    public String toString() {
        return this.qrCode;
    }
}

