/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.adempiere.core.domains.models.I_T_DistributionRunDetail;
import org.adempiere.core.domains.models.X_DD_Order;
import org.adempiere.core.domains.models.X_DD_OrderLine;
import org.adempiere.core.domains.models.X_M_Product;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MDistributionRun;
import org.compiere.model.MDistributionRunDetail;
import org.compiere.model.MDistributionRunLine;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MProduct;
import org.compiere.model.MTable;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class DistributionRun
extends SvrProcess {
    private int p_M_DistributionRun_ID = 0;
    private Timestamp p_DatePromised = null;
    private int p_C_DocType_ID = 0;
    private boolean p_IsTest = false;
    private int p_M_Warehouse_ID = 0;
    private boolean p_ConsolidateDocument = false;
    private int p_M_DistributionList_ID = 0;
    private boolean p_BasedInDamnd = false;
    private MDistributionRun m_run = null;
    private MDistributionRunLine[] m_runLines = null;
    private MDistributionRunDetail[] m_details = null;
    private Timestamp m_DateOrdered = null;
    private int m_counter = 0;
    private MDocType m_docType = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("C_DocType_ID")) {
                this.p_C_DocType_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                this.m_docType = new MDocType(this.getCtx(), this.p_C_DocType_ID, this.get_TrxName());
                continue;
            }
            if (name.equals("DatePromised")) {
                this.p_DatePromised = (Timestamp)para[i2].getParameter();
                continue;
            }
            if (name.equals("IsTest")) {
                this.p_IsTest = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (this.m_docType.getDocBaseType().equals("DOO") & name.equals("M_Warehouse_ID")) {
                this.p_M_Warehouse_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (this.m_docType.getDocBaseType().equals("DOO") & name.equals("ConsolidateDocument")) {
                this.p_ConsolidateDocument = "Y".equals((String)para[i2].getParameter());
                continue;
            }
            if (this.m_docType.getDocBaseType().equals("DOO") & name.equals("M_DistributionList_ID")) {
                this.p_M_DistributionList_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (this.m_docType.getDocBaseType().equals("DOO") & name.equals("IsRequiredDRP")) {
                this.p_BasedInDamnd = "Y".equals((String)para[i2].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
        this.p_M_DistributionRun_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("M_DistributionRun_ID=" + this.p_M_DistributionRun_ID + ", C_DocType_ID=" + this.p_C_DocType_ID + ", DatePromised=" + this.p_DatePromised + ", Test=" + this.p_IsTest);
        if (this.p_M_DistributionRun_ID == 0) {
            throw new IllegalArgumentException("No Distribution Run ID");
        }
        this.m_run = new MDistributionRun(this.getCtx(), this.p_M_DistributionRun_ID, this.get_TrxName());
        if (this.m_run.get_ID() == 0) {
            throw new Exception("Distribution Run not found -  M_DistributionRun_ID=" + this.p_M_DistributionRun_ID);
        }
        this.m_runLines = this.m_run.getLines(true);
        if (this.m_runLines == null || this.m_runLines.length == 0) {
            throw new Exception("No active, non-zero Distribution Run Lines found");
        }
        if (this.p_C_DocType_ID == 0) {
            throw new IllegalArgumentException("No Document Type ID");
        }
        this.m_docType = new MDocType(this.getCtx(), this.p_C_DocType_ID, null);
        if (this.m_docType.get_ID() == 0) {
            throw new Exception("Document Type not found -  C_DocType_ID=" + this.p_C_DocType_ID);
        }
        this.m_DateOrdered = new Timestamp(System.currentTimeMillis());
        if (this.p_DatePromised == null) {
            this.p_DatePromised = this.m_DateOrdered;
        }
        if (this.m_docType.getDocBaseType().equals("DOO") & this.p_M_Warehouse_ID > 0 ? (this.p_BasedInDamnd ? this.insertDetailsDistributionDemand() == 0 : this.insertDetailsDistribution() == 0) : this.insertDetails() == 0) {
            throw new Exception("No Lines");
        }
        this.m_details = MDistributionRunDetail.get(this.getCtx(), this.p_M_DistributionRun_ID, false, this.get_TrxName());
        this.addAllocations();
        int loops = 0;
        while (!this.isAllocationEqTotal()) {
            this.adjustAllocation();
            this.addAllocations();
            if (++loops <= 10) continue;
            throw new Exception("Loop detected - more than 10 Allocation attempts");
        }
        this.m_details = MDistributionRunDetail.get(this.getCtx(), this.p_M_DistributionRun_ID, true, this.get_TrxName());
        if (this.m_docType.getDocBaseType().equals("DOO")) {
            this.distributionOrders();
        } else {
            this.createOrders();
        }
        return "@Created@ #" + this.m_counter;
    }

    private int insertDetails() {
        String sql = "UPDATE M_DistributionRunLine SET MinQty = 0 WHERE MinQty IS NULL AND M_DistributionRun_ID=?";
        int no = DB.executeUpdateEx(sql, new Object[]{this.p_M_DistributionRun_ID}, this.get_TrxName());
        sql = "UPDATE M_DistributionListLine SET MinQty = 0 WHERE MinQty IS NULL";
        no = DB.executeUpdateEx(sql, this.get_TrxName());
        sql = "UPDATE M_DistributionList l SET RatioTotal = (SELECT SUM(Ratio) FROM M_DistributionListLine ll  WHERE l.M_DistributionList_ID=ll.M_DistributionList_ID) WHERE EXISTS (SELECT * FROM M_DistributionRunLine rl WHERE l.M_DistributionList_ID=rl.M_DistributionList_ID AND rl.M_DistributionRun_ID=?)";
        no = DB.executeUpdateEx(sql, new Object[]{this.p_M_DistributionRun_ID}, this.get_TrxName());
        sql = "DELETE FROM T_DistributionRunDetail WHERE M_DistributionRun_ID=?";
        no = DB.executeUpdateEx(sql, new Object[]{this.p_M_DistributionRun_ID}, this.get_TrxName());
        this.log.fine("insertDetails - deleted #" + no);
        sql = "INSERT INTO T_DistributionRunDetail (M_DistributionRun_ID, M_DistributionRunLine_ID, M_DistributionList_ID, M_DistributionListLine_ID,AD_Client_ID,AD_Org_ID, IsActive, Created,CreatedBy, Updated,UpdatedBy,C_BPartner_ID, C_BPartner_Location_ID, M_Product_ID,Ratio, MinQty, Qty) SELECT rl.M_DistributionRun_ID, rl.M_DistributionRunLine_ID,ll.M_DistributionList_ID, ll.M_DistributionListLine_ID, rl.AD_Client_ID,rl.AD_Org_ID, rl.IsActive, rl.Created,rl.CreatedBy, rl.Updated,rl.UpdatedBy,ll.C_BPartner_ID, ll.C_BPartner_Location_ID, rl.M_Product_ID, ll.Ratio, CASE WHEN rl.MinQty > ll.MinQty THEN rl.MinQty ELSE ll.MinQty END, (ll.Ratio/l.RatioTotal*rl.TotalQty)FROM M_DistributionRunLine rl INNER JOIN M_DistributionList l ON (rl.M_DistributionList_ID=l.M_DistributionList_ID) INNER JOIN M_DistributionListLine ll ON (rl.M_DistributionList_ID=ll.M_DistributionList_ID) WHERE rl.M_DistributionRun_ID=? AND l.RatioTotal<>0 AND rl.IsActive='Y' AND ll.IsActive='Y'";
        no = DB.executeUpdateEx(sql, new Object[]{this.p_M_DistributionRun_ID}, this.get_TrxName());
        this.log.fine("inserted #" + no);
        return no;
    }

    private void addAllocations() {
        MDistributionRunLine runLine;
        int j;
        for (j = 0; j < this.m_runLines.length; ++j) {
            runLine = this.m_runLines[j];
            runLine.resetCalculations();
        }
        for (int i2 = 0; i2 < this.m_details.length; ++i2) {
            MDistributionRunDetail detail = this.m_details[i2];
            for (int j2 = 0; j2 < this.m_runLines.length; ++j2) {
                MDistributionRunLine runLine2 = this.m_runLines[j2];
                if (runLine2.getM_DistributionRunLine_ID() != detail.getM_DistributionRunLine_ID()) continue;
                detail.round(runLine2.getUOMPrecision());
                runLine2.addActualMin(detail.getMinQty());
                runLine2.addActualQty(detail.getQty());
                runLine2.addActualAllocation(detail.getActualAllocation());
                runLine2.setMaxAllocation(detail.getActualAllocation(), false);
                this.log.fine("RunLine=" + runLine2.getLine() + ": BP_ID=" + detail.getC_BPartner_ID() + ", Min=" + detail.getMinQty() + ", Qty=" + detail.getQty() + ", Allocation=" + detail.getActualAllocation());
            }
        }
        for (j = 0; j < this.m_runLines.length; ++j) {
            runLine = this.m_runLines[j];
            this.log.fine("Run - " + runLine.getInfo());
        }
    }

    private boolean isAllocationEqTotal() throws Exception {
        boolean allocationEqTotal = true;
        for (int j = 0; j < this.m_runLines.length; ++j) {
            MDistributionRunLine runLine = this.m_runLines[j];
            if (runLine.isActualMinGtTotal()) {
                throw new Exception("Line " + runLine.getLine() + " Sum of Min Qty=" + runLine.getActualMin() + " is greater than Total Qty=" + runLine.getTotalQty());
            }
            if (!allocationEqTotal || runLine.isActualAllocationEqTotal()) continue;
            allocationEqTotal = false;
        }
        this.log.info("=" + allocationEqTotal);
        return allocationEqTotal;
    }

    private void adjustAllocation() throws Exception {
        for (int j = 0; j < this.m_runLines.length; ++j) {
            this.adjustAllocation(j);
        }
    }

    private void adjustAllocation(int index) throws Exception {
        MDistributionRunDetail detail;
        int i2;
        MDistributionRunLine runLine = this.m_runLines[index];
        BigDecimal difference = runLine.getActualAllocationDiff();
        if (difference.compareTo(Env.ZERO) == 0) {
            return;
        }
        boolean adjustBiggest = difference.abs().compareTo(Env.ONE) <= 0 || difference.abs().compareTo(runLine.getLastDifference().abs()) == 0;
        this.log.fine("Line=" + runLine.getLine() + ", Diff=" + difference + ", Adjust=" + adjustBiggest);
        if (adjustBiggest) {
            for (int i3 = 0; i3 < this.m_details.length; ++i3) {
                MDistributionRunDetail detail2 = this.m_details[i3];
                if (runLine.getM_DistributionRunLine_ID() != detail2.getM_DistributionRunLine_ID()) continue;
                this.log.fine("Biggest - DetailAllocation=" + detail2.getActualAllocation() + ", MaxAllocation=" + runLine.getMaxAllocation() + ", Qty Difference=" + difference);
                if (detail2.getActualAllocation().compareTo(runLine.getMaxAllocation()) != 0 || !detail2.isCanAdjust()) continue;
                detail2.adjustQty(difference);
                detail2.saveEx();
                return;
            }
            throw new Exception("Cannot adjust Difference = " + difference + " - You need to change Total Qty or Min Qty");
        }
        BigDecimal ratioTotal = Env.ZERO;
        for (i2 = 0; i2 < this.m_details.length; ++i2) {
            detail = this.m_details[i2];
            if (runLine.getM_DistributionRunLine_ID() != detail.getM_DistributionRunLine_ID() || !detail.isCanAdjust()) continue;
            ratioTotal = ratioTotal.add(detail.getRatio());
        }
        if (ratioTotal.compareTo(Env.ZERO) == 0) {
            throw new Exception("Cannot distribute Difference = " + difference + " - You need to change Total Qty or Min Qty");
        }
        for (i2 = 0; i2 < this.m_details.length; ++i2) {
            detail = this.m_details[i2];
            if (runLine.getM_DistributionRunLine_ID() != detail.getM_DistributionRunLine_ID() || !detail.isCanAdjust()) continue;
            BigDecimal diffRatio = detail.getRatio().multiply(difference).divide(ratioTotal, RoundingMode.HALF_UP);
            this.log.fine("Detail=" + detail.toString() + ", Allocation=" + detail.getActualAllocation() + ", DiffRatio=" + diffRatio);
            detail.adjustQty(diffRatio);
            detail.saveEx();
        }
        runLine.setLastDifference(difference);
    }

    private boolean createOrders() {
        MBPartner runBPartner;
        int runAD_Org_ID = this.m_run.getAD_Org_ID();
        if (runAD_Org_ID == 0) {
            runAD_Org_ID = Env.getAD_Org_ID(this.getCtx());
        }
        MOrg runOrg = MOrg.get(this.getCtx(), runAD_Org_ID);
        int runC_BPartner_ID = runOrg.getLinkedC_BPartner_ID(this.get_TrxName());
        boolean counter = !this.m_run.isCreateSingleOrder() && runC_BPartner_ID > 0 && !this.m_docType.isSOTrx();
        MBPartner mBPartner = runBPartner = counter ? new MBPartner(this.getCtx(), runC_BPartner_ID, this.get_TrxName()) : null;
        if (!counter || runBPartner == null || runBPartner.get_ID() != runC_BPartner_ID) {
            counter = false;
        }
        if (counter) {
            this.log.info("RunBP=" + runBPartner + " - " + this.m_docType);
        }
        this.log.info("Single=" + this.m_run.isCreateSingleOrder() + " - " + this.m_docType + ",SO=" + this.m_docType.isSOTrx());
        this.log.fine("Counter=" + counter + ",C_BPartner_ID=" + runC_BPartner_ID + "," + runBPartner);
        MBPartner bp = null;
        MOrder singleOrder = null;
        X_M_Product product = null;
        if (this.m_run.isCreateSingleOrder()) {
            bp = new MBPartner(this.getCtx(), this.m_run.getC_BPartner_ID(), this.get_TrxName());
            if (bp.get_ID() == 0) {
                throw new IllegalArgumentException("Business Partner not found - C_BPartner_ID=" + this.m_run.getC_BPartner_ID());
            }
            if (!this.p_IsTest) {
                singleOrder = new MOrder(this.getCtx(), 0, this.get_TrxName());
                singleOrder.setC_DocTypeTarget_ID(this.m_docType.getC_DocType_ID());
                singleOrder.setC_DocType_ID(this.m_docType.getC_DocType_ID());
                singleOrder.setIsSOTrx(this.m_docType.isSOTrx());
                singleOrder.setBPartner(bp);
                if (this.m_run.getC_BPartner_Location_ID() != 0) {
                    singleOrder.setC_BPartner_Location_ID(this.m_run.getC_BPartner_Location_ID());
                }
                singleOrder.setDateOrdered(this.m_DateOrdered);
                singleOrder.setDatePromised(this.p_DatePromised);
                if (!singleOrder.save()) {
                    this.log.log(Level.SEVERE, "Order not saved");
                    return false;
                }
                ++this.m_counter;
            }
        }
        int lastC_BPartner_ID = 0;
        int lastC_BPartner_Location_ID = 0;
        MOrder order = null;
        for (int i2 = 0; i2 < this.m_details.length; ++i2) {
            MDistributionRunDetail detail = this.m_details[i2];
            if (this.m_run.isCreateSingleOrder()) {
                order = singleOrder;
            } else if (lastC_BPartner_ID != detail.getC_BPartner_ID() || lastC_BPartner_Location_ID != detail.getC_BPartner_Location_ID()) {
                order = null;
            }
            lastC_BPartner_ID = detail.getC_BPartner_ID();
            lastC_BPartner_Location_ID = detail.getC_BPartner_Location_ID();
            if (order == null) {
                bp = new MBPartner(this.getCtx(), detail.getC_BPartner_ID(), this.get_TrxName());
                if (!this.p_IsTest) {
                    order = new MOrder(this.getCtx(), 0, this.get_TrxName());
                    order.setC_DocTypeTarget_ID(this.m_docType.getC_DocType_ID());
                    order.setC_DocType_ID(this.m_docType.getC_DocType_ID());
                    order.setIsSOTrx(this.m_docType.isSOTrx());
                    if (counter && bp.getAD_OrgBP_ID_Int() > 0) {
                        this.log.fine("Counter - From_BPOrg=" + bp.getAD_OrgBP_ID_Int() + "-" + bp + ", To_BP=" + runBPartner);
                        order.setAD_Org_ID(bp.getAD_OrgBP_ID_Int());
                        MOrgInfo oi = MOrgInfo.get(this.getCtx(), bp.getAD_OrgBP_ID_Int(), this.get_TrxName());
                        if (oi.getM_Warehouse_ID() > 0) {
                            order.setM_Warehouse_ID(oi.getM_Warehouse_ID());
                        }
                        order.setBPartner(runBPartner);
                    } else {
                        this.log.fine("From_Org=" + runAD_Org_ID + ", To_BP=" + bp);
                        order.setAD_Org_ID(runAD_Org_ID);
                        order.setBPartner(bp);
                        if (detail.getC_BPartner_Location_ID() != 0) {
                            order.setC_BPartner_Location_ID(detail.getC_BPartner_Location_ID());
                        }
                    }
                    order.setDateOrdered(this.m_DateOrdered);
                    order.setDatePromised(this.p_DatePromised);
                    if (!order.save()) {
                        this.log.log(Level.SEVERE, "Order not saved");
                        return false;
                    }
                }
            }
            if (product == null || product.getM_Product_ID() != detail.getM_Product_ID()) {
                product = MProduct.get(this.getCtx(), detail.getM_Product_ID());
            }
            if (this.p_IsTest) {
                this.addLog(0, null, detail.getActualAllocation(), bp.getName() + " - " + product.getName());
                continue;
            }
            MOrderLine line = new MOrderLine(order);
            if (!counter || bp.getAD_OrgBP_ID_Int() <= 0) {
                line.setC_BPartner_ID(detail.getC_BPartner_ID());
                if (detail.getC_BPartner_Location_ID() != 0) {
                    line.setC_BPartner_Location_ID(detail.getC_BPartner_Location_ID());
                }
            }
            line.setProduct((MProduct)product);
            line.setQty(detail.getActualAllocation());
            line.setPrice();
            if (!line.save()) {
                this.log.log(Level.SEVERE, "OrderLine not saved");
                return false;
            }
            this.addLog(0, null, detail.getActualAllocation(), order.getDocumentNo() + ": " + bp.getName() + " - " + product.getName());
        }
        order = null;
        return true;
    }

    private int insertDetailsDistributionDemand() {
        Object sql = "UPDATE M_DistributionRunLine SET MinQty = 0 WHERE MinQty IS NULL";
        int no = DB.executeUpdate((String)sql, this.get_TrxName());
        sql = "UPDATE M_DistributionListLine SET MinQty = 0 WHERE MinQty IS NULL";
        no = DB.executeUpdate((String)sql, this.get_TrxName());
        sql = "DELETE FROM T_DistributionRunDetail WHERE M_DistributionRun_ID=" + this.p_M_DistributionRun_ID;
        no = DB.executeUpdate((String)sql, this.get_TrxName());
        this.log.fine("insertDetails - deleted #" + no);
        sql = "INSERT INTO T_DistributionRunDetail (M_DistributionRun_ID, M_DistributionRunLine_ID, M_DistributionList_ID, M_DistributionListLine_ID,AD_Client_ID,AD_Org_ID, IsActive, Created,CreatedBy, Updated,UpdatedBy,C_BPartner_ID, C_BPartner_Location_ID, M_Product_ID,Ratio, MinQty, Qty) SELECT MAX(rl.M_DistributionRun_ID), MAX(rl.M_DistributionRunLine_ID),MAX(ll.M_DistributionList_ID), MAX(ll.M_DistributionListLine_ID), MAX(rl.AD_Client_ID),MAX(rl.AD_Org_ID), MAX(rl.IsActive), MAX(rl.Created),MAX(rl.CreatedBy), MAX(rl.Updated),MAX(rl.UpdatedBy), MAX(ll.C_BPartner_ID), MAX(ll.C_BPartner_Location_ID), MAX(rl.M_Product_ID),COALESCE (SUM(ol.QtyOrdered-ol.QtyDelivered-TargetQty), 0) ,  0 , 0 FROM M_DistributionRunLine rl INNER JOIN M_DistributionList l ON (rl.M_DistributionList_ID=l.M_DistributionList_ID) INNER JOIN M_DistributionListLine ll ON (rl.M_DistributionList_ID=ll.M_DistributionList_ID) INNER JOIN DD_Order o ON (o.C_BPartner_ID=ll.C_BPartner_ID AND o.DocStatus IN ('DR','IN')) INNER JOIN DD_OrderLine ol ON (ol.DD_Order_ID=o.DD_Order_ID AND ol.M_Product_ID=rl.M_Product_ID) INNER JOIN M_Locator loc ON (loc.M_Locator_ID=ol.M_Locator_ID AND loc.M_Warehouse_ID=" + this.p_M_Warehouse_ID + ") WHERE rl.M_DistributionRun_ID=" + this.p_M_DistributionRun_ID + " AND rl.IsActive='Y' AND ll.IsActive='Y' AND ol.DatePromised <= " + DB.TO_DATE(this.p_DatePromised) + " GROUP BY o.M_Shipper_ID , ll.C_BPartner_ID, ol.M_Product_ID";
        no = DB.executeUpdate((String)sql, this.get_TrxName());
        List records = new Query(this.getCtx(), "T_DistributionRunDetail", "M_DistributionRun_ID=?", this.get_TrxName()).setParameters(this.p_M_DistributionRun_ID).list();
        for (MDistributionRunDetail record : records) {
            MDistributionRunLine drl = (MDistributionRunLine)MTable.get(this.getCtx(), MDistributionRunLine.Table_ID).getPO(record.getM_DistributionRunLine_ID(), this.get_TrxName());
            MProduct product = MProduct.get(this.getCtx(), record.getM_Product_ID());
            BigDecimal ration = record.getRatio();
            BigDecimal totalration = this.getQtyDemand(record.getM_Product_ID());
            this.log.info("Value:" + product.getValue());
            this.log.info("Product:" + product.getName());
            this.log.info("Qty To Deliver:" + record.getRatio());
            this.log.info("Qty Target:" + record.getMinQty());
            this.log.info("Qty Total Available:" + drl.getTotalQty());
            this.log.info("Qty Total Demand:" + totalration);
            BigDecimal factor = ration.divide(totalration, 12, RoundingMode.HALF_UP);
            record.setQty(drl.getTotalQty().multiply(factor));
            record.saveEx();
        }
        this.log.fine("inserted #" + no);
        return no;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getQtyDemand(int M_Product_ID) {
        ResultSet rs;
        CPreparedStatement pstmt;
        block4: {
            BigDecimal bigDecimal;
            StringBuffer sql = new StringBuffer("SELECT SUM (QtyOrdered-QtyDelivered-TargetQty)  FROM DD_OrderLine ol INNER JOIN M_Locator l ON (l.M_Locator_ID=ol.M_Locator_ID) INNER JOIN DD_Order o ON (o.DD_Order_ID=ol.DD_Order_ID) ");
            sql.append(" WHERE o.DocStatus IN ('DR','IN') AND ol.DatePromised <= ? AND l.M_Warehouse_ID=? AND ol.M_Product_ID=? GROUP BY M_Product_ID, l.M_Warehouse_ID");
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
                pstmt.setTimestamp(1, this.p_DatePromised);
                pstmt.setInt(2, this.p_M_Warehouse_ID);
                pstmt.setInt(3, M_Product_ID);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                bigDecimal = rs.getBigDecimal(1);
            }
            catch (Exception e) {
                BigDecimal bigDecimal2;
                try {
                    this.log.log(Level.SEVERE, "doIt - " + sql, e);
                    bigDecimal2 = Env.ZERO;
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return bigDecimal2;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return bigDecimal;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return Env.ZERO;
    }

    private int insertDetailsDistribution() {
        Object sql = "UPDATE M_DistributionRunLine SET MinQty = 0 WHERE MinQty IS NULL";
        int no = DB.executeUpdate((String)sql, this.get_TrxName());
        sql = "UPDATE M_DistributionListLine SET MinQty = 0 WHERE MinQty IS NULL";
        no = DB.executeUpdate((String)sql, this.get_TrxName());
        sql = "DELETE FROM T_DistributionRunDetail WHERE M_DistributionRun_ID=" + this.p_M_DistributionRun_ID;
        no = DB.executeUpdate((String)sql, this.get_TrxName());
        this.log.fine("insertDetails - deleted #" + no);
        sql = "INSERT INTO T_DistributionRunDetail (M_DistributionRun_ID, M_DistributionRunLine_ID, M_DistributionList_ID, M_DistributionListLine_ID,AD_Client_ID,AD_Org_ID, IsActive, Created,CreatedBy, Updated,UpdatedBy,C_BPartner_ID, C_BPartner_Location_ID, M_Product_ID,Ratio, MinQty, Qty) SELECT rl.M_DistributionRun_ID, rl.M_DistributionRunLine_ID,ll.M_DistributionList_ID, ll.M_DistributionListLine_ID, rl.AD_Client_ID,rl.AD_Org_ID, rl.IsActive, rl.Created,rl.CreatedBy, rl.Updated,rl.UpdatedBy, ll.C_BPartner_ID, ll.C_BPartner_Location_ID, rl.M_Product_ID, 0 , ol.TargetQty AS MinQty , 0 FROM M_DistributionRunLine rl INNER JOIN M_DistributionList l ON (rl.M_DistributionList_ID=l.M_DistributionList_ID) INNER JOIN M_DistributionListLine ll ON (rl.M_DistributionList_ID=ll.M_DistributionList_ID) INNER JOIN DD_Order o ON (o.C_BPartner_ID=ll.C_BPartner_ID) INNER JOIN DD_OrderLine ol ON (ol.DD_Order_ID=o.DD_Order_ID AND ol.M_Product_ID=rl.M_Product_ID) AND ol.DatePromised<=" + DB.TO_DATE(this.p_DatePromised) + " INNER JOIN M_Locator loc ON (loc.M_Locator_ID=ol.M_Locator_ID AND loc.M_Warehouse_ID=" + this.p_M_Warehouse_ID + ")  WHERE rl.M_DistributionRun_ID=" + this.p_M_DistributionRun_ID + " AND l.RatioTotal<>0 AND rl.IsActive='Y' AND ll.IsActive='Y'";
        no = DB.executeUpdate((String)sql, this.get_TrxName());
        Query query = MTable.get(this.getCtx(), I_T_DistributionRunDetail.Table_ID).createQuery("M_DistributionRun_ID=?", this.get_TrxName());
        query.setParameters(this.p_M_DistributionRun_ID);
        List records = query.list();
        for (MDistributionRunDetail record : records) {
            BigDecimal total_ration = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(Ratio) FROM T_DistributionRunDetail WHERE M_DistributionRun_ID=? AND M_Product_ID=? GROUP BY  M_Product_ID", this.p_M_DistributionRun_ID, record.getM_Product_ID());
            MDistributionRunLine drl = (MDistributionRunLine)MTable.get(this.getCtx(), MDistributionRunLine.Table_ID).getPO(record.getM_DistributionRunLine_ID(), this.get_TrxName());
            BigDecimal ration = record.getRatio();
            BigDecimal factor = ration.divide(total_ration, RoundingMode.HALF_UP);
            record.setQty(factor.multiply(drl.getTotalQty()));
            record.saveEx();
        }
        this.log.fine("inserted #" + no);
        return no;
    }

    private boolean distributionOrders() {
        MBPartner runBPartner;
        if (this.p_BasedInDamnd) {
            int M_Warehouse_ID = 0;
            if (this.p_M_Warehouse_ID <= 0) {
                MOrgInfo oi_source = MOrgInfo.get(this.getCtx(), this.m_run.getAD_Org_ID(), this.get_TrxName());
                MWarehouse m_source = MWarehouse.get(this.getCtx(), oi_source.getM_Warehouse_ID());
                if (m_source == null) {
                    throw new AdempiereException("Do not exist Defautl Warehouse Source");
                }
                M_Warehouse_ID = m_source.getM_Warehouse_ID();
            } else {
                M_Warehouse_ID = this.p_M_Warehouse_ID;
            }
            for (int i2 = 0; i2 < this.m_details.length; ++i2) {
                MDistributionRunDetail detail = this.m_details[i2];
                X_DD_OrderLine distributionOrderLine = (X_DD_OrderLine)new Query(this.getCtx(), "DD_OrderLine", "M_Product_ID = ? AND DatePromised <= ? AND EXISTS(SELECT 1 FROM DD_Order o WHERE o.DD_Order_ID = DD_OrderLine.DD_Order_ID AND o.DocStatus IN('DR','IN') AND o.C_BPartner_ID = ?) AND EXISTS(SELECT 1 FROM M_Locator l WHERE l.M_Locator_ID = DD_OrderLine.M_Locator_ID AND l.M_Warehouse_ID = ?)", this.get_TrxName()).setParameters(detail.getM_Product_ID(), this.p_DatePromised, detail.getC_BPartner_ID(), M_Warehouse_ID).first();
                if (distributionOrderLine == null) continue;
                distributionOrderLine.set_ValueOfColumn("M_Product_ID", (Object)detail.getM_Product_ID());
                BigDecimal targetQuantity = Optional.ofNullable(distributionOrderLine.getTargetQty()).orElse(Env.ZERO);
                distributionOrderLine.setConfirmedQty(targetQuantity.add(detail.getActualAllocation()));
                if (this.p_M_Warehouse_ID > 0) {
                    distributionOrderLine.setDescription(Msg.translate(this.getCtx(), "PlannedQty"));
                } else {
                    distributionOrderLine.setDescription(this.m_run.getName());
                }
                distributionOrderLine.saveEx();
            }
            return true;
        }
        int runAD_Org_ID = this.m_run.getAD_Org_ID();
        if (runAD_Org_ID == 0) {
            runAD_Org_ID = Env.getAD_Org_ID(this.getCtx());
        }
        MOrg runOrg = MOrg.get(this.getCtx(), runAD_Org_ID);
        int runC_BPartner_ID = runOrg.getLinkedC_BPartner_ID(this.get_TrxName());
        boolean counter = !this.m_run.isCreateSingleOrder() && runC_BPartner_ID > 0 && !this.m_docType.isSOTrx();
        MBPartner mBPartner = runBPartner = counter ? new MBPartner(this.getCtx(), runC_BPartner_ID, this.get_TrxName()) : null;
        if (!counter || runBPartner == null || runBPartner.get_ID() != runC_BPartner_ID) {
            counter = false;
        }
        if (counter) {
            this.log.info("RunBP=" + runBPartner + " - " + this.m_docType);
        }
        this.log.info("Single=" + this.m_run.isCreateSingleOrder() + " - " + this.m_docType + ",SO=" + this.m_docType.isSOTrx());
        this.log.fine("Counter=" + counter + ",C_BPartner_ID=" + runC_BPartner_ID + "," + runBPartner);
        MBPartner bp = null;
        X_DD_Order singleOrder = null;
        X_M_Product product = null;
        MWarehouse m_source = null;
        MLocator m_locator = null;
        MWarehouse m_target = null;
        MLocator m_locator_to = null;
        MWarehouse[] ws = null;
        MOrgInfo oi_source = MOrgInfo.get(this.getCtx(), this.m_run.getAD_Org_ID(), this.get_TrxName());
        m_source = MWarehouse.get(this.getCtx(), oi_source.getM_Warehouse_ID());
        if (m_source == null) {
            throw new AdempiereException("Do not exist Defautl Warehouse Source");
        }
        m_locator = MLocator.getDefault(m_source);
        ws = MWarehouse.getInTransitForOrg(this.getCtx(), m_source.getAD_Org_ID());
        if (ws == null) {
            throw new AdempiereException("Warehouse Intransit do not found");
        }
        if (this.m_run.isCreateSingleOrder()) {
            bp = new MBPartner(this.getCtx(), this.m_run.getC_BPartner_ID(), this.get_TrxName());
            if (bp.get_ID() == 0) {
                throw new IllegalArgumentException("Business Partner not found - C_BPartner_ID=" + this.m_run.getC_BPartner_ID());
            }
            if (!this.p_IsTest) {
                singleOrder = new X_DD_Order(this.getCtx(), 0, this.get_TrxName());
                singleOrder.setC_DocType_ID(this.m_docType.getC_DocType_ID());
                singleOrder.setIsSOTrx(this.m_docType.isSOTrx());
                this.setBusinessPartner(singleOrder, bp);
                if (this.m_run.getC_BPartner_Location_ID() != 0) {
                    singleOrder.setC_BPartner_Location_ID(this.m_run.getC_BPartner_Location_ID());
                }
                singleOrder.setDateOrdered(this.m_DateOrdered);
                singleOrder.setDatePromised(this.p_DatePromised);
                singleOrder.setM_Warehouse_ID(ws[0].getM_Warehouse_ID());
                singleOrder.saveEx();
                ++this.m_counter;
            }
        }
        int lastC_BPartner_ID = 0;
        int lastC_BPartner_Location_ID = 0;
        X_DD_Order order = null;
        for (int i3 = 0; i3 < this.m_details.length; ++i3) {
            MDistributionRunDetail detail = this.m_details[i3];
            if (this.m_run.isCreateSingleOrder()) {
                order = singleOrder;
            } else if (lastC_BPartner_ID != detail.getC_BPartner_ID() || lastC_BPartner_Location_ID != detail.getC_BPartner_Location_ID()) {
                order = null;
            }
            lastC_BPartner_ID = detail.getC_BPartner_ID();
            lastC_BPartner_Location_ID = detail.getC_BPartner_Location_ID();
            bp = new MBPartner(this.getCtx(), detail.getC_BPartner_ID(), this.get_TrxName());
            MOrgInfo oi_target = MOrgInfo.get(this.getCtx(), bp.getAD_OrgBP_ID_Int(), this.get_TrxName());
            m_target = MWarehouse.get(this.getCtx(), oi_target.getM_Warehouse_ID());
            if (m_target == null) {
                throw new AdempiereException("Do not exist Default Warehouse Target");
            }
            m_locator_to = MLocator.getDefault(m_target);
            if (m_locator == null || m_locator_to == null) {
                throw new AdempiereException("Do not exist default Locator for Warehouses");
            }
            if (this.p_ConsolidateDocument) {
                String whereClause = "DocStatus IN ('DR','IN') AND AD_Org_ID=" + bp.getAD_OrgBP_ID_Int() + " AND C_BPartner_ID=? AND M_Warehouse_ID=?  AND DatePromised<=? ";
                order = (X_DD_Order)new Query(this.getCtx(), "C_Order", whereClause, this.get_TrxName()).setParameters(lastC_BPartner_ID, ws[0].getM_Warehouse_ID(), this.p_DatePromised).setOrderBy("DatePromised DESC").first();
            }
            if (order == null && !this.p_IsTest) {
                order = new X_DD_Order(this.getCtx(), 0, this.get_TrxName());
                order.setAD_Org_ID(bp.getAD_OrgBP_ID_Int());
                order.setIsSOTrx(this.m_docType.isSOTrx());
                if (counter && bp.getAD_OrgBP_ID_Int() > 0) {
                    this.log.fine("Counter - From_BPOrg=" + bp.getAD_OrgBP_ID_Int() + "-" + bp + ", To_BP=" + runBPartner);
                    order.setAD_Org_ID(bp.getAD_OrgBP_ID_Int());
                    if (ws[0].getM_Warehouse_ID() > 0) {
                        order.setM_Warehouse_ID(ws[0].getM_Warehouse_ID());
                    }
                    this.setBusinessPartner(order, runBPartner);
                } else {
                    this.log.fine("From_Org=" + runAD_Org_ID + ", To_BP=" + bp);
                    order.setAD_Org_ID(bp.getAD_OrgBP_ID_Int());
                    this.setBusinessPartner(order, bp);
                    if (detail.getC_BPartner_Location_ID() != 0) {
                        order.setC_BPartner_Location_ID(detail.getC_BPartner_Location_ID());
                    }
                }
                order.setM_Warehouse_ID(ws[0].getM_Warehouse_ID());
                order.setDateOrdered(this.m_DateOrdered);
                order.setDatePromised(this.p_DatePromised);
                order.setIsInDispute(false);
                order.setIsInTransit(false);
                order.saveEx();
            }
            if (product == null || product.getM_Product_ID() != detail.getM_Product_ID()) {
                product = MProduct.get(this.getCtx(), detail.getM_Product_ID());
            }
            if (this.p_IsTest) {
                this.addLog(0, null, detail.getActualAllocation(), bp.getName() + " - " + product.getName());
                continue;
            }
            if (this.p_ConsolidateDocument) {
                String Description;
                BigDecimal QtyAllocation;
                X_DD_OrderLine line;
                String sql = "SELECT DD_OrderLine_ID FROM DD_OrderLine ol INNER JOIN DD_Order o ON (o.DD_Order_ID=ol.DD_Order_ID) WHERE o.DocStatus IN ('DR','IN') AND o.C_BPartner_ID = ? AND M_Product_ID=? AND  ol.M_Locator_ID=?  AND ol.DatePromised <= ?";
                int DD_OrderLine_ID = DB.getSQLValueEx(this.get_TrxName(), sql, detail.getC_BPartner_ID(), product.getM_Product_ID(), m_locator.getM_Locator_ID(), this.p_DatePromised);
                if (DD_OrderLine_ID <= 0) {
                    line = this.getDistributionOrderLineInstanceFromParent(order);
                    line.setAD_Org_ID(bp.getAD_OrgBP_ID_Int());
                    line.setM_Locator_ID(m_locator.getM_Locator_ID());
                    line.setM_LocatorTo_ID(m_locator_to.getM_Locator_ID());
                    line.setIsInvoiced(false);
                    line.setM_Product_ID(product.getM_Product_ID());
                    QtyAllocation = detail.getActualAllocation();
                    if (QtyAllocation == null) {
                        QtyAllocation = Env.ZERO;
                    }
                    line.setQtyEntered(QtyAllocation);
                    line.setQtyOrdered(QtyAllocation);
                    line.setTargetQty(Env.ZERO);
                    Description = "";
                    if (this.m_run.getName() != null) {
                        Description = Description.concat(this.m_run.getName());
                    }
                    line.setDescription(Description + " " + Msg.translate(this.getCtx(), "Qty") + " = " + QtyAllocation + " ");
                    line.saveEx();
                } else {
                    line = new X_DD_OrderLine(this.getCtx(), DD_OrderLine_ID, this.get_TrxName());
                    QtyAllocation = detail.getActualAllocation();
                    if (QtyAllocation == null) {
                        QtyAllocation = Env.ZERO;
                    }
                    if ((Description = line.getDescription()) == null) {
                        Description = "";
                    }
                    if (this.m_run.getName() != null) {
                        Description = Description.concat(this.m_run.getName());
                    }
                    line.setDescription(Description + " " + Msg.translate(this.getCtx(), "Qty") + " = " + QtyAllocation + " ");
                    BigDecimal quantityentered = Optional.ofNullable(line.getQtyEntered()).orElse(Env.ZERO);
                    line.setQtyEntered(quantityentered.add(QtyAllocation));
                    line.setQtyOrdered(quantityentered.add(QtyAllocation));
                    line.saveEx();
                }
            } else {
                X_DD_OrderLine line = this.getDistributionOrderLineInstanceFromParent(order);
                if (!counter || bp.getAD_OrgBP_ID_Int() > 0) {
                    // empty if block
                }
                line.setAD_Org_ID(bp.getAD_OrgBP_ID_Int());
                line.setM_Locator_ID(m_locator.getM_Locator_ID());
                line.setM_LocatorTo_ID(m_locator_to.getM_Locator_ID());
                line.setIsInvoiced(false);
                line.setM_Product_ID(product.getM_Product_ID());
                line.setQtyEntered(detail.getActualAllocation());
                line.setQtyOrdered(detail.getActualAllocation());
                line.setTargetQty(Env.ZERO);
                String Description = "";
                if (this.m_run.getName() != null) {
                    Description = Description.concat(this.m_run.getName());
                }
                line.setDescription(Description + " " + Msg.translate(this.getCtx(), "Qty") + " = " + detail.getActualAllocation() + " ");
                line.saveEx();
            }
            this.addLog(0, null, detail.getActualAllocation(), order.get_Value("DocumentNo") + ": " + bp.getName() + " - " + product.getName());
        }
        order = null;
        return true;
    }

    private void setBusinessPartner(X_DD_Order referenceToSet, MBPartner bp) {
        if (bp == null) {
            return;
        }
        referenceToSet.setC_BPartner_ID(bp.getC_BPartner_ID());
        int ii = 0;
        ii = referenceToSet.isSOTrx() ? bp.getC_PaymentTerm_ID() : bp.getPO_PaymentTerm_ID();
        ii = referenceToSet.isSOTrx() ? bp.getM_PriceList_ID() : bp.getPO_PriceList_ID();
        String ss = bp.getDeliveryRule();
        if (ss != null) {
            referenceToSet.setDeliveryRule(ss);
        }
        if ((ss = bp.getDeliveryViaRule()) != null) {
            referenceToSet.setDeliveryViaRule(ss);
        }
        ss = bp.getInvoiceRule();
        if (referenceToSet.getSalesRep_ID() == 0 && (ii = Env.getAD_User_ID(referenceToSet.getCtx())) != 0) {
            referenceToSet.setSalesRep_ID(ii);
        }
        List<MBPartnerLocation> partnerLocations = Arrays.asList(bp.getLocations(false));
        MBPartnerLocation partnerLocation = partnerLocations.stream().filter(pl -> pl.isShipTo()).reduce((first, last) -> last).orElseGet(() -> (MBPartnerLocation)partnerLocations.stream().findFirst().orElseThrow(() -> new AdempiereException("@IsShipTo@ @NotFound@")));
        referenceToSet.setC_BPartner_Location_ID(partnerLocation.getC_BPartner_Location_ID());
        Arrays.asList(bp.getContacts(false)).stream().findFirst().ifPresent(user -> referenceToSet.setAD_User_ID(user.getAD_User_ID()));
    }

    private X_DD_OrderLine getDistributionOrderLineInstanceFromParent(X_DD_Order distributionOrder) {
        X_DD_OrderLine distributionOrderLine = new X_DD_OrderLine(distributionOrder.getCtx(), 0, distributionOrder.get_TrxName());
        distributionOrderLine.setDD_Order_ID(distributionOrder.get_ID());
        distributionOrderLine.setAD_Org_ID(distributionOrder.getAD_Org_ID());
        distributionOrderLine.setDateOrdered(distributionOrder.getDateOrdered());
        distributionOrderLine.setDatePromised(distributionOrder.getDatePromised());
        return distributionOrderLine;
    }
}

