/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_GL_Journal;
import org.adempiere.core.domains.models.X_I_GLJournal;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.process.ImportProcess;
import org.compiere.model.MAccount;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MJournalLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;

public class ImportGLJournal
extends SvrProcess
implements ImportProcess {
    private int m_AD_Client_ID = 0;
    private int m_AD_Org_ID = 0;
    private int m_C_AcctSchema_ID = 0;
    private Timestamp m_DateAcct = null;
    private boolean m_DeleteOldImported = false;
    private boolean m_IsValidateOnly = false;
    private boolean m_IsImportOnlyNoErrors = true;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("AD_Client_ID")) {
                this.m_AD_Client_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("AD_Org_ID")) {
                this.m_AD_Org_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_AcctSchema_ID")) {
                this.m_C_AcctSchema_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("DateAcct")) {
                this.m_DateAcct = (Timestamp)para[i2].getParameter();
                continue;
            }
            if (name.equals("IsValidateOnly")) {
                this.m_IsValidateOnly = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("IsImportOnlyNoErrors")) {
                this.m_IsImportOnlyNoErrors = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("DeleteOldImported")) {
                this.m_DeleteOldImported = "Y".equals(para[i2].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("IsValidateOnly=" + this.m_IsValidateOnly + ", IsImportOnlyNoErrors=" + this.m_IsImportOnlyNoErrors);
        String clientCheck = " AND AD_Client_ID=" + this.m_AD_Client_ID;
        Trx.run(trxName -> {
            StringBuilder sql = new StringBuilder();
            int no = 0;
            if (this.m_DeleteOldImported) {
                sql = new StringBuilder("DELETE I_GLJournal WHERE I_IsImported='Y'").append(clientCheck);
                no = DB.executeUpdate(sql.toString(), trxName);
                this.log.fine("Delete Old Impored =" + no);
            }
            ModelValidationEngine.get().fireImportValidate(this, null, null, 10);
            sql = new StringBuilder("UPDATE I_GLJournal SET IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = ' ', I_IsImported = 'N' WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.info("Reset=" + no);
            sql = new StringBuilder("UPDATE I_GLJournal i SET AD_Client_ID=(SELECT c.AD_Client_ID FROM AD_Client c WHERE c.Value=i.ClientValue) WHERE (AD_Client_ID IS NULL OR AD_Client_ID=0) AND ClientValue IS NOT NULL AND I_IsImported<>'Y'");
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Set Client from Value=" + no);
            sql = new StringBuilder("UPDATE I_GLJournal SET AD_Client_ID = COALESCE (AD_Client_ID,").append(this.m_AD_Client_ID).append("), AD_OrgDoc_ID = COALESCE (AD_OrgDoc_ID,").append(this.m_AD_Org_ID).append("),");
            if (this.m_C_AcctSchema_ID != 0) {
                sql.append(" C_AcctSchema_ID = COALESCE (C_AcctSchema_ID,").append(this.m_C_AcctSchema_ID).append("),");
            }
            if (this.m_DateAcct != null) {
                sql.append(" DateAcct = COALESCE (DateAcct,").append(DB.TO_DATE(this.m_DateAcct)).append("),");
            }
            sql.append(" Updated = COALESCE (Updated, SysDate) WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Client/DocOrg/Default=" + no);
            sql = new StringBuilder("UPDATE I_GLJournal o SET I_IsImported='E', I_ErrorMsg=COALESCE(I_ErrorMsg,'')\t||' ERR=Invalid Doc Org, 'WHERE (AD_OrgDoc_ID IS NULL OR AD_OrgDoc_ID=0 OR EXISTS (SELECT * FROM AD_Org oo WHERE o.AD_OrgDoc_ID=oo.AD_Org_ID AND (oo.IsSummary='Y' OR oo.IsActive='N'))) AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            if (no != 0) {
                this.log.warning("Invalid Doc Org=" + no);
            }
            sql = new StringBuilder("UPDATE I_GLJournal i SET C_AcctSchema_ID=(SELECT a.C_AcctSchema_ID FROM C_AcctSchema a WHERE i.AcctSchemaName=a.Name AND i.AD_Client_ID=a.AD_Client_ID) WHERE C_AcctSchema_ID IS NULL AND AcctSchemaName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Set AcctSchema from Name=" + no);
            sql = new StringBuilder("UPDATE I_GLJournal i SET C_AcctSchema_ID=(SELECT c.C_AcctSchema1_ID FROM AD_ClientInfo c WHERE c.AD_Client_ID=i.AD_Client_ID) WHERE C_AcctSchema_ID IS NULL AND AcctSchemaName IS NULL AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Set AcctSchema from Client=" + no);
            sql = new StringBuilder("UPDATE I_GLJournal i SET I_IsImported='E', I_ErrorMsg=COALESCE(I_ErrorMsg,'')\t||' ERR=Invalid AcctSchema, 'WHERE (C_AcctSchema_ID IS NULL OR C_AcctSchema_ID=0 OR NOT EXISTS (SELECT * FROM C_AcctSchema a WHERE i.AD_Client_ID=a.AD_Client_ID)) AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            if (no != 0) {
                this.log.warning("Invalid AcctSchema=" + no);
            }
            sql = new StringBuilder("UPDATE I_GLJournal i SET DateAcct=SysDate WHERE DateAcct IS NULL AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Set DateAcct=" + no);
            sql = new StringBuilder("UPDATE I_GLJournal i SET C_DocType_ID=(SELECT d.C_DocType_ID FROM C_DocType d WHERE d.Name=i.DocTypeName AND d.DocBaseType='GLJ' AND i.AD_Client_ID=d.AD_Client_ID) WHERE C_DocType_ID IS NULL AND DocTypeName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Set DocType=" + no);
            sql = new StringBuilder("UPDATE I_GLJournal i SET I_IsImported='E', I_ErrorMsg=COALESCE(I_ErrorMsg,'')\t||' ERR=Invalid DocType, 'WHERE (C_DocType_ID IS NULL OR C_DocType_ID=0 OR NOT EXISTS (SELECT * FROM C_DocType d WHERE i.AD_Client_ID=d.AD_Client_ID AND d.DocBaseType='GLJ')) AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            if (no != 0) {
                this.log.warning("Invalid DocType=" + no);
            }
            sql = new StringBuilder("UPDATE I_GLJournal i SET GL_Category_ID=(SELECT c.GL_Category_ID FROM GL_Category c WHERE c.Name=i.CategoryName AND i.AD_Client_ID=c.AD_Client_ID) WHERE GL_Category_ID IS NULL AND CategoryName IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Set DocType=" + no);
            sql = new StringBuilder("UPDATE I_GLJournal i SET I_IsImported='E', I_ErrorMsg=COALESCE(I_ErrorMsg,'')\t||' ERR=Invalid Category, 'WHERE (GL_Category_ID IS NULL OR GL_Category_ID=0) AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            if (no != 0) {
                this.log.warning("Invalid GLCategory=" + no);
            }
            sql = new StringBuilder("UPDATE I_GLJournal i SET C_Currency_ID=(SELECT c.C_Currency_ID FROM C_Currency c WHERE c.ISO_Code=i.ISO_Code AND c.AD_Client_ID IN (0,i.AD_Client_ID)) WHERE C_Currency_ID IS NULL AND ISO_Code IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Set Currency from ISO=" + no);
            sql = new StringBuilder("UPDATE I_GLJournal i SET C_Currency_ID=(SELECT a.C_Currency_ID FROM C_AcctSchema a WHERE a.C_AcctSchema_ID=i.C_AcctSchema_ID AND a.AD_Client_ID=i.AD_Client_ID)WHERE C_Currency_ID IS NULL AND ISO_Code IS NULL AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Set Default Currency=" + no);
            sql = new StringBuilder("UPDATE I_GLJournal i SET I_IsImported='E', I_ErrorMsg=COALESCE(I_ErrorMsg,'')\t||' ERR=Invalid Currency, 'WHERE (C_Currency_ID IS NULL OR C_Currency_ID=0) AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            if (no != 0) {
                this.log.warning("Invalid Currency=" + no);
            }
            sql = new StringBuilder("UPDATE I_GLJournal i SET ConversionTypeValue='S' WHERE C_ConversionType_ID IS NULL AND ConversionTypeValue IS NULL AND I_IsImported='N'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Set CurrencyType Value to Spot =" + no);
            sql = new StringBuilder("UPDATE I_GLJournal i SET C_ConversionType_ID=(SELECT c.C_ConversionType_ID FROM C_ConversionType c WHERE c.Value=i.ConversionTypeValue AND c.AD_Client_ID IN (0,i.AD_Client_ID)) WHERE C_ConversionType_ID IS NULL AND ConversionTypeValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Set CurrencyType from Value=" + no);
            sql = new StringBuilder("UPDATE I_GLJournal i SET I_IsImported='E', I_ErrorMsg=COALESCE(I_ErrorMsg,'')\t||' ERR=Invalid CurrencyType, 'WHERE (C_ConversionType_ID IS NULL OR C_ConversionType_ID=0) AND ConversionTypeValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            if (no != 0) {
                this.log.warning("Invalid CurrencyTypeValue=" + no);
            }
            if ((no = DB.executeUpdate((sql = new StringBuilder("UPDATE I_GLJournal i SET I_IsImported='E', I_ErrorMsg=COALESCE(I_ErrorMsg,'')\t||' ERR=No ConversionType, 'WHERE (C_ConversionType_ID IS NULL OR C_ConversionType_ID=0) AND I_IsImported<>'Y'").append(clientCheck)).toString(), trxName)) != 0) {
                this.log.warning("No CourrencyType=" + no);
            }
            sql = new StringBuilder("UPDATE I_GLJournal i SET CurrencyRate=1WHERE EXISTS (SELECT * FROM C_AcctSchema a WHERE a.C_AcctSchema_ID=i.C_AcctSchema_ID AND a.C_Currency_ID=i.C_Currency_ID) AND C_Currency_ID IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Set Home CurrencyRate=" + no);
            sql = new StringBuilder("UPDATE I_GLJournal i SET CurrencyRate=(SELECT MAX(r.MultiplyRate) FROM C_Conversion_Rate r, C_AcctSchema s WHERE s.C_AcctSchema_ID=i.C_AcctSchema_ID AND s.AD_Client_ID=i.AD_Client_ID AND r.C_Currency_ID=i.C_Currency_ID AND r.C_Currency_ID_TO=s.C_Currency_ID AND r.AD_Client_ID=i.AD_Client_ID AND r.AD_Org_ID=i.AD_OrgDoc_ID AND r.C_ConversionType_ID=i.C_ConversionType_ID AND i.DateAcct BETWEEN r.ValidFrom AND r.ValidTo ) WHERE CurrencyRate IS NULL OR CurrencyRate=0 AND C_Currency_ID>0 AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Set Org Rate=" + no);
            sql = new StringBuilder("UPDATE I_GLJournal i SET CurrencyRate=(SELECT MAX(r.MultiplyRate) FROM C_Conversion_Rate r, C_AcctSchema s WHERE s.C_AcctSchema_ID=i.C_AcctSchema_ID AND s.AD_Client_ID=i.AD_Client_ID AND r.C_Currency_ID=i.C_Currency_ID AND r.C_Currency_ID_TO=s.C_Currency_ID AND r.AD_Client_ID=i.AD_Client_ID AND r.C_ConversionType_ID=i.C_ConversionType_ID AND i.DateAcct BETWEEN r.ValidFrom AND r.ValidTo ) WHERE CurrencyRate IS NULL OR CurrencyRate=0 AND C_Currency_ID>0 AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Set Client Rate=" + no);
            sql = new StringBuilder("UPDATE I_GLJournal i SET I_IsImported='E', I_ErrorMsg=COALESCE(I_ErrorMsg,'')\t||' ERR=No Rate, 'WHERE CurrencyRate IS NULL OR CurrencyRate=0 AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            if (no != 0) {
                this.log.warning("No Rate=" + no);
            }
            sql = new StringBuilder("UPDATE I_GLJournal i SET C_Period_ID=(SELECT MAX(p.C_Period_ID) FROM C_Period p INNER JOIN C_Year y ON (y.C_Year_ID=p.C_Year_ID) INNER JOIN AD_ClientInfo c ON (c.C_Calendar_ID=y.C_Calendar_ID) WHERE c.AD_Client_ID=i.AD_Client_ID AND i.DateAcct BETWEEN p.StartDate AND p.EndDate AND p.IsActive='Y' AND p.PeriodType='S') WHERE C_Period_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Set Period=" + no);
            sql = new StringBuilder("UPDATE I_GLJournal i SET I_IsImported='E', I_ErrorMsg=COALESCE(I_ErrorMsg,'')\t||' ERR=Invalid Period, 'WHERE C_Period_ID IS NULL OR C_Period_ID NOT IN(SELECT C_Period_ID FROM C_Period p INNER JOIN C_Year y ON (y.C_Year_ID=p.C_Year_ID) INNER JOIN AD_ClientInfo c ON (c.C_Calendar_ID=y.C_Calendar_ID)  WHERE c.AD_Client_ID=i.AD_Client_ID AND i.DateAcct BETWEEN p.StartDate AND p.EndDate AND p.IsActive='Y' AND p.PeriodType='S') AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            if (no != 0) {
                this.log.warning("Invalid Period=" + no);
            }
            if ((no = DB.executeUpdate((sql = new StringBuilder("UPDATE I_GLJournal i SET I_ErrorMsg=COALESCE(I_ErrorMsg,'')\t||' WARN=Period Closed, ' WHERE C_Period_ID IS NOT NULL AND NOT EXISTS (SELECT * FROM C_PeriodControl pc WHERE pc.C_Period_ID=i.C_Period_ID AND DocBaseType='GLJ' AND PeriodStatus='O')  AND I_IsImported<>'Y'").append(clientCheck)).toString(), trxName)) != 0) {
                this.log.warning("Period Closed=" + no);
            }
            sql = new StringBuilder("UPDATE I_GLJournal i SET PostingType='A' WHERE PostingType IS NULL AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Set Actual PostingType=" + no);
            sql = new StringBuilder("UPDATE I_GLJournal i SET I_IsImported='E', I_ErrorMsg=COALESCE(I_ErrorMsg,'')\t||' ERR=Invalid PostingType, ' WHERE PostingType IS NULL OR NOT EXISTS (SELECT * FROM AD_Ref_List r WHERE r.AD_Reference_ID=125 AND i.PostingType=r.Value) AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            if (no != 0) {
                this.log.warning("Invalid PostingTypee=" + no);
            }
            sql = new StringBuilder("UPDATE I_GLJournal i SET C_ValidCombination_ID=(SELECT MAX(C_ValidCombination_ID) ").append(" FROM C_ValidCombination vc WHERE vc.Alias=i.Alias)").append(" WHERE I_IsImported<>'Y' AND C_ValidCombination_ID IS NULL AND Alias IS NOT NULL ");
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Valid Combination =" + no);
            sql = new StringBuilder("UPDATE I_GLJournal i SET I_IsImported='E', I_ErrorMsg=COALESCE(I_ErrorMsg,'') ||'ERR=Invalid Alias for C_ValidCombination_ID' ").append(" WHERE I_IsImported<>'Y' AND C_ValidCombination_ID IS NULL AND Alias IS NOT NULL");
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Valid Combination Not Found =" + no);
            sql = new StringBuilder("UPDATE I_GLJournal i SET AD_Org_ID=COALESCE((SELECT o.AD_Org_ID FROM AD_Org o WHERE o.Value=i.OrgValue AND o.IsSummary='N' AND i.AD_Client_ID=o.AD_Client_ID),AD_Org_ID) WHERE (AD_Org_ID IS NULL OR AD_Org_ID=0) AND OrgValue IS NOT NULL AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'");
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Set Org from Value=" + no);
            sql = new StringBuilder("UPDATE I_GLJournal i SET AD_Org_ID=AD_OrgDoc_ID WHERE (AD_Org_ID IS NULL OR AD_Org_ID=0) AND OrgValue IS NULL AND AD_OrgDoc_ID IS NOT NULL AND AD_OrgDoc_ID<>0 AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Set Org from Doc Org=" + no);
            sql = new StringBuilder("UPDATE I_GLJournal o SET I_IsImported='E', I_ErrorMsg=COALESCE(I_ErrorMsg,'')\t||' ERR=Invalid Org, 'WHERE (AD_Org_ID IS NULL OR AD_Org_ID=0 OR EXISTS (SELECT * FROM AD_Org oo WHERE o.AD_Org_ID=oo.AD_Org_ID AND (oo.IsSummary='Y' OR oo.IsActive='N'))) AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            if (no != 0) {
                this.log.warning("Invalid Org=" + no);
            }
            sql = new StringBuilder("UPDATE I_GLJournal i SET Account_ID=(SELECT MAX(ev.C_ElementValue_ID) FROM C_ElementValue ev INNER JOIN C_Element e ON (e.C_Element_ID=ev.C_Element_ID) INNER JOIN C_AcctSchema_Element ase ON (e.C_Element_ID=ase.C_Element_ID AND ase.ElementType='AC') WHERE ev.Value=i.AccountValue AND ev.IsSummary='N' AND i.C_AcctSchema_ID=ase.C_AcctSchema_ID AND i.AD_Client_ID=ev.AD_Client_ID) WHERE Account_ID IS NULL AND AccountValue IS NOT NULL AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Set Account from Value=" + no);
            sql = new StringBuilder("UPDATE I_GLJournal i SET I_IsImported='E', I_ErrorMsg=COALESCE(I_ErrorMsg,'')\t||' ERR=Invalid Account, 'WHERE (Account_ID IS NULL OR Account_ID=0) AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            if (no != 0) {
                this.log.warning("Invalid Account=" + no);
            }
            sql = new StringBuilder("UPDATE I_GLJournal i SET C_BPartner_ID=(SELECT bp.C_BPartner_ID FROM C_BPartner bp WHERE bp.Value=i.BPartnerValue AND bp.IsSummary='N' AND i.AD_Client_ID=bp.AD_Client_ID) WHERE C_BPartner_ID IS NULL AND BPartnerValue IS NOT NULL AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Set BPartner from Value=" + no);
            sql = new StringBuilder("UPDATE I_GLJournal i SET I_IsImported='E', I_ErrorMsg=COALESCE(I_ErrorMsg,'')\t||' ERR=Invalid BPartner, 'WHERE C_BPartner_ID IS NULL AND BPartnerValue IS NOT NULL AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            if (no != 0) {
                this.log.warning("Invalid BPartner=" + no);
            }
            sql = new StringBuilder("UPDATE I_GLJournal i SET M_Product_ID=(SELECT MAX(p.M_Product_ID) FROM M_Product p WHERE (p.Value=i.ProductValue OR p.UPC=i.UPC OR p.SKU=i.SKU) AND p.IsSummary='N' AND i.AD_Client_ID=p.AD_Client_ID) WHERE M_Product_ID IS NULL AND (ProductValue IS NOT NULL OR UPC IS NOT NULL OR SKU IS NOT NULL) AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Set Product from Value=" + no);
            sql = new StringBuilder("UPDATE I_GLJournal i SET I_IsImported='E', I_ErrorMsg=COALESCE(I_ErrorMsg,'')\t||' ERR=Invalid Product, 'WHERE M_Product_ID IS NULL AND (ProductValue IS NOT NULL OR UPC IS NOT NULL OR SKU IS NOT NULL) AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            if (no != 0) {
                this.log.warning("Invalid Product=" + no);
            }
            sql = new StringBuilder("UPDATE I_GLJournal i SET C_Project_ID=(SELECT p.C_Project_ID FROM C_Project p WHERE p.Value=i.ProjectValue AND p.IsSummary='N' AND i.AD_Client_ID=p.AD_Client_ID) WHERE C_Project_ID IS NULL AND ProjectValue IS NOT NULL AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Set Project from Value=" + no);
            sql = new StringBuilder("UPDATE I_GLJournal i SET I_IsImported='E', I_ErrorMsg=COALESCE(I_ErrorMsg,'')\t||' ERR=Invalid Project, 'WHERE C_Project_ID IS NULL AND ProjectValue IS NOT NULL AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            if (no != 0) {
                this.log.warning("Invalid Project=" + no);
            }
            sql = new StringBuilder("UPDATE I_GLJournal i SET AD_OrgTrx_ID=(SELECT o.AD_Org_ID FROM AD_Org o WHERE o.Value=i.OrgTrxValue AND o.IsSummary='N' AND i.AD_Client_ID=o.AD_Client_ID) WHERE AD_OrgTrx_ID IS NULL AND OrgTrxValue IS NOT NULL AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Set OrgTrx from Value=" + no);
            sql = new StringBuilder("UPDATE I_GLJournal i SET I_IsImported='E', I_ErrorMsg=COALESCE(I_ErrorMsg,'')\t||' ERR=Invalid OrgTrx, 'WHERE AD_OrgTrx_ID IS NULL AND OrgTrxValue IS NOT NULL AND (C_ValidCombination_ID IS NULL OR C_ValidCombination_ID=0) AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            if (no != 0) {
                this.log.warning("Invalid OrgTrx=" + no);
            }
            sql = new StringBuilder("UPDATE I_GLJournal SET AmtSourceDr = 0 WHERE AmtSourceDr IS NULL AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Set 0 Source Dr=" + no);
            sql = new StringBuilder("UPDATE I_GLJournal SET AmtSourceCr = 0 WHERE AmtSourceCr IS NULL AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            sql = new StringBuilder("UPDATE I_GLJournal i SET I_ErrorMsg=COALESCE(I_ErrorMsg,'')\t||' WARN=Zero Source Balance, ' WHERE (AmtSourceDr-AmtSourceCr)=0 AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            if (no != 0) {
                this.log.warning("Zero Source Balance=" + no);
            }
            sql = new StringBuilder("UPDATE I_GLJournal SET AmtAcctDr = ROUND(AmtSourceDr * CurrencyRate, 2) WHERE AmtAcctDr IS NULL OR AmtAcctDr=0 AND I_IsImported='N'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            sql = new StringBuilder("UPDATE I_GLJournal SET AmtAcctCr = ROUND(AmtSourceCr * CurrencyRate, 2) WHERE AmtAcctCr IS NULL OR AmtAcctCr=0 AND I_IsImported='N'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            this.log.fine("Calculate Acct Cr=" + no);
            sql = new StringBuilder("UPDATE I_GLJournal i SET I_ErrorMsg=COALESCE(I_ErrorMsg,'')\t||' WARN=Zero Acct Balance, ' WHERE (AmtSourceDr-AmtSourceCr)<>0 AND (AmtAcctDr-AmtAcctCr)=0 AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            if (no != 0) {
                this.log.warning("Zero Acct Balance=" + no);
            }
            sql = new StringBuilder("SELECT SUM(AmtSourceDr)-SUM(AmtSourceCr), SUM(AmtAcctDr)-SUM(AmtAcctCr) FROM I_GLJournal WHERE I_IsImported='N'").append(clientCheck);
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql.toString(), trxName);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    BigDecimal source = rs.getBigDecimal(1);
                    BigDecimal acct = rs.getBigDecimal(2);
                    if (source != null && source.signum() == 0 && acct != null && acct.signum() == 0) {
                        this.log.info("Import Balance = 0");
                    } else {
                        this.log.warning("Balance Source=" + source + ", Acct=" + acct);
                    }
                    if (source != null) {
                        this.addLog(0, null, source, "@AmtSourceDr@ - @AmtSourceCr@");
                    }
                    if (acct != null) {
                        this.addLog(0, null, acct, "@AmtAcctDr@ - @AmtAcctCr@");
                    }
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (SQLException ex) {
                this.log.log(Level.SEVERE, sql.toString(), ex);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            pstmt = null;
        });
        int errors = DB.getSQLValue(null, "SELECT COUNT(*) FROM I_GLJournal WHERE I_IsImported NOT IN ('Y','N')" + clientCheck);
        if (errors != 0 && (this.m_IsValidateOnly || this.m_IsImportOnlyNoErrors)) {
            throw new AdempiereException("@Errors@=" + errors);
        }
        if (this.m_IsValidateOnly) {
            return "@Errors@=" + errors;
        }
        this.log.info("Validation Errors=" + errors);
        Trx.run(trxName -> {
            int no = 0;
            int noInsert = 0;
            int noInsertJournal = 0;
            int noInsertLine = 0;
            StringBuilder sql = new StringBuilder();
            MJournalBatch batch = null;
            String BatchDocumentNo = "";
            X_GL_Journal journal = null;
            String JournalDocumentNo = "";
            Timestamp DateAcct = null;
            CPreparedStatement pstmt = null;
            sql = new StringBuilder("SELECT * FROM I_GLJournal WHERE I_IsImported='N'").append(clientCheck).append(" ORDER BY COALESCE(BatchDocumentNo, TO_NCHAR(I_GLJournal_ID)||' '), COALESCE(JournalDocumentNo, TO_NCHAR(I_GLJournal_ID)||' '), C_AcctSchema_ID, PostingType, C_DocType_ID, GL_Category_ID, C_Currency_ID, TRUNC(DateAcct, 'DD'), Line, I_GLJournal_ID");
            try {
                pstmt = DB.prepareStatement(sql.toString(), trxName);
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    String impJournalDocumentNo;
                    X_I_GLJournal imp = new X_I_GLJournal(this.getCtx(), rs, trxName);
                    ModelValidationEngine.get().fireImportValidate(this, imp, null, 20);
                    String impBatchDocumentNo = imp.getBatchDocumentNo();
                    if (impBatchDocumentNo == null) {
                        impBatchDocumentNo = "";
                    }
                    if (batch == null || imp.isCreateNewBatch() || journal.getC_AcctSchema_ID() != imp.getC_AcctSchema_ID() || !BatchDocumentNo.equals(impBatchDocumentNo)) {
                        BatchDocumentNo = impBatchDocumentNo;
                        batch = new MJournalBatch(this.getCtx(), 0, trxName);
                        batch.setClientOrg(imp.getAD_Client_ID(), imp.getAD_OrgDoc_ID());
                        if (imp.getBatchDocumentNo() != null && imp.getBatchDocumentNo().length() > 0) {
                            batch.setDocumentNo(imp.getBatchDocumentNo());
                        }
                        batch.setC_DocType_ID(imp.getC_DocType_ID());
                        batch.setPostingType(imp.getPostingType());
                        Object description = imp.getBatchDescription();
                        description = description == null || ((String)description).length() == 0 ? "*Import-" : (String)description + " *Import-";
                        description = (String)description + new Timestamp(System.currentTimeMillis());
                        batch.setDescription((String)description);
                        if (!batch.save()) {
                            this.log.log(Level.SEVERE, "Batch not saved");
                            Exception ex = CLogger.retrieveException();
                            if (ex == null) break;
                            this.addLog(0, null, null, ex.getLocalizedMessage());
                            throw ex;
                        }
                        ++noInsert;
                        journal = null;
                    }
                    if ((impJournalDocumentNo = imp.getJournalDocumentNo()) == null) {
                        impJournalDocumentNo = "";
                    }
                    Timestamp impDateAcct = TimeUtil.getDay(imp.getDateAcct());
                    if (journal == null || imp.isCreateNewJournal() || !JournalDocumentNo.equals(impJournalDocumentNo) || journal.getC_DocType_ID() != imp.getC_DocType_ID() || journal.getGL_Category_ID() != imp.getGL_Category_ID() || !journal.getPostingType().equals(imp.getPostingType()) || journal.getC_Currency_ID() != imp.getC_Currency_ID() || !impDateAcct.equals(DateAcct)) {
                        JournalDocumentNo = impJournalDocumentNo;
                        DateAcct = impDateAcct;
                        journal = new MJournal(this.getCtx(), 0, trxName);
                        journal.setGL_JournalBatch_ID(batch.getGL_JournalBatch_ID());
                        ((MJournal)journal).setClientOrg(imp.getAD_Client_ID(), imp.getAD_OrgDoc_ID());
                        String description = imp.getBatchDescription();
                        if (description == null || description.length() == 0) {
                            description = "(Import)";
                        }
                        journal.setDescription(description);
                        if (imp.getJournalDocumentNo() != null && imp.getJournalDocumentNo().length() > 0) {
                            journal.setDocumentNo(imp.getJournalDocumentNo());
                        }
                        journal.setC_AcctSchema_ID(imp.getC_AcctSchema_ID());
                        journal.setC_DocType_ID(imp.getC_DocType_ID());
                        journal.setGL_Category_ID(imp.getGL_Category_ID());
                        journal.setPostingType(imp.getPostingType());
                        journal.setGL_Budget_ID(imp.getGL_Budget_ID());
                        ((MJournal)journal).setCurrency(imp.getC_Currency_ID(), imp.getC_ConversionType_ID(), imp.getCurrencyRate());
                        journal.setC_Period_ID(imp.getC_Period_ID());
                        ((MJournal)journal).setDateAcct(imp.getDateAcct());
                        journal.setDateDoc(imp.getDateAcct());
                        if (!journal.save()) {
                            this.log.log(Level.SEVERE, "Journal not saved");
                            Exception ex = CLogger.retrieveException();
                            if (ex == null) break;
                            this.addLog(0, null, null, ex.getLocalizedMessage());
                            throw ex;
                        }
                        ++noInsertJournal;
                    }
                    MJournalLine line = new MJournalLine((MJournal)journal);
                    ModelValidationEngine.get().fireImportValidate(this, imp, line, 30);
                    line.setDescription(imp.getDescription());
                    line.setCurrency(imp.getC_Currency_ID(), imp.getC_ConversionType_ID(), imp.getCurrencyRate());
                    if (imp.getC_ValidCombination_ID() == 0) {
                        MAccount acct = MAccount.get(this.getCtx(), imp.getAD_Client_ID(), imp.getAD_Org_ID(), imp.getC_AcctSchema_ID(), imp.getAccount_ID(), 0, imp.getM_Product_ID(), imp.getC_BPartner_ID(), imp.getAD_OrgTrx_ID(), imp.getC_LocFrom_ID(), imp.getC_LocTo_ID(), imp.getC_SalesRegion_ID(), imp.getC_Project_ID(), imp.getC_Campaign_ID(), imp.getC_Activity_ID(), imp.getUser1_ID(), imp.getUser2_ID(), imp.getUser3_ID(), imp.getUser4_ID(), 0, 0, null);
                        if (acct != null && acct.get_ID() == 0) {
                            acct.saveEx();
                        }
                        if (acct == null || acct.get_ID() == 0) {
                            imp.setI_ErrorMsg("ERROR creating Account");
                            imp.setI_IsImported(false);
                            imp.saveEx();
                            continue;
                        }
                        line.setC_ValidCombination_ID(acct.get_ID());
                        imp.setC_ValidCombination_ID(acct.get_ID());
                    } else {
                        line.setC_ValidCombination_ID(imp.getC_ValidCombination_ID());
                    }
                    line.setLine(imp.getLine());
                    line.setAmtSourceCr(imp.getAmtSourceCr());
                    line.setAmtSourceDr(imp.getAmtSourceDr());
                    line.setAmtAcct(imp.getAmtAcctDr(), imp.getAmtAcctCr());
                    line.setDateAcct(imp.getDateAcct());
                    line.setC_UOM_ID(imp.getC_UOM_ID());
                    line.setQty(imp.getQty());
                    if (line.save()) {
                        imp.setGL_JournalBatch_ID(batch.getGL_JournalBatch_ID());
                        imp.setGL_Journal_ID(journal.getGL_Journal_ID());
                        imp.setGL_JournalLine_ID(line.getGL_JournalLine_ID());
                        imp.setI_IsImported(true);
                        imp.setProcessed(true);
                        if (imp.save()) {
                            ++noInsertLine;
                        }
                    }
                    ModelValidationEngine.get().fireImportValidate(this, imp, line, 40);
                }
                rs.close();
                pstmt.close();
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "", e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            pstmt = null;
            sql = new StringBuilder("UPDATE I_GLJournal SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), trxName);
            this.addLog(0, null, new BigDecimal(no), "@Errors@");
            this.addLog(0, null, new BigDecimal(noInsert), "@GL_JournalBatch_ID@: @Inserted@");
            this.addLog(0, null, new BigDecimal(noInsertJournal), "@GL_Journal_ID@: @Inserted@");
            this.addLog(0, null, new BigDecimal(noInsertLine), "@GL_JournalLine_ID@: @Inserted@");
        });
        return "";
    }

    @Override
    public String getWhereClause() {
        return " AND AD_Client_ID=" + this.m_AD_Client_ID;
    }

    @Override
    public String getImportTableName() {
        return "I_GLJournal";
    }
}

