/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import io.vavr.API;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.Patterns;
import io.vavr.Tuple;
import io.vavr.Tuple6;
import io.vavr.Tuple7;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_C_BPartner_Location;
import org.adempiere.core.domains.models.X_I_Order;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MLocation;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.process.ImportOrderAbstract;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.ResultSetIterable;
import org.compiere.util.Trx;

public class ImportOrder
extends ImportOrderAbstract {
    private Timestamp dateValue = null;
    private String clientCheck = null;
    private final List<Object> clientParameters = new ArrayList<Object>();
    private final HashMap<Integer, Boolean> ordersImported = new HashMap();

    @Override
    protected void prepare() {
        super.prepare();
        if (this.dateValue == null) {
            this.dateValue = new Timestamp(System.currentTimeMillis());
        }
        if (this.getDocAction() == null) {
            this.setDocAction("PR");
        }
    }

    private String getClientCheck() {
        if (this.clientCheck != null) {
            return this.clientCheck;
        }
        this.clientCheck = " AND AD_Client_ID = ? ";
        if (this.getUserId() != 0) {
            this.clientCheck = this.clientCheck + " AND CreatedBy = ? ";
        }
        return this.clientCheck;
    }

    private List<Object> getClientCheckIds() {
        if (!this.clientParameters.isEmpty()) {
            return this.clientParameters;
        }
        this.clientParameters.add(this.getClientId());
        if (this.getUserId() != 0) {
            this.clientParameters.add(this.getUserId());
        }
        return this.clientParameters;
    }

    @Override
    protected String doIt() throws Exception {
        if (this.isDeleteOldImported()) {
            Trx.run(trxName -> {
                int no = 0;
                String sql = "DELETE I_Order WHERE I_IsImported = ? " + this.getClientCheck();
                io.vavr.collection.List withParameters = io.vavr.collection.List.of((Object)true);
                no = DB.executeUpdateEx(sql, withParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
                this.log.fine("Delete Old Imported =" + no);
            });
        }
        this.setClientInfo();
        this.setErrorWithInvalidOrg();
        this.setDocumentType();
        this.setErrorWithInvalidDocumentTypeName();
        this.setDocumentTypeDefault();
        this.setErrorDocumentTypeDefault();
        this.setIsSOTrx();
        this.setPriceList();
        this.setErrorWithNotExistsPriceList();
        this.setOrderSource();
        this.setErrorWithNotFoundOrderSource();
        this.setPaymentTerm();
        this.setErrorWithNotExistsPaymentTerm();
        this.setWarehouse();
        this.setErrorNotExistsWarehouse();
        this.setPartnerFromEmail();
        this.setPartnerFromContactName();
        this.setPartnerFromValue();
        this.setExistingLocationWithExactMatch();
        this.setErrorWithNotExistsPartnerLocation();
        this.setCountry();
        this.setErrorWithInvalidCountry();
        this.setRegion();
        this.setErrorWithExistsInvalidRegion();
        this.setProduct();
        this.setErrorWithInvalidProduct();
        this.setCharge();
        this.setErrorWithInvalidCharge();
        this.setErrorWithInvalidProductAndCharge();
        this.setTax();
        this.setErrorWithInvalidTax();
        this.createPartner();
        this.setErrorWithThatNotExistsPartner();
        AtomicInteger noInsertOrdersReference = new AtomicInteger(0);
        AtomicInteger noInsertOrderLinesReference = new AtomicInteger(0);
        Map ordersImportGroup = this.getOrderImportByDocumentNo().toJavaParallelStream().collect(Collectors.groupingByConcurrent(tuple -> Tuple.of((Object)((Integer)tuple._2), (Object)((Integer)tuple._3), (Object)((Integer)tuple._4), (Object)((Integer)tuple._5), (Object)((Integer)tuple._6), (Object)((String)tuple._7)), Collectors.mapping(tupleGrouping -> (Integer)tupleGrouping._1, Collectors.toList())));
        this.setProcessing(ordersImportGroup, true);
        ordersImportGroup.entrySet().parallelStream().forEach(groupEntry -> {
            Tuple6 ordersGroup = (Tuple6)groupEntry.getKey();
            Integer orgId = (Integer)ordersGroup._1;
            Integer partnerId = (Integer)ordersGroup._2;
            Integer partnerLocationId = (Integer)ordersGroup._3;
            Integer billToId = (Integer)ordersGroup._4;
            Integer documentTypeId = (Integer)ordersGroup._5;
            String documentNo = (String)ordersGroup._6;
            Try.of((CheckedFunction0 & Serializable)() -> {
                Trx.run(trxName -> this.getOrCreateOrder(this.getCtx(), orgId, documentNo, documentTypeId, partnerId, partnerLocationId, billToId, trxName).peek(order -> {
                    noInsertOrdersReference.getAndUpdate(count -> count + 1);
                    int firstImportOrderId = ((List)groupEntry.getValue()).stream().findFirst().orElse(0);
                    ((List)groupEntry.getValue()).forEach(importOrderId -> {
                        X_I_Order importOrder = new X_I_Order(this.getCtx(), (int)importOrderId, trxName);
                        if (importOrder.getC_BPartner_ID() == partnerId.intValue() && importOrder.getC_BPartner_Location_ID() == partnerLocationId.intValue() && importOrder.getBillTo_ID() == billToId.intValue() && importOrder.getC_DocType_ID() == documentTypeId.intValue() && importOrder.getDocumentNo().equals(documentNo)) {
                            if (firstImportOrderId > 0 && importOrderId == firstImportOrderId) {
                                this.updateOrder((MOrder)order, importOrder);
                            }
                            Try.of((CheckedFunction0 & Serializable)() -> this.createOrderLine(importOrder, (MOrder)order)).onSuccess(orderLine -> {
                                importOrder.setC_Order_ID(order.getC_Order_ID());
                                importOrder.setC_Tax_ID(orderLine.getC_Tax_ID());
                                importOrder.setC_OrderLine_ID(orderLine.getC_OrderLine_ID());
                                importOrder.setI_IsImported(true);
                                importOrder.setProcessed(true);
                                importOrder.saveEx();
                                noInsertOrderLinesReference.getAndUpdate(insertLine -> insertLine + 1);
                            }).onFailure(throwable -> {
                                importOrder.setI_IsImported(false);
                                importOrder.setI_ErrorMsg(throwable.getMessage());
                                importOrder.saveEx();
                                this.ordersImported.put(order.getC_Order_ID(), false);
                            });
                        } else {
                            importOrder.setI_IsImported(false);
                            importOrder.setI_ErrorMsg("@I_Order_ID@ @NotValid@");
                            importOrder.saveEx();
                            this.ordersImported.put(order.getC_Order_ID(), false);
                        }
                    });
                }));
                return ordersGroup;
            }).onFailure(throwable -> this.addLog(throwable.getMessage()));
        });
        this.setNotImportOrder();
        this.applyDocumentAction();
        this.setProcessing(ordersImportGroup, false);
        this.addLog(0, null, new BigDecimal(noInsertOrdersReference.get()), "@C_Order_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noInsertOrderLinesReference.get()), "@C_OrderLine_ID@: @Inserted@");
        return "#" + noInsertOrdersReference.get() + "/" + noInsertOrderLinesReference.get();
    }

    private void setProcessing(Map<Tuple6<Integer, Integer, Integer, Integer, Integer, String>, List<Integer>> ordersImportGroup, Boolean processing) {
        String processingValue = processing != false ? "'Y'" : "'N'";
        ordersImportGroup.forEach((key, value) -> value.parallelStream().forEach(importOrderId -> Trx.run(trxName -> {
            String setProcessingFlagForImportOrders = "UPDATE I_Order SET Processing = " + processingValue + " WHERE I_Order_ID = ? " + this.getClientCheck();
            io.vavr.collection.List parameters = io.vavr.collection.List.of((Object)importOrderId);
            DB.executeUpdateEx(setProcessingFlagForImportOrders, parameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
        })));
    }

    private void updateOrder(MOrder order, X_I_Order importOrder) {
        order.setClientOrg(importOrder.getAD_Client_ID(), importOrder.getAD_Org_ID());
        order.setC_DocTypeTarget_ID(importOrder.getC_DocType_ID());
        order.setC_DocType_ID(importOrder.getC_DocType_ID());
        order.setIsSOTrx(importOrder.isSOTrx());
        if (importOrder.getDeliveryRule() != null) {
            order.setDeliveryRule(importOrder.getDeliveryRule());
        }
        if (importOrder.getDocumentNo() != null) {
            order.setDocumentNo(importOrder.getDocumentNo());
        }
        order.setC_BPartner_ID(importOrder.getC_BPartner_ID());
        order.setC_BPartner_Location_ID(importOrder.getC_BPartner_Location_ID());
        if (importOrder.getAD_User_ID() != 0) {
            order.setAD_User_ID(importOrder.getAD_User_ID());
        }
        order.setBill_BPartner_ID(importOrder.getC_BPartner_ID());
        order.setBill_Location_ID(importOrder.getBillTo_ID());
        if (importOrder.getDescription() != null) {
            order.setDescription(importOrder.getDescription());
        }
        order.setC_PaymentTerm_ID(importOrder.getC_PaymentTerm_ID());
        order.setM_PriceList_ID(importOrder.getM_PriceList_ID());
        order.setM_Warehouse_ID(importOrder.getM_Warehouse_ID());
        if (importOrder.getM_Shipper_ID() != 0) {
            order.setM_Shipper_ID(importOrder.getM_Shipper_ID());
        }
        if (importOrder.getSalesRep_ID() != 0) {
            order.setSalesRep_ID(importOrder.getSalesRep_ID());
        }
        if (order.getSalesRep_ID() == 0) {
            order.setSalesRep_ID(this.getAD_User_ID());
        }
        if (importOrder.getAD_OrgTrx_ID() != 0) {
            order.setAD_OrgTrx_ID(importOrder.getAD_OrgTrx_ID());
        }
        if (importOrder.getC_Activity_ID() != 0) {
            order.setC_Activity_ID(importOrder.getC_Activity_ID());
        }
        if (importOrder.getC_Campaign_ID() != 0) {
            order.setC_Campaign_ID(importOrder.getC_Campaign_ID());
        }
        if (importOrder.getC_Project_ID() != 0) {
            order.setC_Project_ID(importOrder.getC_Project_ID());
        }
        if (importOrder.getDateOrdered() != null) {
            order.setDateOrdered(importOrder.getDateOrdered());
        }
        if (importOrder.getDateAcct() != null) {
            order.setDateAcct(importOrder.getDateAcct());
        }
        if (importOrder.getC_OrderSource() != null) {
            order.setC_OrderSource_ID(importOrder.getC_OrderSource_ID());
        }
        if (order.is_Changed()) {
            order.saveEx();
        }
    }

    private Option<MOrder> getOrCreateOrder(Properties ctx, Integer organizationId, String documentNo, Integer documentTypeId, Integer partnerId, Integer partnerLocationId, Integer billToId, String trxName) {
        return API.Match(this.getOrder(ctx, organizationId, documentNo, documentTypeId, partnerId, partnerLocationId, billToId, trxName)).option(new API.Match.Case[]{API.Case((API.Match.Pattern1)Patterns.$Some((API.Match.Pattern)API.$()), order -> order), API.Case((API.Match.Pattern0)Patterns.$None(), () -> this.createOrder(ctx, organizationId, documentNo, documentTypeId, partnerId, partnerLocationId, billToId, trxName))});
    }

    private Option<MOrder> getOrder(Properties ctx, Integer organizationId, String documentNo, Integer documentTypeId, Integer partnerId, Integer partnerLocationId, Integer billToId, String trxName) {
        String whereClause = "AD_Org_ID = ? AND DocumentNo = ? AND C_DocType_ID = ? AND C_BPartner_ID = ? AND C_BPartner_Location_ID = ? AND Bill_BPartner_ID = ? AND DocStatus IN ( ? , ? ) ";
        return Option.of((Object)((MOrder)new Query(ctx, "C_Order", "AD_Org_ID = ? AND DocumentNo = ? AND C_DocType_ID = ? AND C_BPartner_ID = ? AND C_BPartner_Location_ID = ? AND Bill_BPartner_ID = ? AND DocStatus IN ( ? , ? ) ", trxName).setClient_ID().setParameters(organizationId, documentNo, documentTypeId, partnerId, partnerLocationId, billToId, "DR", "IP").first()));
    }

    private MOrder createOrder(Properties ctx, Integer organizationId, String documentNo, Integer documentTypeId, Integer partnerId, Integer partnerLocationId, Integer billToId, String trxName) {
        MOrder order = new MOrder(ctx, 0, trxName);
        order.setAD_Org_ID(organizationId);
        order.setC_DocTypeTarget_ID(documentTypeId);
        order.setC_DocType_ID(documentTypeId);
        if (documentNo != null) {
            order.setDocumentNo(documentNo);
        }
        order.setC_BPartner_ID(partnerId);
        order.setC_BPartner_Location_ID(partnerLocationId);
        order.setBill_BPartner_ID(billToId);
        order.saveEx();
        this.ordersImported.put(order.getC_Order_ID(), true);
        return order;
    }

    private MOrderLine createOrderLine(X_I_Order importOrder, MOrder order) {
        MOrderLine line = new MOrderLine(order);
        if (importOrder.getM_Product_ID() != 0) {
            line.setM_Product_ID(importOrder.getM_Product_ID(), true);
        }
        if (importOrder.getC_Charge_ID() != 0) {
            line.setC_Charge_ID(importOrder.getC_Charge_ID());
        }
        line.setQty(importOrder.getQtyOrdered());
        line.setPrice();
        if (importOrder.getPriceActual().compareTo(Env.ZERO) != 0) {
            line.setPrice(importOrder.getPriceActual());
        }
        if (importOrder.getC_Tax_ID() != 0) {
            line.setC_Tax_ID(importOrder.getC_Tax_ID());
        } else {
            line.setTax();
        }
        if (importOrder.getFreightAmt() != null) {
            line.setFreightAmt(importOrder.getFreightAmt());
        }
        if (importOrder.getLineDescription() != null) {
            line.setDescription(importOrder.getLineDescription());
        }
        line.saveEx();
        return line;
    }

    private void applyDocumentAction() {
        if (this.getDocAction().isEmpty()) {
            return;
        }
        Set<Map.Entry<Integer, Boolean>> orders = this.ordersImported.entrySet();
        orders.parallelStream().filter(Map.Entry::getValue).forEach(entryOrder -> Trx.run(trxName -> {
            MOrder order = new MOrder(this.getCtx(), (Integer)entryOrder.getKey(), trxName);
            order.setDocAction(this.getDocAction());
            order.processIt(this.getDocAction());
            order.saveEx();
        }));
    }

    private io.vavr.collection.List<Tuple7<Integer, Integer, Integer, Integer, Integer, Integer, String>> getOrderImportByDocumentNo() {
        String whereClause = "I_IsImported = ? AND (Processing = ? OR Processing IS NULL ) " + this.getClientCheck();
        String orderBy = "ORDER BY AD_Org_Id , C_BPartner_ID, BillTo_ID, C_BPartner_Location_ID , C_DocType_ID , DocumentNo , I_Order_ID";
        AtomicReference importOrderSelect = new AtomicReference();
        String getImportOrderSelect = "SELECT  I_Order_ID , AD_Org_ID , C_BPartner_ID , C_BPartner_Location_ID , BillTo_ID  , C_DocType_ID , DocumentNo FROM I_Order WHERE " + whereClause + "ORDER BY AD_Org_Id , C_BPartner_ID, BillTo_ID, C_BPartner_Location_ID , C_DocType_ID , DocumentNo , I_Order_ID";
        io.vavr.collection.List withParameters = io.vavr.collection.List.of((Object[])new Object[]{false, false});
        Try tryGetImportOrder = (Try)DB.runResultSetFunction.apply(null, (Object)getImportOrderSelect, (Object)withParameters.appendAll(this.getClientCheckIds()), rows -> importOrderSelect.set(new ResultSetIterable((ResultSet)rows, (CheckedFunction1 & Serializable)row -> Tuple.of((Object)row.getInt(1), (Object)row.getInt(2), (Object)row.getInt(3), (Object)row.getInt(4), (Object)row.getInt(5), (Object)row.getInt(6), (Object)row.getString(7))).toList()));
        return (io.vavr.collection.List)importOrderSelect.get();
    }

    private int[] getImportOrderIdsForPartnerNotExists() {
        String whereClause = "I_IsImported = ? AND C_BPartner_ID IS NULL " + this.getClientCheck();
        io.vavr.collection.List withParameters = io.vavr.collection.List.of((Object)false);
        return new Query(this.getCtx(), "I_Order", whereClause, null).setParameters(withParameters.appendAll(this.getClientCheckIds()).toJavaArray()).getIDs();
    }

    private Option<X_I_Order> getValidImportOrder(Properties ctx, Integer importOrderId, String trxName) {
        X_I_Order importOrder = new X_I_Order(ctx, importOrderId, trxName);
        if (importOrder.getBPartnerValue() == null) {
            if (importOrder.getEMail() != null) {
                importOrder.setBPartnerValue(importOrder.getEMail());
            } else if (importOrder.getName() != null) {
                importOrder.setBPartnerValue(importOrder.getName());
            } else {
                return Option.none();
            }
        }
        if (importOrder.getName() == null) {
            if (importOrder.getContactName() != null) {
                importOrder.setName(importOrder.getContactName());
            } else {
                importOrder.setName(importOrder.getBPartnerValue());
            }
        }
        return Option.of((Object)importOrder);
    }

    private void createPartner() {
        Arrays.stream(this.getImportOrderIdsForPartnerNotExists()).forEach(importOrderId -> Trx.run(trxName -> this.getValidImportOrder(this.getCtx(), importOrderId, trxName).peek(importOrder -> {
            MBPartner partner = MBPartner.get(this.getCtx(), importOrder.getBPartnerValue());
            try {
                if (partner == null) {
                    partner = new MBPartner(this.getCtx(), -1, trxName);
                    partner.setClientOrg(importOrder.getAD_Client_ID(), importOrder.getAD_Org_ID());
                    partner.setValue(importOrder.getBPartnerValue());
                    partner.setName(importOrder.getName());
                    partner.saveEx();
                }
                importOrder.setC_BPartner_ID(partner.getC_BPartner_ID());
                X_C_BPartner_Location partnerLocation = null;
                MBPartnerLocation[] partnerLocations = partner.getLocations(true);
                for (int i2 = 0; partnerLocation == null && i2 < partnerLocations.length; ++i2) {
                    MLocation loc;
                    if (importOrder.getC_BPartner_Location_ID() == partnerLocations[i2].getC_BPartner_Location_ID()) {
                        partnerLocation = partnerLocations[i2];
                        continue;
                    }
                    if (importOrder.getC_Location_ID() == partnerLocations[i2].getC_Location_ID()) {
                        partnerLocation = partnerLocations[i2];
                        continue;
                    }
                    if (importOrder.getC_Location_ID() != 0 || !(loc = partnerLocations[i2].getLocation(false)).equals(importOrder.getC_Country_ID(), importOrder.getC_Region_ID(), importOrder.getPostal(), "", importOrder.getCity(), importOrder.getAddress1(), importOrder.getAddress2())) continue;
                    partnerLocation = partnerLocations[i2];
                }
                if (partnerLocation == null) {
                    MLocation location = new MLocation(this.getCtx(), 0, trxName);
                    location.setAddress1(importOrder.getAddress1());
                    location.setAddress2(importOrder.getAddress2());
                    location.setCity(importOrder.getCity());
                    location.setPostal(importOrder.getPostal());
                    if (importOrder.getC_Region_ID() != 0) {
                        location.setC_Region_ID(importOrder.getC_Region_ID());
                    }
                    location.setC_Country_ID(importOrder.getC_Country_ID());
                    location.saveEx();
                    partnerLocation = new MBPartnerLocation(partner);
                    partnerLocation.setC_Location_ID(location.getC_Location_ID());
                    partnerLocation.saveEx();
                }
                importOrder.setC_Location_ID(partnerLocation.getC_Location_ID());
                importOrder.setBillTo_ID(partnerLocation.getC_BPartner_Location_ID());
                importOrder.setC_BPartner_Location_ID(partnerLocation.getC_BPartner_Location_ID());
                if (importOrder.getContactName() != null || importOrder.getEMail() != null || importOrder.getPhone() != null) {
                    MUser[] users = partner.getContacts(true);
                    MUser user = null;
                    for (int i3 = 0; user == null && i3 < users.length; ++i3) {
                        String name = users[i3].getName();
                        if (!name.equals(importOrder.getContactName()) && !name.equals(importOrder.getName())) continue;
                        user = users[i3];
                        importOrder.setAD_User_ID(user.getAD_User_ID());
                    }
                    if (user == null) {
                        user = new MUser(partner);
                        if (importOrder.getContactName() == null) {
                            user.setName(importOrder.getName());
                        } else {
                            user.setName(importOrder.getContactName());
                        }
                        user.setEMail(importOrder.getEMail());
                        user.setPhone(importOrder.getPhone());
                        if (user.save()) {
                            importOrder.setAD_User_ID(user.getAD_User_ID());
                        }
                    }
                }
                importOrder.saveEx();
            }
            catch (Exception exception) {
                importOrder.setI_IsImported(false);
                importOrder.setI_ErrorMsg(exception.getMessage());
                importOrder.saveEx();
            }
        })));
    }

    private void setClientInfo() {
        Trx.run(trxName -> {
            int no = 0;
            String setClientInfo = "UPDATE I_Order SET AD_Client_ID = COALESCE (AD_Client_ID," + this.getClientId() + "), AD_Org_ID = COALESCE (AD_Org_ID," + this.getOrgId() + "), IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = ' ', I_IsImported = 'N' WHERE I_IsImported <> ?  OR I_IsImported IS NULL ";
            io.vavr.collection.List withParameters = io.vavr.collection.List.of((Object)true);
            no = DB.executeUpdateEx(setClientInfo, withParameters.toJavaArray(), trxName);
            this.log.info("Reset=" + no);
        });
    }

    private void setErrorWithInvalidOrg() {
        Trx.run(trxName -> {
            int no = 0;
            String setErrorWithInvalidOrg = "UPDATE I_Order o SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Org, 'WHERE (AD_Org_ID IS NULL OR AD_Org_ID = ?  OR EXISTS (SELECT * FROM AD_Org oo WHERE o.AD_Org_ID=oo.AD_Org_ID AND (oo.IsSummary= ?  OR oo.IsActive = ? ))) AND I_IsImported <> ? " + this.getClientCheck();
            io.vavr.collection.List withParameters = io.vavr.collection.List.of((Object[])new Object[]{0, true, false, true});
            no = DB.executeUpdateEx(setErrorWithInvalidOrg, withParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            if (no != 0) {
                this.log.warning("Invalid Org=" + no);
            }
        });
    }

    private void setDocumentType() {
        Trx.run(trxName -> {
            int no = 0;
            String setPODocumentTypeId = "UPDATE I_Order o SET C_DocType_ID=(SELECT C_DocType_ID FROM C_DocType d WHERE d.Name=o.DocTypeName AND d.DocBaseType = ?  AND o.AD_Client_ID=d.AD_Client_ID) WHERE C_DocType_ID IS NULL AND IsSOTrx = ?  AND DocTypeName IS NOT NULL AND I_IsImported <> ? " + this.getClientCheck();
            io.vavr.collection.List withPOParameters = io.vavr.collection.List.of((Object[])new Object[]{"POO", false, true});
            no = DB.executeUpdateEx(setPODocumentTypeId, withPOParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set PO DocType=" + no);
            String setSODocumentTypeId = "UPDATE I_Order o SET C_DocType_ID=(SELECT C_DocType_ID FROM C_DocType d WHERE d.Name=o.DocTypeName AND d.DocBaseType = ? AND o.AD_Client_ID=d.AD_Client_ID) WHERE C_DocType_ID IS NULL AND IsSOTrx = ? AND DocTypeName IS NOT NULL AND I_IsImported <> ? " + this.getClientCheck();
            io.vavr.collection.List withSOParameters = io.vavr.collection.List.of((Object[])new Object[]{"SOO", true, true});
            no = DB.executeUpdateEx(setSODocumentTypeId, withSOParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set SO DocType=" + no);
            String setDocumentTypeId = "UPDATE I_Order o SET C_DocType_ID=(SELECT C_DocType_ID FROM C_DocType d WHERE d.Name=o.DocTypeName AND d.DocBaseType IN ( ? , ? ) AND o.AD_Client_ID=d.AD_Client_ID) WHERE C_DocType_ID IS NULL AND DocTypeName IS NOT NULL AND I_IsImported <> ? " + this.getClientCheck();
            io.vavr.collection.List withParameters = io.vavr.collection.List.of((Object[])new Object[]{"SOO", "POO", true});
            no = DB.executeUpdateEx(setDocumentTypeId, withParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set DocType=" + no);
        });
    }

    private void setErrorWithInvalidDocumentTypeName() {
        Trx.run(trxName -> {
            io.vavr.collection.List withParameters;
            int no = 0;
            String setErrorWithInvalidDocumentTypeName = "UPDATE I_Order SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid DocTypeName, ' WHERE C_DocType_ID IS NULL AND DocTypeName IS NOT NULL AND I_IsImported <> ? " + this.getClientCheck();
            no = DB.executeUpdateEx(setErrorWithInvalidDocumentTypeName, (withParameters = io.vavr.collection.List.of((Object)true)).appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            if (no != 0) {
                this.log.warning("Invalid DocTypeName=" + no);
            }
        });
    }

    private void setDocumentTypeDefault() {
        Trx.run(trxName -> {
            int no = 0;
            String setPODocumentTypeDefault = "UPDATE I_Order o SET C_DocType_ID=(SELECT MAX(C_DocType_ID) FROM C_DocType d WHERE d.IsDefault = ?  AND d.DocBaseType = ? AND o.AD_Client_ID=d.AD_Client_ID) WHERE C_DocType_ID IS NULL AND IsSOTrx = ? AND I_IsImported <> ? " + this.getClientCheck();
            io.vavr.collection.List withPOParameters = io.vavr.collection.List.of((Object[])new Object[]{true, "POO", false, true});
            no = DB.executeUpdateEx(setPODocumentTypeDefault, withPOParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set PO Default DocType=" + no);
            String setSODocumentTypeDefault = "UPDATE I_Order o SET C_DocType_ID=(SELECT MAX(C_DocType_ID) FROM C_DocType d WHERE d.IsDefault = ?  AND d.DocBaseType = ? AND o.AD_Client_ID=d.AD_Client_ID) WHERE C_DocType_ID IS NULL AND IsSOTrx = ? AND I_IsImported <> ? " + this.getClientCheck();
            io.vavr.collection.List withSOParameters = io.vavr.collection.List.of((Object[])new Object[]{true, "SOO", true, true});
            no = DB.executeUpdateEx(setSODocumentTypeDefault, withSOParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set SO Default DocType=" + no);
            String setDocumentTypeDefault = "UPDATE I_Order o SET C_DocType_ID=(SELECT MAX(C_DocType_ID) FROM C_DocType d WHERE d.IsDefault = ?  AND d.DocBaseType IN( ? , ? ) AND o.AD_Client_ID=d.AD_Client_ID) WHERE C_DocType_ID IS NULL AND IsSOTrx IS NULL AND I_IsImported<> ? " + this.getClientCheck();
            io.vavr.collection.List withParameters = io.vavr.collection.List.of((Object[])new Object[]{true, "SOO", "POO", true});
            no = DB.executeUpdateEx(setDocumentTypeDefault, withParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set Default DocType=" + no);
        });
    }

    private void setErrorDocumentTypeDefault() {
        Trx.run(trxName -> {
            io.vavr.collection.List withErrorParameters;
            int no = 0;
            String setErrorDocumentTypeDefault = "UPDATE I_Order SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No DocType, ' WHERE C_DocType_ID IS NULL AND I_IsImported <> ? " + this.getClientCheck();
            no = DB.executeUpdateEx(setErrorDocumentTypeDefault, (withErrorParameters = io.vavr.collection.List.of((Object)true)).appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            if (no != 0) {
                this.log.warning("No DocType=" + no);
            }
        });
    }

    private void setIsSOTrx() {
        Trx.run(trxName -> {
            int no = 0;
            String setIsSOTrx = "UPDATE I_Order o SET IsSOTrx='Y' WHERE EXISTS (SELECT * FROM C_DocType d WHERE o.C_DocType_ID=d.C_DocType_ID AND d.DocBaseType='SOO' AND o.AD_Client_ID=d.AD_Client_ID) AND C_DocType_ID IS NOT NULL AND I_IsImported <> ? " + this.getClientCheck();
            io.vavr.collection.List withSOParameters = io.vavr.collection.List.of((Object)true);
            no = DB.executeUpdateEx(setIsSOTrx, withSOParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set IsSOTrx=Y=" + no);
            String setPOTrx = "UPDATE I_Order o SET IsSOTrx='N' WHERE EXISTS (SELECT * FROM C_DocType d WHERE o.C_DocType_ID=d.C_DocType_ID AND d.DocBaseType='POO' AND o.AD_Client_ID=d.AD_Client_ID) AND C_DocType_ID IS NOT NULL AND I_IsImported <> ? " + this.getClientCheck();
            io.vavr.collection.List withPOParameters = io.vavr.collection.List.of((Object)true);
            no = DB.executeUpdateEx(setPOTrx, withPOParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set IsSOTrx=N=" + no);
        });
    }

    private void setPriceList() {
        Trx.run(trxName -> {
            int no = 0;
            String setDefaultCurrencyPriceListId = "UPDATE I_Order o SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p WHERE p.IsDefault = ? AND p.C_Currency_ID=o.C_Currency_ID AND p.IsSOPriceList=o.IsSOTrx AND o.AD_Client_ID=p.AD_Client_ID) WHERE M_PriceList_ID IS NULL AND I_IsImported <> ? " + this.getClientCheck();
            io.vavr.collection.List withDefaultCurrencyParameters = io.vavr.collection.List.of((Object[])new Object[]{true, true});
            no = DB.executeUpdateEx(setDefaultCurrencyPriceListId, withDefaultCurrencyParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set Default Currency PriceList=" + no);
            String setDefaultPriceListId = "UPDATE I_Order o SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p WHERE p.IsDefault = ?  AND p.IsSOPriceList=o.IsSOTrx AND o.AD_Client_ID=p.AD_Client_ID) WHERE M_PriceList_ID IS NULL AND C_Currency_ID IS NULL AND I_IsImported<> ? " + this.getClientCheck();
            io.vavr.collection.List withDefaultParameters = io.vavr.collection.List.of((Object[])new Object[]{true, true});
            no = DB.executeUpdateEx(setDefaultPriceListId, withDefaultParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set Default PriceList=" + no);
            String setCurrencyPriceList = "UPDATE I_Order o SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p  WHERE p.C_Currency_ID=o.C_Currency_ID AND p.IsSOPriceList=o.IsSOTrx AND o.AD_Client_ID=p.AD_Client_ID) WHERE M_PriceList_ID IS NULL AND I_IsImported <> ?" + this.getClientCheck();
            io.vavr.collection.List withCurrencyParameters = io.vavr.collection.List.of((Object)true);
            no = DB.executeUpdateEx(setCurrencyPriceList, withCurrencyParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set Currency PriceList=" + no);
            String setPriceList = "UPDATE I_Order o SET M_PriceList_ID=(SELECT MAX(M_PriceList_ID) FROM M_PriceList p  WHERE p.IsSOPriceList=o.IsSOTrx AND o.AD_Client_ID=p.AD_Client_ID) WHERE M_PriceList_ID IS NULL AND C_Currency_ID IS NULL AND I_IsImported <> ? " + this.getClientCheck();
            io.vavr.collection.List withPriceListParameters = io.vavr.collection.List.of((Object)true);
            no = DB.executeUpdateEx(setPriceList, withPriceListParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set PriceList=" + no);
        });
    }

    private void setErrorWithNotExistsPriceList() {
        Trx.run(trxName -> {
            io.vavr.collection.List withParameters;
            int no = 0;
            String updateErrorWithNotExistsPriceList = "UPDATE I_Order SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No PriceList, ' WHERE M_PriceList_ID IS NULL AND I_IsImported <> ? " + this.getClientCheck();
            no = DB.executeUpdateEx(updateErrorWithNotExistsPriceList, (withParameters = io.vavr.collection.List.of((Object)true)).appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            if (no != 0) {
                this.log.warning("No PriceList=" + no);
            }
        });
    }

    private void setOrderSource() {
        Trx.run(trxName -> {
            int no = 0;
            String setOrderSource = "UPDATE I_Order o SET C_OrderSource_ID=(SELECT C_OrderSource_ID FROM C_OrderSource p WHERE o.C_OrderSourceValue=p.Value AND o.AD_Client_ID=p.AD_Client_ID) WHERE C_OrderSource_ID IS NULL AND C_OrderSourceValue IS NOT NULL AND I_IsImported <> ? " + this.getClientCheck();
            io.vavr.collection.List withParameters = io.vavr.collection.List.of((Object)true);
            no = DB.executeUpdateEx(setOrderSource, withParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set Order Source=" + no);
        });
    }

    private void setErrorWithNotFoundOrderSource() {
        Trx.run(trxName -> {
            io.vavr.collection.List withParameters;
            int no = 0;
            String setErrorWithNotFoundOrderSource = "UPDATE I_Order SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Not Found Order Source, ' WHERE C_OrderSource_ID IS NULL AND C_OrderSourceValue IS NOT NULL AND I_IsImported <> ? " + this.getClientCheck();
            no = DB.executeUpdateEx(setErrorWithNotFoundOrderSource, (withParameters = io.vavr.collection.List.of((Object)true)).appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            if (no != 0) {
                this.log.warning("No OrderSource=" + no);
            }
        });
    }

    private void setPaymentTerm() {
        Trx.run(trxName -> {
            int no = 0;
            String setPaymentTerm = "UPDATE I_Order o SET C_PaymentTerm_ID=(SELECT C_PaymentTerm_ID FROM C_PaymentTerm p WHERE o.PaymentTermValue=p.Value AND o.AD_Client_ID=p.AD_Client_ID) WHERE C_PaymentTerm_ID IS NULL AND PaymentTermValue IS NOT NULL AND I_IsImported <> ? " + this.getClientCheck();
            io.vavr.collection.List withParameters = io.vavr.collection.List.of((Object)true);
            no = DB.executeUpdateEx(setPaymentTerm, withParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set PaymentTerm=" + no);
            String setDefaultPaymentTerm = "UPDATE I_Order o SET C_PaymentTerm_ID=(SELECT MAX(C_PaymentTerm_ID) FROM C_PaymentTerm p WHERE p.IsDefault = ? AND o.AD_Client_ID=p.AD_Client_ID) WHERE C_PaymentTerm_ID IS NULL AND o.PaymentTermValue IS NULL AND I_IsImported <> ? " + this.getClientCheck();
            io.vavr.collection.List withDefaultParameters = io.vavr.collection.List.of((Object[])new Object[]{true, true});
            no = DB.executeUpdateEx(setDefaultPaymentTerm, withDefaultParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set Default PaymentTerm=" + no);
        });
    }

    private void setErrorWithNotExistsPaymentTerm() {
        Trx.run(trxName -> {
            io.vavr.collection.List withParameters;
            int no = 0;
            String setErrorWithNotExistsPaymentTerm = "UPDATE I_Order SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No PaymentTerm, ' WHERE C_PaymentTerm_ID IS NULL AND I_IsImported <> ? " + this.getClientCheck();
            no = DB.executeUpdateEx(setErrorWithNotExistsPaymentTerm, (withParameters = io.vavr.collection.List.of((Object)true)).appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            if (no != 0) {
                this.log.warning("No PaymentTerm=" + no);
            }
        });
    }

    private void setWarehouse() {
        Trx.run(trxName -> {
            io.vavr.collection.List clientwithParameters;
            String setClientWarehouse;
            io.vavr.collection.List withParameters;
            int no = 0;
            String setWarehouse = "UPDATE I_Order o SET M_Warehouse_ID=(SELECT MAX(M_Warehouse_ID) FROM M_Warehouse w WHERE o.AD_Client_ID=w.AD_Client_ID AND o.AD_Org_ID=w.AD_Org_ID) WHERE M_Warehouse_ID IS NULL AND I_IsImported <> ? " + this.getClientCheck();
            no = DB.executeUpdateEx(setWarehouse, (withParameters = io.vavr.collection.List.of((Object)true)).appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            if (no != 0) {
                this.log.fine("Set Warehouse=" + no);
            }
            if ((no = DB.executeUpdateEx(setClientWarehouse = "UPDATE I_Order o SET M_Warehouse_ID=(SELECT M_Warehouse_ID FROM M_Warehouse w WHERE o.AD_Client_ID=w.AD_Client_ID) WHERE M_Warehouse_ID IS NULL AND EXISTS (SELECT AD_Client_ID FROM M_Warehouse w WHERE w.AD_Client_ID=o.AD_Client_ID GROUP BY AD_Client_ID HAVING COUNT(*)=1) AND I_IsImported <> ? " + this.getClientCheck(), (clientwithParameters = io.vavr.collection.List.of((Object)true)).appendAll(this.getClientCheckIds()).toJavaArray(), trxName)) != 0) {
                this.log.fine("Set Only Client Warehouse=" + no);
            }
        });
    }

    private void setErrorNotExistsWarehouse() {
        Trx.run(trxName -> {
            io.vavr.collection.List withParameters;
            int no = 0;
            String setErrorNotExistsWarehouse = "UPDATE I_Order SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No Warehouse, ' WHERE M_Warehouse_ID IS NULL AND I_IsImported <> ? " + this.getClientCheck();
            no = DB.executeUpdateEx(setErrorNotExistsWarehouse, (withParameters = io.vavr.collection.List.of((Object)true)).appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            if (no != 0) {
                this.log.warning("No Warehouse=" + no);
            }
        });
    }

    private void setPartnerFromEmail() {
        Trx.run(trxName -> {
            int no = 0;
            String setPartnerFromEmail = "UPDATE I_Order o SET (C_BPartner_ID,AD_User_ID)=(SELECT C_BPartner_ID,AD_User_ID FROM AD_User u WHERE o.EMail=u.EMail AND o.AD_Client_ID=u.AD_Client_ID AND u.C_BPartner_ID IS NOT NULL) WHERE C_BPartner_ID IS NULL AND EMail IS NOT NULL AND I_IsImported <> ? " + this.getClientCheck();
            io.vavr.collection.List withParameters = io.vavr.collection.List.of((Object)true);
            no = DB.executeUpdateEx(setPartnerFromEmail, withParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set BP from EMail=" + no);
        });
    }

    private void setPartnerFromContactName() {
        Trx.run(trxName -> {
            String setPartnerFromContactName = "UPDATE I_Order o SET (C_BPartner_ID,AD_User_ID)=(SELECT C_BPartner_ID,AD_User_ID FROM AD_User u WHERE o.ContactName=u.Name AND o.AD_Client_ID=u.AD_Client_ID AND u.C_BPartner_ID IS NOT NULL) WHERE C_BPartner_ID IS NULL AND ContactName IS NOT NULL AND EXISTS (SELECT Name FROM AD_User u WHERE o.ContactName=u.Name AND o.AD_Client_ID=u.AD_Client_ID AND u.C_BPartner_ID IS NOT NULL GROUP BY Name HAVING COUNT(*)=1) AND I_IsImported <> ?" + this.getClientCheck();
            io.vavr.collection.List withParameters = io.vavr.collection.List.of((Object)true);
            int no = 0;
            no = DB.executeUpdateEx(setPartnerFromContactName, withParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set BP from ContactName=" + no);
        });
    }

    private void setPartnerFromValue() {
        Trx.run(trxName -> {
            int no = 0;
            String setPartnerFromValue = "UPDATE I_Order o SET C_BPartner_ID=(SELECT MAX(C_BPartner_ID) FROM C_BPartner bp WHERE o.BPartnerValue=bp.Value AND o.AD_Client_ID=bp.AD_Client_ID) WHERE C_BPartner_ID IS NULL AND BPartnerValue IS NOT NULL AND I_IsImported <> ? " + this.getClientCheck();
            io.vavr.collection.List withParameters = io.vavr.collection.List.of((Object)true);
            no = DB.executeUpdateEx(setPartnerFromValue, withParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set BP from Value=" + no);
            String setDefaultPartnerFromValue = "UPDATE I_Order o SET C_BPartner_ID=(SELECT C_BPartnerCashTrx_ID FROM AD_ClientInfo c WHERE o.AD_Client_ID=c.AD_Client_ID) WHERE C_BPartner_ID IS NULL AND BPartnerValue IS NULL AND Name IS NULL AND I_IsImported <> ? " + this.getClientCheck();
            io.vavr.collection.List withDefaultParameters = io.vavr.collection.List.of((Object)true);
            no = DB.executeUpdateEx(setDefaultPartnerFromValue, withDefaultParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set Default BP=" + no);
        });
    }

    private void setExistingLocationWithExactMatch() {
        Trx.run(trxName -> {
            int no = 0;
            String setExistingLocationWithExactMatch = "UPDATE I_Order o SET (BillTo_ID,C_BPartner_Location_ID)=(SELECT C_BPartner_Location_ID,C_BPartner_Location_ID FROM C_BPartner_Location bpl INNER JOIN C_Location l ON (bpl.C_Location_ID=l.C_Location_ID) WHERE o.C_BPartner_ID=bpl.C_BPartner_ID AND bpl.AD_Client_ID=o.AD_Client_ID AND DUMP(o.Address1)=DUMP(l.Address1) AND DUMP(o.Address2)=DUMP(l.Address2) AND DUMP(o.City)=DUMP(l.City) AND DUMP(o.Postal)=DUMP(l.Postal) AND o.C_Region_ID=l.C_Region_ID AND o.C_Country_ID=l.C_Country_ID) WHERE C_BPartner_ID IS NOT NULL AND C_BPartner_Location_ID IS NULL AND I_IsImported = ? " + this.getClientCheck();
            io.vavr.collection.List withParameters = io.vavr.collection.List.of((Object)false);
            no = DB.executeUpdateEx(setExistingLocationWithExactMatch, withParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Found Location=" + no);
            String setBillToFromPartner = "UPDATE I_Order o SET BillTo_ID=(SELECT MAX(C_BPartner_Location_ID) FROM C_BPartner_Location l WHERE l.C_BPartner_ID=o.C_BPartner_ID AND o.AD_Client_ID=l.AD_Client_ID AND ((l.IsBillTo = ?  AND o.IsSOTrx = ? ) OR (l.IsPayFrom = ? AND o.IsSOTrx = ? ))) WHERE C_BPartner_ID IS NOT NULL AND BillTo_ID IS NULL AND I_IsImported <> ? " + this.getClientCheck();
            io.vavr.collection.List withBillToParameters = io.vavr.collection.List.of((Object[])new Object[]{true, true, true, false, true});
            no = DB.executeUpdateEx(setBillToFromPartner, withBillToParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set BP BillTo from BP=" + no);
            String setPartnerLocationFromPartner = "UPDATE I_Order o SET C_BPartner_Location_ID=(SELECT MAX(C_BPartner_Location_ID) FROM C_BPartner_Location l WHERE l.C_BPartner_ID=o.C_BPartner_ID AND o.AD_Client_ID=l.AD_Client_ID AND ((l.IsShipTo = ? AND o.IsSOTrx = ? ) OR o.IsSOTrx = ? )) WHERE C_BPartner_ID IS NOT NULL AND C_BPartner_Location_ID IS NULL AND I_IsImported <> ? " + this.getClientCheck();
            io.vavr.collection.List withLocationParameters = io.vavr.collection.List.of((Object[])new Object[]{true, true, false, true});
            no = DB.executeUpdateEx(setPartnerLocationFromPartner, withLocationParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set BP Location from BP=" + no);
        });
    }

    private void setErrorWithNotExistsPartnerLocation() {
        Trx.run(trxName -> {
            io.vavr.collection.List withParameters;
            int no = 0;
            String setErrorWithNotExistsPartnerLocation = "UPDATE I_Order SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No BP Location, ' WHERE C_BPartner_ID IS NOT NULL AND (BillTo_ID IS NULL OR C_BPartner_Location_ID IS NULL) AND I_IsImported <> ? " + this.getClientCheck();
            no = DB.executeUpdateEx(setErrorWithNotExistsPartnerLocation, (withParameters = io.vavr.collection.List.of((Object)true)).appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            if (no != 0) {
                this.log.warning("No BP Location=" + no);
            }
        });
    }

    private void setCountry() {
        Trx.run(trxName -> {
            int no = 0;
            String setCountry = "UPDATE I_Order o SET C_Country_ID=(SELECT C_Country_ID FROM C_Country c WHERE o.CountryCode=c.CountryCode AND c.AD_Client_ID IN (0, o.AD_Client_ID)) WHERE C_BPartner_ID IS NULL AND C_Country_ID IS NULL AND CountryCode IS NOT NULL AND I_IsImported <> ? " + this.getClientCheck();
            io.vavr.collection.List withParameters = io.vavr.collection.List.of((Object)true);
            no = DB.executeUpdateEx(setCountry, withParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set Country=" + no);
        });
    }

    private void setErrorWithInvalidCountry() {
        Trx.run(trxName -> {
            io.vavr.collection.List withParameters;
            int no = 0;
            String setErrorWithInvalidCountry = "UPDATE I_Order SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Country, ' WHERE C_BPartner_ID IS NULL AND C_Country_ID IS NULL AND I_IsImported <> ? " + this.getClientCheck();
            no = DB.executeUpdateEx(setErrorWithInvalidCountry, (withParameters = io.vavr.collection.List.of((Object)true)).appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            if (no != 0) {
                this.log.warning("Invalid Country=" + no);
            }
        });
    }

    private void setRegion() {
        Trx.run(trxName -> {
            int no = 0;
            String setDefaultRegion = "UPDATE I_Order o Set RegionName=(SELECT MAX(Name) FROM C_Region r WHERE r.IsDefault='Y' AND r.C_Country_ID=o.C_Country_ID AND r.AD_Client_ID IN (0, o.AD_Client_ID)) WHERE C_BPartner_ID IS NULL AND C_Region_ID IS NULL AND RegionName IS NULL AND I_IsImported <> ? " + this.getClientCheck();
            io.vavr.collection.List withDefaultParameters = io.vavr.collection.List.of((Object)true);
            no = DB.executeUpdateEx(setDefaultRegion, withDefaultParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set Region Default=" + no);
            String setRegion = "UPDATE I_Order o Set C_Region_ID=(SELECT C_Region_ID FROM C_Region r WHERE r.Name=o.RegionName AND r.C_Country_ID=o.C_Country_ID AND r.AD_Client_ID IN (0, o.AD_Client_ID)) WHERE C_BPartner_ID IS NULL AND C_Region_ID IS NULL AND RegionName IS NOT NULL AND I_IsImported <> ?" + this.getClientCheck();
            io.vavr.collection.List withParameters = io.vavr.collection.List.of((Object)true);
            no = DB.executeUpdateEx(setRegion, withParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set Region=" + no);
        });
    }

    private void setErrorWithExistsInvalidRegion() {
        Trx.run(trxName -> {
            int no = 0;
            String setErrorWithExistsInvalidRegion = "UPDATE I_Order o SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Region, ' WHERE C_BPartner_ID IS NULL AND C_Region_ID IS NULL  AND EXISTS (SELECT * FROM C_Country c WHERE c.C_Country_ID=o.C_Country_ID AND c.HasRegion = ? ) AND I_IsImported <> ? " + this.getClientCheck();
            io.vavr.collection.List withParameters = io.vavr.collection.List.of((Object[])new Object[]{true, true});
            no = DB.executeUpdateEx(setErrorWithExistsInvalidRegion, withParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            if (no != 0) {
                this.log.warning("Invalid Region=" + no);
            }
        });
    }

    private void setProduct() {
        Trx.run(trxName -> {
            int no = 0;
            String setProductFromValue = "UPDATE I_Order o SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p WHERE o.ProductValue=p.Value AND o.AD_Client_ID=p.AD_Client_ID) WHERE M_Product_ID IS NULL AND ProductValue IS NOT NULL AND I_IsImported <> ? " + this.getClientCheck();
            io.vavr.collection.List withParameters = io.vavr.collection.List.of((Object)true);
            no = DB.executeUpdateEx(setProductFromValue, withParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set Product from Value=" + no);
            String setProductIdFromUPC = "UPDATE I_Order o SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p WHERE o.UPC=p.UPC AND o.AD_Client_ID=p.AD_Client_ID) WHERE M_Product_ID IS NULL AND UPC IS NOT NULL AND I_IsImported <> ?" + this.getClientCheck();
            io.vavr.collection.List withParametersFromUPC = io.vavr.collection.List.of((Object)true);
            no = DB.executeUpdateEx(setProductIdFromUPC, withParametersFromUPC.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set Product from UPC=" + no);
            String setProductIdFromSKU = "UPDATE I_Order o SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p WHERE o.SKU=p.SKU AND o.AD_Client_ID=p.AD_Client_ID) WHERE M_Product_ID IS NULL AND SKU IS NOT NULL AND I_IsImported <> ? " + this.getClientCheck();
            io.vavr.collection.List withParametersProductIdFromSKU = io.vavr.collection.List.of((Object)true);
            no = DB.executeUpdateEx(setProductIdFromSKU, withParametersProductIdFromSKU.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set Product fom SKU=" + no);
        });
    }

    private void setErrorWithInvalidProduct() {
        Trx.run(trxName -> {
            io.vavr.collection.List withParameters;
            int no = 0;
            String setErrorWithInvalidProduct = "UPDATE I_Order SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Product, ' WHERE M_Product_ID IS NULL AND (ProductValue IS NOT NULL OR UPC IS NOT NULL OR SKU IS NOT NULL) AND I_IsImported <> ? " + this.getClientCheck();
            no = DB.executeUpdateEx(setErrorWithInvalidProduct, (withParameters = io.vavr.collection.List.of((Object)true)).appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            if (no != 0) {
                this.log.warning("Invalid Product=" + no);
            }
        });
    }

    private void setCharge() {
        Trx.run(trxName -> {
            int no = 0;
            String setCharge = "UPDATE I_Order o SET C_Charge_ID=(SELECT C_Charge_ID FROM C_Charge c WHERE o.ChargeName=c.Name AND o.AD_Client_ID=c.AD_Client_ID) WHERE C_Charge_ID IS NULL AND ChargeName IS NOT NULL AND I_IsImported <> ? " + this.getClientCheck();
            io.vavr.collection.List withParameters = io.vavr.collection.List.of((Object)true);
            no = DB.executeUpdateEx(setCharge, withParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set Charge=" + no);
        });
    }

    private void setErrorWithInvalidCharge() {
        Trx.run(trxName -> {
            io.vavr.collection.List withParameters;
            int no = 0;
            String setErrorWithInvalidCharge = "UPDATE I_Order SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Charge, ' WHERE C_Charge_ID IS NULL AND (ChargeName IS NOT NULL) AND I_IsImported <> ? " + this.getClientCheck();
            no = DB.executeUpdateEx(setErrorWithInvalidCharge, (withParameters = io.vavr.collection.List.of((Object)true)).appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            if (no != 0) {
                this.log.warning("Invalid Charge=" + no);
            }
        });
    }

    private void setErrorWithInvalidProductAndCharge() {
        Trx.run(trxName -> {
            io.vavr.collection.List withParameters;
            int no = 0;
            String setErrorWithInvalidProductAndCharge = "UPDATE I_Order SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Product and Charge, ' WHERE M_Product_ID IS NOT NULL AND C_Charge_ID IS NOT NULL  AND I_IsImported <> ? " + this.getClientCheck();
            no = DB.executeUpdateEx(setErrorWithInvalidProductAndCharge, (withParameters = io.vavr.collection.List.of((Object)true)).appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            if (no != 0) {
                this.log.warning("Invalid Product and Charge exclusive=" + no);
            }
        });
    }

    private void setTax() {
        Trx.run(trxName -> {
            int no = 0;
            String setTax = "UPDATE I_Order o SET C_Tax_ID=(SELECT MAX(C_Tax_ID) FROM C_Tax t WHERE o.TaxIndicator=t.TaxIndicator AND o.AD_Client_ID=t.AD_Client_ID) WHERE C_Tax_ID IS NULL AND TaxIndicator IS NOT NULL AND I_IsImported <> ? " + this.getClientCheck();
            io.vavr.collection.List withParameters = io.vavr.collection.List.of((Object)true);
            no = DB.executeUpdateEx(setTax, withParameters.appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            this.log.fine("Set Tax=" + no);
        });
    }

    private void setErrorWithInvalidTax() {
        Trx.run(trxName -> {
            io.vavr.collection.List withParameters;
            int no = 0;
            String setErrorWithInvalidTax = "UPDATE I_Order SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Tax, ' WHERE C_Tax_ID IS NULL AND TaxIndicator IS NOT NULL AND I_IsImported <> ? " + this.getClientCheck();
            no = DB.executeUpdateEx(setErrorWithInvalidTax, (withParameters = io.vavr.collection.List.of((Object)true)).appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            if (no != 0) {
                this.log.warning("Invalid Tax=" + no);
            }
        });
    }

    public void setErrorWithThatNotExistsPartner() {
        Trx.run(trxName -> {
            io.vavr.collection.List withParameters;
            int no = 0;
            String setErrorWithThatNotExistsPartner = "UPDATE I_Order SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No BPartner, ' WHERE C_BPartner_ID IS NULL AND I_IsImported <> ? " + this.getClientCheck();
            no = DB.executeUpdateEx(setErrorWithThatNotExistsPartner, (withParameters = io.vavr.collection.List.of((Object)true)).appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            if (no != 0) {
                this.log.warning("No BPartner=" + no);
            }
        });
    }

    private void setNotImportOrder() {
        Trx.run(trxName -> {
            io.vavr.collection.List withParameters;
            int no = 0;
            String setNotImportOrder = "UPDATE I_Order SET I_IsImported = 'N' , Updated=SysDate WHERE I_IsImported <> ? " + this.getClientCheck();
            no = DB.executeUpdateEx(setNotImportOrder, (withParameters = io.vavr.collection.List.of((Object)true)).appendAll(this.getClientCheckIds()).toJavaArray(), trxName);
            if (no != 0) {
                this.log.warning("Order No Import =" + no);
                this.addLog(0, null, new BigDecimal(no), "@Errors@");
            }
        });
    }
}

