/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.Optional;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.process.InOutCreateInvoiceAbstract;

public class InOutCreateInvoice
extends InOutCreateInvoiceAbstract {
    private MInvoice invoice = null;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MInOutLine[] materialReceiptLines;
        this.log.info("M_InOut_ID=" + this.getRecord_ID() + ", M_PriceList_ID=" + this.getPriceListId() + ", InvoiceDocumentNo=" + this.getInvoiceDocumentNo());
        if (this.getRecord_ID() == 0) {
            throw new IllegalArgumentException("No Shipment");
        }
        MInOut materialReceipt = new MInOut(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (materialReceipt.get_ID() == 0) {
            throw new IllegalArgumentException("Shipment not found");
        }
        if (!"CO".equals(materialReceipt.getDocStatus())) {
            throw new IllegalArgumentException("Shipment not completed");
        }
        for (MInOutLine materialReceiptLine : materialReceiptLines = materialReceipt.getLines(false)) {
            Optional<MInvoiceLine> maybeInvoiceLine = Optional.ofNullable(MInvoiceLine.getOfInOutLine(materialReceiptLine));
            if (maybeInvoiceLine.isPresent()) continue;
            MInvoice invoice = this.getCreateHeader(materialReceipt);
            MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
            invoiceLine.setShipLine(materialReceiptLine);
            if (materialReceiptLine.sameOrderLineUOM()) {
                invoiceLine.setQtyEntered(materialReceiptLine.getQtyEntered());
            } else {
                invoiceLine.setQtyEntered(materialReceiptLine.getMovementQty());
            }
            invoiceLine.setQtyInvoiced(materialReceiptLine.getMovementQty());
            if (invoiceLine.save()) continue;
            throw new IllegalArgumentException("Cannot save Invoice Line");
        }
        if (this.invoice == null) {
            throw new AdempiereException("@InvoiceFullyMatched@");
        }
        return this.invoice.getDocumentNo();
    }

    private MInvoice getCreateHeader(MInOut shipment) {
        if (this.invoice != null) {
            return this.invoice;
        }
        this.invoice = new MInvoice(shipment, null);
        if (this.getPriceListId() != 0 && shipment.getM_RMA_ID() == 0) {
            this.invoice.setM_PriceList_ID(this.getPriceListId());
        }
        if (this.getInvoiceDocumentNo() != null && this.getInvoiceDocumentNo().length() > 0) {
            this.invoice.setDocumentNo(this.getInvoiceDocumentNo());
        }
        if (!this.invoice.save()) {
            throw new IllegalArgumentException("Cannot save Invoice");
        }
        return this.invoice;
    }
}

