/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInventoryLineMA;
import org.compiere.model.MStorage;
import org.compiere.process.InventoryCountUpdateAbstract;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class InventoryCountUpdate
extends InventoryCountUpdateAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("M_Inventory_ID=" + this.getRecord_ID());
        MInventory inventory = new MInventory(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (inventory.get_ID() == 0) {
            throw new AdempiereSystemError("Not found: M_Inventory_ID=" + this.getRecord_ID());
        }
        String sql = "UPDATE M_InventoryLine SET IsActive='N' WHERE M_Inventory_ID=" + this.getRecord_ID() + " AND (M_Product_ID, M_Locator_ID, M_AttributeSetInstance_ID) IN (SELECT M_Product_ID, M_Locator_ID, M_AttributeSetInstance_ID FROM M_InventoryLine WHERE M_Inventory_ID=" + this.getRecord_ID() + " GROUP BY M_Product_ID, M_Locator_ID, M_AttributeSetInstance_ID HAVING COUNT(*) > 1)";
        int multiple = DB.executeUpdate(sql, this.get_TrxName());
        this.log.info("Multiple=" + multiple);
        int deleteInventoryMA = MInventoryLineMA.deleteInventoryMA(this.getRecord_ID(), this.get_TrxName());
        this.log.info("DeletedMA=" + deleteInventoryMA);
        sql = "UPDATE M_InventoryLine l SET (QtyBook,QtyCount) = (SELECT QtyOnHand, " + (this.isUpdateCountQty() ? "s.QtyOnHand" : "l.QtyCount") + " FROM M_Storage s WHERE s.M_Product_ID=l.M_Product_ID AND s.M_Locator_ID=l.M_Locator_ID AND s.M_AttributeSetInstance_ID=l.M_AttributeSetInstance_ID), Updated=SysDate, UpdatedBy=" + this.getAD_User_ID() + " WHERE M_Inventory_ID=" + this.getRecord_ID() + " AND EXISTS (SELECT * FROM M_Storage s WHERE s.M_Product_ID=l.M_Product_ID AND s.M_Locator_ID=l.M_Locator_ID AND s.M_AttributeSetInstance_ID=l.M_AttributeSetInstance_ID)";
        int no = DB.executeUpdate(sql, this.get_TrxName());
        this.log.info("Update with ASI=" + no);
        int noMA = this.updateWithMA();
        if (this.isUpdateCountQty() && "Z".equals(this.getInventoryCountSet())) {
            sql = "UPDATE M_InventoryLine l SET QtyCount=0 WHERE M_Inventory_ID=" + this.getRecord_ID();
            no = DB.executeUpdate(sql, this.get_TrxName());
            this.log.info("Set Count to Zero=" + no);
        }
        if (multiple > 0) {
            return "@M_InventoryLine_ID@ - #" + (no + noMA) + " --> @InventoryProductMultiple@";
        }
        return "@M_InventoryLine_ID@ - #" + no;
    }

    private int updateWithMA() {
        int no = 0;
        String sql = "SELECT * FROM M_InventoryLine WHERE M_Inventory_ID=? AND M_AttributeSetInstance_ID=0";
        CPreparedStatement preparedStatement = null;
        try {
            preparedStatement = DB.prepareStatement(sql, this.get_TrxName());
            preparedStatement.setInt(1, this.getRecord_ID());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                MInventoryLine inventoryLine = new MInventoryLine(this.getCtx(), resultSet, this.get_TrxName());
                BigDecimal onHand = Env.ZERO;
                MStorage[] storages = MStorage.getAll(this.getCtx(), inventoryLine.getM_Product_ID(), inventoryLine.getM_Locator_ID(), this.get_TrxName());
                MInventoryLineMA inventoryLineMA = null;
                for (int i2 = 0; i2 < storages.length; ++i2) {
                    MStorage storage = storages[i2];
                    if (storage.getQtyOnHand().signum() == 0) continue;
                    onHand = onHand.add(storage.getQtyOnHand());
                    if ((storage.getM_AttributeSetInstance_ID() != 0 || storages.length != 1) && (inventoryLineMA = new MInventoryLineMA(inventoryLine, storage.getM_AttributeSetInstance_ID(), storage.getQtyOnHand())).save()) continue;
                }
                inventoryLine.setQtyBook(onHand);
                if (this.isUpdateCountQty()) {
                    inventoryLine.setQtyCount(onHand);
                }
                if (!inventoryLine.save()) continue;
                ++no;
            }
            resultSet.close();
            preparedStatement.close();
            preparedStatement = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            preparedStatement = null;
        }
        catch (Exception e) {
            preparedStatement = null;
        }
        this.log.info("#" + no);
        return no;
    }
}

