/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.MUOMConversion;
import org.compiere.model.PO;
import org.compiere.process.InvoiceCreateFromAbstract;
import org.compiere.util.Env;

public class InvoiceCreateFrom
extends InvoiceCreateFromAbstract {
    private static final String RMA = "A";
    private static final String ORDER = "O";
    private static final String RECEIPT = "R";
    private static final String INVOICE = "I";

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.getRecord_ID() == 0) {
            return "";
        }
        MInvoice invoice = new MInvoice(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        AtomicInteger referenceId = new AtomicInteger(0);
        AtomicInteger created = new AtomicInteger(0);
        List<Integer> recordIds = this.getSelectionKeys();
        String createFromType = recordIds.size() > 0 ? this.getSelectionAsString(recordIds.get(0), "CF_CreateFromType") : null;
        this.log.fine("CreateFromType=" + createFromType);
        if (createFromType == null || createFromType.length() == 0) {
            throw new AdempiereException("@CreateFromType@ @NotFound@");
        }
        recordIds.forEach(key -> {
            MInvoiceLine fromLine;
            int productId = this.getSelectionAsInt((int)key, "CF_M_Product_ID");
            int chargeId = this.getSelectionAsInt((int)key, "CF_C_Charge_ID");
            int uomId = this.getSelectionAsInt((int)key, "CF_C_UOM_ID");
            BigDecimal qtyEntered = this.getSelectionAsBigDecimal((int)key, "CF_QtyEntered");
            this.log.fine("Line QtyEntered=" + qtyEntered + ", Product=" + productId + ", CreateFromType=" + createFromType + ", Key=" + key);
            MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
            BigDecimal qtyInvoiced = null;
            int precision = 2;
            if (productId > 0) {
                MProduct product = MProduct.get(Env.getCtx(), productId);
                if (product != null) {
                    invoiceLine.setM_Product_ID(product.getM_Product_ID(), uomId);
                    precision = product.getUOMPrecision();
                    if (product.getC_UOM_ID() != uomId) {
                        qtyEntered = qtyEntered.setScale(precision, RoundingMode.HALF_DOWN);
                        qtyInvoiced = MUOMConversion.convertProductFrom(Env.getCtx(), productId, uomId, qtyEntered);
                    }
                }
            } else if (chargeId != 0) {
                invoiceLine.setC_Charge_ID(chargeId);
            }
            qtyEntered = qtyEntered.setScale(precision, RoundingMode.HALF_DOWN);
            if (qtyInvoiced == null) {
                qtyInvoiced = qtyEntered;
            }
            invoiceLine.setQty(qtyEntered);
            invoiceLine.setQtyInvoiced(qtyInvoiced);
            if (createFromType.equals(ORDER)) {
                MOrderLine orderLine = new MOrderLine(this.getCtx(), (int)key, this.get_TrxName());
                referenceId.set(orderLine.getC_Order_ID());
                invoiceLine.setOrderLine(orderLine);
            } else if (createFromType.equals(INVOICE)) {
                fromLine = new MInvoiceLine(this.getCtx(), (int)key, this.get_TrxName());
                referenceId.set(invoiceLine.getParent().getC_Invoice_ID());
                PO.copyValues(fromLine, invoiceLine);
                invoiceLine.setC_Invoice_ID(invoiceLine.getParent().getC_Invoice_ID());
                invoiceLine.setAD_Org_ID(fromLine.getAD_Org_ID());
                invoiceLine.setC_OrderLine_ID(0);
                invoiceLine.setRef_InvoiceLine_ID(0);
                invoiceLine.setM_InOutLine_ID(0);
                invoiceLine.setA_Asset_ID(0);
                invoiceLine.setM_AttributeSetInstance_ID(0);
                invoiceLine.setS_ResourceAssignment_ID(0);
                if (invoiceLine.getParent().getC_BPartner_ID() != fromLine.getC_Invoice().getC_BPartner_ID()) {
                    invoiceLine.setTax();
                }
                invoiceLine.setProcessed(false);
            } else if (createFromType.equals(RMA)) {
                MRMALine rmaLine = new MRMALine(this.getCtx(), (int)key, this.get_TrxName());
                referenceId.set(rmaLine.getM_RMA_ID());
                invoiceLine.setRMALine(rmaLine);
            } else if (createFromType.equals(RECEIPT)) {
                MInOutLine inOutLine = new MInOutLine(this.getCtx(), (int)key, this.get_TrxName());
                referenceId.set(inOutLine.getM_InOut_ID());
                invoiceLine.setShipLine(inOutLine);
            }
            invoiceLine.saveEx();
            if (createFromType.equals(INVOICE)) {
                fromLine = new MInvoiceLine(this.getCtx(), (int)key, this.get_TrxName());
                invoiceLine.copyLandedCostFrom(fromLine);
                invoiceLine.allocateLandedCosts();
            }
            created.updateAndGet(createNo -> createNo + 1);
        });
        this.addReference(invoice, createFromType, referenceId.get());
        return "@Created@ " + created.get();
    }

    private void addReference(MInvoice invoice, String createFromType, int referenceId) {
        if (referenceId == 0) {
            return;
        }
        if (createFromType.equals(ORDER)) {
            MOrder order = new MOrder(this.getCtx(), referenceId, this.get_TrxName());
            invoice.setOrder(order);
        } else if (createFromType.equals(INVOICE)) {
            MInvoice fromInvoice = new MInvoice(this.getCtx(), referenceId, this.get_TrxName());
            invoice.setAD_OrgTrx_ID(fromInvoice.getAD_OrgTrx_ID());
            invoice.setC_Project_ID(fromInvoice.getC_Project_ID());
            invoice.setC_Campaign_ID(fromInvoice.getC_Campaign_ID());
            invoice.setC_Activity_ID(fromInvoice.getC_Activity_ID());
            invoice.setUser1_ID(fromInvoice.getUser1_ID());
            invoice.setUser2_ID(fromInvoice.getUser2_ID());
            invoice.setUser3_ID(fromInvoice.getUser3_ID());
            invoice.setUser4_ID(fromInvoice.getUser4_ID());
        } else if (createFromType.equals(RMA)) {
            MRMA rma = new MRMA(this.getCtx(), referenceId, this.get_TrxName());
            invoice.setRMA(rma);
        } else if (createFromType.equals(RECEIPT)) {
            MInOut inOut = new MInOut(this.getCtx(), referenceId, this.get_TrxName());
            invoice.setShipment(inOut);
        }
        invoice.saveEx();
    }
}

