/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.MRole;
import org.compiere.process.InvoiceWriteOffAbstract;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class InvoiceWriteOff
extends InvoiceWriteOffAbstract {
    private static String ONLY_AP = "P";
    private static String ONLY_AR = "R";
    private MAllocationHdr allocation = null;
    private MPayment payment = null;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        ArrayList<Object> parameters = new ArrayList<Object>();
        this.log.info("C_BPartner_ID=" + this.getBPartnerId() + ", C_BP_Group_ID=" + this.getBPGroupId() + ", C_Invoice_ID=" + this.getInvoiceId() + ", InvoiceCollectionType=" + this.getInvoiceCollectionType() + ", C_DunningLevel_ID=" + this.getDunningLevelId() + "; APAR=" + this.getAPAR() + ", " + this.getDateInvoiced() + " - " + this.getDateInvoicedTo() + "; CreatePayment=" + this.isCreatePayment() + ", C_BankAccount_ID=" + this.getBankAccountId());
        StringBuffer sql = new StringBuffer("SELECT C_Invoice_ID,DocumentNo,DateInvoiced, C_Currency_ID,GrandTotal, invoiceOpen(C_Invoice_ID, 0) AS OpenAmt FROM C_Invoice WHERE ");
        if (this.getOrgId() > 0) {
            sql.append("AD_Org_ID=? AND ");
            parameters.add(this.getOrgId());
        }
        if (this.getInvoiceId() > 0) {
            sql.append("C_Invoice_ID=? AND ");
            parameters.add(this.getInvoiceId());
        } else {
            if (this.getBPartnerId() > 0) {
                sql.append("C_BPartner_ID=? AND ");
                parameters.add(this.getBPartnerId());
            } else if (this.getBPGroupId() > 0) {
                sql.append("EXISTS (SELECT * FROM C_BPartner bp WHERE C_Invoice.C_BPartner_ID=bp.C_BPartner_ID AND bp.C_BP_Group_ID=?) AND ");
                parameters.add(this.getBPGroupId());
            }
            if (ONLY_AR.equals(this.getAPAR())) {
                sql.append("IsSOTrx=? AND ");
                parameters.add("Y");
            } else if (ONLY_AP.equals(this.getAPAR())) {
                sql.append("IsSOTrx=? AND ");
                parameters.add("N");
            }
            if (this.getInvoiceCollectionType() != null) {
                sql.append(" InvoiceCollectionType=? AND ");
                parameters.add(this.getInvoiceCollectionType());
            }
            if (this.getDunningLevelId() > 0) {
                sql.append(" C_DunningLevel_ID=? AND ");
                parameters.add(this.getDunningLevelId());
            }
            if (this.getDateInvoiced() != null && this.getDateInvoicedTo() != null) {
                sql.append(" TRUNC(DateInvoiced, 'DD') BETWEEN ").append(DB.TO_DATE(this.getDateInvoiced(), true)).append(" AND ").append(DB.TO_DATE(this.getDateInvoicedTo(), true)).append(" AND ");
            } else if (this.getDateInvoiced() != null) {
                sql.append(" TRUNC(DateInvoiced, 'DD') >= ").append(DB.TO_DATE(this.getDateInvoiced(), true)).append(" AND ");
            } else if (this.getDateInvoicedTo() != null) {
                sql.append("  TRUNC(DateInvoiced, 'DD') <= ").append(DB.TO_DATE(this.getDateInvoicedTo(), true)).append(" AND ");
            }
        }
        sql.append(" IsPaid='N' ORDER BY C_Currency_ID, C_BPartner_ID, DateInvoiced");
        String finalSql = MRole.getDefault(this.getCtx(), false).addAccessSQL(sql.toString(), "C_Invoice", true, false);
        this.log.finer(finalSql);
        int counter = 0;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(finalSql, this.get_TrxName());
            DB.setParameters((PreparedStatement)pstmt, parameters);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (!this.writeOff(rs.getInt(1), rs.getString(2), rs.getTimestamp(3), rs.getInt(4), rs.getBigDecimal(6))) continue;
                ++counter;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.processPayment();
        this.processAllocation();
        return "#" + counter;
    }

    private boolean writeOff(int invoiceId, String documentNo, Timestamp dateInvoiced, int currencyId, BigDecimal openAmt) {
        if (openAmt == null || openAmt.signum() == 0) {
            return false;
        }
        if (openAmt.abs().compareTo(this.getMaxInvWriteOffAmt()) >= 0) {
            return false;
        }
        if (this.isSimulation()) {
            this.addLog("@IsSimulation@");
            this.addLog(invoiceId, dateInvoiced, openAmt, documentNo);
            return true;
        }
        MInvoice invoice = new MInvoice(this.getCtx(), invoiceId, this.get_TrxName());
        if (!invoice.isSOTrx()) {
            openAmt = openAmt.negate();
        }
        if (this.allocation == null || currencyId != this.allocation.getC_Currency_ID()) {
            this.processAllocation();
            this.allocation = new MAllocationHdr(this.getCtx(), true, this.getDateAcct(), currencyId, this.getProcessInfo().getTitle() + " #" + this.getAD_PInstance_ID(), this.get_TrxName());
            this.allocation.setAD_Org_ID(invoice.getAD_Org_ID());
            if (!this.allocation.save()) {
                this.log.log(Level.SEVERE, "Cannot create allocation header");
                return false;
            }
        }
        if (this.isCreatePayment() && (this.payment == null || invoice.getC_BPartner_ID() != this.payment.getC_BPartner_ID() || currencyId != this.payment.getC_Currency_ID())) {
            this.processPayment();
            this.payment = new MPayment(this.getCtx(), 0, this.get_TrxName());
            this.payment.setAD_Org_ID(invoice.getAD_Org_ID());
            this.payment.setC_BankAccount_ID(this.getBankAccountId());
            this.payment.setTenderType("K");
            this.payment.setDateTrx(this.getDateAcct());
            this.payment.setDateAcct(this.getDateAcct());
            this.payment.setDescription(this.getProcessInfo().getTitle() + " #" + this.getAD_PInstance_ID());
            this.payment.setC_BPartner_ID(invoice.getC_BPartner_ID());
            this.payment.setIsReceipt(true);
            this.payment.setC_Currency_ID(currencyId);
            if (!this.payment.save()) {
                this.log.log(Level.SEVERE, "Cannot create payment");
                return false;
            }
        }
        MAllocationLine allocationLine = null;
        if (this.isCreatePayment()) {
            allocationLine = new MAllocationLine(this.allocation, openAmt, Env.ZERO, Env.ZERO, Env.ZERO);
            this.payment.setPayAmt(this.payment.getPayAmt().add(openAmt));
            allocationLine.setC_Payment_ID(this.payment.getC_Payment_ID());
        } else {
            allocationLine = new MAllocationLine(this.allocation, Env.ZERO, Env.ZERO, openAmt, Env.ZERO);
        }
        allocationLine.setC_Invoice_ID(invoiceId);
        if (allocationLine.save()) {
            this.addLog(invoiceId, dateInvoiced, openAmt, documentNo);
            return true;
        }
        this.log.log(Level.SEVERE, "Cannot create allocation line for C_Invoice_ID=" + invoiceId);
        return false;
    }

    private boolean processAllocation() {
        if (this.allocation == null) {
            return true;
        }
        this.processPayment();
        if (this.allocation.processIt("CO") && this.allocation.save()) {
            this.allocation = null;
            return true;
        }
        this.allocation = null;
        return false;
    }

    private boolean processPayment() {
        if (this.payment == null) {
            return true;
        }
        if (this.payment.processIt("CO") && this.payment.save()) {
            this.payment = null;
            return true;
        }
        this.payment = null;
        return false;
    }
}

