/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInOut;
import org.compiere.model.MPackage;
import org.compiere.model.MShipper;
import org.compiere.process.PackageCreateAbstract;

public class PackageCreate
extends PackageCreateAbstract {
    @Override
    protected String doIt() throws Exception {
        this.log.info("doIt - M_InOut_ID=" + this.getInOutId() + ", M_Shipper_ID=" + this.getShipperId());
        MInOut shipment = new MInOut(this.getCtx(), this.getInOutId(), this.get_TrxName());
        if (shipment.get_ID() != this.getInOutId()) {
            throw new IllegalArgumentException("@M_InOut_ID@ @NotFound@");
        }
        MShipper shipper = new MShipper(this.getCtx(), this.getShipperId(), this.get_TrxName());
        if (shipper.get_ID() != this.getShipperId()) {
            throw new IllegalArgumentException("@M_Shipper_ID@ @NotFound@");
        }
        MPackage pack = MPackage.create(shipment, shipper, shipment.getMovementDate());
        if (!pack.processIt("CO")) {
            throw new AdempiereException(pack.getProcessMsg());
        }
        pack.saveEx();
        return pack.getDocumentNo();
    }
}

