/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.InvalidClassException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.logging.Level;
import org.adempiere.util.ProcessUtil;
import org.compiere.db.CConnection;
import org.compiere.interfaces.Server;
import org.compiere.model.MPInstance;
import org.compiere.model.MProcess;
import org.compiere.print.ServerReportCtl;
import org.compiere.process.ClientProcess;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.wf.MWFProcess;

public class ServerProcessCtl
implements Runnable {
    private static CLogger log = CLogger.getCLogger(ServerProcessCtl.class);
    private ASyncProcess parentProcess;
    private ProcessInfo processInstance;
    private Trx transaction;
    private boolean isServerProcess = false;

    public ServerProcessCtl(ASyncProcess parent, ProcessInfo pi, Trx trx) {
        this.parentProcess = parent;
        this.processInstance = pi;
        this.transaction = trx;
    }

    public static ServerProcessCtl process(ASyncProcess parent, ProcessInfo processInfo, Trx trx) {
        log.fine("ServerProcess - " + processInfo);
        MPInstance instance = null;
        try {
            instance = new MPInstance(Env.getCtx(), processInfo.getAD_Process_ID(), processInfo.getRecord_ID());
        }
        catch (Exception e) {
            processInfo.setSummary(e.getLocalizedMessage());
            processInfo.setError(true);
            log.warning(processInfo.toString());
            return null;
        }
        catch (Error e) {
            processInfo.setSummary(e.getLocalizedMessage());
            processInfo.setError(true);
            log.warning(processInfo.toString());
            return null;
        }
        if (instance != null && !instance.save()) {
            processInfo.setSummary(Msg.getMsg(Env.getCtx(), "ProcessNoInstance"));
            processInfo.setError(true);
            return null;
        }
        processInfo.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        ServerProcessCtl worker = new ServerProcessCtl(parent, processInfo, trx);
        if (parent != null) {
            worker.start();
        } else {
            worker.run();
        }
        return worker;
    }

    public void start() {
        Thread thread = new Thread(this);
        if (this.processInstance != null) {
            thread.setName(this.processInstance.getTitle() + "-" + this.processInstance.getAD_PInstance_ID());
        }
        thread.start();
    }

    @Override
    public void run() {
        log.fine("AD_PInstance_ID=" + this.processInstance.getAD_PInstance_ID() + ", Record_ID=" + this.processInstance.getRecord_ID());
        String procedureName = "";
        MProcess process = null;
        if (this.processInstance.getAD_Process_ID() != 0) {
            process = MProcess.get(Env.getCtx(), this.processInstance.getAD_Process_ID());
        } else {
            process = MProcess.getFromInstance(Env.getCtx(), this.processInstance.getAD_PInstance_ID());
            this.processInstance.setAD_Process_ID(process.getAD_Process_ID());
        }
        if (process.getAD_Process_ID() <= 0) {
            this.processInstance.setSummary(Msg.parseTranslation(Env.getCtx(), "@AD_Process_ID@ @NotFound@"), true);
            log.log(Level.SEVERE, "run", "AD_Process_ID=" + this.processInstance.getAD_Process_ID() + " Not Found");
            return;
        }
        this.processInstance.setTitle(process.get_Translation("Name"));
        procedureName = process.getProcedureName();
        this.processInstance.setClassName(process.getClassname());
        int estimate = process.getEstimatedSeconds();
        if (estimate != 0) {
            this.processInstance.setEstSeconds(estimate + 1);
        }
        this.isServerProcess = process.isServerProcess();
        if (procedureName == null) {
            procedureName = "";
        }
        if (process.isWorkflow()) {
            this.startWorkflow(process.getAD_Workflow_ID());
            return;
        }
        if (process.isJasper() && "org.compiere.jr.report.ReportStarter".equals(this.processInstance.getClassName())) {
            this.processInstance.setClassName(null);
        }
        if (this.processInstance.getClassName() != null) {
            if (process.isJasper()) {
                this.processInstance.setReportingProcess(true);
            }
            if (!this.startProcess()) {
                return;
            }
            if (!process.isReport() && procedureName.length() == 0) {
                return;
            }
            if (process.isReport() && process.getAD_ReportView_ID() == 0 && !process.isJasper()) {
                return;
            }
        }
        if (process.isReport() && procedureName.length() > 0) {
            this.processInstance.setReportingProcess(true);
            if (!this.startDBProcess(procedureName)) {
                return;
            }
        }
        if (process.isJasper()) {
            this.processInstance.setReportingProcess(true);
            this.processInstance.setClassName("org.compiere.jr.report.ReportStarter");
            this.startProcess();
            return;
        }
        if (process.isReport()) {
            this.processInstance.setReportingProcess(true);
            boolean ok = ServerReportCtl.start(this.parentProcess, this.processInstance);
            this.processInstance.setSummary("Report", !ok);
        } else {
            if (procedureName.length() > 0 && !this.startDBProcess(procedureName)) {
                return;
            }
            ProcessInfoUtil.setSummaryFromDB(this.processInstance);
        }
    }

    protected boolean startWorkflow(int AD_Workflow_ID) {
        log.fine(AD_Workflow_ID + " - " + this.processInstance);
        boolean started = false;
        if (this.isServerProcess) {
            try {
                Server server = CConnection.get().getServer();
                if (server != null) {
                    this.processInstance = server.workflow(Env.getRemoteCallCtx(Env.getCtx()), this.processInstance, AD_Workflow_ID);
                    log.finest("server => " + this.processInstance);
                    started = true;
                }
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "AppsServer error", ex);
                started = false;
            }
        }
        if (!started && !this.isServerProcess) {
            MWFProcess wfProcess;
            if (this.transaction != null) {
                this.processInstance.setTransactionName(this.transaction.getTrxName());
            }
            started = (wfProcess = ProcessUtil.startWorkFlow(Env.getCtx(), this.processInstance, AD_Workflow_ID)) != null;
        }
        return started;
    }

    protected boolean startProcess() {
        log.fine(this.processInstance.toString());
        boolean started = false;
        boolean clientOnly = false;
        if (!this.processInstance.getClassName().toLowerCase().startsWith("@script:")) {
            try {
                Class<?> processClass = Class.forName(this.processInstance.getClassName());
                if (ClientProcess.class.isAssignableFrom(processClass)) {
                    clientOnly = true;
                }
            }
            catch (Exception processClass) {
                // empty catch block
            }
        }
        if (this.isServerProcess && !clientOnly) {
            try {
                Server server = CConnection.get().getServer();
                if (server != null) {
                    this.processInstance = server.process(Env.getRemoteCallCtx(Env.getCtx()), this.processInstance);
                    log.finest("server => " + this.processInstance);
                    started = true;
                }
            }
            catch (UndeclaredThrowableException ex) {
                Throwable cause = ex.getCause();
                if (cause != null) {
                    if (cause instanceof InvalidClassException) {
                        log.log(Level.SEVERE, "Version Server <> Client: " + cause.toString() + " - " + this.processInstance, ex);
                    } else {
                        log.log(Level.SEVERE, "AppsServer error(1b): " + cause.toString() + " - " + this.processInstance, ex);
                    }
                } else {
                    log.log(Level.SEVERE, " AppsServer error(1) - " + this.processInstance, ex);
                }
                started = false;
            }
            catch (Exception ex) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    cause = ex;
                }
                log.log(Level.SEVERE, "AppsServer error - " + this.processInstance, cause);
                started = false;
            }
        }
        if (!(started || this.isServerProcess && !clientOnly)) {
            if (this.processInstance.getClassName().toLowerCase().startsWith("@script:")) {
                return ProcessUtil.startScriptProcess(Env.getCtx(), this.processInstance, this.transaction);
            }
            if (this.processInstance.isManagedTransaction()) {
                return ProcessUtil.startJavaProcess(Env.getCtx(), this.processInstance, this.transaction);
            }
            return ProcessUtil.startJavaProcess(Env.getCtx(), this.processInstance, this.transaction, this.processInstance.isManagedTransaction());
        }
        return !this.processInstance.isError();
    }

    protected boolean startDBProcess(String ProcedureName) {
        log.fine(ProcedureName + "(" + this.processInstance.getAD_PInstance_ID() + ")");
        boolean started = false;
        if (this.isServerProcess) {
            try {
                Server server = CConnection.get().getServer();
                if (server != null) {
                    this.processInstance = server.dbProcess(this.processInstance, ProcedureName);
                    log.finest("server => " + this.processInstance);
                    started = true;
                }
            }
            catch (UndeclaredThrowableException ex) {
                Throwable cause = ex.getCause();
                if (cause != null) {
                    if (cause instanceof InvalidClassException) {
                        log.log(Level.SEVERE, "Version Server <> Client: " + cause.toString() + " - " + this.processInstance, ex);
                    } else {
                        log.log(Level.SEVERE, "AppsServer error(1b): " + cause.toString() + " - " + this.processInstance, ex);
                    }
                } else {
                    log.log(Level.SEVERE, " AppsServer error(1) - " + this.processInstance, ex);
                    cause = ex;
                }
                this.processInstance.setSummary(Msg.getMsg(Env.getCtx(), "ProcessRunError") + " " + cause.getLocalizedMessage());
                this.processInstance.setError(true);
                return false;
            }
            catch (Exception ex) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    cause = ex;
                }
                log.log(Level.SEVERE, "AppsServer error - " + this.processInstance, cause);
                this.processInstance.setSummary(Msg.getMsg(Env.getCtx(), "ProcessRunError") + " " + cause.getLocalizedMessage());
                this.processInstance.setError(true);
                return false;
            }
        }
        if (!started) {
            if (this.processInstance.isManagedTransaction()) {
                return ProcessUtil.startDatabaseProcedure(this.processInstance, ProcedureName, this.transaction);
            }
            return ProcessUtil.startDatabaseProcedure(this.processInstance, ProcedureName, this.transaction, this.processInstance.isManagedTransaction());
        }
        return true;
    }
}

