/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MPInstance;
import org.compiere.model.MProcess;
import org.compiere.model.PO;
import org.compiere.print.MPrintFormat;
import org.compiere.process.GardenWorldCleanup;
import org.compiere.process.IPrintDocument;
import org.compiere.process.ProcessCall;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.spin.util.ASPUtil;

public abstract class SvrProcess
implements ProcessCall {
    private Properties ctx;
    private ProcessInfo processInfo;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private boolean locked = false;
    private PO lockedObject = null;
    private Trx transaction;
    protected static String MESSAGE_SaveErrorRowNotFound = "@SaveErrorRowNotFound@";
    protected static String MESSAGE_InvalidArguments = "@InvalidArguments@";
    protected static String MESSAGE_FillMandatory = "@FillMandatory@";

    @Override
    public final boolean startProcess(Properties ctx, ProcessInfo pi, Trx trx) {
        boolean localTrx;
        this.ctx = ctx == null ? Env.getCtx() : ctx;
        this.processInfo = pi;
        this.transaction = trx;
        boolean bl = localTrx = this.transaction == null;
        if (localTrx) {
            this.transaction = Trx.get(Trx.createTrxName("SvrProcess"), true);
        }
        this.lock();
        boolean success = this.process();
        if (localTrx) {
            if (success) {
                try {
                    this.transaction.commit(true);
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "Commit failed.", e);
                    this.processInfo.addSummary("Commit Failed.");
                    this.processInfo.setError(true);
                }
            } else {
                this.transaction.rollback();
            }
            this.transaction.close();
            this.transaction = null;
        }
        this.unlock();
        this.postProcess(!this.processInfo.isError());
        return !this.processInfo.isError();
    }

    private boolean process() {
        String msg = "";
        boolean success = true;
        try {
            this.getParameter();
            this.validateParameter();
            this.prepare();
            msg = this.doIt();
        }
        catch (Throwable e) {
            msg = e.getLocalizedMessage();
            if (msg == null) {
                msg = e.toString();
            }
            if (e.getCause() != null) {
                this.log.log(Level.SEVERE, msg, e.getCause());
            } else {
                this.log.log(Level.SEVERE, msg, e);
            }
            success = false;
        }
        if (msg != null && msg.contains("@Error@")) {
            success = false;
        }
        msg = Msg.parseTranslation(this.ctx, msg);
        this.processInfo.setSummary(msg, !success);
        return success;
    }

    private void validateParameter() {
        MProcess process = ASPUtil.getInstance(this.getCtx()).getProcess(this.processInfo.getAD_Process_ID());
        if (process == null) {
            return;
        }
        StringBuffer errorMsg = new StringBuffer();
        ASPUtil.getInstance(this.getCtx()).getProcessParameters(this.processInfo.getAD_Process_ID()).forEach(parameter -> {
            ProcessInfoParameter infoParameter;
            if (parameter.isMandatory() && parameter.isActive() && Util.isEmpty(parameter.getDisplayLogic()) && ((infoParameter = this.getInfoParameter(parameter.getColumnName())) == null || infoParameter.getParameter() == null || DisplayType.isID(parameter.getAD_Reference_ID()) && (infoParameter.getParameter() instanceof String && infoParameter.getParameterAsString() == null || infoParameter.getParameter() instanceof Number && infoParameter.getParameterAsInt() < 0) || DisplayType.isText(parameter.getAD_Reference_ID()) && (infoParameter.getParameterAsString() == null || infoParameter.getParameterAsString().length() == 0))) {
                if (errorMsg.length() > 0) {
                    errorMsg.append(", ");
                }
                errorMsg.append("@").append(parameter.getColumnName()).append("@");
            }
        });
        if (errorMsg.length() > 0) {
            throw new AdempiereException(MESSAGE_FillMandatory + errorMsg.toString());
        }
    }

    protected abstract void prepare();

    protected abstract String doIt() throws Exception;

    protected void postProcess(boolean success) {
    }

    protected void commit() {
        if (this.transaction != null) {
            this.transaction.commit();
        }
    }

    protected void commitEx() throws SQLException {
        if (this.transaction != null) {
            this.transaction.commit(true);
        }
    }

    protected void rollback() {
        if (this.transaction != null) {
            this.transaction.rollback();
        }
    }

    protected boolean lockObject(PO po) {
        if (this.locked || this.lockedObject != null) {
            this.unlockObject();
        }
        if (po == null) {
            return false;
        }
        this.lockedObject = po;
        this.locked = this.lockedObject.lock();
        return this.locked;
    }

    protected boolean isLocked() {
        return this.locked;
    }

    protected boolean unlockObject() {
        boolean success = true;
        if (this.locked || this.lockedObject != null) {
            success = this.lockedObject.unlock(null);
        }
        this.locked = false;
        this.lockedObject = null;
        return success;
    }

    public ProcessInfo getProcessInfo() {
        return this.processInfo;
    }

    public Properties getCtx() {
        return this.ctx;
    }

    protected String getName() {
        return this.processInfo.getTitle();
    }

    protected int getAD_PInstance_ID() {
        return this.processInfo.getAD_PInstance_ID();
    }

    protected int getTable_ID() {
        return this.processInfo.getTable_ID();
    }

    protected int getRecord_ID() {
        return this.processInfo.getRecord_ID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getAD_User_ID() {
        if (this.processInfo.getAD_User_ID() == null || this.processInfo.getAD_Client_ID() == null) {
            String sql = "SELECT AD_User_ID, AD_Client_ID FROM AD_PInstance WHERE AD_PInstance_ID=?";
            CPreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = DB.prepareStatement(sql, this.get_TrxName());
                preparedStatement.setInt(1, this.processInfo.getAD_PInstance_ID());
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    this.processInfo.setAD_User_ID(resultSet.getInt(1));
                    this.processInfo.setAD_Client_ID(resultSet.getInt(2));
                }
                DB.close(resultSet, preparedStatement);
                resultSet = null;
                preparedStatement = null;
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
            }
            finally {
                DB.close(resultSet, preparedStatement);
                resultSet = null;
                preparedStatement = null;
            }
        }
        if (this.processInfo.getAD_User_ID() == null) {
            return -1;
        }
        return this.processInfo.getAD_User_ID();
    }

    protected int getAD_Client_ID() {
        if (this.processInfo.getAD_Client_ID() == null) {
            this.getAD_User_ID();
            if (this.processInfo.getAD_Client_ID() == null) {
                return 0;
            }
        }
        return this.processInfo.getAD_Client_ID();
    }

    protected boolean isSelection() {
        return this.processInfo.isSelection();
    }

    public List<Integer> getSelectionKeys() {
        return this.processInfo.getSelectionKeys();
    }

    public LinkedHashMap<Integer, LinkedHashMap<String, Object>> getSelectionValues() {
        return this.processInfo.getSelectionValues();
    }

    public List<?> getInstancesForSelection(String trxName) throws AdempiereException {
        return this.processInfo.getInstancesForSelection(trxName);
    }

    public PO getInstance(String trxName) throws AdempiereException {
        return this.processInfo.getInstance(trxName);
    }

    protected ProcessInfoParameter[] getParameter() {
        ProcessInfoParameter[] parameter = this.processInfo.getParameter();
        if (parameter == null) {
            ProcessInfoUtil.setParameterFromDB(this.processInfo);
            parameter = this.processInfo.getParameter();
        }
        return parameter;
    }

    public ProcessInfoParameter getInfoParameter(String parameterName) {
        return this.processInfo.getInfoParameter(parameterName);
    }

    public Object getParameter(String parameterName) {
        return this.processInfo.getParameter(parameterName);
    }

    public BigDecimal getParameterAsBigDecimal(String parameterName) {
        return this.processInfo.getParameterAsBigDecimal(parameterName);
    }

    public boolean getParameterAsBoolean(String parameterName) {
        return this.processInfo.getParameterAsBoolean(parameterName);
    }

    public int getParameterAsInt(String parameterName) {
        return this.processInfo.getParameterAsInt(parameterName);
    }

    public String getParameterAsString(String parameterName) {
        return this.processInfo.getParameterAsString(parameterName);
    }

    public Timestamp getParameterAsTimestamp(String parameterName) {
        return this.processInfo.getParameterAsTimestamp(parameterName);
    }

    public Object getParameterTo(String parameterName) {
        return this.processInfo.getParameterTo(parameterName);
    }

    public BigDecimal getParameterToAsBigDecimal(String parameterName) {
        return this.processInfo.getParameterToAsBigDecimal(parameterName);
    }

    public boolean getParameterToAsBoolean(String parameterName) {
        return this.processInfo.getParameterToAsBoolean(parameterName);
    }

    public int getParameterToAsInt(String parameterName) {
        return this.processInfo.getParameterToAsInt(parameterName);
    }

    public String getParameterToAsString(String parameterName) {
        return this.processInfo.getParameterToAsString(parameterName);
    }

    public Timestamp getParameterToAsTimestamp(String parameterName) {
        return this.processInfo.getParameterToAsTimestamp(parameterName);
    }

    public Object getSelection(int key, String columnName) {
        return this.processInfo.getSelection(key, columnName);
    }

    public BigDecimal getSelectionAsBigDecimal(int key, String columnName) {
        return this.processInfo.getSelectionAsBigDecimal(key, columnName);
    }

    public boolean getSelectionAsBoolean(int key, String columnName) {
        return this.processInfo.getSelectionAsBoolean(key, columnName);
    }

    public int getSelectionAsInt(int key, String columnName) {
        return this.processInfo.getSelectionAsInt(key, columnName);
    }

    public String getSelectionAsString(int key, String columnName) {
        return this.processInfo.getSelectionAsString(key, columnName);
    }

    public Timestamp getSelectionAsTimestamp(int key, String columnName) {
        return this.processInfo.getSelectionAsTimestamp(key, columnName);
    }

    public void addLog(int id, Timestamp date, BigDecimal number, String msg) {
        if (this.processInfo != null) {
            this.processInfo.addLog(id, date, number, msg);
        }
        this.log.info(id + " - " + date + " - " + number + " - " + msg);
    }

    public void addLog(String msg) {
        if (msg != null) {
            this.addLog(0, null, null, msg);
        }
    }

    public Object doIt(String className, String methodName, Object[] args) {
        try {
            Class<?> clazz = Class.forName(className);
            Object object = clazz.newInstance();
            Method[] methods = clazz.getMethods();
            for (int i2 = 0; i2 < methods.length; ++i2) {
                if (!methods[i2].getName().equals(methodName)) continue;
                return methods[i2].invoke(object, args);
            }
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, "doIt", ex);
            throw new RuntimeException(ex);
        }
        return null;
    }

    private void lock() {
        this.log.fine("AD_PInstance_ID=" + this.processInfo.getAD_PInstance_ID());
        try {
            DB.executeUpdate("UPDATE AD_PInstance SET IsProcessing='Y' WHERE AD_PInstance_ID=" + this.processInfo.getAD_PInstance_ID(), null);
        }
        catch (Exception e) {
            this.log.severe("lock() - " + e.getLocalizedMessage());
        }
    }

    private void unlock() {
        try {
            MPInstance instance = new MPInstance(this.getCtx(), this.processInfo.getAD_PInstance_ID(), null);
            if (instance.get_ID() == 0) {
                this.log.log(Level.SEVERE, "Did not find PInstance " + this.processInfo.getAD_PInstance_ID());
                return;
            }
            instance.setIsProcessing(false);
            instance.setResult(!this.processInfo.isError());
            instance.setErrorMsg(this.processInfo.getSummary());
            instance.saveEx();
            this.log.fine(instance.toString());
            ProcessInfoUtil.saveLogToDB(this.processInfo);
        }
        catch (Exception e) {
            this.log.severe("unlock() - " + e.getLocalizedMessage());
        }
    }

    public String get_TrxName() {
        if (this.transaction != null) {
            return this.transaction.getTrxName();
        }
        return null;
    }

    public String getTableName() {
        return this.processInfo.getTableName();
    }

    public String getTableNameSelection() {
        return this.processInfo.getTableNameSelection();
    }

    public int getTableSelectionId() {
        return this.processInfo.getTableSelectionId();
    }

    public String getAliasForTableSelection() {
        return this.processInfo.getAliasForTableSelection();
    }

    public String getPrefixAliasForTableSelection() {
        return this.processInfo.getPrefixAliasForTableSelection();
    }

    public void printDocument(PO document, String printFormantName) {
        this.printDocument(document, MPrintFormat.getPrintFormat_ID(printFormantName, document.get_Table_ID(), 0), true);
    }

    public void printDocument(PO document, boolean askPrint) {
        int printFormatId = this.getPrintFormatId(document);
        if (printFormatId != 0) {
            this.printDocument(document, printFormatId, askPrint);
        }
    }

    private int getPrintFormatId(PO document) {
        int documentTypeId = document.get_ValueAsInt("C_DocType_ID");
        if (documentTypeId == 0) {
            documentTypeId = document.get_ValueAsInt("C_DocTypeTarget_ID");
        }
        if (documentTypeId != 0) {
            MDocType documentType = MDocType.get(this.getCtx(), documentTypeId);
            return documentType.getAD_PrintFormat_ID();
        }
        return 0;
    }

    public void printDocument(PO document, int printFormatId, boolean askPrint) {
        this.getPrintDocumentImplementation().print(document, printFormatId, this.getProcessInfo().getWindowNo(), askPrint);
    }

    public void printDocument(List<PO> documentList, boolean askPrint) {
        if (documentList.size() == 0) {
            return;
        }
        int printFormatId = this.getPrintFormatId(documentList.get(0));
        if (printFormatId != 0) {
            this.printDocument(documentList, printFormatId, askPrint);
        }
    }

    public void printDocument(List<PO> documentList, int printFormatId, boolean askPrint) {
        this.getPrintDocumentImplementation().print(documentList, printFormatId, this.getProcessInfo().getWindowNo(), askPrint);
    }

    private IPrintDocument getPrintDocumentImplementation() {
        IPrintDocument printDocument;
        if (Ini.isClient()) {
            try {
                Class<?> clazz = Class.forName("org.eevolution.form.VPrintDocument");
                Constructor<?> constructor = null;
                constructor = clazz.getDeclaredConstructor(new Class[0]);
                printDocument = (IPrintDocument)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = GardenWorldCleanup.class.getClassLoader();
            }
            Class<?> clazz = loader.loadClass("org.eevolution.form.WPrintDocument");
            Constructor<?> constructor = null;
            constructor = clazz.getDeclaredConstructor(new Class[0]);
            printDocument = (IPrintDocument)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
        return printDocument;
    }

    public void openResult(String tableName) {
        this.processInfo.openResult(tableName);
    }
}

