/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.sql.Timestamp;
import org.compiere.util.DB;

public class FinReportPeriod {
    private int periodId;
    private String name;
    private Timestamp startDate;
    private Timestamp endDate;
    private Timestamp yearStartDate;
    private String periodType;

    public FinReportPeriod(int periodId, String name, Timestamp startDate, Timestamp endDate, Timestamp yearStartDate, String periodType) {
        this.periodId = periodId;
        this.name = name;
        this.startDate = startDate;
        this.endDate = endDate;
        this.yearStartDate = yearStartDate;
        this.periodType = periodType;
    }

    public String getPeriodTypeWhere(String alias, boolean includeAdjustmentPeriod) {
        String periodTypeWhere = "";
        periodTypeWhere = includeAdjustmentPeriod ? "IN ('S','A')" : "IN ('S')";
        return " EXISTS (SELECT 1 FROM C_Period WHERE C_Period.C_Period_ID = " + alias + ".C_Period_ID AND C_Period.PeriodType " + periodTypeWhere + ") ";
    }

    public String getPeriodWhere() {
        StringBuffer sql = new StringBuffer("BETWEEN ");
        sql.append(DB.TO_DATE(this.startDate)).append(" AND ").append(DB.TO_DATE(this.endDate));
        return sql.toString();
    }

    public String getYearWhere() {
        StringBuffer sql = new StringBuffer("BETWEEN ");
        sql.append(DB.TO_DATE(this.yearStartDate)).append(" AND ").append(DB.TO_DATE(this.endDate));
        return sql.toString();
    }

    public String getTotalWhere() {
        StringBuffer sql = new StringBuffer("<= ");
        sql.append(DB.TO_DATE(this.endDate));
        return sql.toString();
    }

    public boolean inPeriod(Timestamp date) {
        if (date == null) {
            return false;
        }
        if (date.before(this.startDate)) {
            return false;
        }
        return !date.after(this.endDate);
    }

    public String getName() {
        return this.name;
    }

    public int getC_Period_ID() {
        return this.periodId;
    }

    public Timestamp getEndDate() {
        return this.endDate;
    }

    public Timestamp getStartDate() {
        return this.startDate;
    }

    public Timestamp getYearStartDate() {
        return this.yearStartDate;
    }

    public String getNaturalWhere(String alias) {
        String yearWhere = this.getYearWhere();
        String totalWhere = this.getTotalWhere();
        String bs = " EXISTS (SELECT C_ElementValue_ID FROM C_ElementValue WHERE C_ElementValue_ID = " + alias + ".Account_ID AND AccountType NOT IN ('R', 'E'))";
        String full = totalWhere + " AND ( " + bs + " OR TRUNC(" + alias + ".DateAcct, 'DD') " + yearWhere + " ) ";
        return full;
    }
}

