/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.tree.TreeNode;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MHierarchy;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MReportTree {
    private static CCache<String, MReportTree> reportTreeCCache = new CCache("MReportTree", 20);
    private int hierarchyId = 0;
    private String elementType = null;
    private Properties ctx = null;
    private String treeType = null;
    private MTree tree = null;
    private CLogger logger = CLogger.getCLogger(this.getClass());

    public static MReportTree get(Properties ctx, int hierarchyId, String elementType) {
        String key = hierarchyId + elementType;
        MReportTree tree = reportTreeCCache.get(key);
        if (tree == null) {
            tree = new MReportTree(ctx, hierarchyId, elementType);
            reportTreeCCache.put(key, tree);
        }
        return tree;
    }

    public static String getWhereClause(Properties ctx, int hierarchyId, String elementType, int dimensionId) {
        MReportTree tree = MReportTree.get(ctx, hierarchyId, elementType);
        return tree.getWhereClause(dimensionId);
    }

    public static Integer[] getChildIDs(Properties ctx, int hierarchyId, String ElementType, int ID) {
        MReportTree tree = MReportTree.get(ctx, hierarchyId, ElementType);
        return tree.getChildIDs(ID);
    }

    public MReportTree(Properties ctx, int PA_Hierarchy_ID, String ElementType) {
        this.treeType = this.elementType = ElementType;
        if ("AC".equals(this.elementType)) {
            this.treeType = "EV";
        }
        if ("OT".equals(this.elementType)) {
            this.treeType = "OO";
        }
        this.hierarchyId = PA_Hierarchy_ID;
        this.ctx = ctx;
        int treeId = this.getAD_Tree_ID();
        if (treeId == 0) {
            throw new IllegalArgumentException("No AD_Tree_ID for TreeType=" + this.treeType + ", PA_Hierarchy_ID=" + PA_Hierarchy_ID);
        }
        this.tree = new MTree(ctx, treeId, true, null);
        this.tree.trimTree();
    }

    protected int getAD_Tree_ID() {
        if (this.hierarchyId == 0) {
            return this.getDefaultAD_Tree_ID();
        }
        MHierarchy hierarchy = MHierarchy.get(this.ctx, this.hierarchyId);
        int treeId = hierarchy.getAD_Tree_ID(this.treeType);
        if (treeId == 0) {
            return this.getDefaultAD_Tree_ID();
        }
        return treeId;
    }

    protected int getDefaultAD_Tree_ID() {
        int treeId = 0;
        int clientId = Env.getAD_Client_ID(this.ctx);
        String sql = "SELECT AD_Tree_ID, Name FROM AD_Tree WHERE AD_Client_ID=? AND TreeType=? AND IsActive='Y' AND IsAllNodes='Y' ORDER BY IsDefault DESC, AD_Tree_ID";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, clientId);
            pstmt.setString(2, this.treeType);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                treeId = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.logger.log(Level.SEVERE, sql, e);
        }
        return treeId;
    }

    public String getElementType() {
        return this.elementType;
    }

    public String getTreeType() {
        return this.treeType;
    }

    public MTree getTree() {
        return this.tree;
    }

    public String getWhereClause(int id) {
        this.logger.fine("(" + this.elementType + ") ID=" + id);
        String columnName = MAcctSchemaElement.getColumnName(this.elementType);
        MTreeNode node = this.tree.getRoot().findNode(id);
        this.logger.finest("Root=" + node);
        StringBuffer result = null;
        if (node != null && node.isSummary()) {
            Enumeration<TreeNode> en = node.preorderEnumeration();
            StringBuffer sb = new StringBuffer();
            while (en.hasMoreElements()) {
                MTreeNode treeNode = (MTreeNode)en.nextElement();
                if (!treeNode.isSummary()) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(treeNode.getNode_ID());
                    this.logger.finest("- " + treeNode);
                    continue;
                }
                this.logger.finest("- skipped parent (" + treeNode + ")");
            }
            result = new StringBuffer(" ");
            result.append(columnName).append(" IN(");
            result.append(sb);
            result.append(") ");
        } else {
            result = new StringBuffer(columnName).append("=").append(id);
        }
        this.logger.finest(result.toString());
        return result.toString();
    }

    public Integer[] getChildIDs(int ID) {
        this.logger.fine("(" + this.elementType + ") ID=" + ID);
        ArrayList<Integer> list = new ArrayList<Integer>();
        MTreeNode node = this.tree.getRoot().findNode(ID);
        this.logger.finest("Root=" + node);
        if (node != null && node.isSummary()) {
            Enumeration<TreeNode> enumeration = node.preorderEnumeration();
            while (enumeration.hasMoreElements()) {
                MTreeNode treeNode = (MTreeNode)enumeration.nextElement();
                if (!treeNode.isSummary()) {
                    list.add(treeNode.getNode_ID());
                    this.logger.finest("- " + treeNode);
                    continue;
                }
                this.logger.finest("- skipped parent (" + treeNode + ")");
            }
        } else {
            list.add(ID);
        }
        Integer[] retValue = new Integer[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MReportTree[ElementType=");
        sb.append(this.elementType).append(",TreeType=").append(this.treeType).append(",").append(this.tree).append("]");
        return sb.toString();
    }
}

