/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.awt.Toolkit;
import java.rmi.ServerException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.compiere.util.Ini;

public class CLogFormatter
extends Formatter {
    private static CLogFormatter s_formatter = null;
    public static String NL = System.getProperty("line.separator");
    private boolean m_shortFormat = false;

    public static synchronized CLogFormatter get() {
        if (s_formatter == null) {
            s_formatter = new CLogFormatter();
        }
        return s_formatter;
    }

    private CLogFormatter() {
    }

    @Override
    public String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        long ms = record.getMillis();
        Timestamp ts = null;
        ts = ms == 0L ? new Timestamp(System.currentTimeMillis()) : new Timestamp(ms);
        Object tsStr = "";
        try {
            tsStr = ts.toString() + "00";
        }
        catch (Exception e) {
            System.err.println("CLogFormatter.format: Millis=" + ms + " - " + e.toString() + " - " + record.getMessage());
            tsStr = "_________________________";
        }
        if (record.getLevel() == Level.SEVERE) {
            sb.append("===========> ");
            if (Ini.isClient()) {
                Toolkit.getDefaultToolkit().beep();
            }
        } else if (record.getLevel() == Level.WARNING) {
            sb.append("-----------> ");
        } else {
            sb.append(((String)tsStr).substring(11, 23));
            int spaces = 11;
            if (record.getLevel() == Level.INFO) {
                spaces = 1;
            } else if (record.getLevel() == Level.CONFIG) {
                spaces = 3;
            } else if (record.getLevel() == Level.FINE) {
                spaces = 5;
            } else if (record.getLevel() == Level.FINER) {
                spaces = 7;
            } else if (record.getLevel() == Level.FINEST) {
                spaces = 9;
            }
            sb.append("                          ".substring(0, spaces));
        }
        if (!this.m_shortFormat) {
            sb.append(CLogFormatter.getClassMethod(record)).append(": ");
        }
        sb.append(record.getMessage());
        String parameters = CLogFormatter.getParameters(record);
        if (parameters.length() > 0) {
            sb.append(" (").append(parameters).append(")");
        }
        if (record.getThreadID() != 10) {
            sb.append(" [").append(record.getThreadID()).append("]");
        }
        sb.append(NL);
        if (record.getThrown() != null) {
            sb.append(CLogFormatter.getExceptionTrace(record)).append(NL);
        }
        return sb.toString();
    }

    @Override
    public String getHead(Handler h) {
        String className = h.getClass().getName();
        int index = className.lastIndexOf(46);
        if (index != -1) {
            className = className.substring(index + 1);
        }
        StringBuffer sb = new StringBuffer().append("*** ").append(new Timestamp(System.currentTimeMillis())).append(" Adempiere Log (").append(className).append(") ***").append(NL);
        return sb.toString();
    }

    @Override
    public String getTail(Handler h) {
        String className = h.getClass().getName();
        int index = className.lastIndexOf(46);
        if (index != -1) {
            className = className.substring(index + 1);
        }
        StringBuffer sb = new StringBuffer().append(NL).append("*** ").append(new Timestamp(System.currentTimeMillis())).append(" Adempiere Log (").append(className).append(") ***").append(NL);
        return sb.toString();
    }

    public void setFormat(boolean shortFormat) {
        this.m_shortFormat = shortFormat;
    }

    public static String getClassMethod(LogRecord record) {
        String retValue;
        StringBuffer sb = new StringBuffer();
        String className = record.getLoggerName();
        if (className == null || className.indexOf("default") != -1 || className.indexOf("global") != -1) {
            className = record.getSourceClassName();
        }
        if (className != null) {
            int index = className.lastIndexOf(46);
            if (index != -1) {
                sb.append(className.substring(index + 1));
            } else {
                sb.append(className);
            }
        } else {
            sb.append(record.getLoggerName());
        }
        if (record.getSourceMethodName() != null) {
            sb.append(".").append(record.getSourceMethodName());
        }
        if ((retValue = sb.toString()).equals("Trace.printStack")) {
            return "";
        }
        return retValue;
    }

    public static String getParameters(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        Object[] parameters = record.getParameters();
        if (parameters != null && parameters.length > 0) {
            for (int i2 = 0; i2 < parameters.length; ++i2) {
                if (i2 > 0) {
                    sb.append(", ");
                }
                sb.append(parameters[i2]);
            }
        }
        return sb.toString();
    }

    public static String getExceptionTrace(LogRecord record) {
        Throwable thrown = record.getThrown();
        if (thrown == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            CLogFormatter.fillExceptionTrace(sb, "", thrown);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    private static void fillExceptionTrace(StringBuffer sb, String hdr, Throwable thrown) {
        Throwable cause;
        boolean firstError = hdr.length() == 0;
        sb.append(hdr).append(thrown.toString());
        if (thrown instanceof SQLException) {
            SQLException ex = (SQLException)thrown;
            sb.append("; State=").append(ex.getSQLState()).append("; ErrorCode=").append(ex.getErrorCode());
        }
        sb.append(NL);
        StackTraceElement[] trace = thrown.getStackTrace();
        boolean adempiereTrace = false;
        int adempiereTraceNo = 0;
        for (int i2 = 0; i2 < trace.length; ++i2) {
            adempiereTrace = trace[i2].getClassName().startsWith("org.compiere.");
            if (thrown instanceof ServerException || adempiereTrace) {
                if (adempiereTrace) {
                    sb.append("\tat ").append(trace[i2]).append(NL);
                }
            } else {
                if (i2 > 20 || i2 > 10 && adempiereTraceNo > 8) break;
                sb.append("\tat ").append(trace[i2]).append(NL);
            }
            if (!adempiereTrace) continue;
            ++adempiereTraceNo;
        }
        if ((cause = thrown.getCause()) != null) {
            CLogFormatter.fillExceptionTrace(sb, "caused by: ", cause);
        }
    }
}

