/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import io.vavr.CheckedFunction1;
import io.vavr.Tuple;
import io.vavr.Tuple3;
import io.vavr.collection.List;
import io.vavr.control.Try;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import org.compiere.Adempiere;
import org.compiere.db.CConnection;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClientInfo;
import org.compiere.model.MColumn;
import org.compiere.model.MCountry;
import org.compiere.model.MRole;
import org.compiere.model.MSystem;
import org.compiere.model.MTree;
import org.compiere.model.MUser;
import org.compiere.model.M_Element;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.ResultSetIterable;
import org.compiere.util.SecureEngine;

public class Login {
    protected Integer authenticatedUserId = null;
    private static CLogger log = CLogger.getCLogger(Login.class);
    private Properties m_ctx = null;
    private String m_connectionProfile = null;

    public static Properties initTest(boolean isClient) {
        KeyNamePair[] orgs;
        KeyNamePair[] clients;
        Properties ctx;
        Login login;
        KeyNamePair[] roles;
        if (!Adempiere.startupEnvironment(true)) {
            System.exit(1);
        }
        if ((roles = (login = new Login(ctx = Env.getCtx())).getRoles(CConnection.get(), "System", "System", true)) != null && roles.length > 0 && (clients = login.getClients(roles[0])) != null && clients.length > 0 && (orgs = login.getOrgs(clients[0])) != null && orgs.length > 0) {
            KeyNamePair[] whs = login.getWarehouses(orgs[0]);
            login.loadPreferences(orgs[0], null, null, null);
        }
        Env.setContext(ctx, "#Date", "2000-01-01");
        return ctx;
    }

    public static boolean isJavaOK(boolean isClient) {
        String jVersion = System.getProperty("java.version");
        if (jVersion.startsWith("11")) {
            return true;
        }
        if (jVersion.startsWith("17")) {
            return true;
        }
        boolean ok = false;
        StringBuffer msg = new StringBuffer();
        msg.append(System.getProperty("java.vm.name")).append(" - ").append(jVersion);
        if (ok) {
            msg.append("(untested)");
        }
        msg.append(" <> 11, 17");
        if (isClient) {
            JOptionPane.showMessageDialog(null, msg.toString(), Adempiere.getName() + " - Java Version Check", ok ? 2 : 0);
        } else {
            log.severe(msg.toString());
        }
        return ok;
    }

    public Login(Properties ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Context missing");
        }
        this.m_ctx = ctx;
    }

    protected KeyNamePair[] getRoles(CConnection cc, String app_user, String app_pwd, boolean force) {
        DB.setDBTarget(cc);
        Env.setContext(this.m_ctx, "#Host", cc.getAppsHost());
        Env.setContext(this.m_ctx, "#Database", cc.getDbName());
        Connection conn = DB.getConnectionRO();
        if (conn == null) {
            log.saveError("NoDatabase", "");
            return null;
        }
        try {
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (app_pwd == null) {
            return null;
        }
        return this.getRoles(app_user, app_pwd, force);
    }

    public KeyNamePair[] getRoles(Principal app_user) {
        if (app_user == null) {
            return null;
        }
        return this.getRoles(app_user.getName(), null, false);
    }

    public KeyNamePair[] getRoles(String app_user, String app_pwd) {
        return this.getRoles(app_user, app_pwd, false);
    }

    public int getAuthenticatedUserId(String app_user, String app_pwd) {
        MSystem system;
        this.authenticatedUserId = null;
        log.info("User=" + app_user);
        int userId = -1;
        String userPwd = null;
        String userSalt = null;
        if (app_user == null || app_user.length() == 0) {
            log.warning("No Apps User");
            this.authenticatedUserId = userId;
            return userId;
        }
        if (app_pwd == null || app_pwd.length() == 0) {
            log.warning("No Apps Password");
            this.authenticatedUserId = userId;
            return userId;
        }
        boolean authenticated = false;
        if (Ini.isClient()) {
            CConnection.get().setAppServerCredential(app_user, app_pwd);
        }
        if ((system = MSystem.get(this.m_ctx)) == null) {
            throw new IllegalStateException("No System Info");
        }
        if (system.isLDAP()) {
            authenticated = system.isLDAP(app_user, app_pwd);
        }
        boolean loginWithValue = M_Element.get(Env.getCtx(), "IsLoginUser") != null;
        String userLogin = "Name";
        if (loginWithValue) {
            userLogin = "Value";
        }
        StringBuilder sql = new StringBuilder("SELECT AD_User_ID, Password, Salt FROM AD_User WHERE COALESCE(LDAPUser, " + userLogin + " ) = ? AND EXISTS (SELECT 1 FROM AD_User_Roles ur         INNER JOIN AD_Role r ON (ur.AD_Role_ID=r.AD_Role_ID)         WHERE ur.AD_User_ID=AD_User.AD_User_ID AND ur.IsActive = ? AND r.IsActive = ? ) AND  EXISTS (SELECT 1 FROM AD_Client c         WHERE c.AD_Client_ID=AD_User.AD_Client_ID         AND c.IsActive = ? ) AND AD_User.IsActive = ? ");
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(app_user);
        parameters.add(true);
        parameters.add(true);
        parameters.add(true);
        parameters.add(true);
        if (loginWithValue) {
            sql.append("AND IsLoginUser = ? ");
            parameters.add(true);
        }
        AtomicReference authenticatedUserTupleReference = new AtomicReference();
        Try authenticatedUserInfo = ((Try)DB.runResultSetFunction.apply(null, (Object)sql.toString(), (Object)List.ofAll(parameters), resultSet -> {
            if (resultSet.next()) {
                authenticatedUserTupleReference.set(Tuple.of((Object)resultSet.getInt("AD_User_ID"), (Object)resultSet.getString("Password"), (Object)resultSet.getString("Salt")));
            }
        })).onFailure(throwable -> log.severe(throwable.getMessage()));
        if (authenticatedUserInfo.isFailure()) {
            return -1;
        }
        if (authenticatedUserTupleReference.get() != null) {
            Tuple3 authenticatedUserTuple = (Tuple3)authenticatedUserTupleReference.get();
            userId = (Integer)authenticatedUserTuple._1;
            userPwd = (String)authenticatedUserTuple._2;
            userSalt = (String)authenticatedUserTuple._3;
        }
        if (!authenticated) {
            boolean isEncrypted = MColumn.isEncrypted(417);
            if (isEncrypted) {
                app_pwd = SecureEngine.encrypt(app_pwd);
            }
            if (app_pwd == null) {
                return -1;
            }
            if (userSalt == null && app_pwd.equals(userPwd)) {
                this.authenticatedUserId = userId;
                return userId;
            }
            if (userSalt != null && MUser.authenticateHash(app_pwd, userPwd, userSalt)) {
                this.authenticatedUserId = userId;
                return userId;
            }
            return -1;
        }
        this.authenticatedUserId = userId;
        return userId;
    }

    public KeyNamePair[] getRoles(String app_user, String app_pwd, boolean force) {
        long start = System.currentTimeMillis();
        if (this.getAuthenticatedUserId() == null) {
            this.authenticatedUserId = this.getAuthenticatedUserId(app_user, app_pwd);
        }
        if (this.getAuthenticatedUserId() == -1) {
            return null;
        }
        KeyNamePair[] retValue = null;
        ArrayList list = new ArrayList();
        int isDefaultId = MColumn.getColumn_ID("AD_User_Roles", "IsDefault");
        String orderBy = "";
        if (isDefaultId > 0) {
            orderBy = "COALESCE(ur.IsDefault,'N') Desc,";
        }
        StringBuilder sql = new StringBuilder("SELECT u.AD_User_ID, r.AD_Role_ID,r.Name,").append(" u.ConnectionProfile ").append("FROM AD_User u").append(" INNER JOIN AD_User_Roles ur ON (u.AD_User_ID=ur.AD_User_ID AND ur.IsActive = 'Y' )").append(" INNER JOIN AD_Role r ON (ur.AD_Role_ID=r.AD_Role_ID AND r.IsActive = 'Y' ) ").append("WHERE u.AD_User_ID = ?").append(" AND u.IsActive = ? ").append(" AND EXISTS (SELECT 1 FROM AD_Client c WHERE u.AD_Client_ID=c.AD_Client_ID AND c.IsActive = ? )");
        sql.append(" ORDER BY ").append(orderBy).append("r.Name");
        List parameters = List.of((Object[])new Object[]{this.authenticatedUserId, true, true});
        Try tryRoles = ((Try)DB.runResultSetFunction.apply(null, (Object)sql.toString(), (Object)parameters, resultSet -> {
            List roles = new ResultSetIterable((ResultSet)resultSet, (CheckedFunction1 & Serializable)row -> Tuple.of((Object)row.getInt("AD_User_ID"), (Object)row.getInt("AD_Role_ID"), (Object)row.getString("Name"), (Object)row.getString("ConnectionProfile"))).toList();
            if (roles.isEmpty()) {
                if (force) {
                    Env.setContext(this.m_ctx, "#AD_User_Name", "System");
                    Env.setContext(this.m_ctx, "#AD_User_ID", "0");
                    Env.setContext(this.m_ctx, "#AD_User_Description", "System Forced Login");
                    Env.setContext(this.m_ctx, "#User_Level", "S  ");
                    Env.setContext(this.m_ctx, "#User_Client", "0");
                    Env.setContext(this.m_ctx, "#User_Org", "0");
                    list.add(new KeyNamePair(0, "System Administrator"));
                } else {
                    log.saveError("UserPwdError", app_user, false);
                }
            } else {
                roles.forEach(user -> {
                    int AD_Role_ID;
                    Env.setContext(this.m_ctx, "#AD_User_Name", app_user);
                    Env.setContext(this.m_ctx, "#AD_User_ID", (Integer)user._1);
                    Env.setContext(this.m_ctx, "#SalesRep_ID", (Integer)user._1);
                    if (Ini.isClient()) {
                        CConnection cc;
                        if (MSystem.isSwingRememberUserAllowed()) {
                            Ini.setProperty("ApplicationUserID", app_user);
                        } else {
                            Ini.setProperty("ApplicationUserID", "");
                        }
                        if (Ini.isPropertyBool("StorePassword") && MSystem.isSwingRememberPasswordAllowed()) {
                            Ini.setProperty("ApplicationPassword", app_pwd);
                        }
                        this.m_connectionProfile = (String)user._4;
                        if (this.m_connectionProfile != null && !(cc = CConnection.get()).getConnectionProfile().equals(this.m_connectionProfile)) {
                            cc.setConnectionProfile(this.m_connectionProfile);
                            Ini.setProperty("Connection", cc.toStringLong());
                            Ini.saveProperties(false);
                        }
                    }
                    if ((AD_Role_ID = ((Integer)user._2).intValue()) == 0) {
                        Env.setContext(this.m_ctx, "#SysAdmin", "Y");
                    }
                    String Name2 = (String)user._3;
                    KeyNamePair keyNamePair = new KeyNamePair(AD_Role_ID, Name2);
                    list.add(keyNamePair);
                });
            }
        })).onFailure(throwable -> {
            log.log(Level.SEVERE, sql.toString(), (Throwable)throwable);
            log.saveError("DBLogin", (Throwable)throwable);
        });
        if (tryRoles.isFailure()) {
            return null;
        }
        retValue = new KeyNamePair[list.size()];
        list.toArray(retValue);
        long ms = System.currentTimeMillis() - start;
        log.fine("User=" + app_user + " - roles #" + retValue.length + " Start : " + start + " Time  : " + ms);
        return retValue;
    }

    public KeyNamePair[] getRoles(MUser userLogin) {
        long start = System.currentTimeMillis();
        String app_user = userLogin.getValue();
        if (this.getAuthenticatedUserId() == null) {
            this.authenticatedUserId = userLogin.get_ID();
        }
        if (this.getAuthenticatedUserId() == -1) {
            return null;
        }
        KeyNamePair[] retValue = null;
        ArrayList list = new ArrayList();
        int isDefaultId = MColumn.getColumn_ID("AD_User_Roles", "IsDefault");
        String orderBy = "";
        if (isDefaultId > 0) {
            orderBy = "COALESCE(ur.IsDefault,'N') Desc,";
        }
        StringBuilder sql = new StringBuilder("SELECT u.AD_User_ID, r.AD_Role_ID,r.Name,").append(" u.ConnectionProfile ").append("FROM AD_User u").append(" INNER JOIN AD_User_Roles ur ON (u.AD_User_ID=ur.AD_User_ID AND ur.IsActive = 'Y' )").append(" INNER JOIN AD_Role r ON (ur.AD_Role_ID=r.AD_Role_ID AND r.IsActive = 'Y' ) ").append("WHERE u.AD_User_ID = ?").append(" AND u.IsActive = ? ").append(" AND EXISTS (SELECT 1 FROM AD_Client c WHERE u.AD_Client_ID=c.AD_Client_ID AND c.IsActive = ? )");
        sql.append(" ORDER BY ").append(orderBy).append("r.Name");
        List parameters = List.of((Object[])new Object[]{this.authenticatedUserId, true, true});
        Try tryRoles = ((Try)DB.runResultSetFunction.apply(null, (Object)sql.toString(), (Object)parameters, resultSet -> {
            List roles = new ResultSetIterable((ResultSet)resultSet, (CheckedFunction1 & Serializable)row -> Tuple.of((Object)row.getInt("AD_User_ID"), (Object)row.getInt("AD_Role_ID"), (Object)row.getString("Name"), (Object)row.getString("ConnectionProfile"))).toList();
            roles.forEach(user -> {
                int AD_Role_ID;
                Env.setContext(this.m_ctx, "#AD_User_Name", app_user);
                Env.setContext(this.m_ctx, "#AD_User_ID", (Integer)user._1);
                Env.setContext(this.m_ctx, "#SalesRep_ID", (Integer)user._1);
                if (Ini.isClient()) {
                    CConnection cc;
                    if (MSystem.isSwingRememberUserAllowed()) {
                        Ini.setProperty("ApplicationUserID", app_user);
                    } else {
                        Ini.setProperty("ApplicationUserID", "");
                    }
                    this.m_connectionProfile = (String)user._4;
                    if (this.m_connectionProfile != null && !(cc = CConnection.get()).getConnectionProfile().equals(this.m_connectionProfile)) {
                        cc.setConnectionProfile(this.m_connectionProfile);
                        Ini.setProperty("Connection", cc.toStringLong());
                        Ini.saveProperties(false);
                    }
                }
                if ((AD_Role_ID = ((Integer)user._2).intValue()) == 0) {
                    Env.setContext(this.m_ctx, "#SysAdmin", "Y");
                }
                String Name2 = (String)user._3;
                KeyNamePair keyNamePair = new KeyNamePair(AD_Role_ID, Name2);
                list.add(keyNamePair);
            });
        })).onFailure(throwable -> {
            log.log(Level.SEVERE, sql.toString(), (Throwable)throwable);
            log.saveError("DBLogin", (Throwable)throwable);
        });
        if (tryRoles.isFailure()) {
            return null;
        }
        retValue = new KeyNamePair[list.size()];
        list.toArray(retValue);
        long ms = System.currentTimeMillis() - start;
        log.fine("User=" + app_user + " - roles #" + retValue.length + " Start : " + start + " Time  : " + ms);
        return retValue;
    }

    public KeyNamePair[] getClients(KeyNamePair role) {
        if (role == null) {
            throw new IllegalArgumentException("Role missing");
        }
        ArrayList list = new ArrayList();
        KeyNamePair[] retValue = null;
        String sql = "SELECT DISTINCT r.UserLevel, r.ConnectionProfile,  c.AD_Client_ID,c.Name FROM AD_Role r INNER JOIN AD_Client c ON (r.AD_Client_ID=c.AD_Client_ID) WHERE r.AD_Role_ID = ?  AND r.IsActive = ? AND c.IsActive = ? ";
        List parameters = List.of((Object[])new Object[]{role.getKey(), true, true});
        Try tryRole = ((Try)DB.runResultSetFunction.apply(null, (Object)"SELECT DISTINCT r.UserLevel, r.ConnectionProfile,  c.AD_Client_ID,c.Name FROM AD_Role r INNER JOIN AD_Client c ON (r.AD_Client_ID=c.AD_Client_ID) WHERE r.AD_Role_ID = ?  AND r.IsActive = ? AND c.IsActive = ? ", (Object)parameters, resultSet -> {
            List roles = new ResultSetIterable((ResultSet)resultSet, (CheckedFunction1 & Serializable)row -> Tuple.of((Object)row.getString("UserLevel"), (Object)row.getString("ConnectionProfile"), (Object)row.getInt("AD_Client_ID"), (Object)row.getString("Name"))).toList();
            if (roles.isEmpty()) {
                log.log(Level.SEVERE, "No Clients for Role: " + role.toStringX());
            } else {
                roles.forEach(row -> {
                    Env.setContext(this.m_ctx, "#AD_Role_ID", role.getKey());
                    Env.setContext(this.m_ctx, "#AD_Role_Name", role.getName());
                    Ini.setProperty("Role", role.getName());
                    Env.setContext(this.m_ctx, "#User_Level", (String)row._1);
                    CConnection cc = CConnection.get();
                    if (this.m_connectionProfile == null) {
                        this.m_connectionProfile = (String)row._2;
                        if (this.m_connectionProfile != null && !cc.getConnectionProfile().equals(this.m_connectionProfile)) {
                            cc.setConnectionProfile(this.m_connectionProfile);
                            Ini.setProperty("Connection", cc.toStringLong());
                            Ini.saveProperties(false);
                        }
                    }
                    int AD_Client_ID = (Integer)row._3;
                    String Name2 = (String)row._4;
                    KeyNamePair keyNamePair = new KeyNamePair(AD_Client_ID, Name2);
                    list.add(keyNamePair);
                });
            }
        })).onFailure(throwable -> log.log(Level.SEVERE, "SELECT DISTINCT r.UserLevel, r.ConnectionProfile,  c.AD_Client_ID,c.Name FROM AD_Role r INNER JOIN AD_Client c ON (r.AD_Client_ID=c.AD_Client_ID) WHERE r.AD_Role_ID = ?  AND r.IsActive = ? AND c.IsActive = ? ", (Throwable)throwable));
        if (tryRole.isFailure()) {
            return null;
        }
        retValue = new KeyNamePair[list.size()];
        list.toArray(retValue);
        log.fine("Role: " + role.toStringX() + " - clients #" + retValue.length);
        return retValue;
    }

    public KeyNamePair[] getOrgs(KeyNamePair client) {
        if (client == null) {
            throw new IllegalArgumentException("Client missing");
        }
        if (Env.getContext(this.m_ctx, "#AD_Role_ID").length() == 0) {
            throw new UnsupportedOperationException("Missing Context #AD_Role_ID");
        }
        int AD_Role_ID = Env.getContextAsInt(this.m_ctx, "#AD_Role_ID");
        int AD_User_ID = Env.getContextAsInt(this.m_ctx, "#AD_User_ID");
        ArrayList list = new ArrayList();
        KeyNamePair[] retValue = null;
        String sql = "SELECT o.AD_Org_ID,o.Name,o.IsSummary FROM AD_Role r, AD_Client c INNER JOIN AD_Org o ON (c.AD_Client_ID=o.AD_Client_ID OR o.AD_Org_ID=0) WHERE r.AD_Role_ID = ? AND c.AD_Client_ID = ? AND o.IsActive = ? AND o.IsSummary = ?  AND (r.IsAccessAllOrgs = ? OR (r.IsUseUserOrgAccess = ?  AND o.AD_Org_ID IN (SELECT AD_Org_ID FROM AD_Role_OrgAccess ra WHERE ra.AD_Role_ID=r.AD_Role_ID AND ra.IsActive = ? )) OR (r.IsUseUserOrgAccess = ? AND o.AD_Org_ID IN (SELECT AD_Org_ID FROM AD_User_OrgAccess ua WHERE ua.AD_User_ID = ? AND ua.IsActive = ? ))) ORDER BY o.Name";
        List parameters = List.of((Object[])new Object[]{AD_Role_ID, client.getKey(), true, false, true, false, true, true, AD_User_ID, true});
        Try tryRole = ((Try)DB.runResultSetFunction.apply(null, (Object)"SELECT o.AD_Org_ID,o.Name,o.IsSummary FROM AD_Role r, AD_Client c INNER JOIN AD_Org o ON (c.AD_Client_ID=o.AD_Client_ID OR o.AD_Org_ID=0) WHERE r.AD_Role_ID = ? AND c.AD_Client_ID = ? AND o.IsActive = ? AND o.IsSummary = ?  AND (r.IsAccessAllOrgs = ? OR (r.IsUseUserOrgAccess = ?  AND o.AD_Org_ID IN (SELECT AD_Org_ID FROM AD_Role_OrgAccess ra WHERE ra.AD_Role_ID=r.AD_Role_ID AND ra.IsActive = ? )) OR (r.IsUseUserOrgAccess = ? AND o.AD_Org_ID IN (SELECT AD_Org_ID FROM AD_User_OrgAccess ua WHERE ua.AD_User_ID = ? AND ua.IsActive = ? ))) ORDER BY o.Name", (Object)parameters, resultSet -> {
            List roles = new ResultSetIterable((ResultSet)resultSet, (CheckedFunction1 & Serializable)row -> Tuple.of((Object)row.getInt("AD_Org_ID"), (Object)row.getString("Name"), (Object)row.getBoolean("IsSummary"))).toList();
            if (roles.isEmpty()) {
                log.log(Level.WARNING, "No Org for Client: " + client.toStringX() + ", AD_Role_ID=" + AD_Role_ID + ", AD_User_ID=" + AD_User_ID);
            }
            roles.forEach(row -> {
                int AD_Org_ID = (Integer)row._1;
                String Name2 = (String)row._2;
                boolean summary = (Boolean)row._3;
                if (summary) {
                    MRole role = MRole.get(this.m_ctx, AD_Role_ID);
                    this.getOrgsAddSummary(list, AD_Org_ID, Name2, role);
                } else {
                    KeyNamePair keyNamePair = new KeyNamePair(AD_Org_ID, Name2);
                    if (!list.contains(keyNamePair)) {
                        list.add(keyNamePair);
                    }
                }
            });
        })).onFailure(throwable -> log.log(Level.SEVERE, "SELECT o.AD_Org_ID,o.Name,o.IsSummary FROM AD_Role r, AD_Client c INNER JOIN AD_Org o ON (c.AD_Client_ID=o.AD_Client_ID OR o.AD_Org_ID=0) WHERE r.AD_Role_ID = ? AND c.AD_Client_ID = ? AND o.IsActive = ? AND o.IsSummary = ?  AND (r.IsAccessAllOrgs = ? OR (r.IsUseUserOrgAccess = ?  AND o.AD_Org_ID IN (SELECT AD_Org_ID FROM AD_Role_OrgAccess ra WHERE ra.AD_Role_ID=r.AD_Role_ID AND ra.IsActive = ? )) OR (r.IsUseUserOrgAccess = ? AND o.AD_Org_ID IN (SELECT AD_Org_ID FROM AD_User_OrgAccess ua WHERE ua.AD_User_ID = ? AND ua.IsActive = ? ))) ORDER BY o.Name", (Throwable)throwable));
        if (tryRole.isFailure()) {
            return null;
        }
        Env.setContext(this.m_ctx, "#AD_Client_ID", client.getKey());
        Env.setContext(this.m_ctx, "#AD_Client_Name", client.getName());
        Ini.setProperty("Client", client.getName());
        retValue = new KeyNamePair[list.size()];
        list.toArray(retValue);
        log.fine("Client: " + client.toStringX() + ", AD_Role_ID=" + AD_Role_ID + ", AD_User_ID=" + AD_User_ID + " - orgs #" + retValue.length);
        return retValue;
    }

    private void getOrgsAddSummary(ArrayList<KeyNamePair> list, int Summary_Org_ID, String Summary_Name, MRole role) {
        if (role == null) {
            log.warning("Summary Org=" + Summary_Name + "(" + Summary_Org_ID + ") - No Role");
            return;
        }
        if (role.getAD_Tree_Org_ID() == 0) {
            log.config("Summary Org=" + Summary_Name + "(" + Summary_Org_ID + ") - No Org Tree: " + role);
            return;
        }
        MTree tree = MTree.get(this.m_ctx, role.getAD_Tree_Org_ID(), null);
        String sql = "SELECT AD_Client_ID, AD_Org_ID, Name, IsSummary FROM AD_Org WHERE IsActive = ?  AND AD_Org_ID IN (SELECT Node_ID FROM " + tree.getNodeTableName() + " WHERE AD_Tree_ID=? AND Parent_ID=? AND IsActive = ? ) ORDER BY Name";
        List parameters = List.of((Object[])new Object[]{true, tree.getAD_Tree_ID(), Summary_Org_ID, true});
        Try tryOrganization = ((Try)DB.runResultSetFunction.apply(null, (Object)sql, (Object)parameters, resultSet -> {
            while (resultSet.next()) {
                int AD_Client_ID = resultSet.getInt("AD_Client_ID");
                int AD_Org_ID = resultSet.getInt("AD_Org_ID");
                String Name2 = resultSet.getString("Name");
                boolean summary = "Y".equals(resultSet.getString("IsSummary"));
                if (summary) {
                    this.getOrgsAddSummary(list, AD_Org_ID, Name2, role);
                    continue;
                }
                KeyNamePair keyNamePair = new KeyNamePair(AD_Org_ID, Name2);
                if (list.contains(keyNamePair)) continue;
                list.add(keyNamePair);
            }
        })).onFailure(throwable -> log.log(Level.SEVERE, sql, (Throwable)throwable));
    }

    public KeyNamePair[] getWarehouses(KeyNamePair organization) {
        if (organization == null) {
            throw new IllegalArgumentException("Org missing");
        }
        ArrayList list = new ArrayList();
        KeyNamePair[] retValue = null;
        String sql = "SELECT M_Warehouse_ID, Name FROM M_Warehouse WHERE AD_Org_ID=? AND IsActive = ?  AND IsInTransit = ? ORDER BY Name";
        List parameters = List.of((Object[])new Object[]{organization.getKey(), true, false});
        Try tryWarehouse = ((Try)DB.runResultSetFunction.apply(null, (Object)sql, (Object)parameters, resultSet -> {
            List warehouses = new ResultSetIterable((ResultSet)resultSet, (CheckedFunction1 & Serializable)row -> Tuple.of((Object)resultSet.getInt("M_Warehouse_ID"), (Object)resultSet.getString("Name"))).toList();
            if (warehouses.isEmpty()) {
                log.info("No Warehouses for Org: " + organization.toStringX());
            }
            warehouses.forEach(warehouse -> {
                int AD_Warehouse_ID = (Integer)warehouse._1;
                String Name2 = (String)warehouse._2;
                KeyNamePair keyNamePair = new KeyNamePair(AD_Warehouse_ID, Name2);
                list.add(keyNamePair);
            });
        })).onFailure(throwable -> log.log(Level.SEVERE, "getWarehouses", (Throwable)throwable));
        if (tryWarehouse.isFailure()) {
            return null;
        }
        retValue = new KeyNamePair[list.size()];
        list.toArray(retValue);
        log.fine("Org: " + organization.toStringX() + " - warehouses #" + retValue.length);
        return retValue;
    }

    public String validateLogin(KeyNamePair org) {
        int AD_Client_ID = Env.getAD_Client_ID(this.m_ctx);
        int AD_Org_ID = org.getKey();
        int AD_Role_ID = Env.getAD_Role_ID(this.m_ctx);
        int AD_User_ID = Env.getAD_User_ID(this.m_ctx);
        String error = ModelValidationEngine.get().loginComplete(AD_Client_ID, AD_Org_ID, AD_Role_ID, AD_User_ID);
        if (error != null && error.length() > 0) {
            log.severe("Refused: " + error);
            return error;
        }
        return null;
    }

    public String loadPreferences(KeyNamePair org, KeyNamePair warehouse, Timestamp timestamp, String printerName) {
        log.info("Org: " + org.toStringX());
        if (this.m_ctx == null || org == null) {
            throw new IllegalArgumentException("Required parameter missing");
        }
        if (Env.getContext(this.m_ctx, "#AD_Client_ID").length() == 0) {
            throw new UnsupportedOperationException("Missing Context #AD_Client_ID");
        }
        if (Env.getContext(this.m_ctx, "#AD_User_ID").length() == 0) {
            throw new UnsupportedOperationException("Missing Context #AD_User_ID");
        }
        if (Env.getContext(this.m_ctx, "#AD_Role_ID").length() == 0) {
            throw new UnsupportedOperationException("Missing Context #AD_Role_ID");
        }
        Env.setContext(this.m_ctx, "#AD_Org_ID", org.getKey());
        Env.setContext(this.m_ctx, "#AD_Org_Name", org.getName());
        Ini.setProperty("Organization", org.getName());
        if (warehouse != null) {
            Env.setContext(this.m_ctx, "#M_Warehouse_ID", warehouse.getKey());
            Ini.setProperty("Warehouse", warehouse.getName());
        }
        long today = System.currentTimeMillis();
        if (timestamp != null) {
            today = timestamp.getTime();
        }
        Env.setContext(this.m_ctx, "#Date", new Timestamp(today));
        if (printerName == null) {
            printerName = "";
        }
        Env.setContext(this.m_ctx, "#Printer", printerName);
        Ini.setProperty("Printer", printerName);
        MRole.getDefault(this.m_ctx, true);
        Env.setAutoCommit(this.m_ctx, Ini.isPropertyBool("AutoCommit"));
        Env.setAutoNew(this.m_ctx, Ini.isPropertyBool("AutoNew"));
        if (MRole.getDefault(this.m_ctx, false).isShowAcct()) {
            Env.setContext(this.m_ctx, "#ShowAcct", Ini.getProperty("ShowAcct"));
        } else {
            Env.setContext(this.m_ctx, "#ShowAcct", "N");
        }
        Env.setContext(this.m_ctx, "#ShowTrl", Ini.getProperty("ShowTrl"));
        Env.setContext(this.m_ctx, "#ShowAdvanced", Ini.getProperty("ShowAdvanced"));
        AtomicReference<String> retValue = new AtomicReference<String>("");
        int clientId = Env.getContextAsInt(this.m_ctx, "#AD_Client_ID");
        int organizationId = org.getKey();
        int userId = Env.getContextAsInt(this.m_ctx, "#AD_User_ID");
        int roleId = Env.getContextAsInt(this.m_ctx, "#AD_Role_ID");
        Env.setContext(this.m_ctx, "#YYYY", "Y");
        Env.setContext(this.m_ctx, "#StdPrecision", 2);
        String sql = "SELECT C_AcctSchema_ID , C_Currency_ID , HasAlias FROM C_AcctSchema a, AD_ClientInfo c WHERE a.C_AcctSchema_ID=c.C_AcctSchema1_ID AND c.AD_Client_ID=?";
        List parameters = List.of((Object)clientId);
        Try tryAcctSchema = ((Try)DB.runResultSetFunction.apply(null, (Object)"SELECT C_AcctSchema_ID , C_Currency_ID , HasAlias FROM C_AcctSchema a, AD_ClientInfo c WHERE a.C_AcctSchema_ID=c.C_AcctSchema1_ID AND c.AD_Client_ID=?", (Object)parameters, resultSet -> {
            List acctSchemas = new ResultSetIterable((ResultSet)resultSet, (CheckedFunction1 & Serializable)row -> Tuple.of((Object)row.getInt("C_AcctSchema_ID"), (Object)row.getInt("C_Currency_ID"), (Object)row.getString("HasAlias"))).toList();
            if (acctSchemas.isEmpty()) {
                if (roleId != 0) {
                    retValue.set("NoValidAcctInfo");
                }
            } else {
                acctSchemas.forEach(acctSchema -> {
                    int acctSchemaId = (Integer)acctSchema._1;
                    Env.setContext(this.m_ctx, "$C_AcctSchema_ID", acctSchemaId);
                    Env.setContext(this.m_ctx, "$C_Currency_ID", (Integer)acctSchema._2);
                    Env.setContext(this.m_ctx, "$HasAlias", (String)acctSchema._3);
                    Object[] clientAcctSchemes = MAcctSchema.getClientAcctSchema(Env.getCtx(), clientId);
                    if (clientAcctSchemes != null && clientAcctSchemes.length > 1) {
                        acctSchemaId = (Integer)List.of((Object[])clientAcctSchemes).filter(accountSchema -> accountSchema.getAD_OrgOnly_ID() != 0 && !accountSchema.isSkipOrg(organizationId)).map(accountSchema -> {
                            Env.setContext(this.m_ctx, "$C_AcctSchema_ID", accountSchema.getC_AcctSchema_ID());
                            Env.setContext(this.m_ctx, "$C_Currency_ID", accountSchema.getC_Currency_ID());
                            Env.setContext(this.m_ctx, "$HasAlias", accountSchema.isHasAlias());
                            return accountSchema.getC_AcctSchema_ID();
                        }).getOrElse((Object)MClientInfo.get(Env.getCtx(), clientId).getC_AcctSchema1_ID());
                    }
                    List acctSchemaElements = List.ofAll(new Query(this.m_ctx, "C_AcctSchema_Element", " C_AcctSchema_ID = ?", null).setOnlyActiveRecords(true).setParameters(acctSchemaId).list());
                    acctSchemaElements.forEach(acctSchemaElement -> Env.setContext(this.m_ctx, "$Element_" + acctSchemaElement.getElementType(), "Y"));
                    String whereClause = "AD_Client_ID IN (0, @#AD_Client_ID@) AND AD_Org_ID IN (0, @#AD_Org_ID@) AND (AD_User_ID IS NULL OR AD_User_ID=0 OR AD_User_ID=@#AD_User_ID@)";
                    String whereClauseFinal = Env.parseContext(this.m_ctx, 0, "AD_Client_ID IN (0, @#AD_Client_ID@) AND AD_Org_ID IN (0, @#AD_Org_ID@) AND (AD_User_ID IS NULL OR AD_User_ID=0 OR AD_User_ID=@#AD_User_ID@)", false);
                    if (whereClauseFinal.length() == 0) {
                        log.log(Level.SEVERE, "loadPreferences - Missing Environment");
                    } else {
                        List preferences = List.ofAll(new Query(this.m_ctx, "AD_Preference", whereClauseFinal, null).setOnlyActiveRecords(true).setOrderBy("Attribute, AD_Client_ID, AD_User_ID DESC, AD_Org_ID").list());
                        preferences.forEach(preference -> {
                            int windowId = preference.getAD_Window_ID();
                            Object at = "";
                            at = windowId == 0 ? "P|" + preference.getAttribute() : "P" + windowId + "|" + preference.getAttribute();
                            String value = preference.getValue();
                            Env.setContext(this.m_ctx, (String)at, value);
                        });
                        String columnsSelect = "SELECT t.TableName, c.ColumnName FROM AD_Column c  INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID) WHERE c.IsKey = ? AND t.IsActive = ?  AND EXISTS (SELECT * FROM AD_Column cc  WHERE ColumnName = 'IsDefault' AND t.AD_Table_ID=cc.AD_Table_ID AND cc.IsActive = ? )";
                        List parametersColumnsSelect = List.of((Object[])new Object[]{true, true, true});
                        Try try_ = ((Try)DB.runResultSetFunction.apply(null, (Object)"SELECT t.TableName, c.ColumnName FROM AD_Column c  INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID) WHERE c.IsKey = ? AND t.IsActive = ?  AND EXISTS (SELECT * FROM AD_Column cc  WHERE ColumnName = 'IsDefault' AND t.AD_Table_ID=cc.AD_Table_ID AND cc.IsActive = ? )", (Object)parametersColumnsSelect, resultSet1 -> {
                            while (resultSet1.next()) {
                                this.loadDefault(resultSet1.getString("TableName"), resultSet1.getString("ColumnName"));
                            }
                        })).onFailure(throwable -> log.log(Level.SEVERE, "loadPreferences", (Throwable)throwable));
                    }
                });
            }
        })).onFailure(throwable -> {
            log.log(Level.SEVERE, "loadPreferences", (Throwable)throwable);
            retValue.set(throwable.getMessage());
        });
        Ini.saveProperties(Ini.isClient());
        Env.setContext(this.m_ctx, "#C_Country_ID", MCountry.getDefault(this.m_ctx).getC_Country_ID());
        ModelValidationEngine.get().afterLoadPreferences(this.m_ctx);
        return retValue.get();
    }

    private void loadDefault(String TableName, String ColumnName) {
        if (TableName.startsWith("AD_Window") || TableName.startsWith("AD_PrintFormat") || TableName.startsWith("AD_Workflow")) {
            return;
        }
        String sql = "SELECT " + ColumnName + " FROM " + TableName + " WHERE IsDefault = ? AND IsActive = ? ORDER BY AD_Client_ID DESC, AD_Org_ID DESC";
        String sqlAccess = MRole.getDefault(this.m_ctx, false).addAccessSQL(sql, TableName, false, false);
        List parameters = List.of((Object[])new Object[]{true, true});
        Try tryLoadDefaultValue = ((Try)DB.runResultSetFunction.apply(null, (Object)sqlAccess, (Object)parameters, resultSet -> {
            String value;
            if (resultSet.next() && (value = resultSet.getString(ColumnName)) != null && value.length() != 0) {
                if (TableName.equals("C_DocType")) {
                    Env.setContext(this.m_ctx, "#C_DocTypeTarget_ID", value);
                } else {
                    Env.setContext(this.m_ctx, "#" + ColumnName, value);
                }
            }
        })).onFailure(throwable -> log.log(Level.SEVERE, "loadPreferences", (Throwable)throwable));
    }

    public boolean batchLogin(Timestamp loginDate) {
        int i2;
        int i3;
        int i4;
        int i5;
        String pwd;
        String uid = Ini.getProperty("ApplicationUserID");
        KeyNamePair[] roles = this.getRoles(uid, pwd = Ini.getProperty("ApplicationPassword"));
        if (roles == null || roles.length == 0) {
            log.severe("User/Password invalid: " + uid);
            return false;
        }
        log.info("User: " + uid);
        String role = Ini.getProperty("Role");
        KeyNamePair rolePP = null;
        for (i5 = 0; i5 < roles.length; ++i5) {
            KeyNamePair pair = roles[i5];
            if (!pair.getName().equalsIgnoreCase(role)) continue;
            rolePP = pair;
            break;
        }
        if (rolePP == null) {
            log.severe("Role invalid: " + role);
            for (i5 = 0; i5 < roles.length; ++i5) {
                log.info("Option: " + roles[i5]);
            }
            return false;
        }
        log.info("Role: " + role);
        String client = Ini.getProperty("Client");
        KeyNamePair[] clients = this.getClients(rolePP);
        if (clients == null || clients.length == 0) {
            log.severe("No Clients for Role: " + role);
            return false;
        }
        KeyNamePair clientPP = null;
        for (i4 = 0; i4 < clients.length; ++i4) {
            KeyNamePair pair = clients[i4];
            if (!pair.getName().equalsIgnoreCase(client)) continue;
            clientPP = pair;
            break;
        }
        if (clientPP == null) {
            log.severe("Client invalid: " + client);
            for (i4 = 0; i4 < clients.length; ++i4) {
                log.info("Option: " + clients[i4]);
            }
            return false;
        }
        String org = Ini.getProperty("Organization");
        KeyNamePair[] orgs = this.getOrgs(clientPP);
        if (orgs == null || orgs.length == 0) {
            log.severe("No Orgs for Client: " + client);
            return false;
        }
        KeyNamePair orgPP = null;
        for (i3 = 0; i3 < orgs.length; ++i3) {
            KeyNamePair pair = orgs[i3];
            if (!pair.getName().equalsIgnoreCase(org)) continue;
            orgPP = pair;
            break;
        }
        if (orgPP == null) {
            log.severe("Org invalid: " + org);
            for (i3 = 0; i3 < orgs.length; ++i3) {
                log.info("Option: " + orgs[i3]);
            }
            return false;
        }
        String error = this.validateLogin(orgPP);
        if (error != null && error.length() > 0) {
            return false;
        }
        String wh = Ini.getProperty("Warehouse");
        KeyNamePair[] whs = this.getWarehouses(orgPP);
        if (whs == null || whs.length == 0) {
            log.severe("No Warehouses for Org: " + org);
            return false;
        }
        KeyNamePair whPP = null;
        for (i2 = 0; i2 < whs.length; ++i2) {
            KeyNamePair pair = whs[i2];
            if (!pair.getName().equalsIgnoreCase(wh)) continue;
            whPP = pair;
            break;
        }
        if (whPP == null) {
            log.severe("Warehouse invalid: " + wh);
            for (i2 = 0; i2 < whs.length; ++i2) {
                log.info("Option: " + whs[i2]);
            }
            return false;
        }
        String langName = Ini.getProperty("Language");
        Language language = Language.getLanguage(langName);
        Language.setLoginLanguage(language);
        Env.verifyLanguage(this.m_ctx, language);
        Env.setContext(this.m_ctx, "#AD_Language", language.getAD_Language());
        Locale loc = language.getLocale();
        Locale.setDefault(loc);
        Msg.getMsg(this.m_ctx, "0");
        String printerName = Ini.getProperty("Printer");
        if (loginDate == null) {
            loginDate = new Timestamp(System.currentTimeMillis());
        }
        this.loadPreferences(orgPP, whPP, loginDate, printerName);
        log.info("complete");
        return true;
    }

    public boolean batchLogin() {
        return this.batchLogin(new Timestamp(System.currentTimeMillis()));
    }

    public Principal getPrincipal() {
        return null;
    }

    public Integer getAuthenticatedUserId() {
        return this.authenticatedUserId;
    }
}

