/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wf;

import org.compiere.model.MUser;
import org.compiere.wf.MWFProcess;
import org.compiere.wf.MWFResponsible;
import org.compiere.wf.WFProcessManageAbstract;

public class WFProcessManage
extends WFProcessManageAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MWFProcess workflowProcess = new MWFProcess(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        this.log.info("doIt - " + workflowProcess);
        MUser user = MUser.get(this.getCtx(), this.getAD_User_ID());
        if (this.isAbort()) {
            String processMessage = user.getName() + ": Abort";
            workflowProcess.setTextMsg(processMessage);
            workflowProcess.setAD_User_ID(this.getAD_User_ID());
            workflowProcess.setWFState("CA");
            workflowProcess.saveEx();
            if (workflowProcess.isProcessed()) {
                workflowProcess.unlockDocument();
            }
            return processMessage;
        }
        String userMessage = null;
        if (this.getUserId() != 0 && workflowProcess.getAD_User_ID() != this.getUserId()) {
            MUser userFrom = MUser.get(this.getCtx(), workflowProcess.getAD_User_ID());
            MUser userTo = MUser.get(this.getCtx(), this.getUserId());
            userMessage = user.getName() + ": " + userFrom.getName() + " -> " + userTo.getName();
            workflowProcess.setTextMsg(userMessage);
            workflowProcess.setAD_User_ID(this.getUserId());
        }
        if (this.getWFResponsibleId() != 0 && workflowProcess.getAD_WF_Responsible_ID() != this.getWFResponsibleId()) {
            MWFResponsible responsibleFrom = MWFResponsible.get(this.getCtx(), workflowProcess.getAD_WF_Responsible_ID());
            MWFResponsible responsibleTo = MWFResponsible.get(this.getCtx(), this.getWFResponsibleId());
            String responsibleMessage = user.getName() + ": " + responsibleFrom.getName() + " -> " + responsibleTo.getName();
            workflowProcess.setTextMsg(responsibleMessage);
            workflowProcess.setAD_WF_Responsible_ID(this.getWFResponsibleId());
            userMessage = userMessage == null ? responsibleMessage : userMessage + " - " + responsibleMessage;
        }
        workflowProcess.saveEx();
        return userMessage;
    }
}

