/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Optional;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPayment;
import org.compiere.model.MPriceList;
import org.compiere.util.Msg;
import org.eevolution.process.GenerateInvoiceFromPaymentAbstract;

public class GenerateInvoiceFromPayment
extends GenerateInvoiceFromPaymentAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.getRecord_ID() <= 0) {
            throw new AdempiereException("@Record_ID@ @NotFound@");
        }
        MPayment payment = new MPayment(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if ("CO".equals(payment.getDocStatus()) || "CL".equals(payment.getDocStatus())) {
            if (this.getPayAmt() != null && this.getPayAmt().compareTo(payment.getPayAmt()) > 0) {
                throw new AdempiereException("@C_Payment_ID@ @Amount@ > @PayAmt@");
            }
        } else {
            throw new AdempiereException("@C_Payment_ID@ @DocStatus@ @Invalid@");
        }
        if (this.getBPartnerLocationId() <= 0) {
            throw new AdempiereException("@C_BPartner_Location_ID@ @NotFound@");
        }
        if (payment.isAllocated()) {
            throw new AdempiereException("@C_Payment_ID@ @IsAllocated@");
        }
        if (this.getChargeId() <= 0 && this.getProductId() <= 0) {
            throw new AdempiereException("@C_Payment_ID@ @C_Charge_ID@ @OR@ @C_Payment_ID@ @NotFound@");
        }
        this.generateInvoice(payment);
        return "@Ok@";
    }

    private void generateInvoice(MPayment payment) {
        MInvoice invoice = new MInvoice(this.getCtx(), 0, this.get_TrxName());
        invoice.setAD_Org_ID(payment.getAD_Org_ID());
        invoice.setDateInvoiced(this.getDateInvoiced());
        invoice.setDateAcct(this.getDateAcct());
        invoice.setC_BPartner_ID(payment.getC_BPartner_ID());
        invoice.setC_BPartner_Location_ID(this.getBPartnerLocationId());
        invoice.setAD_User_ID(this.getUserId());
        invoice.setDescription(this.getDescription());
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        Optional<MPriceList> maybePriceList = Optional.ofNullable(MPriceList.getDefault(this.getCtx(), payment.isReversal()));
        maybePriceList.ifPresent(priceList -> invoice.setM_PriceList_ID(priceList.get_ID()));
        invoice.setC_Currency_ID(payment.getC_Currency_ID());
        invoice.setC_ConversionType_ID(payment.getC_ConversionType_ID());
        if (this.getDocTypeTargetId() > 0) {
            invoice.setC_DocTypeTarget_ID(this.getDocTypeTargetId());
        } else {
            String documentBaseType = payment.isReceipt() ? "ARI" : "API";
            Optional<MDocType> maybeDocumentType = Arrays.stream(MDocType.getOfDocBaseType(this.getCtx(), documentBaseType)).findFirst();
            maybeDocumentType.ifPresent(documentType -> invoice.setC_DocTypeTarget_ID());
        }
        invoice.setAD_OrgTrx_ID(payment.getAD_OrgTrx_ID());
        invoice.setC_Campaign_ID(payment.getC_Campaign_ID());
        invoice.setC_Activity_ID(payment.getC_Activity_ID());
        invoice.setC_Project_ID(payment.getC_Project_ID());
        invoice.setC_Payment_ID(payment.get_ID());
        invoice.saveEx();
        this.addLog(Msg.translate(this.getCtx(), "@C_Invoice_ID@ : " + invoice.getDocumentInfo()));
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        if (this.getChargeId() > 0) {
            invoiceLine.setC_Charge_ID(this.getChargeId());
        }
        if (this.getProductId() > 0) {
            invoiceLine.setM_Product_ID(this.getProductId());
        }
        invoiceLine.setQty(BigDecimal.ONE);
        invoiceLine.setPrice(this.getPayAmt());
        invoiceLine.setAD_OrgTrx_ID(payment.getAD_OrgTrx_ID());
        invoiceLine.setC_Campaign_ID(payment.getC_Campaign_ID());
        invoiceLine.setC_Activity_ID(payment.getC_Activity_ID());
        invoiceLine.setC_Project_ID(payment.getC_Project_ID());
        Optional.ofNullable(this.getDescription()).ifPresent(invoiceLine::setDescription);
        invoiceLine.saveEx();
        if (!invoice.processIt("CO")) {
            throw new AdempiereException("@C_Invoice_ID@ @Invalid@ @DocStatus@");
        }
        invoice.saveEx();
        MAllocationHdr allocationHdr = new MAllocationHdr(this.getCtx(), false, payment.getDateTrx(), payment.getC_Currency_ID(), payment.getDescription(), this.get_TrxName());
        allocationHdr.setDateAcct(payment.getDateAcct());
        allocationHdr.setDocStatus("DR");
        allocationHdr.setDocAction("CO");
        allocationHdr.saveEx();
        this.addLog(Msg.translate(this.getCtx(), "@C_AllocationHdr_ID@ : " + allocationHdr.getDocumentInfo()));
        MAllocationLine allocationLine = new MAllocationLine(allocationHdr, payment.getPayAmt(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
        allocationLine.setC_Payment_ID(payment.get_ID());
        allocationLine.setC_Invoice_ID(invoice.getC_Invoice_ID());
        allocationLine.setC_BPartner_ID(payment.getC_BPartner_ID());
        allocationLine.setDateTrx(payment.getDateTrx());
        allocationLine.saveEx();
        if (!allocationHdr.processIt("CO")) {
            throw new AdempiereException("@C_AllocationHdr_ID@ @Invalid@ @DocStatus@");
        }
        allocationHdr.saveEx();
    }
}

