/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MLandedCost;
import org.compiere.model.Query;
import org.eevolution.process.GenerateLandedCostAbstract;

public class GenerateLandedCost
extends GenerateLandedCostAbstract {
    protected List<MInOutLine> records = null;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        String receipts = "";
        if (this.isCreateByProduct()) {
            for (MInOutLine inOutLine : this.getRecords()) {
                this.createLandedCost(null, inOutLine);
                receipts = receipts.concat(inOutLine.getParent().getDocumentNo() + " " + inOutLine.getM_Product().getValue()).concat(" ");
            }
        } else {
            MInOut inOut;
            LinkedHashMap<Integer, MInOut> inOutList = new LinkedHashMap<Integer, MInOut>();
            for (MInOutLine mInOutLine : this.getRecords()) {
                inOut = mInOutLine.getParent();
                if (inOutList.containsKey(inOut.getM_InOut_ID())) continue;
                inOutList.put(inOut.getM_InOut_ID(), inOut);
            }
            for (Map.Entry entry : inOutList.entrySet()) {
                inOut = (MInOut)entry.getValue();
                this.createLandedCost(inOut, null);
                receipts = receipts.concat(inOut.getDocumentNo()).concat(" ");
            }
        }
        return receipts;
    }

    public void createLandedCost(MInOut inOut, MInOutLine inOutLine) {
        MInOut document = inOut;
        if (document == null) {
            document = inOutLine.getParent();
        }
        MLandedCost landedCost = new MLandedCost(this.getCtx(), 0, this.get_TrxName());
        landedCost.setAD_Org_ID(document.getAD_Org_ID());
        landedCost.setC_InvoiceLine_ID(this.getRecord_ID());
        landedCost.setM_InOut_ID(document.getM_InOut_ID());
        landedCost.setDescription(document.getPOReference());
        landedCost.setLandedCostDistribution(this.getLandedCostDistribution());
        landedCost.setM_CostElement_ID(this.getCostElementId());
        landedCost.setC_LandedCostType_ID(this.getLandedCostTypeId());
        if (inOut == null) {
            landedCost.setM_InOutLine_ID(inOutLine.getM_InOutLine_ID());
            landedCost.setM_Product_ID(inOutLine.getM_Product_ID());
        }
        landedCost.saveEx();
    }

    private List<MInOutLine> getRecords() {
        if (this.records != null) {
            return this.records;
        }
        StringBuilder whereClause = new StringBuilder("EXISTS (SELECT T_Selection_ID FROM T_Selection ");
        whereClause.append("WHERE T_Selection.AD_PInstance_ID=? AND T_Selection.T_Selection_ID=M_InOutLine.M_InOutLine_ID ");
        if (this.isCreateByProduct()) {
            whereClause.append("AND NOT EXISTS (SELECT 1 FROM C_LandedCost lc WHERE lc.C_InvoiceLine_ID=? AND lc.M_InOutLine_ID=M_InOutLine.M_InOutLine_ID))");
        } else {
            whereClause.append("AND NOT EXISTS (SELECT 1 FROM C_LandedCost lc WHERE lc.C_InvoiceLine_ID=? AND lc.M_InOut_ID=M_InOutLine.M_InOut_ID)) ");
        }
        this.records = new Query(this.getCtx(), "M_InOutLine", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(this.getAD_PInstance_ID(), this.getRecord_ID()).list();
        return this.records;
    }
}

