/*
 * Decompiled with CFR 0.152.
 */
package org.shw.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MBankStatement;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLocator;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MPriceList;
import org.compiere.model.MProject;
import org.compiere.model.MRole;
import org.compiere.model.MUOMConversion;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutSHW
extends CalloutEngine {
    private boolean steps = false;

    public String payment_Contract_ID(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer contract_ID = (Integer)value;
        if (contract_ID == null || contract_ID == 0) {
            return "";
        }
        MInvoice contract = new MInvoice(Env.getCtx(), (int)contract_ID, null);
        BigDecimal paidamt = DB.getSQLValueBDEx(null, "Select coalesce(sum(payamt), 0) from c_payment where shw_contract_ID=?", contract_ID);
        BigDecimal openAmt = contract.getGrandTotal(false).subtract(paidamt);
        mTab.setValue("PayAmt", (Object)openAmt);
        if (openAmt.compareTo(Env.ZERO) == 0) {
            return "";
        }
        for (MInvoiceLine ivl : contract.getLines()) {
            mTab.setValue("C_Charge_ID", (Object)ivl.getC_Charge_ID());
        }
        return "";
    }

    public String invoiceDocType(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer c_doctype_ID = (Integer)value;
        if (c_doctype_ID == null || c_doctype_ID == 0) {
            return "";
        }
        MDocType dt = new MDocType(Env.getCtx(), c_doctype_ID, null);
        mTab.setValue("isContract", dt.get_Value("isContract"));
        return "";
    }

    public String test(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Object A_Value = value;
        GridField A_Field = mField;
        GridTab A_Tab = mTab;
        Properties A_Ctx = ctx;
        if (this.isCalloutActive() || A_Value == null) {
            return "";
        }
        int C_DocType_ID = Env.getContextAsInt(A_Ctx, "0|C_DocType_Target_ID");
        Integer C_Activity_ID = (Integer)A_Value;
        ArrayList params = new ArrayList();
        return "";
    }

    public String updateVendorPrice(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        Integer M_Product_ID = (Integer)value;
        if (Env.getContext(ctx, "0|IsSOTrx").equals("Y")) {
            return "";
        }
        int C_BPartner_ID = Env.getContextAsInt(ctx, WindowNo, "C_BPartner_ID");
        StringBuffer sql = new StringBuffer("select ");
        sql.append("PriceLastInv from m_product_PO where M_Product_ID=? ");
        sql.append(" and c_bpartner_ID =" + C_BPartner_ID);
        sql.append(" and isactive = 'Y' and discontinued = 'N' ");
        BigDecimal pricelastInv = DB.getSQLValueBD(null, sql.toString(), M_Product_ID);
        if (pricelastInv == null) {
            return "";
        }
        if (pricelastInv.compareTo(Env.ZERO) != 0) {
            mTab.setValue("PriceLastInv", (Object)pricelastInv);
        }
        return "";
    }

    public String locator_Org(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        Integer M_Locator_ID = (Integer)value;
        MLocator loc = new MLocator(ctx, M_Locator_ID, null);
        mTab.setValue("AD_Org_ID", (Object)loc.getAD_Org_ID());
        return "";
    }

    public String DT_Org(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        return "";
    }

    public String ProjectweightVolume(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal WeightEntered = (BigDecimal)mTab.getValue("WeightEntered");
        BigDecimal VolumeEntered = (BigDecimal)mTab.getValue("VolumeEntered");
        Integer C_Project_Parent_ID = (Integer)mTab.getValue("C_Project_Parent_ID");
        Integer C_UOM_ID = (Integer)mTab.getValue("C_UOM_ID");
        Integer C_UOM_Volume_ID = (Integer)mTab.getValue("C_UOM_Volume_ID");
        Boolean IsSummary = (Boolean)mTab.getValue("IsSummary");
        if (C_Project_Parent_ID == null || C_Project_Parent_ID == 0) {
            if (IsSummary.booleanValue()) {
                return "";
            }
            mTab.setValue("Weight", mTab.getValue("WeightEntered"));
            mTab.setValue("Volume", mTab.getValue("VolumeEntered"));
            return "";
        }
        MProject parent = new MProject(ctx, C_Project_Parent_ID, null);
        BigDecimal rateWeight = MUOMConversion.convert(C_UOM_ID, parent.get_ValueAsInt("C_UOM_ID"), WeightEntered, true);
        BigDecimal rateVolume = MUOMConversion.convert(C_UOM_Volume_ID, parent.get_ValueAsInt("C_UOM_Volume_ID"), VolumeEntered, true);
        mTab.setValue("Weight", (Object)rateWeight);
        mTab.setValue("Volume", (Object)rateVolume);
        return "";
    }

    public String IsSalesOrderInmediate(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Object A_Value = value;
        Properties A_Ctx = ctx;
        int A_WindowNo = WindowNo;
        GridTab A_Tab = mTab;
        Boolean activeCallout = A_Tab != null ? A_Tab.getActiveCallouts().length > 1 : false;
        if (activeCallout.booleanValue() || A_Value == null) {
            return "";
        }
        Integer M_Product_ID = (Integer)A_Tab.getValue("M_Product_ID");
        Integer C_DocTypeTarget_ID = Env.getContextAsInt(A_Ctx, A_WindowNo, "C_DocTypeTarget_ID");
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        if (C_DocTypeTarget_ID != 1000453 && C_DocTypeTarget_ID != 1000452 && C_DocTypeTarget_ID != 1000443 && C_DocTypeTarget_ID != 1000444) {
            return "";
        }
        Integer C_Project_ID = Env.getContextAsInt(A_Ctx, A_WindowNo, "C_Project_ID");
        MProject project = new MProject(A_Ctx, C_Project_ID, null);
        Integer C_B_Partner_ID = project.getC_BPartner_ID();
        Integer Provider_ID = Env.getContextAsInt(A_Ctx, A_WindowNo, "0|C_BPartner_ID");
        int LG_Route_ID = project.get_ValueAsInt("LG_Route_ID");
        StringBuffer sql = new StringBuffer("select coalesce(po.isSalesOrderImmediate, p.isSalesOrderImmediate) ");
        sql.append(" from m_product p ");
        sql.append(" left join m_product_PO  po on p.m_product_ID = po.m_product_ID and po.c_bpartner_ID =?");
        sql.append("  left join c_bpartner_product  bpp on p.m_product_ID = bpp.m_product_ID and po.c_bpartner_ID =? ");
        sql.append(" left join lg_route_Product   rp on p.m_product_ID = rp.m_product_ID and rp.lg_route_ID =?");
        sql.append("  where p.m_product_ID =?");
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(Provider_ID);
        params.add(C_B_Partner_ID);
        params.add(LG_Route_ID);
        params.add(M_Product_ID);
        String result = DB.getSQLValueStringEx(null, sql.toString(), params.toArray());
        boolean isSalesOrderImmediate = "Y".equals(result);
        A_Tab.setValue("isSalesOrderImmediate", (Object)isSalesOrderImmediate);
        return "";
    }

    public String BankAccount(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        GridTab A_Tab = mTab;
        Object A_Value = value;
        Properties A_Ctx = ctx;
        Integer C_BankAccount_ID = (Integer)A_Tab.getValue("C_BankAccount_ID");
        Integer C_BankStatement_ID = (Integer)A_Tab.getValue("C_BankStatement_ID");
        Timestamp StatementDate = (Timestamp)mTab.getValue("StatementDate");
        if (C_BankAccount_ID == 0 || C_BankAccount_ID == null || StatementDate == null) {
            return "";
        }
        ArrayList<Comparable<Integer>> params = new ArrayList<Comparable<Integer>>();
        params.add(C_BankAccount_ID);
        params.add(StatementDate);
        params.add(C_BankStatement_ID);
        String whereClause = "C_Bankaccount_ID = ? and docstatus = 'CO' and StatementDate <=? and c_bankstatement_ID <>?";
        MBankStatement bs = (MBankStatement)new Query(A_Ctx, "C_BankStatement", whereClause, null).setParameters(params.toArray()).setOrderBy("statementdate desc, c_Bankstatement_ID desc").first();
        A_Tab.setValue("BeginningBalance", (Object)bs.getEndingBalance());
        return "";
    }

    public String Skonto(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        GridTab A_Tab = mTab;
        Object A_Value = value;
        Properties A_Ctx = ctx;
        Integer M_Product_ID = (Integer)A_Tab.getValue("M_Product_ID");
        Integer C_Charge_ID = (Integer)A_Tab.getValue("C_Charge_ID");
        if (!(M_Product_ID != null && M_Product_ID != 0 || C_Charge_ID != null && C_Charge_ID != 0)) {
            return "";
        }
        int C_PaymentTerm_ID = Env.getContextAsInt(A_Ctx, WindowNo + "|0|C_PaymentTerm_ID");
        int C_DocType_ID = Env.getContextAsInt(A_Ctx, WindowNo + "|0|C_DocTypeTarget_ID");
        MDocType dt = new MDocType(A_Ctx, C_DocType_ID, null);
        if (!dt.getDocSubTypeSO().equals("WR")) {
            return "";
        }
        MPaymentTerm pt = new MPaymentTerm(A_Ctx, C_PaymentTerm_ID, null);
        if (pt.getDiscount().compareTo(Env.ZERO) != 0) {
            BigDecimal LineNetAmt;
            boolean enforce;
            BigDecimal discount = (BigDecimal)A_Tab.getValue("Discount");
            discount = discount.add(pt.getDiscount());
            A_Tab.setValue("Discount", (Object)discount);
            int C_UOM_To_ID = Env.getContextAsInt(ctx, WindowNo, "C_UOM_ID");
            BigDecimal PriceEntered = (BigDecimal)mTab.getValue("PriceEntered");
            BigDecimal PriceActual = (BigDecimal)mTab.getValue("PriceActual");
            BigDecimal Discount = (BigDecimal)mTab.getValue("Discount");
            BigDecimal PriceLimit = (BigDecimal)mTab.getValue("PriceLimit");
            BigDecimal PriceList = (BigDecimal)mTab.getValue("PriceList");
            BigDecimal QtyOrdered = (BigDecimal)mTab.getValue("QtyOrdered");
            int M_PriceList_ID = Env.getContextAsInt(ctx, WindowNo, "M_PriceList_ID");
            int StdPrecision = MPriceList.getStandardPrecision(ctx, M_PriceList_ID);
            this.log.fine("PriceList=" + PriceList + ", Limit=" + PriceLimit + ", Precision=" + StdPrecision);
            this.log.fine("PriceEntered=" + PriceEntered + ", Actual=" + PriceActual + ", Discount=" + Discount);
            if (PriceList.doubleValue() != 0.0) {
                PriceActual = new BigDecimal((100.0 - Discount.doubleValue()) / 100.0 * PriceList.doubleValue());
            }
            if ((PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, PriceActual)) == null) {
                PriceEntered = PriceActual;
            }
            mTab.setValue("PriceActual", (Object)PriceActual);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
            String epl = Env.getContext(ctx, WindowNo, "EnforcePriceLimit");
            boolean bl = enforce = Env.isSOTrx(ctx, WindowNo) && epl != null && epl.equals("Y");
            if (enforce && MRole.getDefault().isOverwritePriceLimit()) {
                enforce = false;
            }
            if (enforce && PriceLimit.doubleValue() != 0.0 && PriceActual.compareTo(PriceLimit) < 0) {
                PriceActual = PriceLimit;
                PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, PriceLimit);
                if (PriceEntered == null) {
                    PriceEntered = PriceLimit;
                }
                this.log.fine("(under) PriceEntered=" + PriceEntered + ", Actual" + PriceLimit);
                mTab.setValue("PriceActual", (Object)PriceLimit);
                mTab.setValue("PriceEntered", (Object)PriceEntered);
                mTab.fireDataStatusEEvent("UnderLimitPrice", "", false);
                if (PriceList.intValue() != 0) {
                    Discount = new BigDecimal((PriceList.doubleValue() - PriceActual.doubleValue()) / PriceList.doubleValue() * 100.0);
                    if (Discount.scale() > 2) {
                        Discount = Discount.setScale(2, 4);
                    }
                    mTab.setValue("Discount", (Object)Discount);
                }
            }
            if ((LineNetAmt = QtyOrdered.multiply(PriceActual)).scale() > StdPrecision) {
                LineNetAmt = LineNetAmt.setScale(StdPrecision, 4);
            }
            this.log.info("LineNetAmt=" + LineNetAmt);
            mTab.setValue("LineNetAmt", (Object)LineNetAmt);
        }
        return "";
    }
}

