/*
 * Decompiled with CFR 0.152.
 */
package org.shw.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MUOMConversion;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.shw.model.MLGProductPriceRateLine;
import org.shw.model.X_LG_ProductPriceRate;

public class MLGProductPriceRate
extends X_LG_ProductPriceRate {
    private static final long serialVersionUID = 6181691633960939054L;
    private MLGProductPriceRateLine[] m_lines;

    public MLGProductPriceRate(Properties ctx, int LG_ProductPriceRate_ID, String trxName) {
        super(ctx, LG_ProductPriceRate_ID, trxName);
    }

    public MLGProductPriceRate(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void createQuotation(int C_Bpartner_ID) {
    }

    public MLGProductPriceRateLine[] getLines(boolean requery) {
        if (this.m_lines == null || this.m_lines.length == 0 || requery) {
            this.m_lines = this.getLines("");
        }
        MLGProductPriceRate.set_TrxName(this.m_lines, this.get_TrxName());
        return this.m_lines;
    }

    public MLGProductPriceRateLine[] getLines() {
        return this.getLines(false);
    }

    private MLGProductPriceRateLine[] getLines(String whereClause) {
        Object whereClauseFinal = "LG_ProductPriceRate_ID=? ";
        if (whereClause != "") {
            whereClauseFinal = (String)whereClauseFinal + whereClause;
        }
        List<MLGProductPriceRateLine> list = new Query(this.getCtx(), "LG_ProductPriceRateLine", (String)whereClauseFinal, this.get_TrxName()).setParameters(this.getLG_ProductPriceRate_ID()).setOnlyActiveRecords(true).setOrderBy("BreakValueVolume").list();
        return list.toArray(new MLGProductPriceRateLine[list.size()]);
    }

    public MLGProductPriceRateLine[] getLinesOrderByVolumn(String whereClause) {
        Object whereClauseFinal = "LG_ProductPriceRate_ID=? ";
        if (whereClause != "") {
            whereClauseFinal = (String)whereClauseFinal + "AND " + whereClause;
        }
        List<MLGProductPriceRateLine> list = new Query(this.getCtx(), "LG_ProductPriceRateLine", (String)whereClauseFinal, this.get_TrxName()).setParameters(this.getLG_ProductPriceRate_ID()).setOrderBy("BreakValueVolume desc").list();
        return list.toArray(new MLGProductPriceRateLine[list.size()]);
    }

    public MLGProductPriceRateLine[] getLinesOrderByWeight(String whereClause) {
        Object whereClauseFinal = "LG_ProductPriceRate_ID=? ";
        if (whereClause != "") {
            whereClauseFinal = (String)whereClauseFinal + "AND " + whereClause;
        }
        List<MLGProductPriceRateLine> list = new Query(this.getCtx(), "LG_ProductPriceRateLine", (String)whereClauseFinal, this.get_TrxName()).setParameters(this.getLG_ProductPriceRate_ID()).setOrderBy("BreakValueWeight desc").list();
        return list.toArray(new MLGProductPriceRateLine[list.size()]);
    }

    public static MLGProductPriceRate copyFrom(MLGProductPriceRate from, Timestamp validfrom, boolean isSOTrx, int c_BPartner_ID, String trxName) {
        MLGProductPriceRate to = new MLGProductPriceRate(from.getCtx(), 0, trxName);
        to.set_TrxName(trxName);
        PO.copyValues(from, to, from.getAD_Client_ID(), from.getAD_Org_ID());
        if (c_BPartner_ID != 0) {
            to.setC_BPartner_ID(c_BPartner_ID);
        }
        to.set_Value("isSOTrx", (Object)isSOTrx);
        to.saveEx();
        return to;
    }

    public BigDecimal calculateVolumePrice(int C_UOM_Volume_ID, BigDecimal qtyVolume) {
        BigDecimal volumenPrice = Env.ZERO;
        BigDecimal qtyconverted = qtyVolume;
        for (MLGProductPriceRateLine prl : this.getLinesOrderByVolumn("M_Product_ID=" + this.getM_Product_ID())) {
            if (prl.getC_UOM_Volume_ID() != C_UOM_Volume_ID) {
                qtyconverted = MUOMConversion.convert(C_UOM_Volume_ID, prl.getC_UOM_Volume_ID(), qtyVolume, true);
            }
            if (prl.getBreakValueVolume().compareTo(qtyconverted) == 1) continue;
            volumenPrice = prl.getpriceVolume().multiply(qtyconverted);
            volumenPrice = volumenPrice.compareTo(prl.getMinimumAmt()) == -1 ? prl.getMinimumAmt() : volumenPrice;
        }
        return volumenPrice;
    }

    public BigDecimal calculateWeightPrice(int C_UOM_Weight_ID, BigDecimal qtyweight) {
        BigDecimal weightPrice = Env.ZERO;
        BigDecimal qtyconverted = qtyweight;
        for (MLGProductPriceRateLine prl : this.getLinesOrderByWeight("M_Product_ID=" + this.getM_Product_ID())) {
            if (prl.getC_UOM_Weight_ID() != C_UOM_Weight_ID) {
                qtyconverted = MUOMConversion.convert(C_UOM_Weight_ID, prl.getC_UOM_Weight_ID(), qtyweight, true);
            }
            if (prl.getBreakValueWeight().compareTo(qtyconverted) == 1) continue;
            weightPrice = prl.getPriceWeight().multiply(qtyconverted);
            weightPrice = weightPrice.compareTo(prl.getMinimumAmt()) == -1 ? prl.getMinimumAmt() : weightPrice;
        }
        return weightPrice;
    }

    public int copyLinesFrom(MLGProductPriceRate otherPriceRate) {
        int count = 0;
        for (MLGProductPriceRateLine ppl : otherPriceRate.getLines("")) {
            MLGProductPriceRateLine line = new MLGProductPriceRateLine(this);
            PO.copyValues(ppl, line, this.getAD_Client_ID(), this.getAD_Org_ID());
            line.setLG_ProductPriceRate_ID(this.getLG_ProductPriceRate_ID());
            line.saveEx();
            count = count++;
        }
        return count;
    }
}

