/*
 * Decompiled with CFR 0.152.
 */
package org.shw.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.compiere.model.MOrderLine;
import org.compiere.model.MUOM;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.shw.model.MLGProductPriceRateLine;
import org.shw.model.X_LG_Route;

public class MLGRoute
extends X_LG_Route {
    private static final long serialVersionUID = 6181691633960939054L;

    public MLGRoute(Properties ctx, int LG_Route_ID, String trxName) {
        super(ctx, LG_Route_ID, trxName);
    }

    public MLGRoute(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public Collection<MLGRoute> findRouteByCity(int City_from_ID, int City_To_ID, Timestamp movementdate) {
        StringBuffer whereClause = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        if (City_from_ID > 0) {
            whereClause.append(" AND ").append("LG_CityFrom_ID").append("=?");
            params.add(City_from_ID);
        } else if (City_To_ID > 0) {
            whereClause.append(" AND ").append("LG_CityTo_ID").append("=?");
            params.add(City_To_ID);
        }
        if (movementdate != null) {
            whereClause.append(" AND ").append("ValidFrom").append("<=?");
            params.add(movementdate);
        }
        return new Query(this.getCtx(), "LG_Route", whereClause.toString(), this.get_TrxName()).setParameters(params).list();
    }

    public Collection<MLGRoute> findRouteByRegionOfCity(int Region_from_ID, int Region_To_ID, Timestamp movementdate, Boolean directsearch) {
        StringBuffer whereClause = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        if (!directsearch.booleanValue()) {
            if (Region_from_ID > 0) {
                whereClause.append(" AND LG_CityFrom_ID in (select c_city_ID from LG_Region_City where lg_region_ID=?)");
                params.add(Region_from_ID);
            } else if (Region_To_ID > 0) {
                whereClause.append(" AND LG_CityTo_ID in (select c_city_ID from LG_Region_City where lg_region_ID=?)");
                params.add(Region_To_ID);
            }
        } else if (Region_from_ID > 0) {
            whereClause.append(" AND ").append("LG_RegionFrom_ID").append("=?");
            params.add(Region_from_ID);
        } else if (Region_To_ID > 0) {
            whereClause.append(" AND ").append("LG_RegionTo_ID").append("=?");
            params.add(Region_To_ID);
        }
        if (movementdate != null) {
            whereClause.append(" AND ").append("ValidFrom").append("<=?");
            params.add(movementdate);
        }
        return new Query(this.getCtx(), "LG_Route", whereClause.toString(), this.get_TrxName()).setParameters(params).list();
    }

    public BigDecimal calculatePrice(int M_Product_ID, int C_BPartner_ID, Timestamp ValidFrom, Timestamp ValidTo, int C_UOM_Volume_ID, BigDecimal qtyVolume, int C_UOM_Weight_ID, BigDecimal qtyWeight, StringBuffer description, MOrderLine oLine) {
        BigDecimal volumenPrice = Env.ZERO;
        BigDecimal weightPrice = Env.ZERO;
        BigDecimal minimumPrice = Env.ZERO;
        BigDecimal calculatedPrice = Env.ZERO;
        MUOM uomWeight = new MUOM(this.getCtx(), C_UOM_Weight_ID, this.get_TrxName());
        MUOM uomVolume = new MUOM(this.getCtx(), C_UOM_Volume_ID, this.get_TrxName());
        StringBuffer globalWhereClause = new StringBuffer("");
        ArrayList<Object> globalParameters = new ArrayList<Object>();
        globalWhereClause.append("LG_Route_ID in (select lg_route_ID from lg_route where ");
        globalWhereClause.append("lg_route_ID=? and m_product_ID =? ");
        globalWhereClause.append("and(c_bpartner_ID is null or c_bpartner_ID =?)");
        globalWhereClause.append(" and validFrom <=?");
        globalWhereClause.append(" and (validTo is null or validTo >=?))");
        globalParameters.add(this.get_ID());
        globalParameters.add(M_Product_ID);
        globalParameters.add(C_BPartner_ID);
        globalParameters.add(ValidFrom);
        globalParameters.add(ValidTo);
        volumenPrice = this.calculateVolumePrice(globalWhereClause, globalParameters, C_UOM_Volume_ID, qtyVolume, oLine);
        weightPrice = this.calculateWeightPrice(globalWhereClause, globalParameters, C_UOM_Weight_ID, qtyWeight);
        minimumPrice = this.calculateMinimumPrice(globalWhereClause, globalParameters);
        calculatedPrice = volumenPrice.compareTo(weightPrice) >= 0 ? volumenPrice : weightPrice;
        calculatedPrice = minimumPrice.compareTo(calculatedPrice) > 0 ? minimumPrice : calculatedPrice;
        description.append(" Ruta: " + this.getName() + "\n");
        description.append(" UdM peso: " + uomWeight.getName() + "\n");
        description.append(" Cantidad peso: " + qtyWeight.setScale(2, 4) + "\n");
        description.append(" UdM volumen: " + uomVolume.getName() + "\n");
        description.append(" Cantidad volumen: " + qtyVolume.setScale(2, 4) + "\n");
        description.append(" Precio VOLUMEN: " + volumenPrice.setScale(2, 4) + "\n");
        description.append(" Precio PESO: " + weightPrice.setScale(2, 4) + "\n");
        description.append(" Precio MINIMO: " + minimumPrice.setScale(2, 4) + "\n");
        description.append(" Resultado: " + calculatedPrice.setScale(2, 4) + "\n");
        return calculatedPrice;
    }

    private BigDecimal calculateVolumePrice(StringBuffer globalWhereClause, ArrayList<Object> globalParameters, int C_UOM_Volume_ID, BigDecimal qtyVolume, MOrderLine oLine) {
        StringBuffer whereClauseVolumen = new StringBuffer(globalWhereClause);
        whereClauseVolumen.append(" and BreakValueVolume >? ");
        ArrayList<Object> parametersVolumen = new ArrayList<Object>();
        for (Object par : globalParameters) {
            parametersVolumen.add(par);
        }
        parametersVolumen.add(qtyVolume);
        MLGProductPriceRateLine volumePricerate = (MLGProductPriceRateLine)new Query(this.getCtx(), "LG_ProductPriceRateLine", whereClauseVolumen.toString(), this.get_TrxName()).setOnlyActiveRecords(true).setParameters(parametersVolumen).setOrderBy(" c_Bpartner_ID, BreakValueVolume asc").first();
        BigDecimal volumenPrice = Env.ZERO;
        if (volumePricerate != null) {
            volumenPrice = volumePricerate.getpriceVolume().multiply(qtyVolume);
        }
        if (oLine != null) {
            oLine.set_ValueOfColumn("LG_ProductPriceRate_ID", (Object)volumePricerate.getLG_ProductPriceRate_ID());
        }
        return volumenPrice;
    }

    private BigDecimal calculateWeightPrice(StringBuffer globalWhereClause, ArrayList<Object> globalParameters, int C_UOM_Weight_ID, BigDecimal qtyWeight) {
        StringBuffer whereClauseVolumen = new StringBuffer(globalWhereClause);
        whereClauseVolumen.append(" and BreakValueWeight >? ");
        ArrayList<Object> parametersVolumen = new ArrayList<Object>();
        for (Object par : globalParameters) {
            parametersVolumen.add(par);
        }
        parametersVolumen.add(qtyWeight);
        MLGProductPriceRateLine weightPricerate = (MLGProductPriceRateLine)new Query(this.getCtx(), "LG_ProductPriceRateLine", whereClauseVolumen.toString(), this.get_TrxName()).setOnlyActiveRecords(true).setParameters(parametersVolumen).setOrderBy(" c_Bpartner_ID, BreakValueWeight asc").first();
        BigDecimal weightPrice = Env.ZERO;
        if (weightPricerate != null) {
            weightPrice = weightPricerate.getPriceWeight().multiply(qtyWeight);
        }
        return weightPrice;
    }

    private BigDecimal calculateMinimumPrice(StringBuffer globalWhereClause, ArrayList<Object> globalParameters) {
        StringBuffer whereClauseMinimum = new StringBuffer(globalWhereClause);
        BigDecimal minimumPrice = Env.ZERO;
        whereClauseMinimum.append(" and MinimumAmt > 0");
        MLGProductPriceRateLine minimumPricerate = (MLGProductPriceRateLine)new Query(this.getCtx(), "LG_ProductPriceRate", whereClauseMinimum.toString(), this.get_TrxName()).setOnlyActiveRecords(true).setParameters(globalParameters).setOrderBy(" MinimumAmt desc").first();
        if (minimumPricerate != null) {
            minimumPrice = (BigDecimal)minimumPricerate.get_Value("MinimumAmt");
        }
        return minimumPrice;
    }
}

