/*
 * Decompiled with CFR 0.152.
 */
package org.shw.model;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import org.adempiere.core.domains.models.I_C_BPartner;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.acct.Doc;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MCharge;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentAllocate;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.model.MProject;
import org.compiere.model.MProjectType;
import org.compiere.model.MRequest;
import org.compiere.model.MRole;
import org.compiere.model.MTax;
import org.compiere.model.MTaxCategory;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.shw.model.MLGProductPriceRate;
import org.shw.model.MLGProductPriceRateLine;

public class SAValidatorNEW
implements ModelValidator {
    private CLogger log = CLogger.getCLogger(this.getClass());
    private int m_AD_Client_ID = -1;
    private int m_AD_User_ID = -1;
    private int m_AD_Role_ID = -1;
    Function<Integer, String> converter = num -> Integer.toString(num);
    Runnable r1 = () -> System.out.println("VVV");

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            this.log.info(client.toString());
        } else {
            this.log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Project", this);
        engine.addModelChange("C_AllocationHdr", this);
        engine.addModelChange("C_Order", this);
        engine.addModelChange("C_OrderLine", this);
        engine.addModelChange("C_PaymentAllocate", this);
        engine.addModelChange("R_Request", this);
        engine.addDocValidate("C_Order", this);
        engine.addDocValidate("C_Payment", this);
        engine.addDocValidate("C_AllocationHdr", this);
        engine.addDocValidate("C_Invoice", this);
        engine.addDocValidate("C_BankStatement", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        String error = null;
        if (po.get_TableName().equals("C_Payment")) {
            // empty if block
        }
        if (po.get_TableName().equals("C_OrderLine")) {
            if (type == 1 || type == 2) {
                error = this.orderLine_setLineNetAmt(po);
            }
            if (type == 2) {
                // empty if block
            }
            if (type == 4) {
                error = this.OrderLineUpdateControlAmt(po);
            }
            if (type == 5) {
                error = this.OrderLineUpdateControlAmt(po);
                error = this.updateIsInvoiced(po);
            }
            if (type == 6) {
                // empty if block
            }
            if (type == 3) {
                // empty if block
            }
            if (type == 3) {
                error = this.OLineBeforeDelete(po);
            }
        }
        if (po.get_TableName().equals("C_PaymentAllocate")) {
            // empty if block
        }
        if (po.get_TableName().equals("C_AllocationHdr")) {
            // empty if block
        }
        if (po.get_TableName().equals("C_Project")) {
            if (type == 1 || type == 2) {
                this.projectBeforeNew(po);
            }
            if (type == 4) {
                error = this.UpdateDocumentation(po);
            }
            if (type == 5) {
                error = this.UpdateDocumentation(po);
            }
            if (type == 6) {
                // empty if block
            }
            if (type == 6) {
                // empty if block
            }
            if (type == 3) {
                // empty if block
            }
        }
        if (po.get_TableName().equals("C_Order")) {
            // empty if block
        }
        if (po.get_TableName().equals("R_Request")) {
            // empty if block
        }
        return error;
    }

    @Override
    public String docValidate(PO po, int timing) {
        String error = null;
        if (po.get_TableName().equals("C_Invoice")) {
            if (timing == 1) {
                error = this.InvoiceCalculateContract(po);
            }
            if (timing == 8) {
                // empty if block
            }
            if (timing == 7) {
                // empty if block
            }
            if (timing == 9) {
                error = this.ProjectInvoiceComplete(po);
                error = this.OrderLineControlInvoiced(po);
                error = this.InvoiceLineCreateOdV(po);
                error = this.NdCUpdateControlAmt(po);
                error = this.assignPrepayment(po);
            }
            if (timing == 2) {
                // empty if block
            }
            if (timing == 10) {
                // empty if block
            }
            if (timing == 15) {
                // empty if block
            }
            if (timing == 16) {
                // empty if block
            }
        }
        if (po.get_TableName().equals("C_Payment")) {
            if (timing == 1) {
                // empty if block
            }
            if (timing == 8) {
                error = this.PaymentCreateOrderLine(po);
            }
            if (timing == 7) {
                // empty if block
            }
            if (timing == 9) {
                error = this.PaymentCreateBankstatementLine(po);
            }
            if (timing == 2) {
                // empty if block
            }
            if (timing == 10 || timing == 13 || timing == 12) {
                error = this.DeletePayment(po);
            }
            if (timing == 15) {
                // empty if block
            }
            if (timing == 16) {
                // empty if block
            }
        }
        if (po.get_TableName().equals("C_Order")) {
            if (timing == 1) {
                // empty if block
            }
            if (timing == 8) {
                // empty if block
            }
            if (timing == 7) {
                // empty if block
            }
            if (timing == 9) {
                error = this.ProjectOrderComplete(po);
                error = this.purchaseInvoiceCreateOrderLine(po);
            }
            if (timing == 10 || timing == 13 || timing == 12) {
                error = this.ProjectOrderVoid(po);
            }
            if (timing == 15) {
                // empty if block
            }
            if (timing == 16) {
                // empty if block
            }
        }
        if (po.get_TableName().equals("C_AllocationHdr")) {
            if (timing == 1) {
                // empty if block
            }
            if (timing == 8) {
                // empty if block
            }
            if (timing == 7) {
                // empty if block
            }
            if (timing == 9) {
                this.CreatePaymentFromAllocationReembolso(po);
            }
            if (timing == 2) {
                // empty if block
            }
            if ((timing == 10 || timing == 13 || timing == 12) && timing == 15) {
                this.AfterPost_CorrectGL_Category(po);
            }
            if (timing == 16) {
                // empty if block
            }
        }
        if (po.get_TableName().equals("C_BankStatement")) {
            // empty if block
        }
        return error;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        this.log.info("AD_User_ID=" + AD_User_ID);
        this.m_AD_User_ID = AD_User_ID;
        this.m_AD_Role_ID = AD_Role_ID;
        MUser user = new MUser(Env.getCtx(), AD_User_ID, null);
        if (user.getC_BPartner_ID() != 0) {
            MBPartner bpartner = (MBPartner)user.getC_BPartner();
            Env.setContext(Env.getCtx(), "#User1_ID", bpartner.get_ValueAsInt("User1_ID"));
        }
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SAValidatorNew");
        sb.append("]");
        return sb.toString();
    }

    public void beforeSaveProperties() {
        if (this.m_AD_User_ID == 0 || this.m_AD_User_ID == 100 || this.m_AD_Role_ID == 0 || this.m_AD_Role_ID == 1000000) {
            return;
        }
        this.log.info("Setting default Properties");
        MRole role = MRole.get(Env.getCtx(), this.m_AD_Role_ID);
        if (!role.get_ValueAsBoolean("isshowAdvancedTab")) {
            Ini.setProperty("ShowAdvanced", false);
        }
        Ini.setProperty("ShowAcct", role.isShowAcct());
    }

    String projectBeforeNew(PO A_PO) {
        MProject project = (MProject)A_PO;
        Boolean dateChanged = A_PO.is_ValueChanged("xav_DateLoadingAtOrigin") || A_PO.is_ValueChanged("xav_DateShipAtOrigin") || A_PO.is_ValueChanged("xav_DestPuertoLlegadaFecha") || A_PO.is_ValueChanged("xav_DestBodegaLlegadaFecha");
        if (dateChanged.booleanValue() && project.isSummary()) {
            String whereClause = "C_Project_Parent_ID=?";
            List projectList = new Query(project.getCtx(), "C_Project", whereClause, A_PO.get_TrxName()).setParameters(project.getC_Project_ID()).list();
            for (MProject projectSon : projectList) {
                projectSon.set_ValueOfColumn("xav_DateLoadingAtOrigin", project.get_Value("xav_DateLoadingAtOrigin"));
                projectSon.set_ValueOfColumn("xav_DateShipAtOrigin", project.get_Value("xav_DateShipAtOrigin"));
                projectSon.set_ValueOfColumn("xav_DestPuertoLlegadaFecha", project.get_Value("xav_DestPuertoLlegadaFecha"));
                projectSon.set_ValueOfColumn("xav_DestBodegaLlegadaFecha", project.get_Value("xav_DestBodegaLlegadaFecha"));
                projectSon.saveEx();
            }
        }
        if (A_PO.is_ValueChanged("xav_aduanaregistrofecha") && A_PO.get_Value("xav_aduanaregistrofecha") != null) {
            A_PO.set_ValueOfColumn("SHW_ProjectStatus", (Object)"20");
        }
        if (A_PO.is_ValueChanged("datepagodm") && A_PO.get_Value("datepagodm") != null) {
            A_PO.set_ValueOfColumn("SHW_ProjectStatus", (Object)"30");
        }
        if (A_PO.is_ValueChanged("shw_dateselectividad") && A_PO.get_Value("shw_dateselectividad") != null) {
            A_PO.set_ValueOfColumn("SHW_ProjectStatus", (Object)"40");
        }
        if (A_PO.is_ValueChanged("datedelivered") && A_PO.get_Value("datedelivered") != null) {
            A_PO.set_ValueOfColumn("SHW_ProjectStatus", (Object)"50");
        }
        if (A_PO.is_ValueChanged("C_ProjectType_ID")) {
            int projecttype_ID = A_PO.get_ValueAsInt("C_ProjectType_ID");
            if (projecttype_ID == 0) {
                return "";
            }
            Object neueDocNo = "";
            Object neuerName = "";
            String prefix = "";
            String suffix = "";
            String zahelerString = "";
            MProjectType projecttype = new MProjectType(A_PO.getCtx(), projecttype_ID, A_PO.get_TrxName());
            if (projecttype.getProjectCategory().equals("M") || projecttype.getProjectCategory().equals("T")) {
                A_PO.set_ValueOfColumn("isshipped", (Object)false);
            }
            if ((prefix = projecttype.get_ValueAsString("Prefix")) == null) {
                prefix = "";
            }
            int zaehlerInt = projecttype.get_ValueAsInt("CurrentNext");
            zahelerString = String.format("%07d", zaehlerInt);
            suffix = projecttype.get_ValueAsString("Suffix");
            if (suffix == null) {
                suffix = "";
            }
            neueDocNo = prefix + zahelerString + suffix;
            if (A_PO.get_ValueAsBoolean("isSummary")) {
                A_PO.set_ValueOfColumn("Value", neueDocNo);
                int lg_route_ID = A_PO.get_ValueAsInt("LG_Route_ID");
                if (lg_route_ID != 0) {
                    neueDocNo = DB.getSQLValueStringEx(null, "select name from lg_Route where LG_Route_ID =?", lg_route_ID) + "-" + (String)neueDocNo;
                }
                A_PO.set_ValueOfColumn("Name", neueDocNo);
                projecttype.set_ValueOfColumn("CurrentNext", (Object)(++zaehlerInt));
                projecttype.saveEx();
                return "";
            }
            I_C_BPartner bpartner = project.getC_BPartner();
            String suffix2 = bpartner.getName2() == null ? bpartner.getName() : bpartner.getName2();
            neuerName = suffix2 + "-" + (String)neueDocNo;
            A_PO.set_ValueOfColumn("Value", neueDocNo);
            A_PO.set_ValueOfColumn("Name", neuerName);
            projecttype.set_ValueOfColumn("CurrentNext", (Object)(++zaehlerInt));
            projecttype.saveEx();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Boolean OrdersetBPartner(MOrder order, int C_BPartner_ID, int C_PaymentTerm_ID) {
        if (C_BPartner_ID == 0) {
            return false;
        }
        String sql = "SELECT p.AD_Language,p.C_PaymentTerm_ID, COALESCE(p.M_PriceList_ID,g.M_PriceList_ID) AS M_PriceList_ID, p.PaymentRule,p.POReference, p.SO_Description,p.IsDiscountPrinted, p.InvoiceRule,p.DeliveryRule,p.FreightCostRule,DeliveryViaRule, p.SO_CreditLimit, p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable, lship.C_BPartner_Location_ID,c.AD_User_ID, COALESCE(p.PO_PriceList_ID,g.PO_PriceList_ID) AS PO_PriceList_ID, p.PaymentRulePO,p.PO_PaymentTerm_ID, lbill.C_BPartner_Location_ID AS Bill_Location_ID, p.SOCreditStatus,  p.SalesRep_ID FROM C_BPartner p INNER JOIN C_BP_Group g ON (p.C_BP_Group_ID=g.C_BP_Group_ID) LEFT OUTER JOIN C_BPartner_Location lbill ON (p.C_BPartner_ID=lbill.C_BPartner_ID AND lbill.IsBillTo='Y' AND lbill.IsActive='Y') LEFT OUTER JOIN C_BPartner_Location lship ON (p.C_BPartner_ID=lship.C_BPartner_ID AND lship.IsShipTo='Y' AND lship.IsActive='Y') LEFT OUTER JOIN AD_User c ON (p.C_BPartner_ID=c.C_BPartner_ID) WHERE p.C_BPartner_ID=? AND p.IsActive='Y'";
        boolean IsSOTrx = true;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_BPartner_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                Integer salesRep = rs.getInt("SalesRep_ID");
                if (IsSOTrx && salesRep != 0) {
                    order.setSalesRep_ID(salesRep);
                }
                Integer ii = new Integer(rs.getInt(IsSOTrx ? "M_PriceList_ID" : "PO_PriceList_ID"));
                if (!rs.wasNull()) {
                    order.setM_PriceList_ID(ii);
                } else {
                    int i = Env.getContextAsInt(order.getCtx(), "#M_PriceList_ID");
                    if (i != 0) {
                        order.setM_PriceList_ID(i);
                    }
                }
                order.setBill_BPartner_ID(C_BPartner_ID);
                int bill_Location_ID = rs.getInt("Bill_Location_ID");
                order.setBill_Location_ID(bill_Location_ID);
                int shipTo_ID = rs.getInt("C_BPartner_Location_ID");
                order.setC_BPartner_Location_ID(shipTo_ID);
                int contID = rs.getInt("AD_User_ID");
                order.setAD_User_ID(contID);
                order.setBill_User_ID(contID);
                order.setInvoiceRule("D");
                order.setDeliveryRule("A");
                order.setPaymentRule("P");
                if (C_PaymentTerm_ID != 0) {
                    order.setC_PaymentTerm_ID(C_PaymentTerm_ID);
                } else {
                    C_PaymentTerm_ID = new Query(order.getCtx(), "C_PaymentTerm", "isdefault =?", order.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).setParameters(true).firstId();
                    order.setC_PaymentTerm_ID(C_PaymentTerm_ID);
                }
                order.setInvoiceRule("I");
                order.setDeliveryRule("A");
                order.setFreightCostRule("I");
                order.setDeliveryViaRule("P");
            }
        }
        catch (SQLException e) {
            Boolean bl;
            try {
                this.log.log(Level.SEVERE, sql, e);
                bl = false;
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return bl;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return true;
    }

    private String DeletePayment(PO A_PO) {
        int c_payment_ID = A_PO.get_ID();
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(c_payment_ID);
        List oLines = new Query(A_PO.getCtx(), "C_OrderLine", "c_payment_ID=?", A_PO.get_TrxName()).setParameters(parameters).list();
        for (MOrderLine oLine : oLines) {
            if (oLine.getParent().getDocStatus().equals("CO") || oLine.getParent().getDocStatus().equals("CL")) {
                return "No es posible anular o borrar un pago a cuenta ajena que se encuentra en una orden de venta completada";
            }
            if (oLine.getParent().getDocStatus().equals("RE") || oLine.getParent().getDocStatus().equals("VO")) {
                return "";
            }
            if (oLine.get_ValueAsInt("C_Payment_ID") <= 0) continue;
            ArrayList<Integer> deleteParameters = new ArrayList<Integer>();
            deleteParameters.add(oLine.getC_OrderLine_ID());
            String sqlDelete = "Update r_request set c_orderline_ID = null where c_Orderline_ID=?";
            DB.executeUpdateEx(sqlDelete, deleteParameters.toArray(), A_PO.get_TrxName());
            oLine.deleteEx(true);
            A_PO.set_ValueOfColumn("isInvoiced", (Object)false);
            A_PO.saveEx();
        }
        return "";
    }

    private String UpdateDocumentation(PO A_PO) {
        if (A_PO.is_ValueChanged("DocumentoDeTransporte") || A_PO.is_ValueChanged("CodigoDeDeclaracion") || A_PO.is_ValueChanged("ReferenciaDeDeclaracion") || A_PO.is_ValueChanged("Provider") || A_PO.is_ValueChanged("ProviderPO")) {
            String whereClause = "c_Project_ID=" + A_PO.get_ID();
            List orders = new Query(A_PO.getCtx(), "C_Order", whereClause, A_PO.get_TrxName()).list();
            for (MOrder order : orders) {
                order.set_ValueOfColumn("DocumentoDeTransporte", A_PO.get_Value("DocumentoDeTransporte"));
                order.set_ValueOfColumn("CodigoDeDeclaracion", A_PO.get_Value("CodigoDeDeclaracion"));
                order.set_ValueOfColumn("ReferenciaDeDeclaracion", A_PO.get_Value("ReferenciaDeDeclaracion"));
                order.set_ValueOfColumn("Provider", A_PO.get_Value("Provider"));
                order.set_ValueOfColumn("ProviderPO", A_PO.get_Value("ProviderPO"));
                order.saveEx();
            }
            List invoices = new Query(A_PO.getCtx(), "C_Invoice", whereClause, A_PO.get_TrxName()).list();
            for (MInvoice invoice : invoices) {
                invoice.set_ValueOfColumn("DocumentoDeTransporte", A_PO.get_Value("DocumentoDeTransporte"));
                invoice.set_ValueOfColumn("CodigoDeDeclaracion", A_PO.get_Value("CodigoDeDeclaracion"));
                invoice.set_ValueOfColumn("ReferenciaDeDeclaracion", A_PO.get_Value("ReferenciaDeDeclaracion"));
                invoice.set_ValueOfColumn("Provider", A_PO.get_Value("Provider"));
                invoice.set_ValueOfColumn("ProviderPO", A_PO.get_Value("ProviderPO"));
                invoice.saveEx();
            }
        }
        return "";
    }

    private String ProjectInvoiceComplete(PO A_PO) {
        ArrayList<Integer> ProjectIds = new ArrayList<Integer>();
        MInvoice invoice = (MInvoice)A_PO;
        if (!invoice.isSOTrx() || invoice.getC_Project_ID() == 0) {
            return "";
        }
        Boolean oneProjectInvoice = true;
        int C_Project_ID = invoice.getC_Project_ID();
        for (MInvoiceLine ivl : invoice.getLines()) {
            if (C_Project_ID == ivl.getC_Project_ID()) continue;
            invoice.set_ValueOfColumn("oneProjectInvoice", (Object)false);
            oneProjectInvoice = false;
            break;
        }
        if (oneProjectInvoice.booleanValue()) {
            invoice.setDescription("");
        } else {
            invoice.setC_Order_ID(0);
            invoice.setC_Project_ID(0);
        }
        invoice.saveEx();
        int LGRouteID = 0;
        if (invoice.getC_Order_ID() > 0) {
            MOrder order = (MOrder)invoice.getC_Order();
            LGRouteID = order.get_ValueAsInt("LG_Route_ID");
            if (LGRouteID != 0) {
                invoice.set_ValueOfColumn("LG_Route_ID", (Object)LGRouteID);
            }
            invoice.set_ValueOfColumn("Provider", order.get_Value("Provider"));
            invoice.set_ValueOfColumn("ProviderPO", order.get_Value("ProviderPO"));
            invoice.set_ValueOfColumn("DocumentoDeTransporte", order.get_Value("DocumentoDeTransporte"));
            invoice.set_ValueOfColumn("CodigoDeDeclaracion", order.get_Value("CodigoDeDeclaracion"));
            invoice.set_ValueOfColumn("ReferenciaDeDeclaracion", order.get_Value("ReferenciaDeDeclaracion"));
        }
        invoice.saveEx();
        for (MInvoiceLine invoiceLine : invoice.getLines()) {
            if (LGRouteID > 0) {
                invoiceLine.set_ValueOfColumn("LG_Route_ID", (Object)LGRouteID);
            }
            invoiceLine.saveEx();
            int c_project_ID = invoiceLine.getC_Project_ID();
            if (c_project_ID == 0) {
                c_project_ID = invoiceLine.getC_Invoice().getC_Project_ID();
            }
            if (c_project_ID == 0 || ProjectIds.contains(invoiceLine.getC_Project_ID())) continue;
            ProjectIds.add(c_project_ID);
        }
        Iterator iterator = ProjectIds.iterator();
        while (iterator.hasNext()) {
            int c_project_ID = (Integer)iterator.next();
            MProject project = new MProject(A_PO.getCtx(), c_project_ID, A_PO.get_TrxName());
            this.updateProject(project);
        }
        return "";
    }

    private String PaymentCreateBankstatementLine(PO A_PO) {
        MPayment payment = (MPayment)A_PO;
        String error = "";
        if (payment.getC_POS_ID() <= 0 && payment.getC_BankAccount().getC_Bank().getBankType().equals("C")) {
            this.addPayment(payment);
        }
        return error;
    }

    private String ProjectOrderComplete(PO A_PO) {
        ArrayList<Integer> ProjectIds = new ArrayList<Integer>();
        MOrder order = (MOrder)A_PO;
        for (MOrderLine oLine : order.getLines()) {
            if (oLine.get_ValueAsInt("C_Payment_ID") == 0) {
                return "";
            }
            if (oLine.getC_Charge_ID() == 0) {
                return "";
            }
            if (oLine.getC_Charge().getC_ChargeType_ID() != 1000002 && oLine.getC_Charge().getC_ChargeType_ID() != 1000003) {
                return "";
            }
            MPayment pay = new MPayment(A_PO.getCtx(), oLine.get_ValueAsInt("C_Payment_ID"), A_PO.get_TrxName());
            pay.set_ValueOfColumn("ControlAmt", (Object)oLine.getLineNetAmt());
            pay.saveEx();
        }
        if (!order.getC_DocType().getDocSubTypeSO().equals("SO")) {
            return "";
        }
        for (MOrderLine ol : order.getLines()) {
            int c_project_ID = ol.getC_Project_ID();
            if (c_project_ID == 0) {
                c_project_ID = ol.getC_Order().getC_Project_ID();
            }
            if (c_project_ID == 0 || ProjectIds.contains(ol.getC_Project_ID())) continue;
            ProjectIds.add(c_project_ID);
        }
        Iterator iterator = ProjectIds.iterator();
        while (iterator.hasNext()) {
            int c_project_ID = (Integer)iterator.next();
            MProject project = new MProject(A_PO.getCtx(), c_project_ID, A_PO.get_TrxName());
            this.updateProject(project);
        }
        return "";
    }

    private String ProjectOrderVoid(PO A_PO) {
        int C_Project_ID = A_PO.get_ValueAsInt("C_Project_ID");
        if (C_Project_ID <= 0) {
            return "";
        }
        MProject project = new MProject(A_PO.getCtx(), C_Project_ID, A_PO.get_TrxName());
        MOrder order = (MOrder)A_PO;
        if (order.isSOTrx()) {
            project.setPlannedAmt(project.getPlannedAmt().subtract(order.getGrandTotal()));
        } else {
            project.setCommittedAmt(project.getCommittedAmt().subtract(order.getGrandTotal()));
        }
        project.saveEx();
        return "";
    }

    public String AfterPost_CorrectGL_Category(PO po) {
        MAllocationHdr ah = (MAllocationHdr)po;
        Doc doc = ah.getDoc();
        ArrayList<Fact> facts = doc.getFacts();
        Object description = "";
        for (Fact fact : facts) {
            for (FactLine fLine : fact.getLines()) {
                description = "";
                Boolean isPayment = false;
                MAllocationLine alo = new MAllocationLine(po.getCtx(), fLine.getLine_ID(), po.get_TrxName());
                if (alo.getC_Payment_ID() != 0) {
                    fLine.setGL_Category_ID(alo.getC_Payment().getC_DocType().getGL_Category_ID());
                    description = "Pago: " + alo.getC_Payment().getDocumentNo();
                    continue;
                }
                if (alo.getC_CashLine_ID() != 0) {
                    isPayment = alo.getC_CashLine().getC_Invoice_ID() != 0 ? Boolean.valueOf(alo.getC_Invoice().getC_DocType().getDocBaseType().equals("APP")) : Boolean.valueOf(alo.getAmount().compareTo(Env.ZERO) >= 0);
                }
                MDocType dt = null;
                dt = isPayment != false ? (MDocType)new Query(po.getCtx(), "C_DocType", "Docbasetype = 'APP'", null).first() : (MDocType)new Query(po.getCtx(), "C_DocType", "Docbasetype = 'ARR'", null).first();
                fLine.setGL_Category_ID(dt.getGL_Category_ID());
                if (alo.getC_Invoice_ID() != 0) {
                    description = (String)description + " Factura: " + alo.getC_Invoice().getDocumentNo();
                    continue;
                }
                if (alo.getC_Charge_ID() == 0) continue;
                description = (String)description + " Cargo: " + alo.getC_Charge().getName();
            }
        }
        return "";
    }

    private String OrderLineControlInvoiced(PO A_PO) {
        MInvoice inv = (MInvoice)A_PO;
        if (!inv.isSOTrx()) {
            return "";
        }
        if (inv.getC_Order_ID() != 0 && inv.getC_Order().getC_DocType().getDocSubTypeSO().equals("WI")) {
            return "";
        }
        String whereClause = "c_order_ID in (select c_order_ID from c_orderline where  c_orderline_ID in (select c_orderline_ID from c_invoiceline where c_invoice_ID =?))";
        ArrayList<Constable> params = new ArrayList<Constable>();
        params.add(Integer.valueOf(A_PO.get_ID()));
        List orders = new Query(A_PO.getCtx(), "C_Order", whereClause, A_PO.get_TrxName()).setParameters(params.toArray()).list();
        Boolean isinvoiced = true;
        Iterator iterator = orders.iterator();
        if (iterator.hasNext()) {
            MOrder order = (MOrder)iterator.next();
            for (MOrderLine oLine : order.getLines()) {
                if (oLine.getQtyInvoiced().compareTo(oLine.getQtyOrdered()) >= 0) continue;
                isinvoiced = false;
                break;
            }
            order.setIsInvoiced(isinvoiced);
            order.saveEx();
            int r_status = 0;
            Boolean processed = false;
            if (isinvoiced.booleanValue()) {
                if (Env.getAD_Client_ID(Env.getCtx()) == 1000001) {
                    r_status = 1000007;
                } else if (Env.getAD_Client_ID(Env.getCtx()) == 1000012) {
                    r_status = 1000013;
                }
                processed = true;
            } else if (Env.getAD_Client_ID(Env.getCtx()) == 1000001) {
                r_status = 1000023;
            } else if (Env.getAD_Client_ID(Env.getCtx()) == 1000012) {
                r_status = 1000022;
            }
            whereClause = "c_order_ID=? and r_requesttype_ID in (1000002,1000004)";
            MRequest req = (MRequest)new Query(inv.getCtx(), "R_Request", whereClause, inv.get_TrxName()).setParameters(order.getC_Order_ID()).first();
            if (req == null) {
                return "";
            }
            if (r_status == 0) {
                return "";
            }
            String sqlupdate = "update r_request set r_status_ID=?, processed =? where r_request_ID=?";
            params.clear();
            params.add(Integer.valueOf(r_status));
            params.add(processed);
            params.add(Integer.valueOf(req.getR_Request_ID()));
            int no = DB.executeUpdateEx(sqlupdate, params.toArray(), inv.get_TrxName());
            return "";
        }
        return "";
    }

    private String InvoiceCalculateContract(PO A_PO) {
        MInvoice inv = (MInvoice)A_PO;
        if (inv.getReversal_ID() > 0) {
            return "";
        }
        Calendar invoice1 = TimeUtil.getToday();
        Calendar invoice2 = TimeUtil.getToday();
        if (inv.getReversal_ID() != 0 || !inv.isSOTrx()) {
            return "";
        }
        for (MInvoiceLine ivlLine : inv.getLines()) {
            if (ivlLine.getC_Charge_ID() > 0) continue;
            String whereClause = "isvalid = 'Y' and (c_bpartner_ID = ? or c_bpartner_ID is null) and LG_RateType = 'G' and m_pricelist_ID = ?  and  exists (select 1 from lg_productpricerateline where m_product_id = ? and isactive = 'Y') ";
            ArrayList<Object> param1 = new ArrayList<Object>();
            param1.add(inv.getC_BPartner_ID());
            param1.add(inv.getM_PriceList_ID());
            param1.add(ivlLine.getM_Product_ID());
            MLGProductPriceRate pprl = (MLGProductPriceRate)new Query(A_PO.getCtx(), "LG_ProductPriceRate", whereClause, A_PO.get_TrxName()).setOnlyActiveRecords(true).setParameters(param1).first();
            if (pprl == null) continue;
            Object whereClauseProducts = "(";
            for (MLGProductPriceRateLine ppl : pprl.getLines()) {
                whereClauseProducts = (String)whereClauseProducts + ppl.getM_Product_ID() + ",";
            }
            whereClauseProducts = ((String)whereClauseProducts).substring(0, ((String)whereClauseProducts).length() - 1) + ")";
            String sqlSales = "select sum(qtyinvoiced) from c_invoiceline ivl  inner join c_invoice i on ivl.c_invoice_ID = i.c_invoice_ID where m_product_ID in " + (String)whereClauseProducts + " and c_bpartner_ID =? and (i.docstatus in ('CO','CL') and i.dateinvoiced between ? and ?) or (ivl.c_invoice_ID=? and ivl.line < ? and m_product_ID in " + (String)whereClauseProducts + ")";
            if (pprl.get_ValueAsString("InvoiceFrequency") == null) continue;
            ArrayList<Object> params = new ArrayList<Object>();
            String frequencytype = pprl.get_ValueAsString("InvoiceFrequency");
            if (frequencytype.equals("D")) {
                params.add(ivlLine.getC_Invoice().getC_BPartner_ID());
                params.add(ivlLine.getC_Invoice().getDateInvoiced());
                params.add(ivlLine.getC_Invoice().getDateInvoiced());
                params.add(inv.getC_Invoice_ID());
                params.add(ivlLine.getLine());
                invoice1.setTime(ivlLine.getC_Invoice().getDateInvoiced());
                invoice2.setTime(ivlLine.getC_Invoice().getDateInvoiced());
            } else if (frequencytype.equals("M")) {
                Timestamp orderDate = ivlLine.getC_Invoice().getDateInvoiced();
                invoice1 = TimeUtil.getToday();
                invoice1.setTime(orderDate);
                invoice1.set(5, 1);
                invoice2 = TimeUtil.getToday();
                invoice2.setTime(orderDate);
                invoice2.set(5, invoice1.getActualMaximum(5));
                params.add(ivlLine.getC_Invoice().getC_BPartner_ID());
                params.add(new Timestamp(invoice1.getTimeInMillis()));
                params.add(new Timestamp(invoice2.getTimeInMillis()));
                params.add(inv.getC_Invoice_ID());
                params.add(ivlLine.getLine());
            }
            BigDecimal qtyinvoiced = DB.getSQLValueBD(A_PO.get_TrxName(), sqlSales, params);
            if (qtyinvoiced == null) {
                qtyinvoiced = Env.ZERO;
            }
            qtyinvoiced = qtyinvoiced.add(ivlLine.getQtyInvoiced());
            String whereClause_LPR = " m_product_ID=? and lg_productpricerate_ID=? and ?> breakvalue";
            ArrayList<Object> param2 = new ArrayList<Object>();
            param2.add(ivlLine.getM_Product_ID());
            param2.add(pprl.getLG_ProductPriceRate_ID());
            param2.add(qtyinvoiced);
            MLGProductPriceRateLine plr = (MLGProductPriceRateLine)new Query(A_PO.getCtx(), "LG_ProductPriceRateLine", whereClause_LPR, A_PO.get_TrxName()).setParameters(param2).setOrderBy("ORDER BY BreakValue DESC").first();
            ivlLine.setPriceActual(plr.getPriceStd());
            ivlLine.setPriceEntered(plr.getPriceStd());
            ivlLine.saveEx();
        }
        return "";
    }

    private String PaymentCreateOrderLine(PO A_PO) {
        MPayment pay = (MPayment)A_PO;
        MDocType docType = (MDocType)pay.getC_DocType();
        Boolean iscuentaajena = docType.get_ValueAsBoolean("iscuentaajena");
        if (!iscuentaajena.booleanValue()) {
            return "";
        }
        if (pay.getC_Charge_ID() == 0) {
            this.CreateCTAJPaymentAllocs(pay);
            return "";
        }
        if (pay.get_ValueAsInt("R_Request_ID") == 0) {
            return "";
        }
        MRequest req = new MRequest(pay.getCtx(), pay.get_ValueAsInt("R_Request_ID"), pay.get_TrxName());
        if (req.getC_Order_ID() <= 0) {
            return "";
        }
        if (req.getR_Status().isClosed()) {
            return "";
        }
        String result = this.CreateCTAJPayment(req, pay);
        if (result != "") {
            return result;
        }
        int r_status = 0;
        if (Env.getAD_Client_ID(Env.getCtx()) == 1000001) {
            r_status = 1000001;
        } else if (Env.getAD_Client_ID(Env.getCtx()) == 1000012) {
            r_status = 1000011;
        }
        if (r_status == 0) {
            return "";
        }
        req.setR_Status_ID(r_status);
        req.setSalesRep_ID(req.getCreatedBy());
        req.saveEx();
        return "";
    }

    private String OrderLineUpdateControlAmt(PO A_PO) {
        MOrderLine oLine = (MOrderLine)A_PO;
        if (A_PO.is_ValueChanged("LineNetAmt")) {
            return "";
        }
        if (oLine.get_ValueAsInt("C_Payment_ID") == 0 && oLine.get_ValueAsInt("C_PaymentAllocate_ID") == 0) {
            return "";
        }
        if (oLine.getC_Charge_ID() == 0) {
            return "";
        }
        if (oLine.getC_Charge().getC_ChargeType_ID() != 1000002 && oLine.getC_Charge().getC_ChargeType_ID() != 1000003) {
            return "";
        }
        if (oLine.get_ValueAsInt("C_Payment_ID") != 0 && oLine.get_ValueAsInt("C_PaymentAllocate_ID") == 0) {
            MPayment pay = new MPayment(A_PO.getCtx(), oLine.get_ValueAsInt("C_Payment_ID"), A_PO.get_TrxName());
            pay.set_ValueOfColumn("ControlAmt", (Object)oLine.getLineNetAmt());
            pay.saveEx();
        }
        if (oLine.get_ValueAsInt("C_PaymentAllocate_ID") != 0) {
            MPaymentAllocate alloc = new MPaymentAllocate(A_PO.getCtx(), oLine.get_ValueAsInt("C_PaymentAllocate_ID"), A_PO.get_TrxName());
            alloc.set_ValueOfColumn("ControlAmt", (Object)oLine.getLineNetAmt());
            alloc.saveEx();
        }
        return "";
    }

    private String NdCUpdateControlAmt(PO A_PO) {
        MInvoice ndN = (MInvoice)A_PO;
        for (MInvoiceLine iLine : ndN.getLines()) {
            BigDecimal ctajAmt;
            if (iLine.get_ValueAsInt("C_Payment_ID") == 0 && iLine.get_ValueAsInt("C_PaymentAllocate_ID") == 0) {
                return "";
            }
            if (iLine.get_ValueAsInt("C_Payment_ID") != 0 && iLine.get_ValueAsInt("C_PaymentAllocate_ID") == 0) {
                MPayment pay = new MPayment(A_PO.getCtx(), iLine.get_ValueAsInt("C_Payment_ID"), A_PO.get_TrxName());
                ctajAmt = (BigDecimal)pay.get_Value("ControlAmt");
                ctajAmt = ctajAmt.add(iLine.getLineNetAmt());
                pay.set_ValueOfColumn("ControlAmt", (Object)ctajAmt);
                pay.saveEx();
            }
            if (iLine.get_ValueAsInt("C_PaymentAllocate_ID") == 0) continue;
            MPaymentAllocate alloc = new MPaymentAllocate(A_PO.getCtx(), iLine.get_ValueAsInt("C_PaymentAllocate_ID"), A_PO.get_TrxName());
            ctajAmt = (BigDecimal)alloc.get_Value("ControlAmt");
            ctajAmt = ctajAmt.add(iLine.getLineNetAmt());
            alloc.set_ValueOfColumn("ControlAmt", (Object)ctajAmt);
            alloc.saveEx();
        }
        return "";
    }

    private String OLineBeforeDelete(PO A_PO) {
        MOrderLine oLine = (MOrderLine)A_PO;
        if (oLine.getC_Charge_ID() == 0) {
            return "";
        }
        if (oLine.getC_Charge().getC_ChargeType_ID() != 1000002 && oLine.getC_Charge().getC_ChargeType_ID() != 1000003) {
            return "";
        }
        if (oLine.get_ValueAsInt("C_Payment_ID") == 0 && oLine.get_ValueAsInt("C_PaymentAllocate_ID") == 0) {
            return "";
        }
        if (oLine.get_ValueAsInt("C_Payment_ID") != 0 && oLine.get_ValueAsInt("C_PaymentAllocate_ID") == 0) {
            MPayment pay = new MPayment(A_PO.getCtx(), oLine.get_ValueAsInt("C_Payment_ID"), A_PO.get_TrxName());
            pay.set_ValueOfColumn("ControlAmt", (Object)Env.ZERO);
            pay.saveEx();
        }
        if (oLine.get_ValueAsInt("C_PaymentAllocate_ID") != 0) {
            MPaymentAllocate alloc = new MPaymentAllocate(A_PO.getCtx(), oLine.get_ValueAsInt("C_PaymentAllocate_ID"), A_PO.get_TrxName());
            alloc.set_ValueOfColumn("ControlAmt", (Object)Env.ZERO);
            alloc.saveEx();
        }
        return "";
    }

    private String CreateCTAJPayment(MRequest req, MPayment pay) {
        MOrder order = (MOrder)req.getC_Order();
        if (req.getC_Order_ID() <= 0) {
            return "la solicitud " + req.getDocumentNo() + "no tiene referencia a niguna orden";
        }
        if (req.get_ValueAsInt("C_OrderLine_ID") != 0) {
            MOrderLine oLine = new MOrderLine(pay.getCtx(), req.get_ValueAsInt("C_OrderLine_ID"), pay.get_TrxName());
            oLine.set_ValueOfColumn("C_Payment_ID", (Object)pay.getC_Payment_ID());
            oLine.saveEx();
            return "";
        }
        BigDecimal p_DistributionAmt = pay.getPayAmt();
        MOrderLine oLine = (MOrderLine)new Query(pay.getCtx(), "C_OrderLine", "c_order_ID=? and c_payment_ID=?", pay.get_TrxName()).setParameters(order.getC_Order_ID(), pay.getC_Payment_ID()).first();
        if (oLine != null) {
            return "";
        }
        oLine = new MOrderLine(order);
        int chargeID = pay.getC_Charge_ID();
        oLine.setC_Charge_ID(chargeID);
        MCharge charge = new MCharge(pay.getCtx(), chargeID, pay.get_TrxName());
        MTaxCategory tc = (MTaxCategory)charge.getC_TaxCategory();
        oLine.setC_Tax_ID(tc.getDefaultTax().getC_Tax_ID());
        oLine.setQty(Env.ONE);
        oLine.setPrice(p_DistributionAmt);
        oLine.set_ValueOfColumn("C_Payment_ID", (Object)pay.getC_Payment_ID());
        oLine.setC_Project_ID(pay.getC_Project_ID());
        MBPartner bpartner = (MBPartner)oLine.getC_Order().getC_BPartner();
        oLine.set_ValueOfColumn("isSplitInvoice", (Object)bpartner.get_ValueAsBoolean("isSplitInvoice"));
        oLine.set_ValueOfColumn("R_Request_ID", (Object)req.getR_Request_ID());
        oLine.saveEx();
        pay.set_ValueOfColumn("isInvoiced", (Object)true);
        pay.setDescription((String)(pay.getDescription() == null ? "" : pay.getDescription() + " Asignado en orden: " + order.getDocumentNo()));
        pay.set_ValueOfColumn("ControlAmt", (Object)p_DistributionAmt);
        pay.saveEx();
        return "";
    }

    private void CreateCTAJPaymentAllocs(MPayment pay) {
        MPaymentAllocate[] pAllocs;
        Object description = "";
        int r_status = 0;
        if (Env.getAD_Client_ID(Env.getCtx()) == 1000001) {
            r_status = 1000001;
        } else if (Env.getAD_Client_ID(Env.getCtx()) == 1000012) {
            r_status = 1000011;
        }
        if (r_status == 0) {
            return;
        }
        for (MPaymentAllocate alloc : pAllocs = MPaymentAllocate.get(pay)) {
            MRequest req;
            int r_request_ID;
            if (alloc.getC_Invoice_ID() > 0 || (r_request_ID = alloc.get_ValueAsInt("R_Request_ID")) <= 0 || (req = new MRequest(pay.getCtx(), r_request_ID, pay.get_TrxName())).getC_Order_ID() <= 0) continue;
            if (req.get_ValueAsInt("C_OrderLine_ID") != 0) {
                MOrderLine oLine = new MOrderLine(pay.getCtx(), req.get_ValueAsInt("C_OrderLine_ID"), pay.get_TrxName());
                oLine.set_ValueOfColumn("C_Payment_ID", (Object)pay.getC_Payment_ID());
                oLine.saveEx();
                continue;
            }
            MOrder order = (MOrder)req.getC_Order();
            MOrderLine oLine = new MOrderLine(order);
            int chargeID = alloc.get_ValueAsInt("C_Charge_ID");
            if (chargeID <= 0) continue;
            oLine.setC_Charge_ID(chargeID);
            MCharge charge = new MCharge(pay.getCtx(), chargeID, pay.get_TrxName());
            MTaxCategory tc = (MTaxCategory)charge.getC_TaxCategory();
            oLine.setC_Tax_ID(tc.getDefaultTax().getC_Tax_ID());
            oLine.setQty(Env.ONE);
            oLine.setPrice(alloc.getAmount());
            oLine.set_ValueOfColumn("C_PaymentAllocate_ID", (Object)alloc.getC_PaymentAllocate_ID());
            oLine.set_ValueOfColumn("C_Payment_ID", (Object)pay.getC_Payment_ID());
            oLine.setC_Project_ID(alloc.get_ValueAsInt("C_Project_ID"));
            MBPartner bpartner = (MBPartner)oLine.getC_Order().getC_BPartner();
            oLine.set_ValueOfColumn("isSplitInvoice", (Object)bpartner.get_ValueAsBoolean("isSplitInvoice"));
            oLine.saveEx();
            req.setC_Payment_ID(pay.getC_Payment_ID());
            req.setR_Status_ID(r_status);
            req.setSalesRep_ID(req.getCreatedBy());
            req.saveEx();
            description = (String)description + " " + order.getDocumentNo();
            alloc.set_ValueOfColumn("ControlAmt", (Object)oLine.getLineNetAmt());
        }
        pay.set_ValueOfColumn("isInvoiced", (Object)true);
        pay.setDescription((String)(pay.getDescription() == null ? "" : pay.getDescription() + " Asignado en orden: " + (String)description));
        pay.saveEx();
    }

    private String InvoiceLineCreateOdV(PO A_PO) {
        MInvoice invoice = (MInvoice)A_PO;
        if (!invoice.getC_DocType().getDocBaseType().equals("API")) {
            return "";
        }
        if (invoice.getC_DocTypeTarget_ID() != 1000441 && invoice.getC_DocTypeTarget_ID() != 1000442) {
            return "";
        }
        String whereClause = "c_project_ID=? and issotrx = 'Y' and docstatus in ('DR','IP') and c_doctypetarget_ID not in (1000424, 1000375)";
        for (MInvoiceLine iLine : invoice.getLines()) {
            if (iLine.getC_OrderLine_ID() > 0) {
                return "";
            }
            if (!iLine.get_ValueAsBoolean("isSalesOrderImmediate") || iLine.getC_Project_ID() < 0) {
                return "";
            }
            MOrder salesOrder = (MOrder)new Query(A_PO.getCtx(), "C_Order", whereClause, A_PO.get_TrxName()).setParameters(iLine.getC_Project_ID()).setOnlyActiveRecords(true).first();
            if (salesOrder == null || salesOrder.getC_Order_ID() == 0) {
                return "No existe una orden de venta";
            }
            MOrderLine oSalesLine = new MOrderLine(salesOrder);
            oSalesLine.setC_Charge_ID(iLine.getC_Charge_ID());
            oSalesLine.setQty(iLine.getQtyEntered());
            oSalesLine.setPrice(iLine.getPriceEntered());
            oSalesLine.set_ValueOfColumn("c_invoiceline_PO_ID", (Object)iLine.getC_OrderLine_ID());
            MBPartner bpartner = (MBPartner)salesOrder.getC_BPartner();
            oSalesLine.set_ValueOfColumn("isSplitInvoice", (Object)bpartner.get_ValueAsBoolean("isSplitInvoice"));
            oSalesLine.setPriceCost(iLine.getPriceEntered());
            oSalesLine.setC_Project_ID(iLine.getC_Project_ID());
            oSalesLine.setC_Activity_ID(iLine.getC_Activity_ID());
            oSalesLine.setUser1_ID(iLine.getUser1_ID());
            oSalesLine.saveEx();
            iLine.set_ValueOfColumn("C_OrderLine_SO_ID", (Object)oSalesLine.getC_OrderLine_ID());
            iLine.saveEx();
        }
        whereClause = "c_invoice_ID=?";
        MRequest req = (MRequest)new Query(invoice.getCtx(), "R_Request", whereClause, invoice.get_TrxName()).setParameters(invoice.getC_Invoice_ID()).first();
        if (req == null) {
            return "";
        }
        if (req.getR_Status().isClosed()) {
            return "";
        }
        int r_status = 0;
        if (Env.getAD_Client_ID(Env.getCtx()) == 1000001) {
            r_status = 1000001;
        } else if (Env.getAD_Client_ID(Env.getCtx()) == 1000012) {
            r_status = 1000011;
        }
        if (r_status == 0) {
            return "";
        }
        req.setR_Status_ID(r_status);
        req.setSalesRep_ID(req.getCreatedBy());
        req.saveEx();
        return "";
    }

    private String CreatePaymentFromAllocationReembolso(PO A_PO) {
        MAllocationHdr alloc = (MAllocationHdr)A_PO;
        MPayment payOrg = null;
        MPayment pay = null;
        for (MAllocationLine alo : alloc.getLines(true)) {
            if (alo.getC_Payment_ID() == 0) continue;
            payOrg = (MPayment)alo.getC_Payment();
        }
        for (MAllocationLine alo : alloc.getLines(true)) {
            if (alo.getC_Charge_ID() != 1000280 && alo.getC_Charge_ID() != 1000279) continue;
            int defaultaccount = new Query(A_PO.getCtx(), "C_BankAccount", "", A_PO.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).setOrderBy("C_Bankaccount_ID ").firstId();
            BigDecimal multiplicator = payOrg.getC_DocType().getDocBaseType().equals("ARR") ? Env.ONE.negate() : Env.ONE;
            pay = new MPayment(A_PO.getCtx(), 0, A_PO.get_TrxName());
            pay.setC_BankAccount_ID(defaultaccount);
            pay.setTenderType("T");
            pay.setDateTrx(new Timestamp(System.currentTimeMillis()));
            pay.setIsOverUnderPayment(true);
            pay.setAD_Org_ID(alo.getAD_Org_ID());
            pay.setC_Project_ID(payOrg.getC_Project_ID());
            int c_charge_ID = alo.getC_Charge_ID();
            if (c_charge_ID == 0) {
                return "";
            }
            int c_doctype_ID = 0;
            String docbasetype = payOrg.getC_DocType().getDocBaseType().equals("ARR") ? "APP" : "ARR";
            c_doctype_ID = MDocType.getDocType(docbasetype);
            if (c_doctype_ID == 0) {
                return "";
            }
            pay.setC_DocType_ID(c_doctype_ID);
            pay.setIsReceipt(pay.getC_DocType().isSOTrx());
            pay.setC_Charge_ID(c_charge_ID);
            pay.setC_Currency_ID(100);
            pay.setC_BPartner_ID(payOrg.getC_BPartner_ID());
            pay.setPayAmt(alo.getAmount().multiply(multiplicator));
            pay.setDescription("Aviso de Pago por reembolso de anticipo");
            pay.set_CustomColumn("C_AllocationLine_ID", alo.getC_AllocationLine_ID());
            pay.saveEx();
            Env.setContext(Env.getCtx(), alloc.getDocumentNo(), pay.getDocumentNo());
        }
        return "";
    }

    private String updateIsInvoiced(PO A_PO) {
        if (!A_PO.is_ValueChanged("QtyInvoiced")) {
            return "";
        }
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(A_PO.get_ValueAsInt("C_Order_ID"));
        String sql = "select sum(qtyordered-qtyinvoiced) from c_orderline where c_order_ID=?";
        BigDecimal i = DB.getSQLValueBDEx(A_PO.get_TrxName(), sql, params.toArray());
        if (i.signum() == 0) {
            sql = "Update c_order set isinvoiced = 'Y' where c_order_ID=?";
            DB.executeUpdateEx(sql, params.toArray(), A_PO.get_TrxName());
        }
        return "";
    }

    private String assignPrepayment(PO A_PO) {
        BiFunction<BigDecimal, BigDecimal, BigDecimal> getMaxPayAmt = (t1, t2) -> t1.abs().compareTo(t2.abs()) <= 0 ? t1 : t2;
        BiFunction<BigDecimal, BigDecimal, BigDecimal> getOverUnderAmt = (payamt, openamt) -> payamt.abs().compareTo(openamt.abs()) >= 0 ? Env.ZERO : openamt.subtract((BigDecimal)payamt);
        BiFunction<BigDecimal, Boolean, BigDecimal> getAmtIsreceipt = (amt, isReceipt) -> isReceipt != false ? amt : amt.negate();
        MInvoice invoice = (MInvoice)A_PO;
        if (invoice.getC_Order_ID() == 0) {
            return "";
        }
        if (invoice.getC_Order_ID() != 0 && invoice.getC_Order().getC_POS_ID() != 0) {
            return "";
        }
        String whereClause = "C_ORDER_ID=? and docstatus in ('CO','CL') and isallocated = 'N'";
        List prepayments = new Query(A_PO.getCtx(), "C_Payment", whereClause, A_PO.get_TrxName()).setParameters(invoice.getC_Order_ID()).list();
        BigDecimal openAmt = invoice.getOpenAmt();
        for (MPayment pay : prepayments) {
            MAllocationHdr alloc = new MAllocationHdr(Env.getCtx(), true, invoice.getDateInvoiced(), invoice.getC_Currency_ID(), Env.getContext(Env.getCtx(), "#AD_User_Name"), A_PO.get_TrxName());
            alloc.setAD_Org_ID(invoice.getAD_Org_ID());
            alloc.saveEx();
            BigDecimal aLineAmount = getMaxPayAmt.apply(openAmt, pay.getPayAmt());
            BigDecimal overUnderAmt = getOverUnderAmt.apply(aLineAmount, openAmt);
            MAllocationLine aLine = new MAllocationLine(alloc, getAmtIsreceipt.apply(aLineAmount, invoice.isSOTrx()), Env.ZERO, Env.ZERO, getAmtIsreceipt.apply(overUnderAmt, invoice.isSOTrx()));
            aLine.setDocInfo(invoice.getC_BPartner_ID(), invoice.getC_Order_ID(), invoice.getC_Invoice_ID());
            aLine.setPaymentInfo(pay.getC_Payment_ID(), 0);
            aLine.saveEx();
            if (!alloc.processIt("CO")) {
                throw new AdempiereException("Cannot complete allocation: " + alloc.getProcessMsg());
            }
            alloc.saveEx();
            openAmt = openAmt.subtract(aLineAmount);
        }
        return "";
    }

    public String updateProject(MProject project) {
        BigDecimal result = this.SHW_CostActual(project);
        project.set_ValueOfColumn("SHW_CostActual", (Object)result);
        result = this.SHW_CostPlanned(project);
        project.set_ValueOfColumn("SHW_CostPlanned", (Object)result);
        result = this.SHW_CostExtrapolated(project);
        project.set_ValueOfColumn("SHW_CostExtrapolated", (Object)result);
        result = this.SHW_RevenueActual(project);
        project.set_ValueOfColumn("SHW_RevenueActual", (Object)result);
        result = this.SHW_RevenuePlanned(project);
        project.set_ValueOfColumn("SHW_RevenuePlanned", (Object)result);
        result = this.SHW_RevenueExtrapolated(project);
        project.set_ValueOfColumn("SHW_RevenueExtrapolated", (Object)result);
        if (project.isSummary()) {
            result = this.SHW_RevenuePlanned_Sons(project, project.getC_Project_ID());
            project.set_ValueOfColumn("SHW_RevenuePlanned_Sons", (Object)result);
            result = this.SHW_RevenueActual_Sons(project, project.getC_Project_ID());
            project.set_ValueOfColumn("SHW_RevenueActual_Sons", (Object)result);
            result = this.SHW_RevenueExtrapolated_Sons(project, project.getC_Project_ID());
            project.set_ValueOfColumn("SHW_RevenueExtrapolated_Sons", (Object)result);
            result = this.SHW_CostPlannedHeritage_Parent(project, project.getC_Project_ID());
            project.set_ValueOfColumn("SHW_CostPlanned_Heritage", (Object)result);
            result = this.SHW_CostActualHeritage_Parent(project, project.getC_Project_ID());
            project.set_ValueOfColumn("SHW_CostActual_Heritage", (Object)result);
            result = this.SHW_CostExtrapolatedHeritage_Parent(project, project.getC_Project_ID());
            project.set_ValueOfColumn("SHW_CostExtrapolated_Heritage", (Object)result);
            project.saveEx();
            BigDecimal costPlannedFather = (BigDecimal)project.get_Value("SHW_CostPlanned");
            BigDecimal costActualFather = (BigDecimal)project.get_Value("SHW_CostActual");
            BigDecimal costExtrapolatedFather = (BigDecimal)project.get_Value("SHW_CostExtrapolated");
            BigDecimal revenuePlannedAll = this.SHW_RevenuePlanned_Sons(project, project.get_ValueAsInt("C_Project_ID"));
            BigDecimal revenueExtrapolatedAll = this.SHW_RevenueExtrapolated_Sons(project, project.get_ValueAsInt("C_Project_ID"));
            BigDecimal weight_father = (BigDecimal)project.get_Value("Weight");
            BigDecimal Volume_father = (BigDecimal)project.get_Value("Volume");
            List projectsOfFather = new Query(project.getCtx(), "C_Project", "C_Project_Parent_ID=?", project.get_TrxName()).setParameters(project.getC_Project_ID()).list();
            for (MProject projectson : projectsOfFather) {
                BigDecimal revenuePlanned = (BigDecimal)projectson.get_Value("SHW_RevenuePlanned");
                BigDecimal revenueExtrapolated = (BigDecimal)projectson.get_Value("SHW_RevenueExtrapolated");
                BigDecimal weight = (BigDecimal)projectson.get_Value("Weight");
                BigDecimal volume = (BigDecimal)projectson.get_Value("volume");
                BigDecimal shareRevenue = Env.ZERO;
                BigDecimal shareWeight = Env.ZERO;
                BigDecimal shareVolume = Env.ZERO;
                if (revenuePlannedAll.longValue() != 0L) {
                    shareRevenue = revenuePlanned.divide(revenuePlannedAll, 5, 5);
                }
                if (weight_father != null && weight_father.longValue() != 0L) {
                    shareWeight = weight.divide(weight_father, 5, 5);
                }
                if (Volume_father != null && Volume_father.longValue() != 0L) {
                    shareVolume = volume.divide(Volume_father, 5, 5);
                }
                this.SHW_CostPlanned_Heritage(project, projectson, costPlannedFather, costActualFather, costExtrapolatedFather, shareVolume, shareWeight, shareRevenue);
            }
        }
        if (project.get_ValueAsInt("C_Project_Parent_ID") != 0) {
            MProject father = new MProject(project.getCtx(), project.get_ValueAsInt("C_Project_Parent_ID"), project.get_TrxName());
            result = this.SHW_CostPlannedHeritage_Parent(project, project.get_ValueAsInt("C_Project_Parent_ID"));
            father.set_ValueOfColumn("SHW_CostPlanned_Heritage", (Object)result);
            result = this.SHW_CostActualHeritage_Parent(project, project.getC_Project_ID());
            father.set_ValueOfColumn("SHW_CostActual_Heritage", (Object)result);
            result = this.SHW_CostExtrapolatedHeritage_Parent(project, project.getC_Project_ID());
            father.set_ValueOfColumn("SHW_CostExtrapolated_Heritage", (Object)result);
            father.saveEx();
            BigDecimal costPlannedFather = (BigDecimal)father.get_Value("SHW_CostPlanned");
            BigDecimal costActualFather = (BigDecimal)father.get_Value("SHW_CostActual");
            BigDecimal costExtrapolatedFather = (BigDecimal)father.get_Value("SHW_CostExtrapolated");
            BigDecimal revenuePlanned = this.SHW_RevenuePlanned_Sons(project, project.get_ValueAsInt("C_Project_Parent_ID"));
            BigDecimal revenueAllAct = this.SHW_RevenueActual_Sons(project, project.get_ValueAsInt("C_Project_Parent_ID"));
            BigDecimal revenueAllExtrapolated = this.SHW_RevenueExtrapolated_Sons(project, project.get_ValueAsInt("C_Project_Parent_ID"));
            BigDecimal weight_father = (BigDecimal)father.get_Value("Weight");
            BigDecimal Volume_father = (BigDecimal)father.get_Value("Volume");
            List projectsOfFather = new Query(project.getCtx(), "C_Project", "C_Project_Parent_ID=?", project.get_TrxName()).setParameters(project.get_ValueAsInt("C_Project_Parent_ID")).list();
            for (MProject projectson : projectsOfFather) {
                BigDecimal revenueExtrapolated = (BigDecimal)projectson.get_Value("SHW_RevenuePlanned");
                BigDecimal weight = (BigDecimal)projectson.get_Value("Weight");
                BigDecimal volume = (BigDecimal)projectson.get_Value("volume");
                if (volume == null) {
                    volume = Env.ZERO;
                }
                BigDecimal shareRevenue = Env.ZERO;
                BigDecimal shareWeight = Env.ZERO;
                BigDecimal shareVolume = Env.ZERO;
                if (revenueAllExtrapolated.longValue() != 0L) {
                    shareRevenue = revenueExtrapolated.divide(revenueAllExtrapolated, 5, 5);
                }
                if (weight_father != null && weight_father.longValue() != 0L) {
                    shareWeight = weight.divide(weight_father, 5, 5);
                }
                if (Volume_father != null && Volume_father.longValue() != 0L) {
                    shareVolume = volume.divide(Volume_father, 5, 5);
                }
                this.SHW_CostPlanned_Heritage(project, projectson, costPlannedFather, costActualFather, costExtrapolatedFather, shareVolume, shareWeight, shareRevenue);
            }
            father.set_ValueOfColumn("SHW_RevenuePlanned_Sons", (Object)revenuePlanned);
            father.set_ValueOfColumn("SHW_RevenueActual_Sons", (Object)revenueAllAct);
            father.set_ValueOfColumn("SHW_RevenueExtrapolated_Sons", (Object)revenueAllExtrapolated);
            father.saveEx();
            project.saveEx();
        }
        project.saveEx();
        return "";
    }

    private BigDecimal SHW_CostActual(MProject project) {
        String expresion = "LineNetAmtRealInvoiceLine(c_invoiceline_ID)";
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("c_invoice_ID in (select c_invoice_ID from c_invoice where docstatus in ('CO','CL') ");
        whereClause.append(" AND issotrx = 'N')");
        whereClause.append(" and (c_charge_ID is null or c_charge_ID not in (select c_charge_ID from c_charge where c_chargetype_ID in (1000003,1000002)))");
        whereClause.append(" and c_project_ID in (?)");
        BigDecimal result = Env.ZERO;
        result = new Query(project.getCtx(), "C_InvoiceLine", whereClause.toString(), project.get_TrxName()).setParameters(project.getC_Project_ID()).aggregate(expresion, "SUM");
        return result;
    }

    private BigDecimal SHW_CostPlanned(MProject project) {
        String expresion = "linenetamt - taxAmtReal(c_Orderline_ID)";
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("c_order_ID in (select c_order_ID from c_order where docstatus in ('CO','CL','IP') ");
        whereClause.append(" AND issotrx = 'N')");
        whereClause.append(" and (c_charge_ID is null or c_charge_ID not in (select c_charge_ID from c_charge where c_chargetype_ID in (1000003,1000002)))");
        whereClause.append(" and c_project_ID in (?)");
        BigDecimal result = Env.ZERO;
        result = new Query(project.getCtx(), "C_OrderLine", whereClause.toString(), project.get_TrxName()).setParameters(project.getC_Project_ID()).aggregate(expresion, "SUM");
        return result;
    }

    private BigDecimal SHW_NotInvoicedCost(MProject project) {
        String expresion = "((qtyordered-qtyinvoiced)*Priceactual) - (taxamt_Notinvoiced(c_Orderline_ID))";
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("c_order_ID in (select c_order_ID from c_order where docstatus in ('CO','CL') ");
        whereClause.append(" AND issotrx = 'N')");
        whereClause.append(" and (c_charge_ID is null or c_charge_ID not in (select c_charge_ID from c_charge where c_chargetype_ID in (1000003,1000002)))");
        whereClause.append(" and c_project_ID in (?)");
        BigDecimal amtNotInvoiced = Env.ZERO;
        amtNotInvoiced = new Query(project.getCtx(), "C_OrderLine", whereClause.toString(), project.get_TrxName()).setParameters(project.getC_Project_ID()).aggregate(expresion, "SUM");
        return amtNotInvoiced;
    }

    private BigDecimal SHW_CostExtrapolated(MProject project) {
        BigDecimal result = this.SHW_NotInvoicedCost(project).add(this.SHW_CostActual(project));
        return result;
    }

    private BigDecimal SHW_RevenueActual(MProject project) {
        String expresion = "LineNetAmtRealInvoiceLine(c_invoiceline_ID)";
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("c_invoice_ID in (select c_invoice_ID from c_invoice where docstatus in ('CO','CL') ");
        whereClause.append(" AND issotrx = 'Y')");
        whereClause.append(" and (c_charge_ID is null or c_charge_ID not in (select c_charge_ID from c_charge where c_chargetype_ID in (1000003,1000002)))");
        whereClause.append(" and c_project_ID in (?)");
        BigDecimal result = Env.ZERO;
        result = new Query(project.getCtx(), "C_InvoiceLine", whereClause.toString(), project.get_TrxName()).setParameters(project.getC_Project_ID()).aggregate(expresion, "SUM");
        return result;
    }

    private BigDecimal SHW_RevenuePlanned(MProject project) {
        String expresion = "linenetamt - taxAmtReal(c_Orderline_ID)";
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("c_order_ID in (select c_order_ID from c_order where docstatus in ('CO','CL','IP') ");
        whereClause.append(" AND issotrx = 'Y' )");
        whereClause.append(" and (c_charge_ID is null or c_charge_ID not in (select c_charge_ID from c_charge where c_chargetype_ID in (1000003,1000002)))");
        whereClause.append(" and c_project_ID in (?)");
        BigDecimal result = Env.ZERO;
        result = new Query(project.getCtx(), "C_OrderLine", whereClause.toString(), project.get_TrxName()).setParameters(project.getC_Project_ID()).aggregate(expresion, "SUM");
        return result;
    }

    private BigDecimal SHW_NotInvoicedRevenue(MProject project) {
        String expresion = "((qtyordered-qtyinvoiced)*Priceactual) - (taxamt_Notinvoiced(c_Orderline_ID))";
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("c_order_ID in (select c_order_ID from c_order where docstatus in ('CO','CL') ");
        whereClause.append(" AND issotrx = 'Y')");
        whereClause.append(" and (c_charge_ID is null or c_charge_ID not in (select c_charge_ID from c_charge where c_chargetype_ID in (1000003,1000002)))");
        whereClause.append(" and c_project_ID in (?)");
        BigDecimal amtNotInvoiced = Env.ZERO;
        amtNotInvoiced = new Query(project.getCtx(), "C_OrderLine", whereClause.toString(), project.get_TrxName()).setParameters(project.getC_Project_ID()).aggregate(expresion, "SUM");
        return amtNotInvoiced;
    }

    private BigDecimal SHW_RevenueExtrapolated(MProject project) {
        BigDecimal result = this.SHW_NotInvoicedRevenue(project).add(this.SHW_RevenueActual(project));
        return result;
    }

    private BigDecimal SHW_RevenueActual_Sons(MProject project, int c_project_parent_ID) {
        String expresion = "LineNetAmtRealInvoiceLine(c_invoiceline_ID)";
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("c_invoice_ID in (select c_invoice_ID from c_invoice where docstatus in ('CO','CL') ");
        whereClause.append(" AND issotrx = 'Y')");
        whereClause.append(" and (c_charge_ID is null or c_charge_ID not in (select c_charge_ID from c_charge where c_chargetype_ID in (1000003,1000002)))");
        whereClause.append(" and c_project_ID in (select c_project_ID from c_project where c_project_parent_ID =?)");
        BigDecimal result = Env.ZERO;
        result = new Query(project.getCtx(), "C_InvoiceLine", whereClause.toString(), project.get_TrxName()).setParameters(c_project_parent_ID).aggregate(expresion, "SUM");
        return result;
    }

    private BigDecimal SHW_RevenuePlanned_Sons(MProject project, int c_Project_Parent_ID) {
        String expresion = "linenetamt - taxAmtReal(c_Orderline_ID)";
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("c_order_ID in (select c_order_ID from c_order where docstatus in ('CO','CL','IP') ");
        whereClause.append(" AND issotrx = 'Y')");
        whereClause.append(" and (c_charge_ID is null or c_charge_ID not in (select c_charge_ID from c_charge where c_chargetype_ID in (1000003,1000002)))");
        whereClause.append(" and c_project_ID in (select c_project_ID from c_project where c_project_parent_ID =?)");
        BigDecimal result = Env.ZERO;
        result = new Query(project.getCtx(), "C_OrderLine", whereClause.toString(), project.get_TrxName()).setParameters(c_Project_Parent_ID).aggregate(expresion, "SUM");
        return result;
    }

    private BigDecimal SHW_NotInvoicedRevenue_Sons(MProject project, int c_Project_Parent_ID) {
        String expresion = "((qtyordered-qtyinvoiced)*Priceactual) - (taxamt_Notinvoiced(c_Orderline_ID))";
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("c_order_ID in (select c_order_ID from c_order where docstatus in ('CO','CL') ");
        whereClause.append(" AND issotrx = 'Y')");
        whereClause.append(" and (c_charge_ID is null or c_charge_ID not in (select c_charge_ID from c_charge where c_chargetype_ID in (1000003,1000002)))");
        whereClause.append("  and c_project_ID in (select c_project_ID from c_project where c_project_parent_ID =?)");
        BigDecimal amtNotInvoiced = Env.ZERO;
        amtNotInvoiced = new Query(project.getCtx(), "C_OrderLine", whereClause.toString(), project.get_TrxName()).setParameters(c_Project_Parent_ID).aggregate(expresion, "SUM");
        return amtNotInvoiced;
    }

    private BigDecimal SHW_RevenueExtrapolated_Sons(MProject project, int c_project_Parent_ID) {
        BigDecimal result = this.SHW_NotInvoicedRevenue_Sons(project, c_project_Parent_ID).add(this.SHW_RevenueActual_Sons(project, c_project_Parent_ID));
        return result;
    }

    private BigDecimal SHW_CostPlannedHeritage_Parent(MProject project, int c_Project_Parent_ID) {
        String expresion = "linenetamt - taxAmtReal(c_Orderline_ID)";
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("c_order_ID in (select c_order_ID from c_order where docstatus in ('CO','CL','IP') ");
        whereClause.append(" AND issotrx = 'N')");
        whereClause.append(" and (c_charge_ID is null or c_charge_ID not in (select c_charge_ID from c_charge where c_chargetype_ID in (1000003,1000002)))");
        whereClause.append(" and c_project_ID in (select c_project_ID from c_project where c_project_parent_ID =?)");
        BigDecimal result = Env.ZERO;
        result = new Query(project.getCtx(), "C_OrderLine", whereClause.toString(), project.get_TrxName()).setParameters(c_Project_Parent_ID).aggregate(expresion, "SUM");
        return result;
    }

    private BigDecimal SHW_CostActualHeritage_Parent(MProject project, int c_Project_Parent_ID) {
        String expresion = "LineNetAmtRealInvoiceLine(c_invoiceline_ID)";
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("c_invoice_ID in (select c_invoice_ID from c_invoice where docstatus in ('CO','CL') ");
        whereClause.append(" AND issotrx = 'N')");
        whereClause.append(" and (c_charge_ID is null or c_charge_ID not in (select c_charge_ID from c_charge where c_chargetype_ID in (1000003,1000002)))");
        whereClause.append(" and c_project_ID in (select c_project_ID from c_project where c_project_parent_ID =?)");
        BigDecimal result = Env.ZERO;
        result = new Query(project.getCtx(), "C_InvoiceLine", whereClause.toString(), project.get_TrxName()).setParameters(project.getC_Project_ID()).aggregate(expresion, "SUM");
        return result;
    }

    private BigDecimal SHW_NotInvoiceCostHeritage_Parent(MProject project, int c_Project_Parent_ID) {
        String expresion = "((qtyordered-qtyinvoiced)*Priceactual) - (taxamt_Notinvoiced(c_Orderline_ID))";
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("c_order_ID in (select c_order_ID from c_order where docstatus in ('CO','CL') ");
        whereClause.append(" AND issotrx = 'N')");
        whereClause.append(" and (c_charge_ID is null or c_charge_ID not in (select c_charge_ID from c_charge where c_chargetype_ID in (1000003,1000002)))");
        whereClause.append(" and c_project_ID in (select c_project_ID from c_project where c_project_parent_ID =?)");
        BigDecimal result = Env.ZERO;
        result = new Query(project.getCtx(), "C_OrderLine", whereClause.toString(), project.get_TrxName()).setParameters(c_Project_Parent_ID).aggregate(expresion, "SUM");
        return result;
    }

    private BigDecimal SHW_CostExtrapolatedHeritage_Parent(MProject project, int c_Project_Parent_ID) {
        return this.SHW_NotInvoiceCostHeritage_Parent(project, c_Project_Parent_ID).add(this.SHW_CostActualHeritage_Parent(project, c_Project_Parent_ID));
    }

    private Boolean SHW_CostPlanned_Heritage(MProject project, MProject son, BigDecimal costPlannedFather, BigDecimal costActualFather, BigDecimal costExtrapolatedFather, BigDecimal shareVolume, BigDecimal shareWeight, BigDecimal shareRevenue) {
        BigDecimal result = Env.ZERO;
        result = costPlannedFather.multiply(shareRevenue);
        son.set_ValueOfColumn("SHW_CostPlanned_Heritage", (Object)result);
        result = costPlannedFather.multiply(shareVolume);
        son.set_ValueOfColumn("SHW_CostPlanned_Heritage_V", (Object)result);
        result = costPlannedFather.multiply(shareWeight);
        son.set_ValueOfColumn("SHW_CostPlanned_Heritage_W", (Object)result);
        result = costActualFather.multiply(shareRevenue);
        son.set_ValueOfColumn("SHW_CostActual_Heritage", (Object)result);
        result = costActualFather.multiply(shareVolume);
        son.set_ValueOfColumn("SHW_CostActual_Heritage_V", (Object)result);
        result = costActualFather.multiply(shareWeight);
        son.set_ValueOfColumn("SHW_CostActual_Heritage_W", (Object)result);
        result = costExtrapolatedFather.multiply(shareRevenue);
        son.set_ValueOfColumn("SHW_CostExtrapolated_Heritage", (Object)result);
        result = costExtrapolatedFather.multiply(shareVolume);
        son.set_ValueOfColumn("SHW_CostExtrapol_Heritage_V", (Object)result);
        result = costExtrapolatedFather.multiply(shareWeight);
        son.set_ValueOfColumn("SHW_CostExtrapol_Heritage_W", (Object)result);
        if (son.getC_Project_ID() != project.getC_Project_ID()) {
            son.saveEx();
        }
        return true;
    }

    String purchaseInvoiceCreateOrderLine(PO A_PO) {
        MOrder order = (MOrder)A_PO;
        MDocType doctype = (MDocType)order.getC_DocTypeTarget();
        Boolean isSalesOrderImmediate = doctype.get_ValueAsBoolean("isSalesOrderImmediate");
        if (!isSalesOrderImmediate.booleanValue()) {
            return "";
        }
        MProject project = (MProject)order.getC_Project();
        String whereClause = "issotrx = 'Y' and docstatus in ('DR','IP') and c_doctypetarget_ID not in (1000424, 1000375) and c_project_ID =?";
        String projectclause = "";
        projectclause = !project.isSummary() ? "C_Project_ID =?" : "C_Project_Parent_ID =?";
        List projects = new Query(A_PO.getCtx(), "C_Project", projectclause, A_PO.get_TrxName()).setParameters(project.getC_Project_ID()).setOrderBy("C_Project_ID").list();
        for (MOrderLine oLine : order.getLines()) {
            List iLineHistory;
            if (!oLine.get_ValueAsBoolean("isSalesOrderImmediate") || !(iLineHistory = new Query(A_PO.getCtx(), "C_OrderLine", "c_orderline_PO_ID =?", A_PO.get_TrxName()).setParameters(oLine.getC_OrderLine_ID()).list()).isEmpty()) continue;
            MOrder salesOrder = null;
            for (MProject projectHijo : projects) {
                salesOrder = oLine.get_ValueAsInt("c_OrderSO_ID") > 0 ? new MOrder(A_PO.getCtx(), oLine.get_ValueAsInt("c_OrderSO_ID"), A_PO.get_TrxName()) : (MOrder)new Query(A_PO.getCtx(), "C_Order", whereClause, A_PO.get_TrxName()).setParameters(projectHijo.getC_Project_ID()).setOnlyActiveRecords(true).first();
                if (salesOrder != null && salesOrder.getC_Order_ID() != 0) {
                    MOrderLine oSalesLine = new MOrderLine(salesOrder);
                    if (oLine.getM_Product_ID() > 0) {
                        StringBuffer sql = new StringBuffer("select coalesce(bpp.substitute_ID, p.substitute_ID, p.m_product_ID) ");
                        sql.append(" from m_product p  ");
                        sql.append(" left join c_bpartner_product  bpp on p.m_product_ID = bpp.m_product_ID and bpp.c_bpartner_ID =?");
                        sql.append("  where p.m_product_ID =?");
                        ArrayList<Object> params = new ArrayList<Object>();
                        params.add(salesOrder.getC_BPartner_ID());
                        params.add(oLine.getM_Product_ID());
                        int M_Product_ID = DB.getSQLValueEx(salesOrder.get_TrxName(), sql.toString(), params);
                        MProductPricing pp = new MProductPricing(M_Product_ID, salesOrder.getC_BPartner_ID(), oLine.getQtyOrdered(), salesOrder.isSOTrx(), null);
                        MPriceList pl = (MPriceList)salesOrder.getM_PriceList();
                        pp.setM_PriceList_ID(pl.getM_PriceList_ID());
                        MPriceListVersion plv = pl.getPriceListVersion(salesOrder.getDateOrdered());
                        if (plv == null) {
                            return "No existe una versi\u00f3n v\u00e1lida de la lista de precios";
                        }
                        pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
                        pp.setPriceDate(salesOrder.getDateOrdered());
                        oSalesLine.setM_Product_ID(M_Product_ID);
                        oSalesLine.setPrice(pp.getPriceStd());
                    }
                    if (oLine.getC_Charge_ID() > 0) {
                        oSalesLine.setC_Charge_ID(oLine.getC_Charge_ID());
                        oSalesLine.setPrice(oLine.getPriceActual());
                    }
                    oSalesLine.setC_Project_ID(projectHijo.getC_Project_ID());
                    oSalesLine.setQty(oLine.getQtyEntered());
                    oSalesLine.setC_Tax_ID(oLine.getC_Tax_ID());
                    oSalesLine.set_ValueOfColumn("c_orderline_PO_ID", (Object)oLine.getC_OrderLine_ID());
                    oSalesLine.saveEx();
                    continue;
                }
                return "No existe una orden de venta para el projecto " + projectHijo.getValue();
            }
        }
        return "";
    }

    private Boolean addPayment(MPayment payment) {
        MBankStatementLine bankStatementLine = payment.getBankStatementLine();
        if (bankStatementLine != null && bankStatementLine.getC_BankStatement_ID() > 0) {
            return true;
        }
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("C_BankAccount_ID").append("=? AND ").append("TRUNC(").append("StatementDate").append(",'DD')<=? AND ").append("Processed").append("=?");
        MBankStatement bankStatement = (MBankStatement)new Query(payment.getCtx(), "C_BankStatement", whereClause.toString(), payment.get_TrxName()).setClient_ID().setParameters(payment.getC_BankAccount_ID(), TimeUtil.getDay(payment.getDateTrx()), false).first();
        if (bankStatement == null || bankStatement.get_ID() <= 0) {
            bankStatement = new MBankStatement(payment.getCtx(), 0, payment.get_TrxName());
            bankStatement.setC_BankAccount_ID(payment.getC_BankAccount_ID());
            bankStatement.setStatementDate(payment.getDateAcct());
            if (payment.getDescription() != null) {
                bankStatement.setName(payment.getDescription());
            } else {
                SimpleDateFormat format = DisplayType.getDateFormat(15);
                bankStatement.setName(Msg.parseTranslation(payment.getCtx(), "@Generate@: ") + format.format(payment.getDateAcct()));
            }
            bankStatement.saveEx();
        }
        bankStatementLine = new MBankStatementLine(bankStatement);
        bankStatementLine.setPayment(payment);
        bankStatementLine.setStatementLineDate(payment.getDateAcct());
        bankStatementLine.setDateAcct(payment.getDateAcct());
        bankStatementLine.saveEx();
        return true;
    }

    String orderLine_setLineNetAmt(PO A_PO) {
        MProduct product;
        MOrderLine orderLine = (MOrderLine)A_PO;
        boolean documentLevel = orderLine.getC_Tax().isDocumentLevel();
        MTax orderTax = (MTax)orderLine.getC_Tax();
        if (!orderLine.getC_Order().getM_PriceList().isTaxIncluded() || documentLevel) {
            return "";
        }
        BigDecimal lineNetAmount = null;
        int stdTax_ID = 0;
        if (orderLine.getProduct() == null) {
            if (orderLine.getCharge() != null) {
                stdTax_ID = ((MTaxCategory)orderLine.getCharge().getC_TaxCategory()).getDefaultTax().getC_Tax_ID();
            }
        } else {
            stdTax_ID = ((MTaxCategory)orderLine.getProduct().getC_TaxCategory()).getDefaultTax().getC_Tax_ID();
        }
        if (orderLine.getC_Tax_ID() == stdTax_ID) {
            return "";
        }
        if (orderLine.getM_Product_ID() != 0 && (product = MProduct.get(orderLine.getCtx(), orderLine.getM_Product_ID(), orderLine.get_TrxName())).getC_UOM_ID() != orderLine.getC_UOM_ID() && orderLine.getPriceEntered() != null && !orderLine.getPriceEntered().equals(Env.ZERO) && orderLine.getQtyEntered() != null && !orderLine.getQtyEntered().equals(Env.ZERO)) {
            lineNetAmount = orderLine.getQtyEntered().multiply(orderLine.getPriceEntered());
        }
        if (lineNetAmount == null) {
            lineNetAmount = orderLine.getPriceActual().multiply(orderLine.getQtyOrdered());
        }
        if (lineNetAmount.scale() > orderLine.getPrecision()) {
            lineNetAmount = lineNetAmount.setScale(orderLine.getPrecision(), 4);
        }
        orderLine.setLineNetAmt(lineNetAmount);
        return "";
    }

    String invoiceLine_setLineNetAmt(PO A_PO) {
        MProduct product;
        MInvoiceLine invoiceLine = (MInvoiceLine)A_PO;
        boolean documentLevel = invoiceLine.getC_Tax().isDocumentLevel();
        MTax orderTax = (MTax)invoiceLine.getC_Tax();
        if (!invoiceLine.getC_Invoice().getM_PriceList().isTaxIncluded() || documentLevel) {
            return "";
        }
        BigDecimal lineNetAmount = null;
        int stdTax_ID = 0;
        if (invoiceLine.getProduct() == null) {
            if (invoiceLine.getCharge() != null) {
                stdTax_ID = ((MTaxCategory)invoiceLine.getCharge().getC_TaxCategory()).getDefaultTax().getC_Tax_ID();
            }
        } else {
            stdTax_ID = ((MTaxCategory)invoiceLine.getProduct().getC_TaxCategory()).getDefaultTax().getC_Tax_ID();
        }
        if (invoiceLine.getC_Tax_ID() == stdTax_ID) {
            return "";
        }
        if (invoiceLine.getM_Product_ID() != 0 && (product = MProduct.get(invoiceLine.getCtx(), invoiceLine.getM_Product_ID(), invoiceLine.get_TrxName())).getC_UOM_ID() != invoiceLine.getC_UOM_ID() && invoiceLine.getPriceEntered() != null && !invoiceLine.getPriceEntered().equals(Env.ZERO) && invoiceLine.getQtyEntered() != null && !invoiceLine.getQtyEntered().equals(Env.ZERO)) {
            lineNetAmount = invoiceLine.getQtyEntered().multiply(invoiceLine.getPriceEntered());
        }
        if (lineNetAmount == null) {
            lineNetAmount = invoiceLine.getPriceActual().multiply(invoiceLine.getQtyInvoiced());
        }
        if (lineNetAmount.scale() > invoiceLine.getPrecision()) {
            lineNetAmount = lineNetAmount.setScale(invoiceLine.getPrecision(), 4);
        }
        invoiceLine.setLineNetAmt(lineNetAmount);
        return "";
    }
}

