/*
 * Decompiled with CFR 0.152.
 */
package org.shw.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.compiere.model.MBankAccount;
import org.compiere.model.MPayment;
import org.compiere.model.PO;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.shw.process.BankTransferAbstract;

public class BankTransfer
extends BankTransferAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        Timestamp statementDate = this.getStatementDate();
        Timestamp dateAcct = this.getDateAcct();
        int projectID = BankTransfer.getProcessId();
        if (this.getCBankAccountId() == this.getBankAccountToId()) {
            return "Banco origen = banco destino";
        }
        if (this.getAmount().compareTo(new BigDecimal(0)) == 0) {
            return "El monto es cero";
        }
        if (this.getStatementDate() == null) {
            statementDate = Env.getContextAsDate(this.getCtx(), "#Date");
        }
        if (this.getStatementDate() == null) {
            statementDate = new Timestamp(System.currentTimeMillis());
        }
        if (this.getDateAcct() == null) {
            dateAcct = this.getStatementDate();
        }
        int m_created = 0;
        MBankAccount mBankFrom = new MBankAccount(this.getCtx(), this.getCBankAccountId(), this.get_TrxName());
        MBankAccount mBankTo = new MBankAccount(this.getCtx(), this.getBankAccountToId(), this.get_TrxName());
        MPayment paymentBankFrom = new MPayment(this.getCtx(), 0, this.get_TrxName());
        paymentBankFrom.setC_BankAccount_ID(mBankFrom.getC_BankAccount_ID());
        paymentBankFrom.setC_DocType_ID(false);
        String value = DB.getDocumentNo(paymentBankFrom.getC_DocType_ID(), this.get_TrxName(), false, (PO)paymentBankFrom);
        paymentBankFrom.setDocumentNo(value);
        paymentBankFrom.setDateAcct(dateAcct);
        paymentBankFrom.setDateTrx(statementDate);
        paymentBankFrom.setTenderType(this.getTenderType());
        paymentBankFrom.setDescription(this.getDescription());
        paymentBankFrom.setC_BPartner_ID(this.getBPartnerId());
        paymentBankFrom.setC_Currency_ID(this.getCurrencyId());
        if (this.getConversionTypeId() > 0) {
            paymentBankFrom.setC_ConversionType_ID(this.getConversionTypeId());
        }
        paymentBankFrom.setPayAmt(this.getAmount());
        paymentBankFrom.setOverUnderAmt(Env.ZERO);
        paymentBankFrom.setC_Charge_ID(this.getChargeId());
        paymentBankFrom.setCheckNo(this.getCheckNo());
        if (projectID > 0) {
            paymentBankFrom.setC_Project_ID(projectID);
        }
        if (this.getOrgId() > 0) {
            paymentBankFrom.setAD_Org_ID(this.getOrgId());
        }
        if (this.getUser1Id() > 0) {
            paymentBankFrom.setUser1_ID(this.getUser1Id());
        }
        paymentBankFrom.saveEx();
        paymentBankFrom.processIt("CO");
        paymentBankFrom.saveEx();
        MPayment paymentBankTo = new MPayment(this.getCtx(), 0, this.get_TrxName());
        paymentBankTo.setC_BankAccount_ID(mBankTo.getC_BankAccount_ID());
        paymentBankTo.setC_DocType_ID(true);
        value = DB.getDocumentNo(paymentBankTo.getC_DocType_ID(), this.get_TrxName(), false, (PO)paymentBankTo);
        paymentBankTo.setDocumentNo(value);
        paymentBankTo.setDateAcct(dateAcct);
        paymentBankTo.setDateTrx(statementDate);
        paymentBankTo.setTenderType(this.getTenderType());
        paymentBankTo.setDescription(this.getDescription());
        paymentBankTo.setC_BPartner_ID(this.getBPartnerId());
        paymentBankTo.setC_Currency_ID(this.getCurrencyId());
        if (this.getConversionTypeId() > 0) {
            paymentBankFrom.setC_ConversionType_ID(this.getConversionTypeId());
        }
        paymentBankTo.setPayAmt(this.getAmount());
        paymentBankTo.setOverUnderAmt(Env.ZERO);
        paymentBankTo.setC_Charge_ID(this.getChargeId());
        paymentBankTo.setRef_Payment_ID(paymentBankFrom.getC_Payment_ID());
        if (this.getProjectId() > 0) {
            paymentBankTo.setC_Project_ID(this.getProjectId());
        }
        if (this.getOrgId() > 0) {
            paymentBankTo.setAD_Org_ID(this.getOrgId());
        }
        if (this.getUser1Id() > 0) {
            paymentBankTo.setUser1_ID(this.getUser1Id());
        }
        paymentBankTo.saveEx();
        paymentBankTo.processIt("CO");
        paymentBankTo.saveEx();
        paymentBankFrom.setRef_Payment_ID(paymentBankTo.getC_Payment_ID());
        paymentBankFrom.saveEx();
        return "@Created@ = " + ++m_created;
    }
}

