/*
 * Decompiled with CFR 0.152.
 */
package org.shw.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import org.adempiere.engine.CostEngineFactory;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCampaign;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MJournalLine;
import org.compiere.model.MLandedCostAllocation;
import org.compiere.model.MPeriod;
import org.compiere.model.ProductCost;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CloseRetaceo
extends SvrProcess {
    int c_campaign_ID = 0;
    int p_C_AcctSchema_ID;
    MJournal journal = null;
    MJournalBatch journalBatch = null;
    int charge_Acct = 0;
    MAcctSchema as = null;
    MCampaign retaceo = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] parameters;
        for (ProcessInfoParameter parameter : parameters = this.getParameter()) {
            String name = parameter.getParameterName();
            if (parameter.getParameter() == null) {
                // empty if block
            }
            if (!name.equals("C_AcctSchema_ID")) continue;
            this.p_C_AcctSchema_ID = parameter.getParameterAsInt();
        }
        this.c_campaign_ID = this.getRecord_ID();
        this.retaceo = new MCampaign(this.getCtx(), this.c_campaign_ID, this.get_TrxName());
    }

    @Override
    protected String doIt() throws Exception {
        this.as = new MAcctSchema(this.getCtx(), this.p_C_AcctSchema_ID, this.get_TrxName());
        this.completeReceipt();
        this.distributeLandedCosts();
        this.retaceo.set_ValueOfColumn("DocStatus", (Object)"CL");
        this.retaceo.set_ValueOfColumn("GL_JournalBatch_ID", (Object)this.journalBatch.getGL_JournalBatch_ID());
        this.retaceo.saveEx();
        return this.journalBatch.getDocumentNo();
    }

    private Boolean completeReceipt() {
        List receipts = new Query(this.getCtx(), "M_InOut", "c_campaign_ID=? and docstatus in ('DR','IP')", this.get_TrxName()).setParameters(this.getRecord_ID()).list();
        for (MInOut io : receipts) {
            io.processIt("CO");
            io.saveEx();
        }
        return true;
    }

    private Boolean distributeLandedCosts() {
        String whereClause = " c_invoice_ID IN (select c_invoice_ID from c_invoice where c_campaign_ID =?) and exists (select 1 from c_landedcostallocation where c_invoiceline_ID = c_invoiceline.c_invoiceline_ID)  and c_invoiceline_ID not in (select coalesce(c_invoiceline_ID,0)  from gl_journal)";
        List invoices = new Query(this.getCtx(), "C_InvoiceLine", whereClause, this.get_TrxName()).setParameters(this.c_campaign_ID).list();
        for (MInvoiceLine ivl : invoices) {
            this.generateCostDetail(ivl);
            this.createJournalBatch(ivl);
            this.createJournal(ivl);
            this.CreateHeaderLine(ivl);
            this.distributeLandedCostsAmount(ivl);
        }
        return true;
    }

    private Boolean distributeLandedCostsAmount(MInvoiceLine ivl) {
        String whereClause = "c_invoiceLine_ID =?";
        BigDecimal lineNetAmt = ivl.getLineNetAmt();
        BigDecimal controlamt = Env.ZERO;
        List lcas = new Query(this.getCtx(), "C_LandedCostAllocation", whereClause, this.get_TrxName()).setParameters(ivl.getC_InvoiceLine_ID()).list();
        for (MLandedCostAllocation lca : lcas) {
            controlamt = controlamt.add(lca.getAmt());
            this.CreateLcaLine(lca);
        }
        if (lineNetAmt.compareTo(controlamt) != 0) {
            return false;
        }
        return true;
    }

    private String createJournalBatch(MInvoiceLine ivl) {
        if (this.journalBatch != null) {
            return "";
        }
        this.journalBatch = new MJournalBatch(this.getCtx(), 0, this.get_TrxName());
        if (this.journalBatch == null) {
            return "No fue posible crear la partida";
        }
        MDocType doctype = (MDocType)new Query(this.getCtx(), "C_DocType", "DocBaseType = ?", this.get_TrxName()).setParameters("GLJ").setClient_ID().first();
        if (doctype == null) {
            return "Falta tipo de documento de Cierre";
        }
        this.journalBatch.setGL_Category_ID(doctype.getGL_Category_ID());
        this.journalBatch.setAD_Org_ID(ivl.getAD_Org_ID());
        MPeriod per = MPeriod.get(this.getCtx(), Env.getContextAsDate(this.getCtx(), "#Date"), 0);
        this.journalBatch.setC_Period_ID(per.getC_Period_ID());
        this.journalBatch.setDateAcct(new Timestamp(System.currentTimeMillis()));
        this.journalBatch.setDateDoc(new Timestamp(System.currentTimeMillis()));
        this.journalBatch.setDescription("Distribuci\u00f3n de Costos  " + ivl.getC_Invoice().getDocumentNo());
        this.journalBatch.setC_DocType_ID(doctype.getC_DocType_ID());
        this.journalBatch.setDocumentNo("Distribuci\u00f3n de Costos " + this.retaceo.getName());
        this.journalBatch.setControlAmt(Env.ZERO);
        this.journalBatch.setC_Currency_ID(this.as.getC_Currency_ID());
        this.journalBatch.saveEx();
        return "";
    }

    private String createJournal(MInvoiceLine ivl) {
        this.journal = new MJournal(this.journalBatch);
        MAcctSchema as = new MAcctSchema(this.getCtx(), this.p_C_AcctSchema_ID, this.get_TrxName());
        if (this.journal == null) {
            return "No fue posible crear la partida";
        }
        String sql = "SELECT CH_Expense_Acct FROM C_Charge_Acct WHERE C_Charge_ID=? AND C_AcctSchema_ID=?";
        this.charge_Acct = DB.getSQLValue(this.get_TrxName(), sql, ivl.getC_Charge_ID(), this.p_C_AcctSchema_ID);
        if (this.charge_Acct == 0) {
            return "El cargo no esta definido";
        }
        this.journal.setC_Currency_ID(as.getC_Currency_ID());
        this.journal.setC_AcctSchema_ID(as.get_ID());
        this.journal.setC_ConversionType_ID(114);
        this.journal.setDocumentNo(DB.getDocumentNo(this.getAD_Client_ID(), "GL_Journal", this.get_TrxName()));
        this.journal.setDescription(ivl.getC_Invoice().getDocumentNo() + " ");
        this.journal.setGL_Category_ID(this.journalBatch.getGL_Category_ID());
        this.journal.save();
        this.journal.setControlAmt(ivl.getLineNetAmt());
        this.journal.set_ValueOfColumn("C_InvoiceLine_ID", (Object)ivl.getC_InvoiceLine_ID());
        return "";
    }

    private Boolean CreateHeaderLine(MInvoiceLine ivl) {
        MJournalLine CR = new MJournalLine(this.journal);
        CR.setC_ValidCombination_ID(this.charge_Acct);
        CR.setAmtSourceCr(ivl.getLineNetAmt());
        CR.setDescription(ivl.getC_Charge().getName());
        CR.saveEx();
        return true;
    }

    private Boolean CreateLcaLine(MLandedCostAllocation lca) {
        MJournalLine DR = new MJournalLine(this.journal);
        ProductCost pc = new ProductCost(Env.getCtx(), lca.getM_Product_ID(), lca.getM_AttributeSetInstance_ID(), this.get_TrxName());
        MAccount combi = pc.getAccount(3, this.as);
        DR.setDescription(lca.getM_Product().getName());
        DR.set_ValueOfColumn("Account_ID", (Object)combi.getAccount_ID());
        DR.set_ValueOfColumn("C_SubAcct_ID", combi.getC_SubAcct_ID() > 0 ? Integer.valueOf(combi.getC_SubAcct_ID()) : null);
        DR.set_ValueOfColumn("M_Product_ID", (Object)lca.getM_Product_ID());
        DR.set_ValueOfColumn("C_BPartner_ID", (Object)lca.getC_InvoiceLine().getC_Invoice().getC_BPartner_ID());
        DR.set_ValueOfColumn("AD_OrgTrx_ID", combi.getAD_OrgTrx_ID() > 0 ? Integer.valueOf(combi.getAD_OrgTrx_ID()) : null);
        DR.set_ValueOfColumn("C_LocFrom_ID", combi.getC_LocFrom_ID() > 0 ? Integer.valueOf(combi.getC_LocFrom_ID()) : null);
        DR.set_ValueOfColumn("C_LocTo_ID", combi.getC_LocTo_ID() > 0 ? Integer.valueOf(combi.getC_LocTo_ID()) : null);
        DR.set_ValueOfColumn("C_SalesRegion_ID", combi.getC_SalesRegion_ID() > 0 ? Integer.valueOf(combi.getC_SalesRegion_ID()) : null);
        DR.set_ValueOfColumn("C_Project_ID", (Object)lca.getC_InvoiceLine().getC_Project_ID());
        DR.set_ValueOfColumn("C_Campaign_ID", (Object)this.c_campaign_ID);
        DR.set_ValueOfColumn("C_Activity_ID", (Object)lca.getC_InvoiceLine().getC_Invoice().getC_Activity_ID());
        DR.set_ValueOfColumn("User1_ID", (Object)lca.getC_InvoiceLine().getC_Invoice().getUser1_ID());
        DR.set_ValueOfColumn("User2_ID", (Object)lca.getC_InvoiceLine().getC_Invoice().getUser2_ID());
        DR.setAmtSourceDr(lca.getAmt());
        DR.set_ValueOfColumn("C_LandedCostAllocation_ID", (Object)lca.getC_LandedCostAllocation_ID());
        DR.saveEx();
        return true;
    }

    private void generateCostDetail(MInvoiceLine ivl) {
        for (MLandedCostAllocation allocation : MLandedCostAllocation.getOfInvoiceLine(this.getCtx(), ivl.getC_InvoiceLine_ID(), this.get_TrxName())) {
            CostEngineFactory.getCostEngine(this.getAD_Client_ID()).createCostDetailForLandedCostAllocation(allocation);
        }
    }
}

