/*
 * Decompiled with CFR 0.152.
 */
package org.shw.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.core.domains.models.I_C_Project;
import org.adempiere.core.domains.models.X_C_TaxDefinition;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProject;
import org.compiere.model.MRequest;
import org.compiere.model.MStatus;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.shw.process.CreateOdCForProductAbstract;

public class CreateOdCForProduct
extends CreateOdCForProductAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MRequest request = new MRequest(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        MProject project = (MProject)request.getC_Project();
        for (int key : this.getSelectionKeys()) {
            int bpartnerID = this.getSelectionAsInt(key, "BP_C_BPartner_ID");
            int productID = this.getSelectionAsInt(key, "PP_M_Product_ID");
            BigDecimal price = this.getSelectionAsBigDecimal(key, "PP_PriceStd");
            int bpLocationID = this.getSelectionAsInt(key, "BPL_C_BPartner_Location_ID");
            int priceListID = this.getSelectionAsInt(key, "PL_M_PriceList_ID");
            int paymentTermID = this.getSelectionAsInt(key, "BP_PO_PaymentTerm_ID");
            MOrder order = this.getofBPartner(bpartnerID, this.getDocTypeId(), request.getC_Project_ID());
            if (order == null) {
                order = this.createOrder(request.getC_Project(), bpartnerID, bpLocationID, priceListID, paymentTermID, this.getDocTypeId());
            }
            MOrderLine orderLine = null;
            if (order == null) continue;
            orderLine = new MOrderLine(order);
            orderLine.setM_Product_ID(productID);
            orderLine.setPrice(price);
            orderLine.setQty(Env.ONE);
            orderLine.set_ValueOfColumn("isSalesOrderImmediate", (Object)"Y");
            orderLine.set_ValueOfColumn("Weight", project.get_Value("Weight"));
            orderLine.set_ValueOfColumn("Bultos", request.get_Value("Bultos"));
            orderLine.set_ValueOfColumn("Volume", project.get_Value("Volume"));
            orderLine.set_ValueOfColumn("Pedido", project.get_Value("Pedido"));
            this.taxDefinition(orderLine);
            orderLine.saveEx();
            order.processIt("PR");
            request.setC_Order_ID(order.getC_Order_ID());
            request.setC_OrderLine_ID(orderLine.getC_OrderLine_ID());
            request.setM_Product_ID(orderLine.getM_Product_ID());
            request.saveEx();
            this.requestFinalClose(request);
        }
        return "";
    }

    private MOrder createOrder(I_C_Project i_project, int bpartnerID, int bpLocationID, int priceListID, int paymentTermID, int docTypeID) {
        MProject project = (MProject)i_project;
        MOrder order = new MOrder(this.getCtx(), 0, this.get_TrxName());
        order.setClientOrg(project.getAD_Client_ID(), project.getAD_Org_ID());
        order.setC_Campaign_ID(project.getC_Campaign_ID());
        order.setSalesRep_ID(project.getSalesRep_ID());
        order.setC_Project_ID(project.getC_Project_ID());
        order.setDescription(project.getName());
        order.setC_BPartner_ID(bpartnerID);
        order.setC_BPartner_Location_ID(bpLocationID);
        order.setAD_User_ID(project.getAD_User_ID());
        order.setUser1_ID(project.get_ValueAsInt("User1_ID"));
        order.setM_Warehouse_ID(project.getM_Warehouse_ID());
        order.setM_PriceList_ID(priceListID);
        order.setC_PaymentTerm_ID(paymentTermID);
        order.setIsSOTrx(false);
        order.setC_DocTypeTarget_ID(docTypeID);
        order.saveEx();
        return order;
    }

    private MOrder getofBPartner(int bpartnerID, int doctypeID, int projectID) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(bpartnerID);
        parameters.add(doctypeID);
        parameters.add(projectID);
        String whereClause = "C_BPartner_ID=? AND C_DocTypeTarget_ID=? AND C_Project_ID=? AND Processed='N'";
        MOrder order = (MOrder)new Query(this.getCtx(), "C_Order", whereClause, this.get_TrxName()).setParameters(parameters).setOnlyActiveRecords(true).setOrderBy("DateOrdered").first();
        return order;
    }

    private void requestFinalClose(MRequest request) {
        if (request.getStatus().isClosed()) {
            return;
        }
        String whereClause = " EXISTS (SELECT * FROM R_RequestType rt INNER JOIN R_StatusCategory sc ON (rt.R_StatusCategory_ID=sc.R_StatusCategory_ID)WHERE R_Status.R_StatusCategory_ID=sc.R_StatusCategory_ID AND rt.R_RequestType_ID=?)";
        List statusList = new Query(this.getCtx(), "R_Status", whereClause, this.get_TrxName()).setParameters(request.getR_RequestType_ID()).list();
        for (MStatus statusClosed : statusList) {
            if (!statusClosed.isFinalClose()) continue;
            request.setR_Status_ID(statusClosed.getR_Status_ID());
            request.saveEx();
            break;
        }
    }

    public void taxDefinition(MOrderLine orderLine) {
        int M_Product_ID = orderLine.getM_Product_ID();
        int C_Charge_ID = orderLine.getC_Charge_ID();
        ArrayList<Object> params = new ArrayList<Object>();
        Object whereClause = "(c_taxgroup_ID =? or c_taxgroup_ID is null)";
        MBPartner bpartner = (MBPartner)orderLine.getParent().getC_BPartner();
        params.add(bpartner.getC_TaxGroup_ID());
        if (C_Charge_ID != 0) {
            whereClause = (String)whereClause + " AND (c_taxcategory_ID =? or c_taxcategory_ID is null)";
            params.add(orderLine.getC_Charge().getC_TaxCategory_ID());
        } else if (M_Product_ID != 0) {
            whereClause = (String)whereClause + " AND (c_taxcategory_ID =? or c_taxcategory_ID is null)";
            params.add(orderLine.getM_Product().getC_TaxCategory_ID());
        }
        X_C_TaxDefinition taxdefinition = (X_C_TaxDefinition)new Query(Env.getCtx(), "C_TaxDefinition", (String)whereClause, null).setClient_ID().setOnlyActiveRecords(true).setParameters(params).setOrderBy("seqNo").first();
        orderLine.setC_Tax_ID(taxdefinition.getC_Tax_ID());
    }
}

