/*
 * Decompiled with CFR 0.152.
 */
package org.spin.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_AD_AttachmentReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MADAttachmentReference
extends X_AD_AttachmentReference {
    private static CCache<Integer, MADAttachmentReference> attachmentReferenceCacheIds = new CCache("AD_AttachmentReference", 30);
    private static CCache<String, MADAttachmentReference> attachmentReferenceCacheUuids = new CCache("AD_AttachmentReference", 30);
    private static CCache<String, MADAttachmentReference> attachmentReferenceCacheExternCall = new CCache("AD_AttachmentReference", 30);
    private static CCache<String, List<MADAttachmentReference>> attachmentReferenceCache = new CCache("AD_AttachmentReference_List", 30);
    private static final long serialVersionUID = 3160093764545078785L;

    public MADAttachmentReference(Properties ctx, int AD_AttachmentReference_ID, String trxName) {
        super(ctx, AD_AttachmentReference_ID, trxName);
    }

    public MADAttachmentReference(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getValidFileName() {
        String uuid = this.get_UUID();
        if (Util.isEmpty(uuid)) {
            throw new AdempiereException("@UUID@ @NotFound@");
        }
        return (uuid + "-" + this.getFileName()).replaceAll("[+^:&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$()*#/><]", "").replaceAll(" ", "-");
    }

    public static MADAttachmentReference getById(Properties ctx, int attachmentReferenceId, String trxName) {
        if (attachmentReferenceId <= 0) {
            return null;
        }
        MADAttachmentReference attachmentReference = attachmentReferenceCacheIds.get(attachmentReferenceId);
        if (attachmentReference != null && attachmentReference.get_ID() > 0) {
            return attachmentReference;
        }
        attachmentReference = (MADAttachmentReference)new Query(ctx, "AD_AttachmentReference", "AD_AttachmentReference_ID=?", trxName).setClient_ID().setParameters(attachmentReferenceId).first();
        if (attachmentReference != null && attachmentReference.get_ID() > 0) {
            String key = attachmentReference.getUUID();
            attachmentReferenceCacheUuids.put(key, attachmentReference);
            attachmentReferenceCacheIds.put(attachmentReference.get_ID(), attachmentReference);
        }
        return attachmentReference;
    }

    public static MADAttachmentReference getByImageId(Properties ctx, int fileHandlerId, int imageId, String trxName) {
        if (imageId <= 0) {
            return null;
        }
        String key = "Image#" + fileHandlerId + "|" + imageId;
        MADAttachmentReference attachmentReference = attachmentReferenceCacheExternCall.get(key);
        if (attachmentReference != null && attachmentReference.get_ID() > 0) {
            return attachmentReference;
        }
        attachmentReference = (MADAttachmentReference)new Query(ctx, "AD_AttachmentReference", "FileHandler_ID = ? AND AD_Image_ID = ?", trxName).setClient_ID().setParameters(fileHandlerId, imageId).first();
        if (attachmentReference != null && attachmentReference.get_ID() > 0) {
            attachmentReferenceCacheUuids.put(attachmentReference.getUUID(), attachmentReference);
            attachmentReferenceCacheIds.put(attachmentReference.get_ID(), attachmentReference);
            attachmentReferenceCacheExternCall.put(key, attachmentReference);
        }
        return attachmentReference;
    }

    public static MADAttachmentReference getByArchiveId(Properties ctx, int fileHandlerId, int archiveId, String trxName) {
        if (archiveId <= 0) {
            return null;
        }
        String key = "Archive#" + fileHandlerId + "|" + archiveId;
        MADAttachmentReference attachmentReference = attachmentReferenceCacheExternCall.get(key);
        if (attachmentReference != null && attachmentReference.get_ID() > 0) {
            return attachmentReference;
        }
        attachmentReference = (MADAttachmentReference)new Query(ctx, "AD_AttachmentReference", "FileHandler_ID = ? AND AD_Archive_ID = ?", trxName).setClient_ID().setParameters(fileHandlerId, archiveId).first();
        if (attachmentReference != null && attachmentReference.get_ID() > 0) {
            attachmentReferenceCacheUuids.put(attachmentReference.getUUID(), attachmentReference);
            attachmentReferenceCacheIds.put(attachmentReference.get_ID(), attachmentReference);
            attachmentReferenceCacheExternCall.put(key, attachmentReference);
        }
        return attachmentReference;
    }

    public static MADAttachmentReference getByAttachmentId(Properties ctx, int fileHandlerId, int attachmentId, String fileName, String trxName) {
        if (attachmentId <= 0) {
            return null;
        }
        String key = "Attachment#" + fileHandlerId + "|" + attachmentId + "|" + fileName;
        MADAttachmentReference attachmentReference = attachmentReferenceCacheExternCall.get(key);
        if (attachmentReference != null && attachmentReference.get_ID() > 0) {
            return attachmentReference;
        }
        attachmentReference = (MADAttachmentReference)new Query(ctx, "AD_AttachmentReference", "FileHandler_ID = ? AND AD_Attachment_ID = ? AND FileName = ?", trxName).setClient_ID().setParameters(fileHandlerId, attachmentId, fileName).first();
        if (attachmentReference != null && attachmentReference.get_ID() > 0) {
            attachmentReferenceCacheUuids.put(attachmentReference.getUUID(), attachmentReference);
            attachmentReferenceCacheIds.put(attachmentReference.getAD_AttachmentReference_ID(), attachmentReference);
            attachmentReferenceCacheExternCall.put(key, attachmentReference);
        }
        return attachmentReference;
    }

    public static void resetAttachmentCacheFromId(int fileHandlerId, int attachmentId) {
        if (attachmentId <= 0) {
            return;
        }
        String key = "AttachmentList#" + fileHandlerId + "|" + attachmentId;
        attachmentReferenceCache.remove(key);
    }

    public static void resetAttachmentReferenceCache(int fileHandlerId, MADAttachmentReference attachmentReference) {
        if (attachmentReference == null) {
            return;
        }
        String key = "AttachmentList#" + fileHandlerId + "|" + attachmentReference.getAD_Attachment_ID();
        attachmentReferenceCache.remove(key);
        key = "Attachment#" + fileHandlerId + "|" + attachmentReference.getAD_Attachment_ID() + "|" + attachmentReference.getFileName();
        attachmentReferenceCacheExternCall.remove(key);
        attachmentReferenceCacheUuids.remove(attachmentReference.getUUID());
        attachmentReferenceCacheIds.remove(attachmentReference.getAD_AttachmentReference_ID());
    }

    public static List<MADAttachmentReference> getListByAttachmentId(Properties ctx, int fileHandlerId, int attachmentId, String trxName) {
        if (attachmentId <= 0) {
            return null;
        }
        String key = "AttachmentList#" + fileHandlerId + "|" + attachmentId;
        List<MADAttachmentReference> attachmentReferenceList = attachmentReferenceCache.get(key);
        if (attachmentReferenceList != null && attachmentReferenceList.size() > 0) {
            return attachmentReferenceList;
        }
        attachmentReferenceList = new Query(ctx, "AD_AttachmentReference", "FileHandler_ID = ? AND AD_Attachment_ID = ? ", trxName).setClient_ID().setParameters(fileHandlerId, attachmentId).list();
        if (attachmentReferenceList != null && attachmentReferenceList.size() > 0) {
            attachmentReferenceCache.put(key, attachmentReferenceList);
        }
        return attachmentReferenceList;
    }

    public static MADAttachmentReference getByUuid(Properties ctx, String attachmentReferenceUuid, String trxName) {
        String key;
        MADAttachmentReference attachmentReference;
        if (attachmentReferenceUuid == null) {
            return null;
        }
        if (attachmentReferenceCacheUuids.size() == 0) {
            MADAttachmentReference.getAll(ctx, true, trxName);
        }
        if ((attachmentReference = attachmentReferenceCacheUuids.get(key = attachmentReferenceUuid)) != null && attachmentReference.get_ID() > 0) {
            return attachmentReference;
        }
        attachmentReference = (MADAttachmentReference)new Query(ctx, "AD_AttachmentReference", "UUID=?", trxName).setClient_ID().setParameters(attachmentReferenceUuid).first();
        if (attachmentReference != null && attachmentReference.get_ID() > 0) {
            attachmentReferenceCacheUuids.put(key, attachmentReference);
            attachmentReferenceCacheIds.put(attachmentReference.get_ID(), attachmentReference);
        }
        return attachmentReference;
    }

    public static List<MADAttachmentReference> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || attachmentReferenceCacheIds.size() > 0) {
            List<MADAttachmentReference> attachmentReferenceList = new Query(Env.getCtx(), "AD_AttachmentReference", null, trxName).setClient_ID().list();
            attachmentReferenceList.stream().forEach(attachmentReference -> {
                String key = attachmentReference.getUUID();
                attachmentReferenceCacheIds.put(attachmentReference.getAD_AttachmentReference_ID(), (MADAttachmentReference)attachmentReference);
                attachmentReferenceCacheUuids.put(key, (MADAttachmentReference)attachmentReference);
            });
            return attachmentReferenceList;
        }
        List<MADAttachmentReference> attachmentReferenceList = attachmentReferenceCacheIds.entrySet().stream().map(activity -> (MADAttachmentReference)activity.getValue()).collect(Collectors.toList());
        return attachmentReferenceList;
    }

    @Override
    public String toString() {
        return "MADAttachmentReference [getFileName()=" + this.getFileName() + ", getUUID()=" + this.getUUID() + "]";
    }
}

