/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.spin.process.DeleteTemporaryTablesAbstract;

public class DeleteTemporaryTables
extends DeleteTemporaryTablesAbstract {
    private AtomicInteger counter = new AtomicInteger();

    @Override
    protected String doIt() throws Exception {
        this.getTemporaryTablesList().forEach(table -> this.processTable(table.getTableName()));
        return "@Processed@: " + this.counter.get();
    }

    private void processTable(final String tableName) {
        try {
            Trx.run(new TrxRunnable(){

                @Override
                public void run(String trxName) {
                    int no;
                    DeleteTemporaryTables.this.log.info("doIt - TableName=" + tableName);
                    String sql = "DELETE FROM " + tableName;
                    if (DeleteTemporaryTables.this.getKeepLogDays() > 0) {
                        sql = sql + " WHERE (Created+" + DeleteTemporaryTables.this.getKeepLogDays() + ") < SysDate";
                    }
                    if ((no = DB.executeUpdate(sql, DeleteTemporaryTables.this.get_TrxName())) > 0) {
                        DeleteTemporaryTables.this.addLog("@AD_Table_ID@: " + tableName + " @Deleted@ = " + no);
                    }
                    DeleteTemporaryTables.this.counter.getAndIncrement();
                }
            });
        }
        catch (Exception e) {
            this.addLog(e.getMessage());
        }
    }

    private List<MTable> getTemporaryTablesList() {
        return new Query(this.getCtx(), "AD_Table", "TableName LIKE 'T_%' AND IsView = 'N'", this.get_TrxName()).setOnlyActiveRecords(true).list();
    }
}

