/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MPayment;
import org.compiere.util.Util;
import org.spin.process.DepositFromCashAbstract;

public class DepositFromCash
extends DepositFromCashAbstract {
    Map<Integer, Integer> withdrawalLinkPayments = new HashMap<Integer, Integer>();
    Map<Integer, Integer> depositLinkPayments = new HashMap<Integer, Integer>();
    Map<String, MPayment> payments = new HashMap<String, MPayment>();
    AtomicInteger created = new AtomicInteger();

    @Override
    protected void prepare() {
        super.prepare();
        if (Util.isEmpty(this.getTenderType())) {
            this.setTenderType("A");
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (!this.isSplitDeposits() && Util.isEmpty(this.getDocumentNo())) {
            throw new AdempiereException("@DocumentNo@ @IsMandatory@");
        }
        this.getSelectionKeys().forEach(key -> {
            int paymentId = this.getSelectionAsInt((int)key, "CP_C_Payment_ID");
            MPayment sourcePayment = new MPayment(this.getCtx(), paymentId, this.get_TrxName());
            String paymentKey = this.getKey(String.valueOf(sourcePayment.getC_Payment_ID()), sourcePayment.getC_BankAccount_ID(), sourcePayment.isReceipt(), sourcePayment.getC_Currency_ID(), sourcePayment.getC_ConversionType_ID());
            this.payments.put(paymentKey, sourcePayment);
            String documentNo = this.getDocumentNo();
            if (this.isSplitDeposits()) {
                documentNo = sourcePayment.getDocumentNo();
            }
            MPayment bankDeposit = this.addPayment(documentNo, this.getBankAccountId(), true, sourcePayment.getPayAmt(), sourcePayment.getTenderType(), sourcePayment.getC_Currency_ID(), sourcePayment.getC_ConversionType_ID());
            this.depositLinkPayments.put(sourcePayment.getC_Payment_ID(), bankDeposit.getC_Payment_ID());
            MPayment cashWithdrawal = this.addPayment(this.getDocumentNo(), sourcePayment.getC_BankAccount_ID(), false, sourcePayment.getPayAmt(), sourcePayment.getTenderType(), sourcePayment.getC_Currency_ID(), sourcePayment.getC_ConversionType_ID());
            if (sourcePayment.getC_POS_ID() > 0) {
                cashWithdrawal.setC_POS_ID(sourcePayment.getC_POS_ID());
                cashWithdrawal.saveEx();
            }
            this.withdrawalLinkPayments.put(sourcePayment.getC_Payment_ID(), cashWithdrawal.getC_Payment_ID());
        });
        StringBuffer msg = new StringBuffer();
        this.payments.entrySet().forEach(entry -> {
            MPayment payment = (MPayment)entry.getValue();
            Integer referenceId = this.withdrawalLinkPayments.get(payment.getC_Payment_ID());
            Optional.ofNullable(referenceId).ifPresent(theReferenceId -> {
                payment.setRef_Payment_ID((int)theReferenceId);
                payment.saveEx();
            });
            Integer relatedId = this.depositLinkPayments.get(payment.getC_Payment_ID());
            Optional.ofNullable(relatedId).ifPresent(theRelatedId -> {
                payment.setRelatedPayment_ID((int)theRelatedId);
                payment.saveEx();
            });
            if (payment.getDocStatus().equals("DR")) {
                payment.processIt("CO");
                payment.saveEx();
                if (msg.length() > 0) {
                    msg.append(", ");
                }
                msg.append("[" + payment.getDocumentNo() + "]");
                this.created.addAndGet(1);
            }
            if (this.isAutoReconciled()) {
                MBankStatement.addPayment(payment);
            }
        });
        return "@Created@: (" + this.created.get() + ") " + msg.toString();
    }

    private MPayment addPayment(String documentNo, int bankAccountId, boolean isReceipt, BigDecimal paymentAmount, String tenderType, int currencyId, int conversionTypeId) {
        String key = this.getKey(documentNo, bankAccountId, isReceipt, currencyId, conversionTypeId);
        MPayment payment = this.payments.get(key);
        if (payment != null) {
            BigDecimal amount = payment.getPayAmt().add(paymentAmount);
            payment.setPayAmt(amount);
            payment.saveEx();
        } else {
            payment = this.createPayment(documentNo, bankAccountId, isReceipt, paymentAmount, tenderType, currencyId, conversionTypeId);
        }
        this.payments.put(key, payment);
        return payment;
    }

    private String getKey(String documentNo, int bankAccountId, boolean isReceipt, int currencyId, int conversionTypeId) {
        return documentNo + "|" + bankAccountId + "|" + isReceipt + "|" + currencyId + "|" + conversionTypeId;
    }

    private MPayment createPayment(String documentNo, int bankAccountId, boolean isReceipt, BigDecimal paymentAmount, String tenderType, int currencyId, int conversionTypeId) {
        MBankAccount bankAccount = MBankAccount.get(this.getCtx(), bankAccountId);
        MPayment payment = new MPayment(this.getCtx(), 0, this.get_TrxName());
        payment.setC_BPartner_ID(this.getBPartnerId());
        payment.setC_BankAccount_ID(bankAccountId);
        payment.setIsReceipt(isReceipt);
        payment.setTenderType(tenderType != null ? tenderType : this.getTenderType());
        payment.setDateTrx(this.getDateTrx());
        payment.setDateAcct(this.getDateTrx());
        if (!Util.isEmpty(documentNo)) {
            payment.setDocumentNo(documentNo);
        }
        if (currencyId != 0) {
            payment.setC_Currency_ID(currencyId);
        } else {
            payment.setC_Currency_ID(bankAccount.getC_Currency_ID());
        }
        if (conversionTypeId != 0) {
            payment.setC_ConversionType_ID(conversionTypeId);
        }
        payment.setC_Charge_ID(this.getChargeId());
        payment.setDocStatus("DR");
        if (paymentAmount != null) {
            payment.setPayAmt(paymentAmount);
        }
        if (isReceipt) {
            if (this.getDepositDocumentTypeId() != 0) {
                payment.setC_DocType_ID(this.getDepositDocumentTypeId());
            }
        } else if (this.getWithdrawalDocumentTypeId() != 0) {
            payment.setC_DocType_ID(this.getWithdrawalDocumentTypeId());
        }
        payment.saveEx();
        return payment;
    }
}

