/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.MBrowse;
import org.compiere.model.MForm;
import org.compiere.model.MMenu;
import org.compiere.model.MProcess;
import org.compiere.model.MWindow;
import org.compiere.model.Query;
import org.compiere.util.Util;
import org.spin.process.GenerateDocsFromMenuAbstract;
import org.spin.util.docs.AbstractDocumentationSource;
import org.spin.util.docs.AbstractTextConverter;
import org.spin.util.docs.FunctionalDocsForForm;
import org.spin.util.docs.FunctionalDocsForMenu;
import org.spin.util.docs.FunctionalDocsForProcess;
import org.spin.util.docs.FunctionalDocsForSmartBrowse;
import org.spin.util.docs.FunctionalDocsForWindow;
import org.spin.util.docs.IIndex;

public class GenerateDocsFromMenu
extends GenerateDocsFromMenuAbstract {
    private AbstractTextConverter textConverter = null;
    private AbstractTextConverter indexConverter = null;
    private int created = 0;
    public static final String FOLDER_NAME = "functional-guide";

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        Class<?> clazz = Class.forName(this.getDocsExportFormat());
        if (!AbstractTextConverter.class.isAssignableFrom(clazz)) {
            throw new AdempiereException("@DocsExportFormat@ @NotMatched@");
        }
        this.textConverter = (AbstractTextConverter)clazz.newInstance();
        this.indexConverter = (AbstractTextConverter)clazz.newInstance();
        ((IIndex)((Object)this.indexConverter)).addGroup("Functional Guide", FOLDER_NAME, 1);
        this.loadMenu();
        this.loadProcess();
        this.loadWindow();
        this.loadForm();
        this.loadSmartBrowse();
        if (this.indexConverter.getMainIndex() != null && !Util.isEmpty(this.indexConverter.getMainIndexFileName())) {
            String folderName = this.getDirectory();
            String fileName = FOLDER_NAME + File.separator + this.textConverter.getMainIndexFileName();
            if (!Util.isEmpty(fileName)) {
                this.writeFile(folderName, fileName, this.indexConverter.getMainIndex().toString());
            }
        }
        return "@Created@ " + this.created;
    }

    private void loadMenu() throws IOException {
        MMenu[] menuList;
        StringBuffer whereClause = new StringBuffer("AD_Client_ID = " + this.getAD_Client_ID() + " AND IsSummary = 'N'");
        if (this.getRecord_ID() > 0) {
            whereClause.append(" AND ").append("AD_Menu_ID = ").append(this.getRecord_ID());
        }
        if ((menuList = MMenu.get(this.getCtx(), whereClause.toString(), this.get_TrxName())) == null || menuList.length == 0) {
            return;
        }
        String folderName = this.getDirectory() + File.separator + FunctionalDocsForMenu.FOLDER_NAME;
        String fileName = this.textConverter.getIndexFileName();
        if (!Util.isEmpty(fileName)) {
            this.indexConverter.addHeaderIndexName(FunctionalDocsForMenu.FOLDER_NAME);
            this.indexConverter.newLine();
            this.indexConverter.addSection("Menu");
            this.indexConverter.newLine();
            ((IIndex)((Object)this.indexConverter)).addTreeDefinition(1, true);
            ((IIndex)((Object)this.indexConverter)).addGroup("Menu", FunctionalDocsForMenu.FOLDER_NAME, 2);
        }
        for (MMenu menu : menuList) {
            this.documentForMenu(menu, folderName);
            this.textConverter.clear();
        }
        if (!Util.isEmpty(fileName)) {
            this.writeFile(folderName, fileName, this.indexConverter.toString());
        }
        this.indexConverter.clear();
    }

    private void loadProcess() throws IOException {
        List processList = new Query(this.getCtx(), "AD_Process", null, this.get_TrxName()).setOnlyActiveRecords(true).setClient_ID().list();
        if (processList == null || processList.size() == 0) {
            return;
        }
        String folderName = this.getDirectory() + File.separator + FunctionalDocsForProcess.FOLDER_NAME;
        String fileName = this.textConverter.getIndexFileName();
        if (!Util.isEmpty(fileName)) {
            this.indexConverter.addHeaderIndexName(FunctionalDocsForProcess.FOLDER_NAME);
            this.indexConverter.newLine();
            this.indexConverter.addSection("Process");
            this.indexConverter.newLine();
            ((IIndex)((Object)this.indexConverter)).addTreeDefinition(1, true);
            ((IIndex)((Object)this.indexConverter)).addGroup("Process", FunctionalDocsForProcess.FOLDER_NAME, 2);
        }
        for (MProcess process : processList) {
            this.documentForProcess(process, folderName);
            this.textConverter.clear();
        }
        if (!Util.isEmpty(fileName)) {
            this.writeFile(folderName, fileName, this.indexConverter.toString());
        }
        this.indexConverter.clear();
    }

    private void loadWindow() throws IOException {
        List windowList = new Query(this.getCtx(), "AD_Window", null, this.get_TrxName()).setOnlyActiveRecords(true).setClient_ID().list();
        if (windowList == null || windowList.size() == 0) {
            return;
        }
        String folderName = this.getDirectory() + File.separator + FunctionalDocsForWindow.FOLDER_NAME;
        String fileName = this.textConverter.getIndexFileName();
        if (!Util.isEmpty(fileName)) {
            this.indexConverter.addHeaderIndexName(FunctionalDocsForWindow.FOLDER_NAME);
            this.indexConverter.newLine();
            this.indexConverter.addSection("Windows");
            this.indexConverter.newLine();
            ((IIndex)((Object)this.indexConverter)).addTreeDefinition(1, true);
            ((IIndex)((Object)this.indexConverter)).addGroup("Window", FunctionalDocsForProcess.FOLDER_NAME, 2);
        }
        for (MWindow window : windowList) {
            this.documentForWindow(window, folderName);
            this.textConverter.clear();
        }
        if (!Util.isEmpty(fileName)) {
            this.writeFile(folderName, fileName, this.indexConverter.toString());
        }
        this.indexConverter.clear();
    }

    private void loadForm() throws IOException {
        List formList = new Query(this.getCtx(), "AD_Form", null, this.get_TrxName()).setOnlyActiveRecords(true).setClient_ID().list();
        if (formList == null || formList.size() == 0) {
            return;
        }
        String folderName = this.getDirectory() + File.separator + FunctionalDocsForForm.FOLDER_NAME;
        String fileName = this.textConverter.getIndexFileName();
        if (!Util.isEmpty(fileName)) {
            this.indexConverter.addHeaderIndexName(FunctionalDocsForForm.FOLDER_NAME);
            this.indexConverter.newLine();
            this.indexConverter.addSection("Forms");
            this.indexConverter.newLine();
            ((IIndex)((Object)this.indexConverter)).addTreeDefinition(1, true);
            ((IIndex)((Object)this.indexConverter)).addGroup("Form", FunctionalDocsForProcess.FOLDER_NAME, 2);
        }
        for (MForm form : formList) {
            this.documentForForm(form, folderName);
            this.textConverter.clear();
        }
        if (!Util.isEmpty(fileName)) {
            this.writeFile(folderName, fileName, this.indexConverter.toString());
        }
        this.indexConverter.clear();
    }

    private void loadSmartBrowse() throws IOException {
        List smartBrowseList = new Query(this.getCtx(), "AD_Browse", null, this.get_TrxName()).setOnlyActiveRecords(true).setClient_ID().list();
        if (smartBrowseList == null || smartBrowseList.size() == 0) {
            return;
        }
        String folderName = this.getDirectory() + File.separator + FunctionalDocsForSmartBrowse.FOLDER_NAME;
        String fileName = this.textConverter.getIndexFileName();
        if (!Util.isEmpty(fileName)) {
            this.indexConverter.addHeaderIndexName(FunctionalDocsForSmartBrowse.FOLDER_NAME);
            this.indexConverter.newLine();
            this.indexConverter.addSection("Smart Browsers");
            this.indexConverter.newLine();
            ((IIndex)((Object)this.indexConverter)).addTreeDefinition(1, true);
            ((IIndex)((Object)this.indexConverter)).addGroup("Smart Browsers", FunctionalDocsForProcess.FOLDER_NAME, 2);
        }
        for (MBrowse smartBrowse : smartBrowseList) {
            this.documentForSmartBrowse(smartBrowse, folderName);
            this.textConverter.clear();
        }
        if (!Util.isEmpty(fileName)) {
            this.writeFile(folderName, fileName, this.indexConverter.toString());
        }
        this.indexConverter.clear();
    }

    private void documentForMenu(MMenu menu, String folderName) throws IOException {
        FunctionalDocsForMenu documentGenerator = new FunctionalDocsForMenu();
        boolean isOk = ((AbstractDocumentationSource)documentGenerator).createDocumentation(this.textConverter, menu);
        if (!isOk) {
            return;
        }
        if (!Util.isEmpty(this.textConverter.getIndexFileName())) {
            ((AbstractDocumentationSource)documentGenerator).addIndex(this.indexConverter, menu);
        }
        String fileName = this.getValidName(((AbstractDocumentationSource)documentGenerator).getDocumentName());
        this.writeFile(folderName, fileName, this.textConverter.toString());
        this.addLog("@AD_Menu_ID@ " + menu.getName());
        ++this.created;
    }

    private void documentForProcess(MProcess process, String folderName) throws IOException {
        FunctionalDocsForProcess documentGenerator = new FunctionalDocsForProcess();
        boolean isOk = ((AbstractDocumentationSource)documentGenerator).createDocumentation(this.textConverter, process);
        if (!isOk) {
            return;
        }
        if (!Util.isEmpty(this.textConverter.getIndexFileName())) {
            ((AbstractDocumentationSource)documentGenerator).addIndex(this.indexConverter, process);
        }
        String fileName = this.getValidName(((AbstractDocumentationSource)documentGenerator).getDocumentName());
        this.writeFile(folderName, fileName, this.textConverter.toString());
        this.addLog("@AD_Process_ID@ " + process.getName());
        ++this.created;
    }

    private void documentForWindow(MWindow window, String folderName) throws IOException {
        FunctionalDocsForWindow documentGenerator = new FunctionalDocsForWindow();
        boolean isOk = ((AbstractDocumentationSource)documentGenerator).createDocumentation(this.textConverter, window);
        if (!isOk) {
            return;
        }
        if (!Util.isEmpty(this.textConverter.getIndexFileName())) {
            ((AbstractDocumentationSource)documentGenerator).addIndex(this.indexConverter, window);
        }
        String fileName = this.getValidName(((AbstractDocumentationSource)documentGenerator).getDocumentName());
        this.writeFile(folderName, fileName, this.textConverter.toString());
        this.addLog("@AD_Window_ID@ " + window.getName());
        ++this.created;
    }

    private void documentForForm(MForm form, String folderName) throws IOException {
        FunctionalDocsForForm documentGenerator = new FunctionalDocsForForm();
        boolean isOk = ((AbstractDocumentationSource)documentGenerator).createDocumentation(this.textConverter, form);
        if (!isOk) {
            return;
        }
        if (!Util.isEmpty(this.textConverter.getIndexFileName())) {
            ((AbstractDocumentationSource)documentGenerator).addIndex(this.indexConverter, form);
        }
        String fileName = this.getValidName(((AbstractDocumentationSource)documentGenerator).getDocumentName());
        this.writeFile(folderName, fileName, this.textConverter.toString());
        this.addLog("@AD_Form_ID@ " + form.getName());
        ++this.created;
    }

    private void documentForSmartBrowse(MBrowse smartBrowse, String folderName) throws IOException {
        FunctionalDocsForSmartBrowse documentGenerator = new FunctionalDocsForSmartBrowse();
        boolean isOk = ((AbstractDocumentationSource)documentGenerator).createDocumentation(this.textConverter, smartBrowse);
        if (!isOk) {
            return;
        }
        if (!Util.isEmpty(this.textConverter.getIndexFileName())) {
            ((AbstractDocumentationSource)documentGenerator).addIndex(this.indexConverter, smartBrowse);
        }
        String fileName = this.getValidName(((AbstractDocumentationSource)documentGenerator).getDocumentName());
        this.writeFile(folderName, fileName, this.textConverter.toString());
        this.addLog("@AD_Browse_ID@ " + smartBrowse.getName());
        ++this.created;
    }

    private void writeFile(String folderName, String fileName, String value) throws IOException {
        File exportDir = new File(folderName);
        exportDir.mkdirs();
        File exportFile = new File(folderName + File.separator + fileName);
        FileWriter writer = new FileWriter(exportFile);
        writer.write(value);
        writer.flush();
        writer.close();
    }

    private String getValidName(String fileName) {
        return (fileName + "." + this.textConverter.getExtension()).toLowerCase();
    }
}

