/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.Query;
import org.spin.model.MADToken;
import org.spin.process.GenerateTokenForThirdPartyAccessAbstract;
import org.spin.util.IThirdPartyAccessGenerator;
import org.spin.util.ITokenGenerator;
import org.spin.util.TokenGeneratorHandler;

public class GenerateTokenForThirdPartyAccess
extends GenerateTokenForThirdPartyAccessAbstract {
    @Override
    protected String doIt() throws Exception {
        if (this.getRecord_ID() > 0 && this.getTableName().equals("AD_Role")) {
            this.setRoleId(this.getRecord_ID());
        } else if (this.getRecord_ID() > 0 && this.getTableName().equals("AD_User")) {
            this.setUserId(this.getRecord_ID());
        }
        boolean match = new Query(this.getCtx(), "AD_Role", "EXISTS(SELECT 1 FROM AD_User_Roles ur WHERE ur.AD_Role_ID = AD_Role.AD_Role_ID AND ur.AD_User_ID = ?)", this.get_TrxName()).setParameters(this.getUserId()).match();
        if (!match) {
            throw new AdempiereException("@AD_User_ID@ / @AD_Role_ID@ @Mismatched@");
        }
        if (this.isRevokeAllTokens()) {
            List<MADToken> tokens = new Query(this.getCtx(), "AD_Token", "AD_User_ID = ? AND AD_Role_ID = ? AND EXISTS(SELECT 1 FROM AD_TokenDefinition td WHERE td.AD_TokenDefinition_ID = AD_Token.AD_TokenDefinition_ID AND td.TokenType = ?)", this.get_TrxName()).setParameters(this.getUserId(), this.getRoleId(), "TPA").setOnlyActiveRecords(true).setClient_ID().list();
            AtomicInteger counter = new AtomicInteger(0);
            if (tokens != null && tokens.size() > 0) {
                tokens.forEach(token -> {
                    token.setIsActive(false);
                    token.saveEx();
                    counter.incrementAndGet();
                });
            }
            return "@Updated@: " + counter.get();
        }
        ITokenGenerator generator = TokenGeneratorHandler.getInstance().getTokenGenerator("TPA");
        if (generator == null) {
            throw new AdempiereException("@AD_TokenDefinition_ID@ @NotFound@");
        }
        if (!IThirdPartyAccessGenerator.class.isAssignableFrom(generator.getClass())) {
            throw new AdempiereException("@AD_TokenDefinition_ID@ @Invalid@");
        }
        IThirdPartyAccessGenerator thirdPartyAccessGenerator = (IThirdPartyAccessGenerator)generator;
        String token2 = thirdPartyAccessGenerator.generateToken(this.getUserId(), this.getRoleId());
        return "@TokenValue@: " + token2;
    }
}

