/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.notification.support;

import java.util.Arrays;
import org.adempiere.core.domains.models.X_AD_UserMail;
import org.compiere.model.MAttachment;
import org.compiere.model.MClient;
import org.compiere.model.MEMailConfig;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.spin.queue.notification.model.MADNotificationQueue;
import org.spin.queue.notification.support.INotification;

public class EMailSender
implements INotification {
    private int registrationId = 0;
    private CLogger log = CLogger.getCLogger(EMailSender.class);

    @Override
    public int getAppRegistrationId() {
        return this.registrationId;
    }

    @Override
    public void setAppRegistrationId(int registrationId) {
        this.registrationId = registrationId;
        this.log.fine("set Registration: " + registrationId);
    }

    @Override
    public String testConnection() {
        this.log.fine("Test connection");
        return "Ok";
    }

    @Override
    public void sendNotification(MADNotificationQueue notification) {
        StringBuffer errorMessage = new StringBuffer();
        notification.getRecipients().forEach(recipient -> {
            MOrg organization;
            MOrgInfo organizationInformation;
            int eMailConfigurationId = 0;
            String eMailUser = null;
            String eMailPassword = null;
            MUser notificationUser = new MUser(notification.getCtx(), notification.getCreatedBy(), notification.get_TrxName());
            StringBuffer recipientErrorMessage = new StringBuffer();
            MClient client = MClient.get(notification.getCtx(), notification.getAD_Client_ID());
            eMailConfigurationId = notificationUser.getAD_EMailConfig_ID();
            eMailUser = notificationUser.getEMailUser();
            eMailPassword = notificationUser.getEMailUserPW();
            if ((eMailConfigurationId <= 0 || eMailUser == null || eMailUser.isEmpty() || eMailPassword == null || eMailPassword.isEmpty()) && notification.getAD_Org_ID() > 0 && (organizationInformation = (organization = MOrg.get(notification.getCtx(), notification.getAD_Org_ID())).getInfo()) != null && organizationInformation.get_ID() > 0) {
                eMailConfigurationId = organizationInformation.getAD_EMailConfig_ID();
                eMailUser = organizationInformation.getEMail();
                eMailPassword = organizationInformation.getRequestUserPW();
            }
            if (eMailConfigurationId <= 0 || eMailUser == null || eMailUser.isEmpty() || eMailPassword == null || eMailPassword.isEmpty()) {
                eMailUser = client.getRequestEMail();
                eMailPassword = client.getRequestUserPW();
                eMailConfigurationId = client.getAD_EMailConfig_ID();
            }
            if (eMailConfigurationId <= 0 || eMailUser == null || eMailUser.isEmpty() || eMailPassword == null || eMailPassword.isEmpty()) {
                this.log.warning("@AD_EMailConfig_ID@ @NotFound@");
                if (errorMessage.length() > 0) {
                    errorMessage.append(Env.NL);
                }
                errorMessage.append("@AD_EMailConfig_ID@ @NotFound@");
            } else {
                EMail email = new EMail(client, eMailConfigurationId, eMailUser, recipient.getAccountName(), notification.getDescription(), notification.getText(), false);
                if (!email.isValid() && !email.isValid(true)) {
                    this.log.warning("NOT VALID - " + email);
                    if (recipientErrorMessage.length() > 0) {
                        recipientErrorMessage.append(Env.NL);
                    }
                    recipientErrorMessage.append("NOT VALID - " + email);
                    recipient.setIsActive(false);
                } else {
                    boolean isSent;
                    MEMailConfig eMailConfig = MEMailConfig.get(notification.getCtx(), eMailConfigurationId);
                    if (eMailConfig.isSmtpAuthorization()) {
                        email.createAuthenticator(eMailUser, eMailPassword);
                    }
                    email.setSubject(notification.getDescription());
                    email.setMessageHTML(notification.getText());
                    MAttachment attachment = notification.getAttachment();
                    if (attachment != null && attachment.getAD_Attachment_ID() > 0) {
                        Arrays.asList(attachment.getEntries()).forEach(entry -> email.addAttachment(entry.getFile()));
                    }
                    if (isSent = "OK".equals(email.send())) {
                        this.log.fine("EMail Sent: " + recipient.getAccountName());
                        recipient.setProcessed(true);
                    } else {
                        recipient.setIsActive(false);
                        if (recipientErrorMessage.length() > 0) {
                            recipientErrorMessage.append(Env.NL);
                        }
                        recipientErrorMessage.append("Error: Sending to: " + recipient.getAccountName());
                    }
                    if (recipient.getAD_User_ID() > 0) {
                        X_AD_UserMail userMail = new X_AD_UserMail(notification.getCtx(), 0, notification.get_TrxName());
                        userMail.setAD_Org_ID(notification.getAD_Org_ID());
                        userMail.setAD_User_ID(recipient.getAD_User_ID());
                        userMail.setSubject(email.getSubject());
                        userMail.setMailText(email.getMessageCRLF());
                        if (email.isSentOK()) {
                            userMail.setMessageID(email.getMessageID());
                        } else {
                            userMail.setMessageID(email.getSentMsg());
                            userMail.setIsDelivered("N");
                        }
                        userMail.saveEx();
                    }
                }
                if (recipientErrorMessage.length() > 0) {
                    errorMessage.append(recipientErrorMessage);
                    recipient.setErrorMsg(recipientErrorMessage.toString());
                }
                if (recipient.is_Changed()) {
                    recipient.saveEx();
                }
            }
        });
    }
}

