/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.compiere.util.CLogger;
import org.compiere.util.Ini;

public class PrinterUtil {
    private static CLogger log = CLogger.getCLogger(PrinterUtil.class);
    private static PrintService[] s_services = PrintServiceLookup.lookupPrintServices(null, null);

    public static PrinterJob getPrinterJob() {
        return PrinterUtil.getPrinterJob(Ini.getProperty("Printer"));
    }

    public static PrinterJob getPrinterJob(String printerName) {
        PrinterJob pj = null;
        PrintService ps = null;
        try {
            String serviceName;
            pj = PrinterJob.getPrinterJob();
            if (printerName == null || printerName.length() == 0) {
                printerName = Ini.getProperty("Printer");
            }
            if (printerName != null && printerName.length() != 0) {
                for (int i = 0; i < s_services.length; ++i) {
                    serviceName = s_services[i].getName();
                    if (!printerName.equals(serviceName)) continue;
                    ps = s_services[i];
                    break;
                }
            }
            try {
                if (ps != null) {
                    pj.setPrintService(ps);
                }
            }
            catch (Exception e) {
                log.warning("Could not set Print Service: " + e.toString());
            }
            PrintService psUsed = pj.getPrintService();
            if (psUsed == null) {
                log.warning("Print Service not Found");
            } else {
                serviceName = psUsed.getName();
                if (printerName != null && !printerName.equals(serviceName)) {
                    log.warning("Not found: " + printerName + " - Used: " + serviceName);
                }
            }
        }
        catch (Exception e) {
            log.warning("Could not create for " + printerName + ": " + e.toString());
        }
        return pj;
    }

    public static String[] getPrinterNames() {
        s_services = PrintServiceLookup.lookupPrintServices(null, null);
        String[] retValue = new String[s_services.length];
        for (int i = 0; i < s_services.length; ++i) {
            retValue[i] = s_services[i].getName();
        }
        return retValue;
    }

    public PrintService getPrintService(String currentService) {
        for (int i = 0; i < s_services.length; ++i) {
            if (!s_services[i].getName().equals(currentService)) continue;
            return s_services[i];
        }
        return PrintServiceLookup.lookupDefaultPrintService();
    }
}

