/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.compiere.print.ReportEngine;
import org.spin.util.AbstractExportFormat;
import org.spin.util.ExportFormatARXML;
import org.spin.util.ExportFormatCSV;
import org.spin.util.ExportFormatHTML;
import org.spin.util.ExportFormatPDF;
import org.spin.util.ExportFormatPS;
import org.spin.util.ExportFormatSSV;
import org.spin.util.ExportFormatTXT;
import org.spin.util.ExportFormatXLS;
import org.spin.util.ExportFormatXLSX;
import org.spin.util.ExportFormatXML;

public class ReportExport {
    private ReportEngine reportEngine;
    private Properties ctx;
    private List<AbstractExportFormat> exportFormatList = new ArrayList<AbstractExportFormat>();

    public ReportExport(Properties ctx, ReportEngine reportEngine) {
        this.ctx = ctx;
        this.reportEngine = reportEngine;
        this.loadDefaultFormat();
    }

    public ReportEngine getReportEngine() {
        return this.reportEngine;
    }

    public Properties getCtx() {
        return this.ctx;
    }

    public void addExportFormat(AbstractExportFormat supportedFormat) {
        if (supportedFormat == null) {
            return;
        }
        this.exportFormatList.add(supportedFormat);
    }

    public List<AbstractExportFormat> getExportFormatList() {
        return this.exportFormatList;
    }

    private void loadDefaultFormat() {
        this.addExportFormat(new ExportFormatPS(this.getCtx(), this.getReportEngine()));
        this.addExportFormat(new ExportFormatXML(this.getCtx(), this.getReportEngine()));
        this.addExportFormat(new ExportFormatPDF(this.getCtx(), this.getReportEngine()));
        this.addExportFormat(new ExportFormatHTML(this.getCtx(), this.getReportEngine()));
        this.addExportFormat(new ExportFormatTXT(this.getCtx(), this.getReportEngine()));
        this.addExportFormat(new ExportFormatSSV(this.getCtx(), this.getReportEngine()));
        this.addExportFormat(new ExportFormatCSV(this.getCtx(), this.getReportEngine()));
        this.addExportFormat(new ExportFormatXLS(this.getCtx(), this.getReportEngine()));
        this.addExportFormat(new ExportFormatXLSX(this.getCtx(), this.getReportEngine()));
        this.addExportFormat(new ExportFormatARXML(this.getCtx(), this.getReportEngine()));
    }
}

