/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.docs;

import java.io.File;
import java.util.ArrayList;
import org.adempiere.model.MBrowse;
import org.compiere.model.MForm;
import org.compiere.model.MMenu;
import org.compiere.model.MProcess;
import org.compiere.model.MRefList;
import org.compiere.model.MTree;
import org.compiere.model.MWindow;
import org.compiere.model.PO;
import org.compiere.util.DB;
import org.compiere.util.Util;
import org.spin.util.docs.AbstractDocumentationSource;
import org.spin.util.docs.AbstractTextConverter;
import org.spin.util.docs.FunctionalDocsForForm;
import org.spin.util.docs.FunctionalDocsForProcess;
import org.spin.util.docs.FunctionalDocsForSmartBrowse;
import org.spin.util.docs.FunctionalDocsForWindow;
import org.spin.util.docs.IIndex;

public class FunctionalDocsForMenu
extends AbstractDocumentationSource {
    private MMenu menu;
    public static final String SUB_FOLDER_NAME = "menu";
    public static final String FOLDER_NAME = "functional-guide" + File.separator + "menu";

    @Override
    public boolean createDocumentation(AbstractTextConverter textConverter, PO source) {
        this.menu = (MMenu)source;
        textConverter.addHeaderIndexName((this.getFolderName() + "/" + this.getDocumentName()).toLowerCase());
        textConverter.addSection(this.menu.getName());
        textConverter.newLine();
        if (!Util.isEmpty(this.menu.getDescription())) {
            textConverter.addText(this.menu.getDescription());
            textConverter.newLine();
        }
        ArrayList<MMenu> menuList = new ArrayList<MMenu>();
        int currentMenuId = this.menu.getAD_Menu_ID();
        int parentId = 0;
        int treeId = MTree.getDefaultTreeIdFromTableName(this.menu.getAD_Client_ID(), "AD_Menu_ID");
        menuList.add(this.menu);
        do {
            if ((parentId = DB.getSQLValue(this.menu.get_TrxName(), "SELECT Parent_ID FROM AD_TreeNodeMM WHERE AD_Tree_ID = ? AND Node_ID = ?", treeId, currentMenuId)) <= 0) continue;
            currentMenuId = parentId;
            menuList.add(MMenu.getFromId(this.menu.getCtx(), currentMenuId));
        } while (parentId > 0);
        textConverter.addSubSection("Menu Path");
        int index = menuList.size() - 1;
        int level = 0;
        while (index >= 0) {
            MMenu menuItem = (MMenu)menuList.get(index);
            textConverter.addQuote(menuItem.getName(), level);
            --index;
            ++level;
        }
        textConverter.newLine();
        textConverter.addSubSubSection("Menu Type");
        textConverter.addBold(MRefList.getListName(source.getCtx(), 104, this.menu.getAction()));
        textConverter.newLine();
        if (this.menu.isSOTrx()) {
            textConverter.addNote(this.getFeature("IsSOTrx"));
        }
        textConverter.newLine();
        String internalReference = null;
        String validName = null;
        String showName = null;
        if (this.menu.getAction().equals("P")) {
            MProcess process = MProcess.get(this.menu.getCtx(), this.menu.getAD_Process_ID());
            validName = this.getValidValue(process.getValue());
            showName = process.getName();
            internalReference = ".." + File.separator + ".." + File.separator + FunctionalDocsForProcess.FOLDER_NAME + File.separator + "process-" + validName;
        } else if (this.menu.getAction().equals("W")) {
            MWindow window = (MWindow)this.menu.getAD_Window();
            validName = this.getValidValue(window.getName());
            showName = window.getName();
            internalReference = ".." + File.separator + ".." + File.separator + FunctionalDocsForWindow.FOLDER_NAME + File.separator + "window-" + validName;
        } else if (this.menu.getAction().equals("S")) {
            MBrowse browse = (MBrowse)this.menu.getAD_Browse();
            validName = this.getValidValue(browse.getName());
            showName = browse.getName();
            internalReference = ".." + File.separator + ".." + File.separator + FunctionalDocsForSmartBrowse.FOLDER_NAME + File.separator + "smart-browse-" + validName;
        } else if (this.menu.getAction().equals("X")) {
            MForm form = (MForm)this.menu.getAD_Form();
            validName = this.getValidValue(form.getName());
            showName = form.getName();
            internalReference = ".." + File.separator + ".." + File.separator + FunctionalDocsForForm.FOLDER_NAME + File.separator + "form-" + validName;
        }
        if (!Util.isEmpty(internalReference)) {
            textConverter.addSeeAlso(showName, internalReference.toLowerCase());
        }
        return true;
    }

    @Override
    public boolean createDocumentation(AbstractTextConverter textConverter) {
        return false;
    }

    @Override
    public boolean addIndex(AbstractTextConverter indexConverter, PO source) {
        this.menu = (MMenu)source;
        ((IIndex)((Object)indexConverter)).addIndex(this.menu.getName(), this.getDocumentName().toLowerCase(), this.getFolderName(), 0);
        return true;
    }

    @Override
    public String getFolderName() {
        return FOLDER_NAME;
    }

    @Override
    public String getDocumentName() {
        if (this.menu != null) {
            return this.getValidValue("menu-" + this.menu.getName());
        }
        return null;
    }
}

