/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.docs;

import java.io.File;
import org.adempiere.model.MBrowse;
import org.compiere.model.MForm;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.compiere.wf.MWorkflow;
import org.spin.util.docs.AbstractDocumentationSource;
import org.spin.util.docs.AbstractTextConverter;
import org.spin.util.docs.IIndex;

public class FunctionalDocsForProcess
extends AbstractDocumentationSource {
    private MProcess process;
    public static final String SUB_FOLDER_NAME = "process";
    public static final String FOLDER_NAME = "functional-guide" + File.separator + "process";

    @Override
    public boolean createDocumentation(AbstractTextConverter textConverter, PO source) {
        MProcessPara[] parameters;
        this.process = (MProcess)source;
        textConverter.addHeaderIndexName((this.getFolderName() + "/" + this.getDocumentName()).toLowerCase());
        textConverter.addSection(this.process.getName());
        textConverter.newLine();
        if (!Util.isEmpty(this.process.getDescription())) {
            textConverter.addText(this.process.getDescription());
            textConverter.newLine();
        }
        if (!Util.isEmpty(this.process.getHelp())) {
            textConverter.addSubSection("Help");
            textConverter.addText(this.process.getHelp());
            textConverter.newLine();
        }
        if (this.process.isBetaFunctionality()) {
            textConverter.addNote(this.getFeature("IsBetaFunctionality"));
        }
        if (this.process.getAD_Workflow_ID() != 0) {
            MWorkflow workflow = MWorkflow.get(source.getCtx(), this.process.getAD_Workflow_ID());
            textConverter.addSubSubSection("Workflow");
            textConverter.addBold(workflow.getName());
            textConverter.newLine();
            textConverter.addText(" ");
            textConverter.addItalic(workflow.getDescription());
            textConverter.newLine();
        }
        if (this.process.getAD_Form_ID() != 0) {
            MForm form = (MForm)this.process.getAD_Form();
            textConverter.addSubSubSection("Special Form");
            textConverter.addBold(form.getName());
            textConverter.newLine();
            textConverter.addText(" ");
            textConverter.addItalic(form.getDescription());
            textConverter.newLine();
        }
        if (this.process.getAD_Browse_ID() != 0) {
            MBrowse smartBrowse = MBrowse.get(source.getCtx(), this.process.getAD_Browse_ID());
            textConverter.addSubSubSection("Smart Browse");
            textConverter.addBold(smartBrowse.getName());
            textConverter.newLine();
            textConverter.addText(" ");
            textConverter.addItalic(smartBrowse.getDescription());
            textConverter.newLine();
        }
        if ((parameters = this.process.getParameters()) != null && parameters.length > 0) {
            textConverter.addSubSection("Parameters");
            for (MProcessPara parameter : parameters) {
                textConverter.addSubSubSection(parameter.getName());
                if (!Util.isEmpty(parameter.getDescription())) {
                    textConverter.addBold("Description");
                    textConverter.newLine();
                    textConverter.addText(" ");
                    textConverter.addItalic(parameter.getDescription());
                    textConverter.newLine();
                }
                if (!Util.isEmpty(parameter.getHelp())) {
                    textConverter.addBold("Help");
                    textConverter.newLine();
                    textConverter.addText(" ");
                    textConverter.addItalic(parameter.getHelp());
                    textConverter.newLine();
                }
                StringBuffer note = new StringBuffer();
                if (parameter.isMandatory()) {
                    note.append(this.getFeature("IsMandatory"));
                }
                if (parameter.isRange()) {
                    if (note.length() > 0) {
                        note.append(Env.NL);
                    }
                    note.append(this.getFeature("IsRange"));
                }
                if (parameter.isInfoOnly()) {
                    if (note.length() > 0) {
                        note.append(Env.NL);
                    }
                    note.append(this.getFeature("IsInfoOnly"));
                }
                if (note.length() <= 0) continue;
                textConverter.addNote(note.toString());
            }
        }
        return true;
    }

    @Override
    public boolean addIndex(AbstractTextConverter indexConverter, PO source) {
        this.process = (MProcess)source;
        ((IIndex)((Object)indexConverter)).addIndex(this.process.getName(), this.getDocumentName().toLowerCase(), this.getFolderName(), 0);
        return true;
    }

    @Override
    public boolean createDocumentation(AbstractTextConverter textConverter) {
        return false;
    }

    @Override
    public String getFolderName() {
        return FOLDER_NAME;
    }

    @Override
    public String getDocumentName() {
        if (this.process != null) {
            return this.getValidValue("process-" + this.process.getValue());
        }
        return null;
    }
}

