/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.docs;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.util.docs.AbstractTextConverter;
import org.spin.util.docs.IIndex;
import org.spin.util.docs.TableTextConverter;

public class MarkdownConverter
extends AbstractTextConverter
implements IIndex {
    private StringBuffer formattedText;
    private StringBuffer translatedText;
    private int previouslevel = -1;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private MarkdownConverter mainIndex;

    public MarkdownConverter() {
        this.formattedText = new StringBuffer();
        this.translatedText = new StringBuffer();
    }

    @Override
    public AbstractTextConverter addText(String text) {
        this.formattedText.append(this.formatText(text));
        this.log.fine("addText=" + text);
        return this;
    }

    private String formatText(String text) {
        return text.replaceAll("(?i)<p */?>", "").replaceAll("(?i)<br */?>\\n", "\n").replaceAll("(?i)<br */?>", "* ").replaceAll("(?i)<b */?>", "\\\\ **").replaceAll("(?i)</b */?>", "**\\\\ ");
    }

    @Override
    public AbstractTextConverter addBold(String text) {
        if (Util.isEmpty(text)) {
            return this;
        }
        this.log.fine("addBold=" + text);
        this.addText(this.formatBold(text));
        return this;
    }

    @Override
    public AbstractTextConverter addItalic(String text) {
        if (Util.isEmpty(text)) {
            return this;
        }
        this.log.fine("addItalic=" + text);
        this.addText(this.formatItalic(text));
        return this;
    }

    @Override
    public AbstractTextConverter addStrikethrough(String text) {
        if (Util.isEmpty(text)) {
            return this;
        }
        this.log.fine("Strikethrough=" + text);
        this.addText(this.formatStrikethrough(text));
        return this;
    }

    @Override
    public AbstractTextConverter addCode(String text) {
        if (Util.isEmpty(text)) {
            return this;
        }
        this.log.fine("addCode=" + text);
        this.newLine();
        this.addText(this.formatCode(text));
        this.newLine();
        return this;
    }

    @Override
    public AbstractTextConverter addQuote(String text, int level) {
        if (Util.isEmpty(text)) {
            return this;
        }
        this.log.fine("addQuote=" + text);
        this.newLine();
        this.addText(this.formatQuote(text, false, level));
        return this;
    }

    @Override
    public AbstractTextConverter addQuote(String text) {
        return this.addQuote(text, 0);
    }

    @Override
    public AbstractTextConverter addQuoteNumeric(String text, int level) {
        if (Util.isEmpty(text)) {
            return this;
        }
        this.log.fine("addQuoteNumeric=" + text);
        this.newLine();
        this.addText(this.formatQuote(text, true, level));
        return this;
    }

    @Override
    public AbstractTextConverter addQuoteNumeric(String text) {
        return this.addQuoteNumeric(text, 0);
    }

    @Override
    public AbstractTextConverter addSection(String text) {
        if (Util.isEmpty(text)) {
            return this;
        }
        this.log.fine("addSection=" + text);
        this.newLine();
        this.addText(this.formatSection(text));
        this.newLine();
        return this;
    }

    @Override
    public AbstractTextConverter addSubSection(String text) {
        if (Util.isEmpty(text)) {
            return this;
        }
        this.log.fine("addSubSection=" + text);
        this.newLine();
        this.addText(this.formatSubSection(text));
        this.newLine();
        return this;
    }

    @Override
    public AbstractTextConverter addSubSubSection(String text) {
        if (Util.isEmpty(text)) {
            return this;
        }
        this.log.fine("addSubSubSection=" + text);
        this.newLine();
        this.addText(this.formatSubSubSection(text));
        this.newLine();
        return this;
    }

    @Override
    public AbstractTextConverter addParagraph(String text) {
        if (Util.isEmpty(text)) {
            return this;
        }
        this.log.fine("addParagraph=" + text);
        this.newLine();
        this.addText(this.formatParagraphs(text));
        this.newLine();
        return this;
    }

    @Override
    public AbstractTextConverter addPart(String text) {
        if (Util.isEmpty(text)) {
            return this;
        }
        this.log.fine("addPart=" + text);
        this.newLine();
        this.addText(this.formatPart(text));
        this.newLine();
        return this;
    }

    @Override
    public AbstractTextConverter addChapter(String text) {
        if (Util.isEmpty(text)) {
            return this;
        }
        this.log.fine("addChapter=" + text);
        this.newLine();
        this.addText(this.formatChapter(text));
        this.newLine();
        return this;
    }

    @Override
    public AbstractTextConverter addExternalLink(String text, String link2) {
        if (Util.isEmpty(text) || Util.isEmpty(link2)) {
            return this;
        }
        this.log.fine("addExternalLink=" + text);
        this.addText(this.formatExternalLink(text, link2));
        return this;
    }

    @Override
    public AbstractTextConverter addSeeAlso(String internalLink) {
        return this.addSeeAlso(null, internalLink);
    }

    @Override
    public AbstractTextConverter addSeeAlso(String name, String internalLink) {
        if (Util.isEmpty(internalLink)) {
            return this;
        }
        this.log.fine("addSeeAlso=" + internalLink);
        this.formattedText.append(this.formatSeeAlso(name, internalLink));
        return this;
    }

    @Override
    public AbstractTextConverter addHeaderIndexName(String indexName) {
        return this;
    }

    @Override
    public AbstractTextConverter addComment(String comment) {
        if (Util.isEmpty(comment)) {
            return this;
        }
        this.log.fine("addComment=" + comment);
        this.addText(this.formatComment(comment));
        return this;
    }

    @Override
    public AbstractTextConverter addNote(String text) {
        if (Util.isEmpty(text)) {
            return this;
        }
        this.addText(this.formatNote(text));
        return this;
    }

    @Override
    public AbstractTextConverter addTable(TableTextConverter table2) {
        List<String> firstRow;
        this.log.fine("addTable=" + table2);
        if (table2.getRows().size() != 0 && (firstRow = table2.getRow(0)).size() != 0) {
            String columnSeparator = " | ";
            int[] maxSizes = new int[firstRow.size()];
            this.newLine();
            boolean isFirst = true;
            StringBuffer headerLine = new StringBuffer();
            for (List<String> row : table2.getRows()) {
                this.newLine();
                StringBuffer text = new StringBuffer();
                for (int columnIndex = 0; columnIndex < maxSizes.length; ++columnIndex) {
                    int size;
                    String columnText = "";
                    if (columnIndex < row.size()) {
                        maxSizes[columnIndex] = table2.getMaxColumnSize(columnIndex);
                        columnText = row.get(columnIndex);
                        if (Util.isEmpty(columnText)) {
                            columnText = "";
                        }
                    }
                    if ((size = maxSizes[columnIndex]) > 0) {
                        columnText = this.isNumeric(columnText) ? String.format("%1$" + size + "s", columnText) : String.format("%1$-" + size + "s", columnText);
                    }
                    if (text.length() > 0) {
                        text.append(columnSeparator);
                    }
                    text.append(columnText);
                    if (!isFirst) continue;
                    if (headerLine.length() > 0) {
                        headerLine.append(columnSeparator);
                    }
                    headerLine.append(this.getParalelChar(columnText, "-"));
                }
                if (isFirst) {
                    this.newLine();
                    this.addText(text.toString());
                    this.newLine();
                    this.addText(headerLine.toString());
                    isFirst = false;
                    continue;
                }
                this.addText(text.toString());
            }
            this.newLine();
        }
        return this;
    }

    private String formatBold(String text) {
        StringBuffer formattedValue = new StringBuffer();
        formattedValue.append("**").append(text.trim()).append("**");
        return formattedValue.toString();
    }

    private String formatItalic(String text) {
        StringBuffer formattedValue = new StringBuffer();
        formattedValue.append("*").append(text.trim()).append("*");
        return formattedValue.toString();
    }

    private String formatStrikethrough(String text) {
        StringBuffer formattedValue = new StringBuffer();
        formattedValue.append("~~").append(text.trim()).append("~~");
        return formattedValue.toString();
    }

    private String formatCode(String text) {
        StringBuffer formattedValue = new StringBuffer();
        formattedValue.append("```").append(Env.NL).append(text.trim()).append(Env.NL).append("```");
        return formattedValue.toString();
    }

    private String formatQuote(String text, boolean isNumeric, int level) {
        if (this.previouslevel != level) {
            this.newLine();
        }
        this.previouslevel = level;
        StringBuffer formattedValue = new StringBuffer();
        String leftSpace = "";
        if (level > 0) {
            leftSpace = String.format("%1$" + level + "s", "");
        }
        String type = "-";
        if (isNumeric) {
            type = "1.";
        }
        formattedValue.append(leftSpace).append(type).append(" ").append(text);
        return formattedValue.toString();
    }

    private String formatIndex(String text, int level) {
        if (this.previouslevel != level) {
            this.newLine();
        }
        this.previouslevel = level;
        StringBuffer formattedValue = new StringBuffer();
        String leftSpace = "";
        if (level > 0) {
            leftSpace = String.format("%1$" + level + "s", "");
        }
        String type = "-";
        formattedValue.append(leftSpace).append(type).append(" ").append(text);
        return formattedValue.toString();
    }

    private String formatHeader(String text, String charValue) {
        StringBuffer formattedValue = new StringBuffer(text.trim());
        formattedValue.append(Env.NL);
        formattedValue.append(charValue).append(" ").append(text.trim());
        formattedValue.append(Env.NL);
        return formattedValue.toString();
    }

    private String formatExternalLink(String text, String link2) {
        StringBuffer formattedValue = new StringBuffer();
        formattedValue.append("[").append(text.trim()).append("]").append("(").append(link2).append(")");
        return formattedValue.toString();
    }

    private String formatSection(String text) {
        return this.formatHeader(text, "#");
    }

    private String formatSubSection(String text) {
        return this.formatHeader(text, "##");
    }

    private String formatSubSubSection(String text) {
        return this.formatHeader(text, "###");
    }

    private String formatParagraphs(String text) {
        return this.formatHeader(text, "");
    }

    private String formatPart(String text) {
        return this.formatHeader(text, "#");
    }

    private String formatChapter(String text) {
        return this.formatHeader(text, "*");
    }

    private String getParalelChar(String text, String underValue) {
        return String.format("%1$" + text.length() + "s", "").replace(" ", underValue);
    }

    private String formatNote(String text) {
        StringBuffer formattedValue = new StringBuffer(Env.NL);
        formattedValue.append("```").append(Env.NL).append(text.trim()).append(Env.NL).append("```");
        return formattedValue.toString();
    }

    private String formatSeeAlso(String name, String internalLink) {
        StringBuffer formattedValue = new StringBuffer(Env.NL);
        if (Util.isEmpty(name)) {
            name = internalLink;
        }
        formattedValue.append(this.formatExternalLink(name, internalLink.trim() + "." + this.getExtension()));
        return formattedValue.toString();
    }

    private String formatComment(String comment) {
        StringBuffer formattedValue = new StringBuffer(Env.NL);
        formattedValue.append(".. ").append(comment.replaceAll("\\n", "\n..")).append(Env.NL);
        return formattedValue.toString();
    }

    @Override
    public AbstractTextConverter newLine() {
        this.addText(Env.NL);
        return this;
    }

    public String toString() {
        this.log.fine("toString=" + this.formattedText.toString());
        return this.formattedText.toString();
    }

    public static void main(String[] args) {
        MarkdownConverter formatter = new MarkdownConverter();
        formatter.addSection("Section");
        formatter.addSubSection("SubSection");
        formatter.addSubSubSection("SubSubSection");
        formatter.addChapter("Chapter");
        formatter.addPart("Part");
        formatter.addBold("Hi everybody");
        formatter.newLine();
        formatter.newLine();
        formatter.addBold("Hi");
        formatter.newLine();
        formatter.addItalic("Hello");
        formatter.newLine();
        formatter.addStrikethrough("Hello");
        formatter.newLine();
        formatter.addText("Hi all");
        formatter.newLine();
        formatter.addQuote("Items");
        formatter.addQuote("Item 1", 1);
        formatter.addQuote("Item 2", 1);
        formatter.addQuote("Item 2.1", 2);
        formatter.addQuote("Item 2.2", 2);
        formatter.addQuote("Item 2.3", 2);
        formatter.addQuote("Item 3", 1);
        formatter.addQuoteNumeric("Other");
        formatter.addQuoteNumeric("Description 1", 1);
        formatter.addQuoteNumeric("Description 2", 2);
        formatter.addQuoteNumeric("Description 2.1", 3);
        formatter.addQuoteNumeric("Description 2.2", 3);
        formatter.addQuoteNumeric("Description 2.3", 3);
        formatter.addQuoteNumeric("Description 3", 2);
        formatter.addText("This is a collection of key documentation gathered from the ADempiere wiki and the collective experience of the ADempiere Development Community. The aim of this collection is to provide a searchable and usable source of project documentation that will improve on the data contained in the wiki while enhancing the readers experience. ");
        formatter.addExternalLink("ADempiere Test", "http://demo.erpya.com:8888");
        formatter.addText(" si no le interesa revise tambien ");
        formatter.addExternalLink("ADempiere Test 1 ", "http://demo.erpya.com:8888/webui/");
        formatter.addCode("String a = \"Epale\";");
        TableTextConverter table2 = new TableTextConverter();
        ArrayList<String> row = new ArrayList<String>();
        row.add("Value");
        row.add("Name");
        row.add("Description");
        table2.addRow(row);
        row = new ArrayList();
        row.add("Test");
        row.add("Test Process");
        row.add("A Test Process");
        table2.addRow(row);
        row = new ArrayList();
        row.add("Production");
        row.add("Production Process");
        row.add("A Production Process");
        table2.addRow(row);
        row = new ArrayList();
        row.add("Report");
        row.add("Test Report");
        row.add("A Test Report");
        table2.addRow(row);
        formatter.addTable(table2);
        System.out.println(formatter.toString());
    }

    @Override
    public void clear() {
        this.formattedText = new StringBuffer();
        this.previouslevel = -1;
    }

    @Override
    public String getExtension() {
        return "md";
    }

    @Override
    public String getIndexFileName() {
        return "index.md";
    }

    @Override
    public String getMainIndexFileName() {
        return "mkdocs.yml";
    }

    @Override
    public AbstractTextConverter addText(String text, int margin) {
        if (Util.isEmpty(text)) {
            return this;
        }
        String leftSpace = "";
        if (margin > 0) {
            leftSpace = String.format("%1$" + margin + "s", "");
        }
        this.addText(leftSpace + text);
        return this;
    }

    @Override
    public AbstractTextConverter getMainIndex() {
        return this.mainIndex;
    }

    private void addToMainIndex(String title, String name, String folder, int margin) {
        if (this.mainIndex == null) {
            this.mainIndex = new MarkdownConverter();
            this.mainIndex.addText("site_name: ERPCyA - Documentation");
            this.mainIndex.newLine();
            this.mainIndex.newLine();
            this.mainIndex.addText("nav:");
            this.mainIndex.newLine();
            this.mainIndex.newLine();
        }
        Object fileName = "";
        if (margin == -1) {
            margin = 1;
        }
        if (!Util.isEmpty(folder)) {
            fileName = folder + File.separator + name.trim() + "." + this.getExtension();
        }
        for (char value : ((String)fileName).toCharArray()) {
            if (value != File.separatorChar) continue;
            ++margin;
        }
        this.mainIndex.newLine();
        this.mainIndex.addText(this.formatIndex(title + ": " + (String)(Util.isEmpty((String)fileName) ? "" : "'" + (String)fileName + "'"), margin * 4));
    }

    @Override
    public AbstractTextConverter addTranslationText(String text) {
        this.translatedText.append(text);
        return this;
    }

    @Override
    public void addIndex(String title, String name, String folder, int margin) {
        this.addToMainIndex(title, name, folder, -1);
        this.addText(this.formatIndex(this.formatExternalLink(title, name.trim() + "." + this.getExtension()), margin));
    }

    @Override
    public void addGroup(String title, String name, int margin) {
        this.addToMainIndex(title, null, null, margin);
    }

    @Override
    public void addTreeDefinition(int maxdepth, boolean isnumbered) {
        this.newLine();
    }
}

