/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.support.aws3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.Env;
import org.compiere.util.MimeType;
import org.compiere.util.Util;
import org.spin.model.MADAppRegistration;
import org.spin.util.support.aws3.AmazonWS3Resource;
import org.spin.util.support.webdav.IWebDav;
import org.spin.util.support.webdav.IWebDavResource;

public class AmazonWS3
implements IWebDav {
    private int registrationId = 0;
    private String bucketName = null;
    private String baseURL = "";
    private final String ACCESS_KEY = "ACCESS_KEY";
    private final String SECRET_KEY = "SECRET_KEY";
    private final String BUCKET_REGION = "BUCKET_REGION";
    private final String BUCKET_NAME = "BUCKET_NAME";

    private String getPath(String relativePath) {
        String path = this.baseURL;
        if (Util.isEmpty((String)relativePath)) {
            return path;
        }
        if (Util.isEmpty(path)) {
            if (((String)relativePath).lastIndexOf(".") == -1) {
                relativePath = (String)relativePath + "/";
            }
            return relativePath;
        }
        if (this.baseURL.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (((String)relativePath).startsWith("/")) {
            relativePath = ((String)relativePath).substring(1);
        }
        if (((String)relativePath).lastIndexOf(".") == -1) {
            relativePath = (String)relativePath + "/";
        }
        return path + "/" + (String)relativePath;
    }

    private MADAppRegistration getRegistrationInstance() {
        if (this.getAppRegistrationId() <= 0) {
            throw new AdempiereException("@AD_AppRegistration_ID@ @NotFound@");
        }
        MADAppRegistration registration = MADAppRegistration.getById(Env.getCtx(), this.getAppRegistrationId(), null);
        if (Util.isEmpty(registration.getParameterValue("ACCESS_KEY"))) {
            throw new AdempiereException("ACCESS_KEY @NotFound@");
        }
        if (Util.isEmpty(registration.getParameterValue("SECRET_KEY"))) {
            throw new AdempiereException("SECRET_KEY @NotFound@");
        }
        if (Util.isEmpty(registration.getHost())) {
            throw new AdempiereException("@Host@ @NotFound@");
        }
        if (Util.isEmpty(registration.getParameterValue("BUCKET_REGION"))) {
            throw new AdempiereException("BUCKET_REGION @NotFound@");
        }
        if (Util.isEmpty(registration.getParameterValue("BUCKET_NAME"))) {
            throw new AdempiereException("BUCKET_NAME @NotFound@");
        }
        this.bucketName = registration.getParameterValue("BUCKET_NAME");
        return registration;
    }

    private String getBucketName() {
        if (Util.isEmpty(this.bucketName)) {
            this.getRegistrationInstance();
        }
        return this.bucketName;
    }

    private String getValidFileName(String fileName) {
        if (Util.isEmpty(fileName)) {
            return fileName;
        }
        int index = fileName.lastIndexOf("/");
        if (index == -1) {
            index = fileName.lastIndexOf("\\");
        }
        if (index != -1) {
            fileName = fileName.substring(index + 1);
        }
        return fileName.replaceAll("[+^:&\u00e1\u00e0\u00e4\u00e9\u00e8\u00eb\u00ed\u00ec\u00ef\u00f3\u00f2\u00f6\u00fa\u00f9\u00f1\u00c1\u00c0\u00c4\u00c9\u00c8\u00cb\u00cd\u00cc\u00cf\u00d3\u00d2\u00d6\u00da\u00d9\u00dc\u00d1\u00e7\u00c7$()*#/><]", "").replaceAll(" ", "-");
    }

    private AmazonS3 getS3Instance() {
        MADAppRegistration registration = this.getRegistrationInstance();
        return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(registration.getParameterValue("ACCESS_KEY"), registration.getParameterValue("SECRET_KEY"))))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(registration.getHost(), registration.getParameterValue("BUCKET_REGION")))).build();
    }

    @Override
    public void setAppRegistrationId(int registrationId) {
        this.registrationId = registrationId;
    }

    @Override
    public int getAppRegistrationId() {
        return this.registrationId;
    }

    @Override
    public InputStream getResource(String relativePath) throws Exception {
        if (Util.isEmpty(relativePath)) {
            return null;
        }
        AmazonS3 s3Client = this.getS3Instance();
        S3Object resource = null;
        resource = s3Client.getObject(new GetObjectRequest(this.getBucketName(), this.getPath(relativePath)));
        if (resource == null) {
            return null;
        }
        return resource.getObjectContent();
    }

    @Override
    public void putResource(String relativePath, InputStream resource) throws Exception {
        if (Util.isEmpty(relativePath) || resource == null) {
            return;
        }
        if (Util.isEmpty(relativePath) || resource == null) {
            return;
        }
        AmazonS3 s3Client = this.getS3Instance();
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength((long)resource.available());
        String fileName = this.getValidFileName(relativePath);
        metadata.setContentType(MimeType.getMimeType(fileName));
        s3Client.putObject(this.getBucketName(), this.getPath(relativePath), resource, metadata);
    }

    @Override
    public void deleteResource(String relativePath) throws Exception {
        if (Util.isEmpty(relativePath)) {
            return;
        }
        AmazonS3 s3Client = this.getS3Instance();
        s3Client.deleteObject(new DeleteObjectRequest(this.getBucketName(), this.getPath(relativePath)));
    }

    @Override
    public void createDirectory(String relativePathName) throws Exception {
        if (Util.isEmpty(relativePathName)) {
            return;
        }
        AmazonS3 s3Client = this.getS3Instance();
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(0L);
        ByteArrayInputStream emptyContent = new ByteArrayInputStream(new byte[0]);
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.getBucketName(), this.getPath(relativePathName), (InputStream)emptyContent, metadata);
        s3Client.putObject(putObjectRequest);
    }

    @Override
    public void moveResource(String relativeSourcePath, String relativeTargetPath) throws Exception {
        if (Util.isEmpty(relativeSourcePath) || Util.isEmpty(relativeTargetPath)) {
            return;
        }
        this.copyResource(relativeSourcePath, relativeTargetPath);
        this.deleteResource(relativeSourcePath);
    }

    @Override
    public void copyResource(String relativeSourcePath, String relativeTargetPath) throws Exception {
        if (Util.isEmpty(relativeSourcePath) || Util.isEmpty(relativeTargetPath)) {
            return;
        }
        AmazonS3 s3Client = this.getS3Instance();
        CopyObjectRequest copyObjRequest = new CopyObjectRequest(this.getBucketName(), this.getPath(relativeSourcePath), this.getBucketName(), this.getPath(relativeTargetPath));
        s3Client.copyObject(copyObjRequest);
    }

    @Override
    public boolean exists(String relativePath) throws Exception {
        if (Util.isEmpty(relativePath)) {
            return false;
        }
        return this.getS3Instance().doesObjectExist(this.getBucketName(), this.getPath(relativePath));
    }

    @Override
    public List<IWebDavResource> getResourceList(String relativePath) throws Exception {
        AmazonS3 s3Client = this.getS3Instance();
        ArrayList<IWebDavResource> resources = new ArrayList<IWebDavResource>();
        s3Client.listObjects(this.getBucketName(), this.getPath(relativePath)).getObjectSummaries().forEach(resource -> resources.add(new AmazonWS3Resource((S3ObjectSummary)resource)));
        return resources;
    }

    @Override
    public void putResource(String relativePath, byte[] resource) throws Exception {
        if (Util.isEmpty(relativePath) || resource == null) {
            return;
        }
        AmazonS3 s3Client = this.getS3Instance();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(resource);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength((long)resource.length);
        String fileName = this.getValidFileName(relativePath);
        metadata.setContentType(MimeType.getMimeType(fileName));
        s3Client.putObject(this.getBucketName(), this.getPath(relativePath), (InputStream)inputStream, metadata);
    }

    @Override
    public String testConnection() {
        StringBuffer message = new StringBuffer();
        try {
            List<IWebDavResource> resources = this.getResourceList(null);
            for (IWebDavResource resource : resources) {
                if (message.length() > 0) {
                    message.append(Env.NL);
                }
                message.append(resource);
            }
        }
        catch (Exception e) {
            message.append(e.getLocalizedMessage());
        }
        return message.toString();
    }

    public static void main(String[] args) {
    }
}

