/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.support.aws3;

import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.sql.Timestamp;
import java.util.Date;
import org.adempiere.exceptions.AdempiereException;
import org.spin.util.support.webdav.IWebDavResource;

public class AmazonWS3Resource
implements IWebDavResource {
    private S3ObjectSummary resource;

    public AmazonWS3Resource(S3ObjectSummary resource) {
        if (resource == null) {
            throw new AdempiereException("@Resource@ @NotFound@");
        }
        this.resource = resource;
    }

    @Override
    public String getDisplayName() {
        return this.resource.getKey();
    }

    @Override
    public String getName() {
        return this.resource.getKey();
    }

    @Override
    public String getPath() {
        return this.resource.getKey();
    }

    @Override
    public Timestamp getCreated() {
        Date created = this.resource.getLastModified();
        if (created == null) {
            return null;
        }
        return new Timestamp(created.getTime());
    }

    @Override
    public Timestamp getUpdated() {
        Date created = this.resource.getLastModified();
        if (created == null) {
            return null;
        }
        return new Timestamp(created.getTime());
    }

    public String toString() {
        return this.resource.toString();
    }
}

