/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.exceptions;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MLocation;
import org.compiere.model.MTaxCategory;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public class TaxNotFoundException
extends AdempiereException {
    private static final long serialVersionUID = -5471615720092096644L;
    private static final String AD_Message = "TaxNotFound";

    public TaxNotFoundException(int C_TaxCategory_ID, boolean IsSOTrx, Timestamp shipDate, int shipFromC_Location_ID, int shipToC_Location_ID, Timestamp billDate, int billFromC_Location_ID, int billToC_Location_ID) {
        super(TaxNotFoundException.buildMessage(C_TaxCategory_ID, IsSOTrx, shipDate, shipFromC_Location_ID, shipToC_Location_ID, billDate, billFromC_Location_ID, billToC_Location_ID));
    }

    private static final String buildMessage(int C_TaxCategory_ID, boolean IsSOTrx, Timestamp shipDate, int shipFromC_Location_ID, int shipToC_Location_ID, Timestamp billDate, int billFromC_Location_ID, int billToC_Location_ID) {
        SimpleDateFormat df = DisplayType.getDateFormat();
        StringBuffer msg = new StringBuffer("@").append(AD_Message).append("@");
        msg.append(" - @C_TaxCategory_ID@:").append(TaxNotFoundException.getTaxCategoryString(C_TaxCategory_ID));
        msg.append(", @IsSOTrx@:@").append(IsSOTrx ? "Y" : "N").append("@");
        msg.append(", @Shipment@ (").append(df.format(shipDate)).append(", ").append(TaxNotFoundException.getLocationString(shipFromC_Location_ID)).append(" -> ").append(TaxNotFoundException.getLocationString(shipToC_Location_ID)).append(")");
        msg.append(", @Invoice@ (").append(df.format(billDate)).append(", ").append(TaxNotFoundException.getLocationString(billFromC_Location_ID)).append(" -> ").append(TaxNotFoundException.getLocationString(billToC_Location_ID)).append(")");
        return msg.toString();
    }

    private static final String getTaxCategoryString(int C_TaxCategory_ID) {
        if (C_TaxCategory_ID <= 0) {
            return "?";
        }
        MTaxCategory cat = new MTaxCategory(Env.getCtx(), C_TaxCategory_ID, null);
        if (cat.get_ID() != C_TaxCategory_ID) {
            return "?";
        }
        return cat.getName();
    }

    private static final String getLocationString(int C_Location_ID) {
        if (C_Location_ID <= 0) {
            return "?";
        }
        MLocation loc = MLocation.get(Env.getCtx(), C_Location_ID, null);
        if (loc == null | loc.get_ID() != C_Location_ID) {
            return "?";
        }
        return loc.toString();
    }
}

